/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.gff;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ListIterator;
import org.biojava.nbio.genome.parsers.gff.Feature;
import org.biojava.nbio.genome.parsers.gff.FeatureI;
import org.biojava.nbio.genome.parsers.gff.FeatureList;
import org.biojava.nbio.genome.parsers.gff.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneIDGFF2Reader {
    private static final Logger logger = LoggerFactory.getLogger(GeneIDGFF2Reader.class);

    public static FeatureList read(String filename) throws IOException {
        logger.info("Reading: {}", (Object)filename);
        FeatureList features = new FeatureList();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String s2 = br.readLine();
        while (null != s2) {
            Feature f;
            if ((s2 = s2.trim()).length() > 0 && s2.charAt(0) != '#' && (f = GeneIDGFF2Reader.parseLine(s2)) != null) {
                features.add(f);
            }
            s2 = br.readLine();
        }
        br.close();
        return features;
    }

    private static Feature parseLine(String s2) {
        int frame;
        Double score;
        int end;
        int start = 0;
        start = end = 0;
        end = s2.indexOf(9, start);
        String seqname = s2.substring(start, end).trim();
        start = end + 1;
        end = s2.indexOf(9, start);
        String source = s2.substring(start, end).trim();
        start = end + 1;
        end = s2.indexOf(9, start);
        String type = s2.substring(start, end);
        start = end + 1;
        end = s2.indexOf(9, start);
        String locStart = s2.substring(start, end);
        start = end + 1;
        end = s2.indexOf(9, start);
        String locEnd = s2.substring(start, end);
        start = end + 1;
        end = s2.indexOf(9, start);
        try {
            score = Double.parseDouble(s2.substring(start, end));
        }
        catch (Exception e) {
            score = 0.0;
        }
        start = end + 1;
        end = s2.indexOf(9, start);
        char strand = s2.charAt(end - 1);
        Location location = Location.fromBio(Integer.parseInt(locStart), Integer.parseInt(locEnd), strand);
        assert (strand == '-' == location.isNegative());
        start = end + 1;
        end = s2.indexOf(9, start);
        try {
            frame = Integer.parseInt(s2.substring(start, end));
        }
        catch (Exception e) {
            frame = -1;
        }
        start = end + 1;
        end = s2.indexOf(35, start);
        String attributes = null;
        attributes = end < 0 ? new String(s2.substring(start)) : new String(s2.substring(start, end));
        attributes = "gene_id \"" + attributes + '\"' + ";";
        return new Feature(seqname, source, type, location, score, frame, attributes);
    }

    public static void write(FeatureList features, String filename) throws IOException {
        logger.info("Writing: {}", (Object)filename);
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        ListIterator iter = features.listIterator();
        while (iter.hasNext()) {
            Feature feature = (Feature)iter.next();
            GeneIDGFF2Reader.writeLine(feature, bw);
        }
        bw.close();
    }

    private static void writeLine(Feature f, BufferedWriter bw) throws IOException {
        String s2 = f.seqname() + '\t';
        s2 = s2 + f.source() + '\t';
        s2 = s2 + f.type() + '\t';
        s2 = s2 + f.location().bioStart() + "\t";
        s2 = s2 + f.location().bioEnd() + "\t";
        s2 = s2 + Double.toString(f.score()) + "\t";
        s2 = s2 + f.location().bioStrand() + "\t";
        s2 = f.frame() == -1 ? s2 + ".\t" : s2 + f.frame() + "\t";
        s2 = s2 + f.attributes();
        bw.write(s2);
        bw.newLine();
    }

    public static void main(String[] args) throws Exception {
        FeatureList listGenes = GeneIDGFF2Reader.read("/Users/Scooter/scripps/dyadic/analysis/454Scaffolds/genemark_hmm.gtf");
        for (FeatureI feature : listGenes) {
            logger.info("Gene Feature: {}", (Object)feature);
        }
    }
}

