/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.twobit;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.biojava.nbio.core.util.FileDownloadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTwoBitFileProvider {
    private static final Logger logger = LoggerFactory.getLogger(SimpleTwoBitFileProvider.class);

    public static synchronized void downloadIfNoTwoBitFileExists(File twoBitFileLocalLocation, String genomeAssembly) throws IOException {
        if (!twoBitFileLocalLocation.exists()) {
            File tmp = File.createTempFile(genomeAssembly, ".2bit");
            URL twoBitFileURL = SimpleTwoBitFileProvider.getTwoBitURL(genomeAssembly);
            logger.info("downloading " + twoBitFileURL + " to " + tmp.getAbsolutePath());
            FileDownloadUtils.downloadFile(twoBitFileURL, tmp);
            Path p = Paths.get(twoBitFileLocalLocation.getAbsolutePath(), new String[0]);
            Path dir = p.getParent();
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            logger.info("renaming " + tmp.getAbsolutePath() + " to " + twoBitFileLocalLocation.getAbsolutePath());
            tmp.renameTo(twoBitFileLocalLocation);
        }
    }

    public static URL getTwoBitURL(String genomeAssembly) throws MalformedURLException {
        String url = "";
        if (genomeAssembly.equals("hg19") || genomeAssembly.equals("hg37")) {
            url = "http://cdn.rcsb.org/gene/hg37/hg19.2bit";
        } else if (genomeAssembly.equals("hg38")) {
            url = "http://cdn.rcsb.org/gene/hg38/hg38.2bit";
        }
        return new URL(url);
    }

    public static void main(String[] args) {
        try {
            SimpleTwoBitFileProvider.downloadIfNoTwoBitFileExists(new File("/Users/yana/spark/2bit/hg38.2bit"), "hg38");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

