/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.uniprot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.io.FastaWriterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniprotToFasta {
    private static final Logger logger = LoggerFactory.getLogger(UniprotToFasta.class);

    public static void main(String[] args) {
        try {
            String uniprotDatFileName = "uniprot_trembl_fungi.dat";
            String fastaFileName = "uniprot__trembel_fungi.faa";
            UniprotToFasta uniprotToFasta = new UniprotToFasta();
            uniprotToFasta.process(uniprotDatFileName, fastaFileName);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    public void process(String uniprotDatFileName, String fastaFileName) throws Exception {
        FileReader fr = new FileReader(uniprotDatFileName);
        BufferedReader br = new BufferedReader(fr);
        String line = br.readLine();
        String id = "";
        StringBuffer sequence = new StringBuffer();
        ArrayList<ProteinSequence> seqCodingRegionsList = new ArrayList<ProteinSequence>();
        int count = 0;
        HashMap<String, String> uniqueGenes = new HashMap<String, String>();
        HashMap<String, String> uniqueSpecies = new HashMap<String, String>();
        while (line != null) {
            if (line.startsWith("ID")) {
                String[] data = line.split(" ");
                id = data[3];
            } else if (line.startsWith("SQ")) {
                line = br.readLine();
                while (!line.startsWith("//")) {
                    for (int i = 0; i < line.length(); ++i) {
                        char aa2 = line.charAt(i);
                        if ((aa2 < 'A' || aa2 > 'Z') && (aa2 < 'a' || aa2 > 'z')) continue;
                        sequence.append(aa2);
                    }
                    line = br.readLine();
                }
                ProteinSequence seq = new ProteinSequence(sequence.toString());
                seq.setAccession(new AccessionID(id));
                seqCodingRegionsList.add(seq);
                sequence = new StringBuffer();
                if (++count % 100 == 0) {
                    logger.info("Count: ", (Object)count);
                }
                String[] parts = id.split("_");
                uniqueGenes.put(parts[0], "");
                uniqueSpecies.put(parts[1], "");
            }
            line = br.readLine();
        }
        FastaWriterHelper.writeProteinSequence(new File(fastaFileName), seqCodingRegionsList);
        br.close();
        fr.close();
    }
}

