/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.phylo;

import java.io.IOException;
import java.util.List;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.MultipleSequenceAlignment;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.phylo.Comparison;
import org.biojava.nbio.phylo.ForesterWrapper;
import org.forester.evoinference.distance.PairwiseDistanceCalculator;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.msa.Msa;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistanceMatrixCalculator {
    private static final Logger logger = LoggerFactory.getLogger(DistanceMatrixCalculator.class);

    private DistanceMatrixCalculator() {
    }

    public static <C extends Sequence<D>, D extends Compound> DistanceMatrix fractionalDissimilarity(MultipleSequenceAlignment<C, D> msa) throws IOException {
        Msa fMsa = ForesterWrapper.convert(msa);
        BasicSymmetricalDistanceMatrix DM = PairwiseDistanceCalculator.calcFractionalDissimilarities(fMsa);
        return DM;
    }

    public static <C extends Sequence<D>, D extends Compound> DistanceMatrix poissonDistance(MultipleSequenceAlignment<C, D> msa) throws IOException {
        Msa fMsa = ForesterWrapper.convert(msa);
        BasicSymmetricalDistanceMatrix DM = PairwiseDistanceCalculator.calcPoissonDistances(fMsa);
        return DM;
    }

    public static <C extends Sequence<D>, D extends Compound> DistanceMatrix kimuraDistance(MultipleSequenceAlignment<C, D> msa) throws IOException {
        Msa fMsa = ForesterWrapper.convert(msa);
        BasicSymmetricalDistanceMatrix DM = PairwiseDistanceCalculator.calcPoissonDistances(fMsa);
        return DM;
    }

    public static <C extends Sequence<D>, D extends Compound> DistanceMatrix percentageIdentity(MultipleSequenceAlignment<C, D> msa) {
        logger.info("{}:{}", (Object)"Determing Distances", (Object)0);
        int n = msa.getSize();
        String[] sequenceString = new String[n];
        for (int i = 0; i < n; ++i) {
            sequenceString[i] = msa.getAlignedSequence(i + 1).getSequenceAsString();
        }
        BasicSymmetricalDistanceMatrix distance = new BasicSymmetricalDistanceMatrix(n);
        int totalloopcount = n / 2 * (n + 1);
        int loopcount = 0;
        for (int i = 0; i < n - 1; ++i) {
            logger.info("{}:{}", (Object)"Determining Distances", (Object)(loopcount * 100 / totalloopcount));
            distance.setIdentifier(i, msa.getAlignedSequence(i + 1).getAccession().getID());
            for (int j = i; j < n; ++j) {
                ++loopcount;
                if (j == i) {
                    distance.setValue(i, j, 0.0);
                    continue;
                }
                distance.setValue(i, j, 100.0f - Comparison.PID(sequenceString[i], sequenceString[j]));
                distance.setValue(j, i, distance.getValue(i, j));
            }
        }
        logger.info("{}:{}", (Object)"Determining Distances", (Object)100);
        return distance;
    }

    public static <C extends Sequence<D>, D extends Compound> DistanceMatrix fractionalDissimilarityScore(MultipleSequenceAlignment<C, D> msa, SubstitutionMatrix<D> M) {
        logger.info("{}:{}", (Object)"Determing Distances", (Object)0);
        int n = msa.getSize();
        BasicSymmetricalDistanceMatrix DM = new BasicSymmetricalDistanceMatrix(n);
        int totalloopcount = n / 2 * (n + 1);
        int end = msa.getLength();
        String[] sequenceString = new String[n];
        for (int i = 0; i < n; ++i) {
            sequenceString[i] = msa.getAlignedSequence(i + 1).getSequenceAsString();
        }
        List<C> seqs = msa.getAlignedSequences();
        int loopcount = 0;
        for (int i = 0; i < n - 1; ++i) {
            logger.info("{}:{}", (Object)"Determining Distances", (Object)(loopcount * 100 / totalloopcount));
            for (int j = i; j < n; ++j) {
                double score = 0.0;
                ++loopcount;
                for (int k = 0; k < end; ++k) {
                    if (Comparison.isGap(sequenceString[i].charAt(k)) || Comparison.isGap(sequenceString[j].charAt(k))) continue;
                    score += (double)M.getValue(((Sequence)seqs.get(i)).getCompoundAt(k + 1), ((Sequence)seqs.get(j)).getCompoundAt(k + 1));
                }
                if (i == j) {
                    DM.setValue(i, j, 0.0);
                    continue;
                }
                double dS = ((double)M.getMaxValue() - score / (double)msa.getLength()) / (double)(M.getMaxValue() - M.getMinValue());
                DM.setValue(i, j, dS);
                DM.setValue(j, i, dS);
            }
        }
        return DM;
    }

    public static <C extends Sequence<D>, D extends Compound> DistanceMatrix dissimilarityScore(MultipleSequenceAlignment<C, D> msa, SubstitutionMatrix<D> M) {
        int j;
        int i;
        logger.info("{}:{}", (Object)"Determing Distances", (Object)0);
        int n = msa.getSize();
        String[] sequenceString = new String[n];
        for (int i2 = 0; i2 < n; ++i2) {
            sequenceString[i2] = msa.getAlignedSequence(i2 + 1).getSequenceAsString();
        }
        List<C> seqs = msa.getAlignedSequences();
        BasicSymmetricalDistanceMatrix DM = new BasicSymmetricalDistanceMatrix(n);
        int totalloopcount = n / 2 * (n + 1);
        double maxscore = 0.0;
        int end = msa.getLength();
        int loopcount = 0;
        for (i = 0; i < n - 1; ++i) {
            logger.info("{}:{}", (Object)"Determining Distances", (Object)(loopcount * 100 / totalloopcount));
            for (j = i; j < n; ++j) {
                double score = 0.0;
                ++loopcount;
                for (int k = 0; k < end; ++k) {
                    if (Comparison.isGap(sequenceString[i].charAt(k)) || Comparison.isGap(sequenceString[j].charAt(k))) continue;
                    score += (double)M.getValue(((Sequence)seqs.get(i)).getCompoundAt(k + 1), ((Sequence)seqs.get(j)).getCompoundAt(k + 1));
                }
                if (i != j) {
                    score = Math.max(score, 0.0);
                    DM.setValue(i, j, score);
                }
                if (!(score > maxscore)) continue;
                maxscore = score;
            }
        }
        for (i = 0; i < n; ++i) {
            DM.setIdentifier(i, msa.getAlignedSequence(i + 1).getAccession().getID());
            for (j = i; j < n; ++j) {
                if (i == j) {
                    DM.setValue(i, j, 0.0);
                    continue;
                }
                double dS = Math.max(maxscore - DM.getValue(i, j), 0.0);
                DM.setValue(i, j, dS);
                DM.setValue(j, i, dS);
            }
        }
        logger.info("{}:{}", (Object)"Determining Distances", (Object)100);
        return DM;
    }

    public static <C extends Sequence<D>, D extends Compound> DistanceMatrix pamMLdistance(MultipleSequenceAlignment<C, D> msa) {
        throw new IllegalStateException("PAM ML distance calculation not implemented!");
    }

    public static <C extends Sequence<D>, D extends Compound> DistanceMatrix structuralDistance(double[][] rmsdMat, double alpha, double rmsdMax, double rmsd0) {
        int n = rmsdMat.length;
        BasicSymmetricalDistanceMatrix DM = new BasicSymmetricalDistanceMatrix(n);
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                if (i == j) {
                    DM.setValue(i, j, 0.0);
                    continue;
                }
                double d = rmsdMax * rmsdMax / (alpha * alpha) * Math.log((rmsdMax * rmsdMax - rmsd0 * rmsd0) / (rmsdMax * rmsdMax - rmsdMat[i][j] * rmsdMat[i][j]));
                d = Math.max(d, 0.0);
                DM.setValue(i, j, d);
                DM.setValue(j, i, d);
            }
        }
        return DM;
    }
}

