/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.forester.io.parsers.FastaParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.sequence.MolecularSequence;
import org.forester.tools.PhylogenyDecorator;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class decorator {
    private static final String SEQUENCE_NAME_FIELD = "s";
    private static final String MOL_SEQ = "m";
    private static final String TAXONOMY_CODE_FIELD = "c";
    private static final String TAXONOMY_SCIENTIFIC_NAME_FIELD = "sn";
    private static final String DS_FILED = "d";
    private static final String SEQUENCE_ANNOTATION_DESC = "a";
    private static final String NODE_NAME_FIELD = "n";
    private static final String PICKY_OPTION = "p";
    private static final String FIELD_OPTION = "f";
    private static final String TRIM_AFTER_TILDE_OPTION = "t";
    private static final String VERBOSE_OPTION = "ve";
    private static final String TREE_NAME_OPTION = "pn";
    private static final String TREE_ID_OPTION = "pi";
    private static final String TREE_DESC_OPTION = "pd";
    private static final String MIDPOINT_ROOT_OPTION = "mp";
    private static final String ORDER_TREE_OPTION = "or";
    private static final String EXTRACT_BRACKETED_SCIENTIC_NAME_OPTION = "sn";
    private static final String EXTRACT_BRACKETED_TAXONOMIC_CODE_OPTION = "tc";
    private static final String CUT_NAME_AFTER_FIRST_SPACE_OPTION = "c";
    private static final String ADVANCED_TABLE_OPTION = "table";
    private static final String KEY_COLUMN = "k";
    private static final String VALUE_COLUMN = "v";
    private static final String MAPPING_FILE_SEPARATOR_OPTION = "s";
    private static final char MAPPING_FILE_SEPARATOR_DEFAULT = '\t';
    private static final String PRG_NAME = "decorator";
    private static final String PRG_VERSION = "1.16";
    private static final String PRG_DATE = "131113";

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        Phylogeny[] phylogenies;
        boolean midpoint_root;
        boolean order_tree;
        File phylogenies_outfile;
        block83: {
            boolean advanced_table;
            String err;
            ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
            System.out.println();
            if (args.length < 4 || args.length > 13) {
                decorator.argumentsError();
            }
            CommandLineArguments cla = null;
            try {
                cla = new CommandLineArguments(args);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
            if (cla.getNumberOfNames() < 3 || cla.getNumberOfNames() > 4) {
                decorator.argumentsError();
            }
            File phylogenies_infile = cla.getFile(0);
            File mapping_infile = cla.getFile(1);
            phylogenies_outfile = cla.getFile(2);
            if (phylogenies_outfile.exists()) {
                ForesterUtil.fatalError(PRG_NAME, "[" + phylogenies_outfile + "] already exists");
            }
            if (!ForesterUtil.isEmpty(err = ForesterUtil.isReadableFile(phylogenies_infile))) {
                ForesterUtil.fatalError(PRG_NAME, err);
            }
            if (!ForesterUtil.isEmpty(err = ForesterUtil.isReadableFile(mapping_infile))) {
                ForesterUtil.fatalError(PRG_NAME, err);
            }
            ArrayList<String> allowed_options = new ArrayList<String>();
            allowed_options.add(ADVANCED_TABLE_OPTION);
            allowed_options.add(PICKY_OPTION);
            allowed_options.add(FIELD_OPTION);
            allowed_options.add("c");
            allowed_options.add(KEY_COLUMN);
            allowed_options.add(VALUE_COLUMN);
            allowed_options.add("s");
            allowed_options.add("sn");
            allowed_options.add(EXTRACT_BRACKETED_TAXONOMIC_CODE_OPTION);
            allowed_options.add(TREE_NAME_OPTION);
            allowed_options.add(TREE_ID_OPTION);
            allowed_options.add(TREE_DESC_OPTION);
            allowed_options.add(TRIM_AFTER_TILDE_OPTION);
            allowed_options.add(ORDER_TREE_OPTION);
            allowed_options.add(MIDPOINT_ROOT_OPTION);
            allowed_options.add(VERBOSE_OPTION);
            String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
            if (dissallowed_options.length() > 0) {
                ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
            }
            if (!(advanced_table = cla.isOptionSet(ADVANCED_TABLE_OPTION))) {
                ArrayList<String> mandatory_options = new ArrayList<String>();
                mandatory_options.add(FIELD_OPTION);
                String missing_options = cla.validateMandatoryOptionsAsString(mandatory_options);
                if (missing_options.length() > 0) {
                    ForesterUtil.fatalError(PRG_NAME, "missing option(s): " + missing_options);
                }
            }
            boolean picky = cla.isOptionSet(PICKY_OPTION);
            char separator = '\t';
            if (cla.isOptionSet("s")) {
                if (advanced_table) {
                    decorator.argumentsError();
                }
                separator = cla.getOptionValueAsChar("s");
            }
            int key_column = 0;
            int value_column = 1;
            String field_str = "";
            PhylogenyDecorator.FIELD field = PhylogenyDecorator.FIELD.NODE_NAME;
            boolean cut_name_after_space = false;
            boolean extract_bracketed_scientific_name = false;
            boolean extract_bracketed_tax_code = false;
            boolean trim_after_tilde = false;
            order_tree = false;
            midpoint_root = false;
            boolean verbose = false;
            String tree_name = "";
            String tree_id = "";
            String tree_desc = "";
            try {
                if (cla.isOptionSet(TREE_NAME_OPTION)) {
                    tree_name = cla.getOptionValueAsCleanString(TREE_NAME_OPTION);
                }
                if (cla.isOptionSet(TREE_ID_OPTION)) {
                    tree_id = cla.getOptionValueAsCleanString(TREE_ID_OPTION);
                }
                if (cla.isOptionSet(TREE_DESC_OPTION)) {
                    tree_desc = cla.getOptionValueAsCleanString(TREE_DESC_OPTION);
                }
                if (cla.isOptionSet("sn")) {
                    if (advanced_table) {
                        decorator.argumentsError();
                    }
                    extract_bracketed_scientific_name = true;
                }
                if (cla.isOptionSet(EXTRACT_BRACKETED_TAXONOMIC_CODE_OPTION)) {
                    if (advanced_table) {
                        decorator.argumentsError();
                    }
                    extract_bracketed_tax_code = true;
                }
                if (cla.isOptionSet(KEY_COLUMN)) {
                    if (advanced_table) {
                        decorator.argumentsError();
                    }
                    key_column = cla.getOptionValueAsInt(KEY_COLUMN);
                }
                if (cla.isOptionSet(VALUE_COLUMN)) {
                    if (advanced_table) {
                        decorator.argumentsError();
                    }
                    value_column = cla.getOptionValueAsInt(VALUE_COLUMN);
                }
                if (cla.isOptionSet("c")) {
                    if (advanced_table) {
                        decorator.argumentsError();
                    }
                    cut_name_after_space = true;
                }
                if (cla.isOptionSet(TRIM_AFTER_TILDE_OPTION)) {
                    if (advanced_table) {
                        decorator.argumentsError();
                    }
                    trim_after_tilde = true;
                }
                if (cla.isOptionSet(MIDPOINT_ROOT_OPTION)) {
                    midpoint_root = true;
                }
                if (cla.isOptionSet(ORDER_TREE_OPTION)) {
                    order_tree = true;
                }
                if (cla.isOptionSet(VERBOSE_OPTION)) {
                    verbose = true;
                }
                if (cla.isOptionSet(FIELD_OPTION)) {
                    field_str = cla.getOptionValue(FIELD_OPTION);
                    if (field_str.equals(NODE_NAME_FIELD)) {
                        field = PhylogenyDecorator.FIELD.NODE_NAME;
                    } else if (field_str.equals(SEQUENCE_ANNOTATION_DESC)) {
                        field = PhylogenyDecorator.FIELD.SEQUENCE_ANNOTATION_DESC;
                    } else if (field_str.equals(DS_FILED)) {
                        field = PhylogenyDecorator.FIELD.DOMAIN_STRUCTURE;
                        extract_bracketed_scientific_name = false;
                        extract_bracketed_tax_code = false;
                    } else if (field_str.equals("c")) {
                        field = PhylogenyDecorator.FIELD.TAXONOMY_CODE;
                    } else if (field_str.equals("s")) {
                        field = PhylogenyDecorator.FIELD.SEQUENCE_NAME;
                    } else if (field_str.equals(MOL_SEQ)) {
                        field = PhylogenyDecorator.FIELD.MOL_SEQ;
                    } else if (field_str.equals("sn")) {
                        field = PhylogenyDecorator.FIELD.TAXONOMY_SCIENTIFIC_NAME;
                        extract_bracketed_scientific_name = false;
                        extract_bracketed_tax_code = false;
                    } else {
                        ForesterUtil.fatalError(PRG_NAME, "unknown value for \"f\" option: \"" + field_str + "\"");
                    }
                }
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "error in command line: " + e.getMessage());
            }
            if (extract_bracketed_scientific_name && extract_bracketed_tax_code) {
                decorator.argumentsError();
            }
            ForesterUtil.programMessage(PRG_NAME, "input tree(s) : " + phylogenies_infile);
            ForesterUtil.programMessage(PRG_NAME, "map           : " + mapping_infile);
            ForesterUtil.programMessage(PRG_NAME, "output tree(s): " + phylogenies_outfile);
            System.out.println();
            phylogenies = null;
            try {
                PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(phylogenies_infile, true);
                phylogenies = factory.create(phylogenies_infile, phylogenyParser);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read phylgenies from [" + phylogenies_infile + "] [" + e.getMessage() + "]");
            }
            Map<String, String> map = null;
            if (!advanced_table) {
                if (field != PhylogenyDecorator.FIELD.MOL_SEQ) {
                    void var27_35;
                    Object var27_33 = null;
                    try {
                        BasicTable<String> basicTable = BasicTableParser.parse(mapping_infile, separator, true, false);
                    }
                    catch (Exception e) {
                        ForesterUtil.fatalError(PRG_NAME, "failed to read [" + mapping_infile + "] [" + e.getMessage() + "]");
                    }
                    if (key_column < 0 || key_column >= var27_35.getNumberOfColumns()) {
                        ForesterUtil.fatalError(PRG_NAME, "illegal value for key column");
                    }
                    if (value_column < 0 || value_column >= var27_35.getNumberOfColumns()) {
                        ForesterUtil.fatalError(PRG_NAME, "illegal value for value column");
                    }
                    if (var27_35.isEmpty() || var27_35.getNumberOfColumns() < 1) {
                        ForesterUtil.fatalError(PRG_NAME, "mapping table is empty");
                    }
                    if (var27_35.getNumberOfColumns() == 1) {
                        ForesterUtil.fatalError(PRG_NAME, "mapping table has only one column");
                    }
                    map = var27_35.getColumnsAsMap(key_column, value_column);
                    Iterator<Map.Entry<String, String>> iter = map.entrySet().iterator();
                    if (verbose) {
                        System.out.println();
                    }
                    while (iter.hasNext()) {
                        Map.Entry<String, String> e = iter.next();
                        if (ForesterUtil.isEmpty(e.getKey())) {
                            ForesterUtil.fatalError(PRG_NAME, "mapping table contains empty key");
                        }
                        if (ForesterUtil.isEmpty(e.getValue())) {
                            ForesterUtil.fatalError(PRG_NAME, "mapping table contains empty value");
                        }
                        if (!verbose) continue;
                        System.out.println(e.getKey() + " => " + e.getValue());
                    }
                    if (verbose) {
                        System.out.println();
                    }
                } else {
                    map = decorator.readFastaFileIntoMap(mapping_infile, verbose);
                }
            }
            if (!(ForesterUtil.isEmpty(tree_name) && ForesterUtil.isEmpty(tree_id) && ForesterUtil.isEmpty(tree_desc))) {
                if (!(phylogenies.length <= 1 || ForesterUtil.isEmpty(tree_name) && ForesterUtil.isEmpty(tree_id))) {
                    ForesterUtil.fatalError(PRG_NAME, "attempt to set same name or id on more than one phylogeny");
                }
                if (!ForesterUtil.isEmpty(tree_name)) {
                    phylogenies[0].setName(tree_name);
                }
                if (!ForesterUtil.isEmpty(tree_id)) {
                    String[] stringArray = tree_id.split(":");
                    phylogenies[0].setIdentifier(new Identifier(stringArray[1], stringArray[0]));
                }
                if (!ForesterUtil.isEmpty(tree_desc)) {
                    for (Phylogeny phylogeny : phylogenies) {
                        phylogeny.setDescription(tree_desc);
                    }
                }
            }
            try {
                if (advanced_table) {
                    void var30_66;
                    Object var27_41 = null;
                    try {
                        Map<String, Map<String, String>> map2 = PhylogenyDecorator.parseMappingTable(mapping_infile);
                    }
                    catch (IOException e) {
                        ForesterUtil.fatalError(PRG_NAME, "failed to read \"" + mapping_infile + "\" [" + e.getMessage() + "]");
                    }
                    Phylogeny[] phylogenyArray = phylogenies;
                    int n = phylogenyArray.length;
                    boolean bl = false;
                    while (var30_66 < n) {
                        void var27_43;
                        Phylogeny phylogenie = phylogenyArray[var30_66];
                        PhylogenyDecorator.decorate(phylogenie, (Map<String, Map<String, String>>)var27_43, picky);
                        ++var30_66;
                    }
                    break block83;
                }
                for (Phylogeny phylogeny : phylogenies) {
                    String msg = PhylogenyDecorator.decorate(phylogeny, map, field, extract_bracketed_scientific_name, extract_bracketed_tax_code, picky, cut_name_after_space, trim_after_tilde, verbose);
                    ForesterUtil.programMessage(PRG_NAME, msg);
                }
            }
            catch (NullPointerException nullPointerException) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, nullPointerException);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getLocalizedMessage());
            }
        }
        if (midpoint_root || order_tree) {
            for (Phylogeny phylogeny : phylogenies) {
                if (midpoint_root) {
                    PhylogenyMethods.midpointRoot(phylogeny);
                }
                if (!order_tree) continue;
                PhylogenyMethods.orderAppearance(phylogeny.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY);
            }
        }
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(phylogenies, 0, phylogenies_outfile, ForesterUtil.getLineSeparator());
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write output [" + iOException.getMessage() + "]");
        }
        System.out.println();
        ForesterUtil.programMessage(PRG_NAME, "wrote: " + phylogenies_outfile);
        ForesterUtil.programMessage(PRG_NAME, "OK.");
    }

    private static Map<String, String> readFastaFileIntoMap(File mapping_infile, boolean verbose) {
        List<MolecularSequence> seqs = null;
        try {
            seqs = FastaParser.parse(new FileInputStream(mapping_infile));
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read fasta-file from [" + mapping_infile + "] [" + e.getMessage() + "]");
        }
        if (ForesterUtil.isEmpty(seqs)) {
            ForesterUtil.fatalError(PRG_NAME, "fasta-file [" + mapping_infile + "] is devoid of fasta-formatted sequences");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (MolecularSequence seq : seqs) {
            if (ForesterUtil.isEmpty(seq.getIdentifier())) {
                ForesterUtil.fatalError(PRG_NAME, "fasta-file [" + mapping_infile + "] contains sequence with empty identifier");
            }
            if (map.containsKey(seq.getIdentifier())) {
                ForesterUtil.fatalError(PRG_NAME, "sequence identifier [" + seq.getIdentifier() + "] is not unique");
            }
            if (seq.getLength() < 1) {
                ForesterUtil.fatalError(PRG_NAME, "sequence [" + seq.getIdentifier() + "] is empty");
            }
            map.put(seq.getIdentifier(), seq.getMolecularSequenceAsString());
            if (!verbose) continue;
            System.out.println(seq.getIdentifier() + " => " + seq.getMolecularSequenceAsString());
        }
        return map;
    }

    private static void argumentsError() {
        System.out.println();
        System.out.println("decorator -table | -f=<c> <phylogenies infile> <mapping table file|fasta-file> <phylogenies outfile>");
        System.out.println();
        System.out.println("options:");
        System.out.println();
        System.out.println(" -table : table instead of one to one map (-f=<c>)");
        System.out.println(" -p     : picky, fails if node name not found in mapping table");
        System.out.println(" -pn=<s>: name for the phylogeny");
        System.out.println(" -pi=<s>: identifier for the phylogeny (in the form provider:value)");
        System.out.println(" -pd=<s>: description for phylogenies");
        System.out.println();
        System.out.println();
        System.out.println("advanced options, only available if -table is not used:");
        System.out.println();
        System.out.println(" -f=<c> : field to be replaced: n : node name");
        System.out.println("                                a : sequence annotation description");
        System.out.println("                                d : domain structure");
        System.out.println("                                c : taxonomy code");
        System.out.println("                                sn: taxonomy scientific name");
        System.out.println("                                s : sequence name");
        System.out.println("                                m : molecular sequence");
        System.out.println(" -k=<n> : key column in mapping table (0 based),");
        System.out.println("          names of the node to be decorated - default is 0");
        System.out.println(" -v=<n> : value column in mapping table (0 based),");
        System.out.println("          data which with to decorate - default is 1");
        System.out.println(" -sn    : to extract bracketed scientific names, e.g. [Nematostella vectensis]");
        System.out.println(" -tc    : to extract bracketed taxonomic codes, e.g. [NEMVE]");
        System.out.println(" -s=<c> : column separator in mapping file, default is tab");
        System.out.println(" -c     : cut name after first space (only for -f=n)");
        System.out.println(" -t     : trim node name to be replaced after tilde");
        System.out.println(" -mp    : to midpoint-root the tree");
        System.out.println(" -or    : to order tree branches");
        System.out.println(" -ve    : verbose");
        System.out.println();
        System.exit(-1);
    }
}

