/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.pccx.BasicExternalNodeBasedCoverageExtender;
import org.forester.pccx.Coverage;
import org.forester.pccx.CoverageCalculator;
import org.forester.pccx.ExternalNodeBasedCoverageMethod;
import org.forester.pccx.ExternalNodeBasedCoverageMethodOptions;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class pccx {
    private static final int EXTEND_BY_DEFAULT = -100;
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String USE_REAL_BL_OPTION = "d";
    private static final String USE_LOG_REAL_BL_OPTION = "ld";
    private static final String EXTEND_BY_OPTION = "x";
    private static final String OUTPUT_OPTION = "o";
    private static final String INPUT_OPTION = "i";
    private static final String OUTPUT_ANNOTATED_PHYLOGENIES_OPTION = "p";
    private static final String PRG_NAME = "pccx";
    private static final String PRG_VERSION = "1.0.0";
    private static final String BRANCH_LENGTH_BASED_SCORING = "org.forester.tools.modeling.BranchLengthBasedScoringMethod";
    private static final String BRANCH_COUNTING_BASED_SCORING = "org.forester.tools.modeling.BranchCountingBasedScoringMethod";
    private static final String LOG_BRANCH_LENGTH_BASED_SCORING = "org.forester.tools.modeling.LogBranchLengthBasedScoringMethod";
    private static final String PRG_DATE = "2008.03.04";
    private static final String WWW = "www.phylosoft.org/forester/applications/pccx";
    private static final String E_MAIL = "czmasek@burnham.org";

    public static void main(String[] args) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2)) {
            System.out.println();
            pccx.printHelp();
            System.exit(0);
        }
        if (args.length < 2) {
            System.out.println();
            System.out.println("Incorrect number of arguments.");
            System.out.println();
            pccx.printHelp();
            System.exit(-1);
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        boolean use_bl = false;
        boolean use_log_bl = false;
        int extend_by = -100;
        allowed_options.add(USE_REAL_BL_OPTION);
        allowed_options.add(USE_LOG_REAL_BL_OPTION);
        allowed_options.add(EXTEND_BY_OPTION);
        allowed_options.add(INPUT_OPTION);
        allowed_options.add(OUTPUT_OPTION);
        allowed_options.add(OUTPUT_ANNOTATED_PHYLOGENIES_OPTION);
        String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
        if (dissallowed_options.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
        }
        if (cla.getNumberOfNames() < 1) {
            System.out.println();
            System.out.println("No phylogenies infile indicated.");
            System.out.println();
            pccx.printHelp();
            System.exit(-1);
        }
        File phylogenies_infile = cla.getFile(0);
        ArrayList<String> external_otu_names = new ArrayList<String>();
        if (cla.getNumberOfNames() > 1) {
            for (int i = 1; i < cla.getNumberOfNames(); ++i) {
                external_otu_names.add(cla.getName(i));
            }
        }
        if (cla.isOptionSet(USE_REAL_BL_OPTION)) {
            use_bl = true;
        }
        if (cla.isOptionSet(USE_LOG_REAL_BL_OPTION)) {
            use_log_bl = true;
        }
        if (use_bl && use_log_bl) {
            System.out.println();
            pccx.printHelp();
            System.exit(-1);
        }
        if (cla.isOptionSet(EXTEND_BY_OPTION)) {
            extend_by = 0;
            try {
                extend_by = cla.getOptionValueAsInt(EXTEND_BY_OPTION);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
        }
        Phylogeny[] phylogenies = null;
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser pp = ParserUtils.createParserDependingOnFileType(phylogenies_infile, true);
            phylogenies = factory.create(phylogenies_infile, pp);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "could not read \"" + phylogenies_infile + "\": " + e.getMessage());
        }
        List<Phylogeny> phylogenies_list = Arrays.asList(phylogenies);
        File outfile = null;
        PrintStream out = System.out;
        if (cla.isOptionSet(OUTPUT_OPTION)) {
            try {
                outfile = new File(cla.getOptionValue(OUTPUT_OPTION));
                String error = ForesterUtil.isWritableFile(outfile);
                if (!ForesterUtil.isEmpty(error)) {
                    ForesterUtil.fatalError(PRG_NAME, error);
                }
                out = new PrintStream(outfile);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
        }
        File infile = null;
        BasicTable<String> intable = null;
        if (cla.isOptionSet(INPUT_OPTION)) {
            try {
                infile = new File(cla.getOptionValue(INPUT_OPTION));
                String error = ForesterUtil.isReadableFile(infile);
                if (!ForesterUtil.isEmpty(error)) {
                    ForesterUtil.fatalError(PRG_NAME, error);
                }
                intable = BasicTableParser.parse(infile, ' ', false, false);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read \"" + infile + "\" [" + e.getMessage() + "]");
            }
            try {
                for (int row = 0; row < intable.getNumberOfRows(); ++row) {
                    System.out.println("Adding external node: " + intable.getValueAsString(0, row));
                    external_otu_names.add(intable.getValueAsString(0, row));
                }
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
        }
        File annotated_phylogenies_outfile = null;
        boolean output_annoted_phylogenies = false;
        if (cla.isOptionSet(OUTPUT_ANNOTATED_PHYLOGENIES_OPTION)) {
            output_annoted_phylogenies = true;
            annotated_phylogenies_outfile = new File(cla.getOptionValue(OUTPUT_ANNOTATED_PHYLOGENIES_OPTION));
            String error = ForesterUtil.isWritableFile(annotated_phylogenies_outfile);
            if (!ForesterUtil.isEmpty(error)) {
                ForesterUtil.fatalError(PRG_NAME, error);
            }
        }
        try {
            CoverageCalculator cc;
            ExternalNodeBasedCoverageMethodOptions options = use_log_bl ? new ExternalNodeBasedCoverageMethodOptions(LOG_BRANCH_LENGTH_BASED_SCORING) : (use_bl ? new ExternalNodeBasedCoverageMethodOptions(BRANCH_LENGTH_BASED_SCORING) : new ExternalNodeBasedCoverageMethodOptions(BRANCH_COUNTING_BASED_SCORING));
            int s2 = phylogenies_list.get(0).getNumberOfExternalNodes() - external_otu_names.size();
            if (extend_by > s2) {
                extend_by = s2;
            }
            System.out.println();
            System.out.println("Options: " + options.asString());
            System.out.println();
            if (extend_by != -100) {
                if (extend_by > 0) {
                    System.out.println("Printing " + extend_by + " names to extend coverage in an optimal manner:");
                } else {
                    System.out.println("Printing names to completely extend coverage in an optimal manner:");
                }
                System.out.println();
                cc = CoverageCalculator.getInstance(new ExternalNodeBasedCoverageMethod(), options);
                BasicExternalNodeBasedCoverageExtender ce = new BasicExternalNodeBasedCoverageExtender();
                Coverage cov = cc.calculateCoverage(phylogenies_list, external_otu_names, false);
                System.out.println(" before:");
                System.out.println(cov.asString());
                System.out.println();
                List<String> result = ce.find(phylogenies_list, external_otu_names, extend_by, options, out);
                ArrayList<String> new_names = new ArrayList<String>(external_otu_names);
                Iterator<String> iterator = result.iterator();
                while (iterator.hasNext()) {
                    String element;
                    String n = element = iterator.next();
                    new_names.add(n);
                }
                cov = cc.calculateCoverage(phylogenies_list, new_names, output_annoted_phylogenies);
                System.out.println();
                System.out.println(" after:");
                System.out.println(cov.asString());
            } else {
                cc = CoverageCalculator.getInstance(new ExternalNodeBasedCoverageMethod(), options);
                Coverage cov = cc.calculateCoverage(phylogenies_list, external_otu_names, output_annoted_phylogenies);
                System.out.println(cov.asString());
            }
            System.out.println();
            if (output_annoted_phylogenies) {
                try {
                    PhylogenyWriter writer = new PhylogenyWriter();
                    writer.toPhyloXML(annotated_phylogenies_outfile, phylogenies_list.get(0), 1);
                    System.out.println("Wrote annotated phylogeny to \"" + annotated_phylogenies_outfile + "\"");
                    System.out.println();
                }
                catch (IOException e) {
                    ForesterUtil.fatalError(PRG_NAME, "Failed to write to \"" + annotated_phylogenies_outfile + "\" [" + e.getMessage() + "]");
                }
            }
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.toString());
        }
        System.out.println();
        System.out.println("pccx: successfully completed");
        System.out.println("If this application is useful to you, please cite:");
        System.out.println(WWW);
        System.out.println();
        out.flush();
        out.close();
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("pccx  [options] <phylogen(y|ies) infile> [external node name 1] [name 2] ... [name n]");
        System.out.println();
        System.out.println(" Options: ");
        System.out.println();
        System.out.println(" -d        : 1/distance based scoring method (instead of branch counting based)");
        System.out.println(" -ld       : -ln(distance) based scoring method (instead of branch counting based)");
        System.out.println(" -x[=<n>]  : optimally extend coverage by <n> external nodes. Use none, 0,");
        System.out.println("             or negative value for complete coverage extension.");
        System.out.println(" -o=<file> : write output to <file>");
        System.out.println(" -i=<file> : read (new-line separated) external node names from <file>");
        System.out.println(" -p=<file> : write output as annotated phylogeny to <file> (only first");
        System.out.println("             phylogeny in phylogenies infile is used)");
        System.out.println();
    }
}

