/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;

public class pfamacc2go {
    private static final String PRG_NAME = "pfamacc2go";

    public static void main(String[] args) {
        if (args.length != 2) {
            pfamacc2go.printHelp();
            System.exit(-1);
        }
        PfamToGoParser p = new PfamToGoParser(new File(args[0]));
        p.setUseAccessors(true);
        List<PfamToGoMapping> pfam2go = null;
        try {
            pfam2go = p.parse();
        }
        catch (IOException e) {
            pfamacc2go.printHelp();
            e.printStackTrace();
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(args[1]));
        }
        catch (FileNotFoundException e) {
            pfamacc2go.printHelp();
            e.printStackTrace();
        }
        int total_pfam_ids = 0;
        int mapped_pfam_ids = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                String[] pfam_ids = null;
                pfam_ids = line.contains(",") ? line.split(",") : new String[]{line};
                for (String pfam_id : pfam_ids) {
                    ++total_pfam_ids;
                    boolean mapped = false;
                    for (PfamToGoMapping pfam_to_go_mapping : pfam2go) {
                        if (!pfam_to_go_mapping.getKey().equals(pfam_id)) continue;
                        mapped = true;
                        System.out.println(pfam_to_go_mapping.getValue().toString());
                    }
                    if (!mapped) continue;
                    ++mapped_pfam_ids;
                }
            }
        }
        catch (Exception e) {
            pfamacc2go.printHelp();
            e.printStackTrace();
        }
        System.out.println("# total pfam ids : " + total_pfam_ids);
        System.out.println("# pfam ids mapped: " + mapped_pfam_ids);
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("pfamacc2go <pfam2go mapping file> <file with pfam accessors, newline and/or comma separated>");
        System.out.println();
    }
}

