/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.forester.datastructures.IntMatrix;
import org.forester.io.parsers.IteratingPhylogenyParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.rio.RIO;
import org.forester.rio.RIOException;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIutil;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.CommandLineArguments;
import org.forester.util.EasyWriter;
import org.forester.util.ForesterUtil;

public class rio {
    private static final String PRG_NAME = "rio";
    private static final String PRG_VERSION = "4.000 beta 10";
    private static final String PRG_DATE = "140211";
    private static final String E_MAIL = "phyloxml@gmail.com";
    private static final String WWW = "https://sites.google.com/site/cmzmasek/home/software/forester";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String GT_FIRST = "f";
    private static final String GT_LAST = "l";
    private static final String REROOTING_OPT = "r";
    private static final String OUTGROUP = "o";
    private static final String RETURN_SPECIES_TREE = "s";
    private static final String RETURN_BEST_GENE_TREE = "g";
    private static final String USE_SDIR = "b";
    private static final String TRANSFER_TAXONOMY_OPTION = "t";

    public static void main(String[] args) {
        File logfile;
        ForesterUtil.printProgramInformation(PRG_NAME, "resampled inference of orthologs", PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2) || args.length == 0) {
            rio.printHelp();
        }
        if (args.length < 3 || args.length > 11 || cla.getNumberOfNames() < 3) {
            System.out.println();
            System.out.println("error: incorrect number of arguments");
            System.out.println();
            rio.printHelp();
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(GT_FIRST);
        allowed_options.add(GT_LAST);
        allowed_options.add(REROOTING_OPT);
        allowed_options.add(OUTGROUP);
        allowed_options.add(USE_SDIR);
        allowed_options.add(RETURN_SPECIES_TREE);
        allowed_options.add(RETURN_BEST_GENE_TREE);
        allowed_options.add(TRANSFER_TAXONOMY_OPTION);
        String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
        if (dissallowed_options.length() > 0) {
            ForesterUtil.fatalError("unknown option(s): " + dissallowed_options);
        }
        File gene_trees_file = cla.getFile(0);
        File species_tree_file = cla.getFile(1);
        File orthology_outtable = cla.getFile(2);
        if (cla.getNumberOfNames() > 3) {
            logfile = cla.getFile(3);
            if (logfile.exists()) {
                ForesterUtil.fatalError("\"" + logfile + "\" already exists");
            }
        } else {
            logfile = null;
        }
        boolean sdir = false;
        if (cla.isOptionSet(USE_SDIR)) {
            if (cla.isOptionHasAValue(USE_SDIR)) {
                ForesterUtil.fatalError("no value allowed for -b");
            }
            sdir = true;
            if (logfile != null) {
                ForesterUtil.fatalError("no logfile output for SDIR algorithm");
            }
        }
        String outgroup = null;
        if (cla.isOptionSet(OUTGROUP)) {
            if (!cla.isOptionHasAValue(OUTGROUP)) {
                ForesterUtil.fatalError("no value for -o");
            }
            if (sdir) {
                ForesterUtil.fatalError("no outgroup option for SDIR algorithm");
            }
            outgroup = cla.getOptionValueAsCleanString(OUTGROUP);
        }
        RIO.REROOTING rerooting = RIO.REROOTING.BY_ALGORITHM;
        if (cla.isOptionSet(REROOTING_OPT)) {
            String rerooting_str;
            if (!cla.isOptionHasAValue(REROOTING_OPT)) {
                ForesterUtil.fatalError("no value for -r");
            }
            if (sdir) {
                ForesterUtil.fatalError("no re-rooting option for SDIR algorithm");
            }
            if ((rerooting_str = cla.getOptionValueAsCleanString(REROOTING_OPT).toLowerCase()).equals("none")) {
                rerooting = RIO.REROOTING.NONE;
            } else if (rerooting_str.equals("midpoint")) {
                rerooting = RIO.REROOTING.MIDPOINT;
            } else if (rerooting_str.equals("outgroup")) {
                rerooting = RIO.REROOTING.OUTGROUP;
            } else {
                ForesterUtil.fatalError("values for re-rooting are: 'none', 'midpoint', or 'outgroup' (minizming duplications is default)");
            }
        }
        if (ForesterUtil.isEmpty(outgroup) && rerooting == RIO.REROOTING.OUTGROUP) {
            ForesterUtil.fatalError("selected re-rooting by outgroup, but outgroup not set");
        }
        if (!ForesterUtil.isEmpty(outgroup) && rerooting != RIO.REROOTING.OUTGROUP) {
            ForesterUtil.fatalError("outgroup set, but selected re-rooting by other approach");
        }
        int gt_first = -1;
        int gt_last = -1;
        if (cla.isOptionSet(GT_FIRST)) {
            if (!cla.isOptionHasAValue(GT_FIRST)) {
                ForesterUtil.fatalError("no value for -f");
            }
            if (sdir) {
                ForesterUtil.fatalError("no gene tree range option for SDIR algorithm");
            }
            try {
                gt_first = cla.getOptionValueAsInt(GT_FIRST);
            }
            catch (IOException e) {
                ForesterUtil.fatalError("could not parse integer for -f option");
            }
            if (gt_first < 0) {
                ForesterUtil.fatalError("attempt to set index of first tree to analyze to: " + gt_first);
            }
        }
        if (cla.isOptionSet(GT_LAST)) {
            if (!cla.isOptionHasAValue(GT_LAST)) {
                ForesterUtil.fatalError("no value for -l");
            }
            if (sdir) {
                ForesterUtil.fatalError("no gene tree range option for SDIR algorithm");
            }
            try {
                gt_last = cla.getOptionValueAsInt(GT_LAST);
            }
            catch (IOException e) {
                ForesterUtil.fatalError("could not parse integer for -l option");
            }
            if (gt_last < 0) {
                ForesterUtil.fatalError("attempt to set index of last tree to analyze to: " + gt_last);
            }
        }
        if (gt_last != -1 && gt_first != -1 && gt_last < gt_first) {
            ForesterUtil.fatalError("attempt to set range (0-based) of gene to analyze to: from " + gt_first + " to " + gt_last);
        }
        File return_species_tree = null;
        if (!sdir && cla.isOptionSet(RETURN_SPECIES_TREE)) {
            String s2;
            if (!cla.isOptionHasAValue(RETURN_SPECIES_TREE)) {
                ForesterUtil.fatalError("no value for -s");
            }
            if ((return_species_tree = new File(s2 = cla.getOptionValueAsCleanString(RETURN_SPECIES_TREE))).exists()) {
                ForesterUtil.fatalError("\"" + return_species_tree + "\" already exists");
            }
        }
        File return_gene_tree = null;
        if (!sdir && cla.isOptionSet(RETURN_BEST_GENE_TREE)) {
            String s3;
            if (!cla.isOptionHasAValue(RETURN_BEST_GENE_TREE)) {
                ForesterUtil.fatalError("no value for -g");
            }
            if ((return_gene_tree = new File(s3 = cla.getOptionValueAsCleanString(RETURN_BEST_GENE_TREE))).exists()) {
                ForesterUtil.fatalError("\"" + return_gene_tree + "\" already exists");
            }
        }
        boolean transfer_taxonomy = false;
        if (!sdir && cla.isOptionSet(TRANSFER_TAXONOMY_OPTION)) {
            if (return_gene_tree == null) {
                ForesterUtil.fatalError("no point in transferring taxonomy data without returning best gene tree");
            }
            transfer_taxonomy = true;
        }
        ForesterUtil.fatalErrorIfFileNotReadable(gene_trees_file);
        ForesterUtil.fatalErrorIfFileNotReadable(species_tree_file);
        if (orthology_outtable.exists()) {
            ForesterUtil.fatalError("\"" + orthology_outtable + "\" already exists");
        }
        long time = 0L;
        System.out.println("Gene trees                : " + gene_trees_file);
        System.out.println("Species tree              : " + species_tree_file);
        System.out.println("All vs all orthology table: " + orthology_outtable);
        if (logfile != null) {
            System.out.println("Logfile                   : " + logfile);
        }
        if (gt_first != -1) {
            System.out.println("First gene tree to analyze: " + gt_first);
        }
        if (gt_last != -1) {
            System.out.println("Last gene tree to analyze : " + gt_last);
        }
        String rerooting_str = "";
        switch (rerooting) {
            case BY_ALGORITHM: {
                rerooting_str = "by minimizing duplications";
                break;
            }
            case MIDPOINT: {
                rerooting_str = "by midpoint method";
                break;
            }
            case OUTGROUP: {
                rerooting_str = "by outgroup: " + outgroup;
                break;
            }
            case NONE: {
                rerooting_str = "none";
            }
        }
        System.out.println("Re-rooting                : " + rerooting_str);
        if (!sdir) {
            System.out.println("Non binary species tree   : allowed");
        } else {
            System.out.println("Non binary species tree   : disallowed");
        }
        if (return_species_tree != null) {
            System.out.println("Write used species tree to: " + return_species_tree);
        }
        if (return_gene_tree != null) {
            System.out.println("Write best gene tree to   : " + return_gene_tree);
            System.out.println("Transfer taxonomic data   : " + transfer_taxonomy);
        }
        time = System.currentTimeMillis();
        SDIutil.ALGORITHM algorithm = sdir ? SDIutil.ALGORITHM.SDIR : SDIutil.ALGORITHM.GSDIR;
        try {
            RIO rio2;
            boolean iterating = false;
            PhylogenyParser p = ParserUtils.createParserDependingOnFileType(gene_trees_file, true);
            if (p instanceof PhyloXmlParser) {
                rio2 = RIO.executeAnalysis(gene_trees_file, species_tree_file, algorithm, rerooting, outgroup, gt_first, gt_last, logfile != null, true, transfer_taxonomy);
            } else {
                iterating = true;
                if (p instanceof NHXParser) {
                    NHXParser nhx = (NHXParser)p;
                    nhx.setReplaceUnderscores(false);
                    nhx.setIgnoreQuotes(true);
                    nhx.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
                } else if (p instanceof NexusPhylogeniesParser) {
                    NexusPhylogeniesParser nex = (NexusPhylogeniesParser)p;
                    nex.setReplaceUnderscores(false);
                    nex.setIgnoreQuotes(true);
                    nex.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
                } else {
                    throw new RuntimeException("unknown parser type: " + p);
                }
                IteratingPhylogenyParser ip = (IteratingPhylogenyParser)((Object)p);
                ip.setSource(gene_trees_file);
                rio2 = RIO.executeAnalysis(ip, species_tree_file, algorithm, rerooting, outgroup, gt_first, gt_last, logfile != null, true, transfer_taxonomy);
            }
            if (algorithm == SDIutil.ALGORITHM.GSDIR) {
                System.out.println("Taxonomy linking based on : " + (Object)((Object)rio2.getGSDIRtaxCompBase()));
            }
            IntMatrix m3 = iterating ? rio2.getOrthologTable() : RIO.calculateOrthologTable(rio2.getAnalyzedGeneTrees(), true);
            BasicDescriptiveStatistics stats = rio2.getDuplicationsStatistics();
            rio.writeTable(orthology_outtable, stats.getN(), m3);
            if (algorithm != SDIutil.ALGORITHM.SDIR && logfile != null) {
                rio.writeLogFile(logfile, rio2, species_tree_file, gene_trees_file, orthology_outtable, PRG_NAME, PRG_VERSION, PRG_DATE, ForesterUtil.getForesterLibraryInformation());
            }
            if (return_species_tree != null) {
                rio.writeTree(rio2.getSpeciesTree(), return_species_tree, "Wrote (stripped) species tree to");
            }
            if (return_gene_tree != null) {
                String tt = "";
                if (transfer_taxonomy) {
                    tt = "(with transferred taxonomic data) ";
                }
                rio.writeTree(rio2.getMinDuplicationsGeneTree(), return_gene_tree, "Wrote (one) minimal duplication gene tree " + tt + "to");
            }
            DecimalFormat df = new DecimalFormat("0.#");
            System.out.println("Mean number of duplications  : " + df.format(stats.arithmeticMean()) + " (sd: " + df.format(stats.sampleStandardDeviation()) + ") (" + df.format(100.0 * stats.arithmeticMean() / (double)rio2.getIntNodesOfAnalyzedGeneTrees()) + "%)");
            if (stats.getN() > 3) {
                System.out.println("Median number of duplications: " + df.format(stats.median()) + " (" + df.format(100.0 * stats.median() / (double)rio2.getIntNodesOfAnalyzedGeneTrees()) + "%)");
            }
            System.out.println("Minimum duplications         : " + (int)stats.getMin() + " (" + df.format(100.0 * stats.getMin() / (double)rio2.getIntNodesOfAnalyzedGeneTrees()) + "%)");
            System.out.println("Maximum duplications         : " + (int)stats.getMax() + " (" + df.format(100.0 * stats.getMax() / (double)rio2.getIntNodesOfAnalyzedGeneTrees()) + "%)");
            System.out.println("Gene tree internal nodes     : " + rio2.getIntNodesOfAnalyzedGeneTrees());
            System.out.println("Gene tree external nodes     : " + rio2.getExtNodesOfAnalyzedGeneTrees());
        }
        catch (RIOException e) {
            ForesterUtil.fatalError(e.getLocalizedMessage());
        }
        catch (SDIException e) {
            ForesterUtil.fatalError(e.getLocalizedMessage());
        }
        catch (IOException e) {
            ForesterUtil.fatalError(e.getLocalizedMessage());
        }
        catch (OutOfMemoryError e) {
            ForesterUtil.outOfMemoryError(e);
        }
        catch (Exception e) {
            ForesterUtil.unexpectedFatalError(e);
        }
        catch (Error e) {
            ForesterUtil.unexpectedFatalError(e);
        }
        time = System.currentTimeMillis() - time;
        System.out.println("Time: " + time + "ms");
        System.out.println("OK");
        System.exit(0);
    }

    private static final void printHelp() {
        System.out.println("Usage");
        System.out.println();
        System.out.println("rio [options] <gene trees infile> <species tree infile> <all vs all orthology table outfile> [logfile]");
        System.out.println();
        System.out.println(" Options");
        System.out.println("  -f=<first>     : first gene tree to analyze (0-based index)");
        System.out.println("  -l=<last>      : last gene tree to analyze (0-based index)");
        System.out.println("  -r=<re-rooting>: re-rooting method for gene trees, possible values or 'none', 'midpoint',");
        System.out.println("                   or 'outgroup' (default: by minizming duplications)");
        System.out.println("  -o=<outgroup>  : for rooting by outgroup, name of outgroup (external gene tree node)");
        System.out.println("  -s=<outfile>   : to write the (stripped) species tree to file");
        System.out.println("  -g=<outfile>   : to write (one) minimal duplication gene tree to file");
        System.out.println("  -t             : to transfer taxonomic data from species tree to returned minimal duplication gene tree\n                   (if -g option is used)");
        System.out.println("  -b             : to use SDIR instead of GSDIR (faster, but non-binary species trees are");
        System.out.println("                   disallowed, as are most options)");
        System.out.println();
        System.out.println(" Formats");
        System.out.println("  The gene trees, as well as the species tree, ideally are in phyloXML (www.phyloxml.org) format,");
        System.out.println("  but can also be in New Hamphshire (Newick) or Nexus format as long as species information can be");
        System.out.println("  extracted from the gene names (e.g. \"HUMAN\" from \"BCL2_HUMAN\") and matched to a single species");
        System.out.println("  in the species tree.");
        System.out.println();
        System.out.println(" Examples");
        System.out.println("  \"rio gene_trees.nh species.xml outtable.tsv log.txt\"");
        System.out.println();
        System.out.println(" More information: http://code.google.com/p/forester/wiki/RIO");
        System.out.println();
        System.exit(-1);
    }

    private static void writeLogFile(File logfile, RIO rio2, File species_tree_file, File gene_trees_file, File outtable, String prg_name, String prg_v, String prg_date, String f) throws IOException {
        EasyWriter out = ForesterUtil.createEasyWriter(logfile);
        out.println(prg_name);
        out.println("version : " + prg_v);
        out.println("date    : " + prg_date);
        out.println("based on: " + f);
        out.println("----------------------------------");
        out.println("Gene trees                                      : " + gene_trees_file);
        out.println("Species tree                                    : " + species_tree_file);
        out.println("All vs all orthology table                      : " + outtable);
        out.flush();
        out.println(rio2.getLog().toString());
        out.close();
        System.out.println("Wrote log to \"" + logfile + "\"");
    }

    private static void writeTable(File table_outfile, int gene_trees_analyzed, IntMatrix m3) throws IOException {
        EasyWriter w = ForesterUtil.createEasyWriter(table_outfile);
        DecimalFormat df = new DecimalFormat("0.####");
        df.setDecimalSeparatorAlwaysShown(false);
        df.setRoundingMode(RoundingMode.HALF_UP);
        for (int i = 0; i < m3.size(); ++i) {
            w.print("\t");
            w.print(m3.getLabel(i));
        }
        w.println();
        for (int x = 0; x < m3.size(); ++x) {
            w.print(m3.getLabel(x));
            for (int y = 0; y < m3.size(); ++y) {
                w.print("\t");
                if (x == y) {
                    if (m3.get(x, y) != gene_trees_analyzed) {
                        ForesterUtil.unexpectedFatalError("diagonal value is off");
                    }
                    w.print("-");
                    continue;
                }
                w.print(df.format((double)m3.get(x, y) / (double)gene_trees_analyzed));
            }
            w.println();
        }
        w.close();
        System.out.println("Wrote table to \"" + table_outfile + "\"");
    }

    private static void writeTree(Phylogeny p, File f, String comment) throws IOException {
        PhylogenyWriter writer = new PhylogenyWriter();
        writer.toPhyloXML(f, p, 0);
        System.out.println(comment + " \"" + f + "\"");
    }
}

