/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.CommandLineArguments;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public final class support_statistics {
    private static final int PLACES = 2;
    private static final String HELP_OPTION = "help";
    private static final String OUTPUTFILE_OPTION = "o";
    private static final String PRG_NAME = "support_statistics";
    private static final String PRG_VERSION = "1.0";
    private static final String PRG_DATE = "2008.08.29";

    private static StringBuffer analyze(File[] phylogenies_infiles, Phylogeny[] phylogenies) {
        DescriptiveStatistics[] dss = new DescriptiveStatistics[phylogenies.length];
        for (int i = 0; i < phylogenies.length; ++i) {
            dss[i] = new BasicDescriptiveStatistics();
            DescriptiveStatistics[] p = phylogenies[i];
            PhylogenyNodeIterator iter = p.iteratorPostorder();
            while (iter.hasNext()) {
                PhylogenyNode node = iter.next();
                if (node.isRoot() || node.isExternal()) continue;
                double s2 = PhylogenyMethods.getConfidenceValue(node);
                if (s2 < 0.0) {
                    s2 = 0.0;
                }
                dss[i].addValue(s2);
            }
        }
        BasicDescriptiveStatistics dss_comp = null;
        if (dss.length > 2) {
            dss_comp = new BasicDescriptiveStatistics();
            for (DescriptiveStatistics element : dss) {
                dss_comp.addValue(element.arithmeticMean());
            }
        }
        int max_length = 30;
        for (int i = 0; i < phylogenies.length; ++i) {
            int l = phylogenies_infiles[i].getName().length();
            if (l <= max_length) continue;
            max_length = l;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\t" + ForesterUtil.normalizeString("name:", max_length, true, ' ') + "\t");
        sb.append("median:\t");
        sb.append("mean:\t");
        sb.append("sd:\t");
        sb.append("min:\t");
        sb.append("max:\t");
        sb.append("n:\t");
        if (dss_comp != null) {
            sb.append("\"z-score\":");
        }
        sb.append(ForesterUtil.getLineSeparator());
        for (int i = 0; i < phylogenies.length; ++i) {
            sb.append(i + 1 + ":\t" + ForesterUtil.normalizeString(phylogenies_infiles[i].getName(), max_length, true, ' ') + "\t");
            sb.append(ForesterUtil.round(dss[i].median(), 2) + "\t");
            sb.append(ForesterUtil.round(dss[i].arithmeticMean(), 2) + "\t");
            try {
                sb.append(ForesterUtil.round(dss[i].sampleStandardDeviation(), 2) + "\t");
            }
            catch (ArithmeticException ex) {
                sb.append("n/a\t");
            }
            sb.append(ForesterUtil.round(dss[i].getMin(), 2) + "\t");
            sb.append(ForesterUtil.round(dss[i].getMax(), 2) + "\t");
            sb.append(dss[i].getN() + "\t");
            if (dss_comp != null) {
                double z_score = dss_comp.sampleStandardUnit(dss[i].arithmeticMean());
                sb.append(ForesterUtil.round(z_score, 2) + "\t");
            }
            sb.append(ForesterUtil.getLineSeparator());
        }
        if (dss_comp != null) {
            sb.append(ForesterUtil.getLineSeparator());
            sb.append("\t" + ForesterUtil.normalizeString("values for support means:", max_length, true, ' ') + "\t\t");
            sb.append(ForesterUtil.round(dss_comp.arithmeticMean(), 2) + "\t");
            sb.append(ForesterUtil.round(dss_comp.sampleStandardDeviation(), 2) + "\t");
            sb.append(ForesterUtil.round(dss_comp.getMin(), 2) + "\t");
            sb.append(ForesterUtil.round(dss_comp.getMax(), 2) + "\t");
        }
        return sb;
    }

    public static void main(String[] args) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        if (args.length < 1) {
            System.out.println();
            System.out.println("wrong number of arguments");
            System.out.println();
            support_statistics.printHelp();
            System.exit(-1);
        }
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION)) {
            System.out.println();
            support_statistics.printHelp();
            System.exit(0);
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(OUTPUTFILE_OPTION);
        String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
        if (dissallowed_options.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
        }
        File[] phylogenies_infiles = new File[cla.getNumberOfNames()];
        for (int i = 0; i < phylogenies_infiles.length; ++i) {
            phylogenies_infiles[i] = cla.getFile(i);
        }
        File outfile = null;
        if (cla.isOptionSet(OUTPUTFILE_OPTION)) {
            try {
                outfile = new File(cla.getOptionValue(OUTPUTFILE_OPTION));
            }
            catch (IllegalArgumentException e) {
                ForesterUtil.fatalError(PRG_NAME, "error in command line: " + e.getMessage());
            }
            String error = ForesterUtil.isWritableFile(outfile);
            if (error != null) {
                ForesterUtil.fatalError(PRG_NAME, error);
            }
        }
        Phylogeny[] phylogenies = new Phylogeny[phylogenies_infiles.length];
        for (int i = 0; i < phylogenies_infiles.length; ++i) {
            try {
                PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                PhylogenyParser pp = ParserUtils.createParserDependingOnFileType(phylogenies_infiles[i], true);
                phylogenies[i] = factory.create(phylogenies_infiles[i], pp)[0];
                continue;
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "could not read \"" + phylogenies_infiles[i] + "\": " + e.getMessage());
            }
        }
        StringBuffer sb = support_statistics.analyze(phylogenies_infiles, phylogenies);
        System.out.println();
        System.out.println(sb);
        System.out.println();
        if (outfile != null) {
            try {
                PrintWriter out = new PrintWriter(outfile);
                out.println(sb);
                out.flush();
                out.close();
                System.out.println("wrote file: " + outfile);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to write output: " + e.getMessage());
            }
        }
        System.out.println("support_statistics: successfully completed");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println("usage:");
        System.out.println();
        System.out.println("support_statistics [-o=<outfile>] <phylogeny infile 1> <phylogeny infile 2> <phylogeny infile 3> ...");
        System.out.println();
        System.out.println(" options: ");
        System.out.println();
        System.out.println(" -o=<outfile> : write output to file");
        System.out.println();
    }
}

