/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.BasicDescriptiveStatistics;

public class genome_counts_for_once_appearing_dcs {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println();
            System.err.println("genome_counts_for_once_appearing_dcs: wrong number of arguments");
            System.err.println("Usage: \"genome_counts_for_once_appearing_dcs <intree>");
            System.err.println();
            System.exit(-1);
        }
        File infile = new File(args[0]);
        Phylogeny phy = null;
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            phy = factory.create(infile, ParserUtils.createParserDependingOnFileType(infile, true))[0];
        }
        catch (Exception e) {
            System.err.println(e + "\nCould not read " + infile + "\n");
            System.exit(-1);
        }
        SortedSet<String> all_dcs = genome_counts_for_once_appearing_dcs.getAllExternalPresentAndGainedCharacters(phy.getRoot());
        TreeSet<String> appearing_once_dcs = new TreeSet<String>();
        System.out.println("All DCs: " + all_dcs.size());
        for (String dc : all_dcs) {
            int reappearing_count = 0;
            Iterator<PhylogenyNode> it = phy.iteratorPreorder();
            while (it.hasNext()) {
                PhylogenyNode n = it.next();
                SortedSet<String> n_gained_dcs = null;
                n_gained_dcs = n.isRoot() ? n.getNodeData().getBinaryCharacters().getPresentCharacters() : n.getNodeData().getBinaryCharacters().getGainedCharacters();
                if (!n_gained_dcs.contains(dc)) continue;
                ++reappearing_count;
            }
            if (reappearing_count < 1) {
                System.out.println("error: " + dc);
                System.exit(-1);
            }
            if (reappearing_count != true) continue;
            appearing_once_dcs.add(dc);
        }
        System.out.println("Appearing once DCs: " + appearing_once_dcs.size());
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        HashMap<String, SortedSet<String>> node_to_chars = new HashMap<String, SortedSet<String>>();
        TreeSet<String> appearing_in_all_dcs = new TreeSet<String>();
        for (String appearing_once_dc : appearing_once_dcs) {
            int count = 0;
            PhylogenyNodeIterator ite = phy.iteratorExternalForward();
            while (ite.hasNext()) {
                PhylogenyNode ext_node = ite.next();
                if (!node_to_chars.containsKey(ext_node.getName())) {
                    node_to_chars.put(ext_node.getName(), genome_counts_for_once_appearing_dcs.getAllExternalPresentAndGainedCharacters(ext_node));
                }
                if (!((Set)node_to_chars.get(ext_node.getName())).contains(appearing_once_dc)) continue;
                ++count;
            }
            if (count < 1) {
                System.out.println("error, count is <1");
                System.exit(-1);
            }
            if (count == phy.getNumberOfExternalNodes()) {
                appearing_in_all_dcs.add(appearing_once_dc);
            }
            stats.addValue(count);
        }
        System.out.println();
        System.out.println(stats.toString());
        System.out.println();
        int[] bins = BasicDescriptiveStatistics.performBinning(stats.getDataAsDoubleArray(), 1.0, 172.0, 172);
        for (int i = 0; i < bins.length; ++i) {
            System.out.println(i + 1 + "\t" + bins[i]);
        }
        System.out.println();
        System.out.println("appearing in all:");
        for (String i : appearing_in_all_dcs) {
            System.out.println(i);
        }
        System.out.println();
        for (String dc : appearing_once_dcs) {
            System.out.println("1\t" + dc);
        }
    }

    private static SortedSet<String> getAllExternalPresentAndGainedCharacters(PhylogenyNode node) {
        TreeSet<String> chars = new TreeSet<String>();
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        for (PhylogenyNode desc : descs) {
            chars.addAll(desc.getNodeData().getBinaryCharacters().getGainedCharacters());
            chars.addAll(desc.getNodeData().getBinaryCharacters().getPresentCharacters());
        }
        return chars;
    }
}

