/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.forester.archaeopteryx.Archaeopteryx;
import org.forester.io.parsers.FastaParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.sequence.MolecularSequence;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class map_lengths {
    private static final String PRG_NAME = "map_lengths";

    public static void main(String[] args) {
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            PhyloXmlParser xml_parser = PhyloXmlParser.createPhyloXmlParserXsdValidating();
            Phylogeny[] phylogenies_0 = factory.create(cla.getFile(0), xml_parser);
            Phylogeny phy = phylogenies_0[0];
            for (int i = 1; i < cla.getNumberOfNames(); ++i) {
                String fasta_name = cla.getName(i);
                List<MolecularSequence> seqs = FastaParser.parse(new File(fasta_name));
                for (int s2 = 0; s2 < seqs.size(); ++s2) {
                    MolecularSequence seq = seqs.get(s2);
                    int actual_length = seq.getLength() - seq.getNumberOfGapResidues();
                    String node_name = "" + seq.getIdentifier();
                    PhylogenyNode n = phy.getNode(node_name = node_name.substring(0, node_name.indexOf("/")));
                    if (n.getNodeData().getProperties() == null) {
                        n.getNodeData().setProperties(new PropertiesMap());
                    }
                    PropertiesMap properties = n.getNodeData().getProperties();
                    Property p = new Property("r:" + i, "" + actual_length, "", "xsd:integer", Property.AppliesTo.NODE);
                    properties.addProperty(p);
                }
            }
            Archaeopteryx.createApplication(phy);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

