/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.codec.binary.Base64;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.ColorSchemeChooser;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.FontChooser;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TextFrame;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreePanel;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.sdi.GSDI;
import org.forester.sdi.GSDIR;
import org.forester.sdi.SDIException;
import org.forester.util.ForesterConstants;
import org.forester.util.ForesterUtil;
import org.forester.util.WindowsUtils;

public class ArchaeopteryxE
extends JApplet
implements ActionListener {
    private static final String NAME = "ArchaeopteryxE";
    private static final long serialVersionUID = -1220055577935759443L;
    private Configuration _configuration;
    private MainPanel _mainpanel;
    private JMenuBar _jmenubar;
    private JMenu _options_jmenu;
    private JMenu _font_size_menu;
    private JMenuItem _super_tiny_fonts_mi;
    private JMenuItem _tiny_fonts_mi;
    private JMenuItem _small_fonts_mi;
    private JMenuItem _medium_fonts_mi;
    private JMenuItem _large_fonts_mi;
    private JMenu _tools_menu;
    private JMenuItem _taxcolor_item;
    private JMenuItem _confcolor_item;
    private JMenuItem _midpoint_root_item;
    private JMenu _view_jmenu;
    private JMenuItem _view_as_XML_item;
    private JMenuItem _view_as_NH_item;
    private JMenuItem _view_as_nexus_item;
    private JMenuItem _display_basic_information_item;
    private JMenu _type_menu;
    private JCheckBoxMenuItem _rectangular_type_cbmi;
    private JCheckBoxMenuItem _triangular_type_cbmi;
    private JCheckBoxMenuItem _curved_type_cbmi;
    private JCheckBoxMenuItem _convex_type_cbmi;
    private JCheckBoxMenuItem _euro_type_cbmi;
    private JCheckBoxMenuItem _rounded_type_cbmi;
    private JCheckBoxMenuItem _unrooted_type_cbmi;
    private JCheckBoxMenuItem _circular_type_cbmi;
    private JMenuItem _help_item;
    private JMenuItem _about_item;
    private JMenu _help_jmenu;
    private JMenuItem _website_item;
    private JMenuItem _phyloxml_website_item;
    private JMenuItem _phyloxml_ref_item;
    private JMenuItem _aptx_ref_item;
    private JMenuItem _remove_branch_color_item;
    private JMenuItem _remove_visual_styles_item;
    private JCheckBoxMenuItem _show_domain_labels;
    private JCheckBoxMenuItem _show_annotation_ref_source;
    private JCheckBoxMenuItem _color_labels_same_as_parent_branch;
    private JCheckBoxMenuItem _abbreviate_scientific_names;
    private JCheckBoxMenuItem _screen_antialias_cbmi;
    private JCheckBoxMenuItem _background_gradient_cbmi;
    private JCheckBoxMenuItem _color_by_taxonomic_group_cbmi;
    private JRadioButtonMenuItem _non_lined_up_cladograms_rbmi;
    private JRadioButtonMenuItem _uniform_cladograms_rbmi;
    private JRadioButtonMenuItem _ext_node_dependent_cladogram_rbmi;
    private Options _options;
    private JMenuItem _choose_font_mi;
    private JMenuItem _switch_colors_mi;
    JCheckBoxMenuItem _label_direction_cbmi;
    private JCheckBoxMenuItem _show_scale_cbmi;
    private JCheckBoxMenuItem _search_case_senstive_cbmi;
    private JCheckBoxMenuItem _search_whole_words_only_cbmi;
    private JCheckBoxMenuItem _inverse_search_result_cbmi;
    private JCheckBoxMenuItem _search_with_regex_cbmi;
    private JCheckBoxMenuItem _show_overview_cbmi;
    private JMenuItem _choose_minimal_confidence_mi;
    private JMenuItem _collapse_species_specific_subtrees;
    private JMenuItem _overview_placment_mi;
    private ButtonGroup _radio_group_1;
    private JCheckBoxMenuItem _show_default_node_shapes_internal_cbmi;
    private JCheckBoxMenuItem _show_default_node_shapes_external_cbmi;
    private JCheckBoxMenuItem _show_default_node_shapes_for_marked_cbmi;
    private JMenuItem _cycle_node_shape_mi;
    private JMenuItem _cycle_node_fill_mi;
    private JMenuItem _choose_node_size_mi;
    private JCheckBoxMenuItem _show_confidence_stddev_cbmi;
    private final LinkedList<TextFrame> _textframes = new LinkedList();
    private JMenu _analysis_menu;
    private JMenuItem _gsdi_item;
    private JMenuItem _gsdir_item;
    private Phylogeny _species_tree;
    private JCheckBoxMenuItem _right_line_up_domains_cbmi;
    private JCheckBoxMenuItem _line_up_renderable_data_cbmi;
    private JMenuItem _save_item;
    private JMenuItem _print_item;
    private JMenuItem _write_to_pdf_item;
    private JMenuItem _write_to_jpg_item;
    private JMenuItem _write_to_gif_item;
    private JMenuItem _write_to_tif_item;
    private JMenuItem _write_to_png_item;
    private JMenuItem _write_to_bmp_item;
    private JMenu _file_jmenu;
    private JFileChooser _writetopdf_filechooser;
    private File _current_dir;
    private JFileChooser _save_filechooser;
    private JFileChooser _writetographics_filechooser;
    private JCheckBoxMenuItem _graphics_export_visible_only_cbmi;
    private JCheckBoxMenuItem _antialias_print_cbmi;
    private JCheckBoxMenuItem _print_black_and_white_cbmi;
    private JCheckBoxMenuItem _print_using_actual_size_cbmi;
    private JCheckBoxMenuItem _graphics_export_using_actual_size_cbmi;
    private JMenuItem _print_size_mi;
    private JMenuItem _choose_pdf_width_mi;

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this._midpoint_root_item) {
            this.getMainPanel().getCurrentTreePanel().midpointRoot();
        } else if (o == this._gsdi_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.executeGSDI();
        } else if (o == this._gsdir_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.executeGSDIR();
        } else if (o == this._taxcolor_item) {
            this.getMainPanel().getCurrentTreePanel().taxColor();
        } else if (o == this._confcolor_item) {
            this.getMainPanel().getCurrentTreePanel().confColor();
        } else if (o == this._collapse_species_specific_subtrees) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().collapseSpeciesSpecificSubtrees();
            }
        } else if (o == this._remove_branch_color_item) {
            this.removeBranchColors();
        } else if (o == this._remove_visual_styles_item) {
            this.removeVisualStyles();
        } else if (o == this._switch_colors_mi) {
            this.switchColors();
        } else if (o == this._display_basic_information_item) {
            this.displayBasicInformation();
        } else if (o == this._view_as_NH_item) {
            this.viewAsNH();
        } else if (o == this._view_as_XML_item) {
            this.viewAsXML();
        } else if (o == this._view_as_nexus_item) {
            this.viewAsNexus();
        } else if (o == this._super_tiny_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSuperTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._tiny_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._small_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSmallFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._medium_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setMediumFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._large_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setLargeFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._choose_font_mi) {
            this.chooseFont();
        } else if (o == this._choose_minimal_confidence_mi) {
            this.chooseMinimalConfidence();
        } else if (o == this._choose_node_size_mi) {
            MainFrame.chooseNodeSize(this.getOptions(), this);
        } else if (o == this._overview_placment_mi) {
            MainFrame.cycleOverview(this.getOptions(), this.getCurrentTreePanel());
        } else if (o == this._cycle_node_fill_mi) {
            MainFrame.cycleNodeFill(this.getOptions());
        } else if (o == this._cycle_node_shape_mi) {
            MainFrame.cycleNodeShape(this.getOptions());
        } else if (o == this._non_lined_up_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this._mainpanel.getControlPanel().showWhole();
        } else if (o == this._uniform_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this._mainpanel.getControlPanel().showWhole();
        } else if (o == this._ext_node_dependent_cladogram_rbmi) {
            this.updateOptions(this.getOptions());
            this._mainpanel.getControlPanel().showWhole();
        } else if (o == this._search_case_senstive_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
        } else if (o == this._search_whole_words_only_cbmi) {
            if (this._search_with_regex_cbmi != null && this._search_whole_words_only_cbmi.isSelected()) {
                this._search_with_regex_cbmi.setSelected(false);
            }
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
        } else if (o == this._inverse_search_result_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
        } else if (o == this._search_with_regex_cbmi) {
            if (this._search_whole_words_only_cbmi != null && this._search_with_regex_cbmi.isSelected()) {
                this._search_whole_words_only_cbmi.setSelected(false);
            }
            if (this._search_case_senstive_cbmi != null && this._search_with_regex_cbmi.isSelected()) {
                this._search_case_senstive_cbmi.setSelected(true);
            }
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
        } else if (o == this._show_scale_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_confidence_stddev_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._label_direction_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._abbreviate_scientific_names) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_overview_cbmi) {
            this.updateOptions(this.getOptions());
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().updateOvSizes();
            }
        } else if (o == this._rectangular_type_cbmi || o == this._triangular_type_cbmi || o == this._curved_type_cbmi || o == this._convex_type_cbmi || o == this._rounded_type_cbmi || o == this._euro_type_cbmi || o == this._unrooted_type_cbmi || o == this._circular_type_cbmi) {
            this.typeChanged(o);
        } else if (o == this._screen_antialias_cbmi) {
            this.updateOptions(this.getOptions());
            ArchaeopteryxE.setupScreenTextAntialias(this.getMainPanel().getTreePanels(), this.isScreenAntialias());
        } else if (o == this._background_gradient_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_domain_labels) {
            this.updateOptions(this.getOptions());
        } else if (o == this._color_labels_same_as_parent_branch) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_default_node_shapes_internal_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_default_node_shapes_external_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._about_item) {
            MainFrame.about();
        } else if (o == this._help_item) {
            try {
                AptxUtil.openWebsite("https://sites.google.com/site/cmzmasek/home/software/archaeopteryx/documentation", true, this);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._website_item) {
            try {
                AptxUtil.openWebsite("https://sites.google.com/site/cmzmasek/home/software/archaeopteryx", true, this);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._phyloxml_website_item) {
            try {
                AptxUtil.openWebsite("http://www.phyloxml.org", true, this);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._aptx_ref_item) {
            try {
                AptxUtil.openWebsite("http://www.biomedcentral.com/bmcbioinformatics/", true, this);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._phyloxml_ref_item) {
            try {
                AptxUtil.openWebsite("http://www.biomedcentral.com/1471-2105/10/356/", true, this);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._color_by_taxonomic_group_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._line_up_renderable_data_cbmi) {
            if (!this._line_up_renderable_data_cbmi.isSelected()) {
                this._right_line_up_domains_cbmi.setSelected(false);
            }
            this.updateOptions(this.getOptions());
        } else if (o == this._right_line_up_domains_cbmi) {
            if (this._right_line_up_domains_cbmi.isSelected()) {
                this._line_up_renderable_data_cbmi.setSelected(true);
            }
            this.updateOptions(this.getOptions());
        } else if (o == this._write_to_pdf_item) {
            File curr_dir = MainFrame.writeToPdf(this._mainpanel.getCurrentPhylogeny(), this.getMainPanel(), this._writetopdf_filechooser, this._current_dir, this.getContentPane(), this);
            if (curr_dir != null) {
                this.setCurrentDir(curr_dir);
            }
        } else if (o == this._write_to_jpg_item) {
            File curr_dir = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.JPG, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (curr_dir != null) {
                this.setCurrentDir(curr_dir);
            }
        } else if (o == this._write_to_gif_item) {
            File curr_dir = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.GIF, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (curr_dir != null) {
                this.setCurrentDir(curr_dir);
            }
        } else if (o == this._write_to_tif_item) {
            File curr_dir = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.TIFF, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (curr_dir != null) {
                this.setCurrentDir(curr_dir);
            }
        } else if (o == this._write_to_bmp_item) {
            File curr_dir = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.BMP, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (curr_dir != null) {
                this.setCurrentDir(curr_dir);
            }
        } else if (o == this._write_to_png_item) {
            File curr_dir = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.PNG, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (curr_dir != null) {
                this.setCurrentDir(curr_dir);
            }
        } else if (o == this._print_item) {
            MainFrame.print(this.getCurrentTreePanel(), this.getOptions(), this);
        } else if (o == this._save_item) {
            File new_dir = MainFrame.writeToFile(this._mainpanel.getCurrentPhylogeny(), this.getMainPanel(), this._save_filechooser, this._current_dir, this.getContentPane(), this);
            if (new_dir != null) {
                this.setCurrentDir(new_dir);
            }
        } else if (o == this._graphics_export_visible_only_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._antialias_print_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._print_black_and_white_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._print_using_actual_size_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._graphics_export_using_actual_size_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._print_size_mi) {
            this.choosePrintSize();
        } else if (o == this._choose_pdf_width_mi) {
            this.choosePdfWidth();
        }
        this.repaint();
    }

    @Override
    public void destroy() {
        AptxUtil.printAppletMessage(NAME, "going to be destroyed ");
        this.removeAllTextFrames();
        if (this.getMainPanel() != null) {
            this.getMainPanel().terminate();
        }
    }

    public String getCurrentExternalNodesDataBuffer() {
        return this.getCurrentTreePanel().getCurrentExternalNodesDataBufferAsString();
    }

    public int getCurrentExternalNodesDataBufferChangeCounter() {
        return this.getCurrentTreePanel().getCurrentExternalNodesDataBufferChangeCounter();
    }

    public int getCurrentExternalNodesDataBufferLength() {
        return this.getCurrentTreePanel().getCurrentExternalNodesDataBufferAsString().length();
    }

    public String getCurrentPhylogeny(String format) {
        this.removeAllTextFrames();
        if (this.getMainPanel().getCurrentPhylogeny() == null || this.getMainPanel().getCurrentPhylogeny().isEmpty() || this.getMainPanel().getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return new String();
        }
        switch (ForesterConstants.PhylogeneticTreeFormats.valueOf(format)) {
            case NH: {
                return this.getMainPanel().getCurrentPhylogeny().toNewHampshire();
            }
            case NHX: {
                return this.getMainPanel().getCurrentPhylogeny().toNewHampshireX();
            }
            case NEXUS: {
                return this.getMainPanel().getCurrentPhylogeny().toNexus();
            }
            case PHYLOXML: {
                return this.getMainPanel().getCurrentPhylogeny().toPhyloXML(-1);
            }
        }
        return new String();
    }

    public String getCurrentPhylogenyGraphicsAsBase64EncodedString(String format) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            AptxUtil.writePhylogenyToGraphicsByteArrayOutputStream(baos, this._mainpanel.getWidth(), this._mainpanel.getHeight(), this.getCurrentTreePanel(), this.getCurrentTreePanel().getControlPanel(), AptxUtil.GraphicsExportType.valueOf(format), this.getOptions());
        }
        catch (IOException ioe) {
            ForesterUtil.printErrorMessage(NAME, ioe.toString());
            ioe.printStackTrace();
            JOptionPane.showMessageDialog(this, "ArchaeopteryxE: Failed to generate graphics: \nException: " + ioe, "Failed to generate graphics", 0);
            return null;
        }
        byte[] bytes = baos.toByteArray();
        String dataImg = Base64.encodeBase64String(bytes);
        return dataImg;
    }

    public Options getOptions() {
        return this._options;
    }

    @Override
    public void init() {
        this._writetopdf_filechooser = new JFileChooser();
        this._writetopdf_filechooser.setMultiSelectionEnabled(false);
        this._writetopdf_filechooser.addChoosableFileFilter(MainFrame.pdffilter);
        this._writetographics_filechooser = new JFileChooser();
        this._writetographics_filechooser.setMultiSelectionEnabled(false);
        this._writetographics_filechooser.addChoosableFileFilter(MainFrame.graphicsfilefilter);
        this._save_filechooser = new JFileChooser();
        this._save_filechooser.setMultiSelectionEnabled(false);
        this._save_filechooser.setFileFilter(MainFrame.xmlfilter);
        this._save_filechooser.addChoosableFileFilter(MainFrame.nhfilter);
        this._save_filechooser.addChoosableFileFilter(MainFrame.nexusfilter);
        this._save_filechooser.addChoosableFileFilter(this._save_filechooser.getAcceptAllFileFilter());
        try {
            String home_dir = System.getProperty("user.home");
            this._save_filechooser.setCurrentDirectory(new File(home_dir));
            this._writetopdf_filechooser.setCurrentDirectory(new File(home_dir));
            this._writetographics_filechooser.setCurrentDirectory(new File(home_dir));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String config_filename = this.getParameter("config_file");
        AptxUtil.printAppletMessage(NAME, "URL for configuration file is: " + config_filename);
        Configuration configuration = new Configuration(config_filename, true, true, true);
        this.setConfiguration(configuration);
        this.setOptions(Options.createInstance(configuration));
        this.setupUI();
        String tree_url_str = this.getParameter("url_of_tree_to_load");
        if (ForesterUtil.isEmpty(tree_url_str)) {
            ForesterUtil.printErrorMessage(NAME, "could not get tree URL from url_of_tree_to_load");
            JOptionPane.showMessageDialog(this, "ArchaeopteryxE: could not get tree URL from url_of_tree_to_load", "Failed get URL", 0);
            return;
        }
        AptxUtil.printAppletMessage(NAME, "URL for phylogenies is " + tree_url_str);
        URL phys_url = null;
        try {
            phys_url = new URL(tree_url_str);
        }
        catch (Exception e) {
            ForesterUtil.printErrorMessage(NAME, "error: " + e);
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "ArchaeopteryxE: Could not create URL from: \"" + tree_url_str + "\"\nException: " + e, "Failed to create URL", 0);
        }
        if (phys_url == null) {
            ForesterUtil.printErrorMessage(NAME, "failed to get tree URL from url_of_tree_to_load");
            JOptionPane.showMessageDialog(this, "ArchaeopteryxE: Could not create URL from: \"" + tree_url_str, "Failed to create URL", 0);
            return;
        }
        Phylogeny[] phys = null;
        try {
            phys = AptxUtil.readPhylogeniesFromUrl(phys_url, this.getConfiguration().isValidatePhyloXmlAgainstSchema(), this.getConfiguration().isReplaceUnderscoresInNhParsing(), this.getConfiguration().isInternalNumberAreConfidenceForNhParsing(), this.getConfiguration().getTaxonomyExtraction(), this.getConfiguration().isMidpointReroot());
        }
        catch (Exception e) {
            ForesterUtil.printErrorMessage(NAME, e.toString());
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "ArchaeopteryxE: Failed to read phylogenies: \nException: " + e, "Failed to read phylogenies", 0);
        }
        if (phys == null) {
            ForesterUtil.printErrorMessage(NAME, "phylogenies from [" + phys_url + "] are null");
            JOptionPane.showMessageDialog(this, "ArchaeopteryxE: phylogenies from [" + phys_url + "] are null", "Failed to read phylogenies", 0);
            return;
        }
        if (phys.length < 1) {
            ForesterUtil.printErrorMessage(NAME, "phylogenies from [" + phys_url + "] are empty");
            JOptionPane.showMessageDialog(this, "ArchaeopteryxE: phylogenies from [" + phys_url + "] are empty", "Failed to read phylogenies", 0);
            return;
        }
        AptxUtil.printAppletMessage(NAME, "loaded " + phys.length + " phylogenies from: " + phys_url);
        String species_tree_url_str = this.getParameter("url_of_species_tree_to_load");
        if (!ForesterUtil.isEmpty(species_tree_url_str)) {
            AptxUtil.printAppletMessage(NAME, "URL of species tree to load: \"" + species_tree_url_str + "\"");
            Phylogeny[] species_trees = null;
            try {
                URL species_tree_url = new URL(species_tree_url_str);
                species_trees = AptxUtil.readPhylogeniesFromUrl(species_tree_url, configuration.isValidatePhyloXmlAgainstSchema(), configuration.isReplaceUnderscoresInNhParsing(), false, NHXParser.TAXONOMY_EXTRACTION.NO, false);
            }
            catch (IOException e) {
                ForesterUtil.printErrorMessage(NAME, "could not read species tree from  [" + species_tree_url_str + "]");
                JOptionPane.showMessageDialog(this, "ArchaeopteryxE: could not read species tree from  [" + species_tree_url_str + "]", "Failed to read species tree", 0);
            }
            if (species_trees != null && species_trees.length > 0) {
                AptxUtil.printAppletMessage(NAME, "successfully read species tree");
                if (species_trees[0].isEmpty()) {
                    ForesterUtil.printErrorMessage(NAME, "species tree is empty");
                } else if (!species_trees[0].isRooted()) {
                    ForesterUtil.printErrorMessage(NAME, "species tree is not rooted");
                } else {
                    this.setSpeciesTree(species_trees[0]);
                    AptxUtil.printAppletMessage(NAME, "species tree OK");
                }
            }
        }
        try {
            String default_sequence;
            this.setVisible(false);
            this.setMainPanel(new MainPanelApplets(this.getConfiguration(), this));
            this._jmenubar = new JMenuBar();
            if (!this.getConfiguration().isHideControlPanelAndMenubar()) {
                this.buildFileMenu();
                if (!this.getConfiguration().isUseNativeUI()) {
                    this._jmenubar.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                }
                if (this.getSpeciesTree() != null) {
                    this.buildAnalysisMenu();
                }
                this.buildToolsMenu();
                this.buildViewMenu();
                this.buildFontSizeMenu();
                this.buildOptionsMenu();
                this.buildTypeMenu();
                this.buildHelpMenu();
                this.setJMenuBar(this._jmenubar);
            }
            Container contentpane = this.getContentPane();
            contentpane.setLayout(new BorderLayout());
            contentpane.add((Component)this.getMainPanel(), "Center");
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (ArchaeopteryxE.this.getMainPanel().getCurrentTreePanel() != null) {
                        ArchaeopteryxE.this.getMainPanel().getCurrentTreePanel().calcParametersForPainting(ArchaeopteryxE.this.getMainPanel().getCurrentTreePanel().getWidth(), ArchaeopteryxE.this.getMainPanel().getCurrentTreePanel().getHeight());
                    }
                }
            });
            if (this.getConfiguration().isUseTabbedDisplay()) {
                try {
                    AptxUtil.printAppletMessage(NAME, "using tabbed display");
                    AptxUtil.addPhylogeniesToTabs(phys, new File(phys_url.getFile()).getName(), phys_url.toString(), this.getConfiguration(), this.getMainPanel());
                }
                catch (Exception e) {
                    ForesterUtil.printErrorMessage(NAME, e.toString());
                    e.printStackTrace();
                }
            } else {
                AptxUtil.printAppletMessage(NAME, "not using tabbed display");
                if (this.getSpeciesTree() != null) {
                    AptxUtil.printAppletMessage(NAME, "Warning: gsdi (gene duplication inference) only available tabbed display");
                }
                AptxUtil.addPhylogenyToPanel(phys, this.getConfiguration(), this.getMainPanel());
            }
            this.validate();
            this.setName(NAME);
            this.getMainPanel().getControlPanel().showWholeAll();
            this.getMainPanel().getControlPanel().showWhole();
            this.getCurrentTreePanel().getControlPanel().getSequenceRelationTypeBox().removeAllItems();
            for (SequenceRelation.SEQUENCE_RELATION_TYPE type : this.getMainPanel().getCurrentPhylogeny().getRelevantSequenceRelationTypes()) {
                this.getCurrentTreePanel().getControlPanel().getSequenceRelationTypeBox().addItem(type);
            }
            String default_relation = this.getParameter("homology_type_analysis_initial_relation_type");
            if (default_relation != null) {
                this.getCurrentTreePanel().getControlPanel().getSequenceRelationTypeBox().setSelectedItem(default_relation);
            }
            if ((default_sequence = this.getParameter("homology_type_analysis_query_sequence")) != null) {
                this.getCurrentTreePanel().getControlPanel().getSequenceRelationBox().setSelectedItem(default_sequence);
            }
            System.gc();
            AptxUtil.printAppletMessage(NAME, "successfully initialized");
            this.setVisible(true);
        }
        catch (Exception e) {
            ForesterUtil.printErrorMessage(NAME, e.toString());
            e.printStackTrace();
        }
    }

    public void showTextFrame(String s2, String title) {
        this.checkTextFrames();
        this._textframes.addLast(TextFrame.instantiate(s2, title, this._textframes));
    }

    @Override
    public void start() {
        if (this.getMainPanel() != null) {
            this.getMainPanel().validate();
        }
        this.requestFocus();
        this.requestFocusInWindow();
        this.requestFocus();
        AptxUtil.printAppletMessage(NAME, "started");
    }

    private void chooseFont() {
        FontChooser fc = new FontChooser();
        fc.setFont(this.getMainPanel().getTreeFontSet().getLargeFont());
        fc.showDialog(this, "Select the Base Font");
        this.getMainPanel().getTreeFontSet().setBaseFont(fc.getFont());
    }

    private void chooseMinimalConfidence() {
        String s2 = (String)JOptionPane.showInputDialog(this, "Please the minimum for confidence values to be displayed.\n[current value: " + this.getOptions().getMinConfidenceValue() + "]\n", "Minimal Confidence Value", 3, null, null, this.getOptions().getMinConfidenceValue());
        if (!ForesterUtil.isEmpty(s2)) {
            boolean success = true;
            double m3 = 0.0;
            String m_str = s2.trim();
            if (!ForesterUtil.isEmpty(m_str)) {
                try {
                    m3 = Double.parseDouble(m_str);
                }
                catch (Exception ex) {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && m3 >= 0.0) {
                this.getOptions().setMinConfidenceValue(m3);
            }
        }
    }

    private void choosePdfWidth() {
        String s2 = (String)JOptionPane.showInputDialog(this, "Please enter the default line width for PDF export.\n[current value: " + this.getOptions().getPrintLineWidth() + "]\n", "Line Width for PDF Export", 3, null, null, Float.valueOf(this.getOptions().getPrintLineWidth()));
        if (!ForesterUtil.isEmpty(s2)) {
            boolean success = true;
            float f = 0.0f;
            String m_str = s2.trim();
            if (!ForesterUtil.isEmpty(m_str)) {
                try {
                    f = Float.parseFloat(m_str);
                }
                catch (Exception ex) {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && (double)f > 0.0) {
                this.getOptions().setPrintLineWidth(f);
            }
        }
    }

    private void choosePrintSize() {
        String s2 = (String)JOptionPane.showInputDialog(this, "Please enter values for width and height,\nseparated by a comma.\n[current values: " + this.getOptions().getPrintSizeX() + ", " + this.getOptions().getPrintSizeY() + "]\n[A4: " + 595 + ", " + 845 + "]\n[US Letter: " + 612 + ", " + 792 + "]", "Default Size for Graphics Export", 3, null, null, this.getOptions().getPrintSizeX() + ", " + this.getOptions().getPrintSizeY());
        if (!ForesterUtil.isEmpty(s2) && s2.indexOf(44) > 0) {
            boolean success = true;
            int x = 0;
            int y = 0;
            String[] str_ary = s2.split(",");
            if (str_ary.length == 2) {
                String x_str = str_ary[0].trim();
                String y_str = str_ary[1].trim();
                if (!ForesterUtil.isEmpty(x_str) && !ForesterUtil.isEmpty(y_str)) {
                    try {
                        x = Integer.parseInt(x_str);
                        y = Integer.parseInt(y_str);
                    }
                    catch (Exception ex) {
                        success = false;
                    }
                } else {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && x > 1 && y > 1) {
                this.getOptions().setPrintSizeX(x);
                this.getOptions().setPrintSizeY(y);
            }
        }
    }

    private void customizeRadioButtonMenuItem(JRadioButtonMenuItem item, boolean is_selected) {
        if (item != null) {
            item.setFont(MainFrame.menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                item.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                item.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            item.setSelected(is_selected);
            item.addActionListener(this);
        }
    }

    private Phylogeny getSpeciesTree() {
        return this._species_tree;
    }

    private boolean isScreenAntialias() {
        return true;
    }

    private void removeBranchColors() {
        if (this.getMainPanel().getCurrentPhylogeny() != null) {
            AptxUtil.removeBranchColors(this.getMainPanel().getCurrentPhylogeny());
        }
    }

    private void removeVisualStyles() {
        if (this.getMainPanel().getCurrentPhylogeny() != null) {
            AptxUtil.removeVisualStyles(this.getMainPanel().getCurrentPhylogeny());
        }
    }

    private void setMainPanel(MainPanelApplets main_panel) {
        this._mainpanel = main_panel;
    }

    private void setSpeciesTree(Phylogeny species_tree) {
        this._species_tree = species_tree;
    }

    private void setupUI() {
        try {
            if (this.getConfiguration().isUseNativeUI()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            AptxUtil.dieWithSystemError("UnsupportedLookAndFeelException: " + e.toString());
        }
        catch (ClassNotFoundException e) {
            AptxUtil.dieWithSystemError("ClassNotFoundException: " + e.toString());
        }
        catch (InstantiationException e) {
            AptxUtil.dieWithSystemError("InstantiationException: " + e.toString());
        }
        catch (IllegalAccessException e) {
            AptxUtil.dieWithSystemError("IllegalAccessException: " + e.toString());
        }
        catch (Exception e) {
            AptxUtil.dieWithSystemError(e.toString());
        }
    }

    void buildAnalysisMenu() {
        this._analysis_menu = MainFrame.createMenu("Analysis", this.getConfiguration());
        this._gsdi_item = new JMenuItem("GSDI (Generalized Speciation Duplication Inference)");
        this._analysis_menu.add(this._gsdi_item);
        this._gsdir_item = new JMenuItem("GSDIR (GSDI with re-rooting)");
        this._analysis_menu.add(this._gsdir_item);
        this.customizeJMenuItem(this._gsdi_item);
        this.customizeJMenuItem(this._gsdir_item);
        this._analysis_menu.addSeparator();
        this._jmenubar.add(this._analysis_menu);
    }

    void buildFileMenu() {
        this._file_jmenu = MainFrame.createMenu("File", this.getConfiguration());
        this._save_item = new JMenuItem("Save Tree As...");
        this._file_jmenu.add(this._save_item);
        this._file_jmenu.addSeparator();
        this._write_to_pdf_item = new JMenuItem("Export to PDF file ...");
        this._file_jmenu.add(this._write_to_pdf_item);
        if (AptxUtil.canWriteFormat("tif") || AptxUtil.canWriteFormat("tiff") || AptxUtil.canWriteFormat("TIF")) {
            this._write_to_tif_item = new JMenuItem("Export to TIFF file...");
            this._file_jmenu.add(this._write_to_tif_item);
        }
        this._write_to_png_item = new JMenuItem("Export to PNG file...");
        this._file_jmenu.add(this._write_to_png_item);
        this._write_to_jpg_item = new JMenuItem("Export to JPG file...");
        this._file_jmenu.add(this._write_to_jpg_item);
        if (AptxUtil.canWriteFormat("gif")) {
            this._write_to_gif_item = new JMenuItem("Export to GIF file...");
            this._file_jmenu.add(this._write_to_gif_item);
        }
        if (AptxUtil.canWriteFormat("bmp")) {
            this._write_to_bmp_item = new JMenuItem("Export to BMP file...");
            this._file_jmenu.add(this._write_to_bmp_item);
        }
        this._file_jmenu.addSeparator();
        this._print_item = new JMenuItem("Print...");
        this._file_jmenu.add(this._print_item);
        this.customizeJMenuItem(this._save_item);
        this.customizeJMenuItem(this._write_to_pdf_item);
        this.customizeJMenuItem(this._write_to_png_item);
        this.customizeJMenuItem(this._write_to_jpg_item);
        this.customizeJMenuItem(this._write_to_gif_item);
        this.customizeJMenuItem(this._write_to_tif_item);
        this.customizeJMenuItem(this._write_to_bmp_item);
        this.customizeJMenuItem(this._print_item);
        this._jmenubar.add(this._file_jmenu);
    }

    void buildFontSizeMenu() {
        this._font_size_menu = MainFrame.createMenu("Font Size", this.getConfiguration());
        this._super_tiny_fonts_mi = new JMenuItem("Super tiny fonts");
        this._font_size_menu.add(this._super_tiny_fonts_mi);
        this._tiny_fonts_mi = new JMenuItem("Tiny fonts");
        this._font_size_menu.add(this._tiny_fonts_mi);
        this._small_fonts_mi = new JMenuItem("Small fonts");
        this._font_size_menu.add(this._small_fonts_mi);
        this._medium_fonts_mi = new JMenuItem("Medium fonts");
        this._font_size_menu.add(this._medium_fonts_mi);
        this._large_fonts_mi = new JMenuItem("Large fonts");
        this._font_size_menu.add(this._large_fonts_mi);
        this.customizeJMenuItem(this._super_tiny_fonts_mi);
        this.customizeJMenuItem(this._tiny_fonts_mi);
        this.customizeJMenuItem(this._small_fonts_mi);
        this.customizeJMenuItem(this._medium_fonts_mi);
        this.customizeJMenuItem(this._large_fonts_mi);
        this._jmenubar.add(this._font_size_menu);
    }

    void buildHelpMenu() {
        this._help_jmenu = MainFrame.createMenu("Help", this.getConfiguration());
        this._help_item = new JMenuItem("Documentation");
        this._help_jmenu.add(this._help_item);
        this._help_jmenu.addSeparator();
        this._website_item = new JMenuItem("Archaeopteryx Home");
        this._help_jmenu.add(this._website_item);
        this._aptx_ref_item = new JMenuItem("Archaeopteryx Reference");
        this._phyloxml_website_item = new JMenuItem("phyloXML Home");
        this._help_jmenu.add(this._phyloxml_website_item);
        this._phyloxml_ref_item = new JMenuItem("phyloXML Reference");
        this._help_jmenu.add(this._phyloxml_ref_item);
        this._help_jmenu.addSeparator();
        this._about_item = new JMenuItem("About");
        this._help_jmenu.add(this._about_item);
        this.customizeJMenuItem(this._help_item);
        this.customizeJMenuItem(this._website_item);
        this.customizeJMenuItem(this._phyloxml_website_item);
        this.customizeJMenuItem(this._aptx_ref_item);
        this.customizeJMenuItem(this._phyloxml_ref_item);
        this.customizeJMenuItem(this._about_item);
        this._phyloxml_ref_item.setToolTipText("Han MV and Zmasek CM (2009): \"phyloXML: XML for evolutionary biology and comparative genomics\", BMC Bioinformatics 10:356");
        this._aptx_ref_item.setToolTipText("Zmasek...");
        this._jmenubar.add(this._help_jmenu);
    }

    void buildOptionsMenu() {
        this._options_jmenu = MainFrame.createMenu("Options", this.getConfiguration());
        this._options_jmenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.setOvPlacementColorChooseMenuItem(ArchaeopteryxE.this._overview_placment_mi, ArchaeopteryxE.this.getOptions());
                MainFrame.setTextColorChooseMenuItem(ArchaeopteryxE.this._switch_colors_mi, ArchaeopteryxE.this.getCurrentTreePanel());
                MainFrame.setTextMinSupportMenuItem(ArchaeopteryxE.this._choose_minimal_confidence_mi, ArchaeopteryxE.this.getOptions(), ArchaeopteryxE.this.getCurrentTreePanel());
                MainFrame.setTextForFontChooserMenuItem(ArchaeopteryxE.this._choose_font_mi, MainFrame.createCurrentFontDesc(ArchaeopteryxE.this.getMainPanel().getTreeFontSet()));
                ArchaeopteryxE.setTextForGraphicsSizeChooserMenuItem(ArchaeopteryxE.this._print_size_mi, ArchaeopteryxE.this.getOptions());
                ArchaeopteryxE.setTextForPdfLineWidthChooserMenuItem(ArchaeopteryxE.this._choose_pdf_width_mi, ArchaeopteryxE.this.getOptions());
                MainFrame.setCycleNodeFillMenuItem(ArchaeopteryxE.this._cycle_node_fill_mi, ArchaeopteryxE.this.getOptions());
                MainFrame.setCycleNodeShapeMenuItem(ArchaeopteryxE.this._cycle_node_shape_mi, ArchaeopteryxE.this.getOptions());
                MainFrame.setTextNodeSizeMenuItem(ArchaeopteryxE.this._choose_node_size_mi, ArchaeopteryxE.this.getOptions());
                try {
                    ArchaeopteryxE.this.getMainPanel().getControlPanel().setVisibilityOfDomainStrucureCB();
                    ArchaeopteryxE.this.getMainPanel().getControlPanel().setVisibilityOfX();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._options_jmenu.add(MainFrame.customizeMenuItemAsLabel(new JMenuItem("Display:"), this.getConfiguration()));
        this._ext_node_dependent_cladogram_rbmi = new JRadioButtonMenuItem("External Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._ext_node_dependent_cladogram_rbmi);
        this._uniform_cladograms_rbmi = new JRadioButtonMenuItem("Total Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._uniform_cladograms_rbmi);
        this._non_lined_up_cladograms_rbmi = new JRadioButtonMenuItem("Non-Lined Up Cladograms");
        this._options_jmenu.add(this._non_lined_up_cladograms_rbmi);
        this._radio_group_1 = new ButtonGroup();
        this._radio_group_1.add(this._ext_node_dependent_cladogram_rbmi);
        this._radio_group_1.add(this._uniform_cladograms_rbmi);
        this._radio_group_1.add(this._non_lined_up_cladograms_rbmi);
        this._show_overview_cbmi = new JCheckBoxMenuItem("Overview");
        this._options_jmenu.add(this._show_overview_cbmi);
        this._show_scale_cbmi = new JCheckBoxMenuItem("Scale");
        this._options_jmenu.add(this._show_scale_cbmi);
        this._show_default_node_shapes_internal_cbmi = new JCheckBoxMenuItem("Shapes for Internal Nodes");
        this._options_jmenu.add(this._show_default_node_shapes_internal_cbmi);
        this._show_default_node_shapes_external_cbmi = new JCheckBoxMenuItem("Shapes for External Nodes");
        this._options_jmenu.add(this._show_default_node_shapes_external_cbmi);
        this._show_default_node_shapes_for_marked_cbmi = new JCheckBoxMenuItem("Shapes for Nodes with Visual Data");
        this._options_jmenu.add(this._show_default_node_shapes_for_marked_cbmi);
        this._line_up_renderable_data_cbmi = new JCheckBoxMenuItem("Line Up Diagrams (such as Domain Architectures)");
        this._options_jmenu.add(this._line_up_renderable_data_cbmi);
        if (this.getConfiguration().doDisplayOption(10)) {
            this._right_line_up_domains_cbmi = new JCheckBoxMenuItem("Right-align Domain Architectures");
            this._options_jmenu.add(this._right_line_up_domains_cbmi);
            this._show_domain_labels = new JCheckBoxMenuItem("Domain Labels");
            this._options_jmenu.add(this._show_domain_labels);
        }
        this._show_annotation_ref_source = new JCheckBoxMenuItem("Seq Annotation Ref Sources");
        this._options_jmenu.add(this._show_annotation_ref_source);
        this._show_confidence_stddev_cbmi = new JCheckBoxMenuItem("Confidence Standard Deviations");
        this._options_jmenu.add(this._show_confidence_stddev_cbmi);
        this._color_by_taxonomic_group_cbmi = new JCheckBoxMenuItem("Colorize by Taxonomic Group");
        this._options_jmenu.add(this._color_by_taxonomic_group_cbmi);
        this._color_labels_same_as_parent_branch = new JCheckBoxMenuItem("Colorize Labels Same as Parent Branch");
        this._options_jmenu.add(this._color_labels_same_as_parent_branch);
        this._color_labels_same_as_parent_branch.setToolTipText("To use parent branch colors for node labels as well, need to turn off taxonomy dependent colorization and turn on branch colorization for this to become apparent");
        this._abbreviate_scientific_names = new JCheckBoxMenuItem("Abbreviate Scientific Taxonomic Names");
        this._options_jmenu.add(this._abbreviate_scientific_names);
        this._label_direction_cbmi = new JCheckBoxMenuItem("Radial Labels");
        this._options_jmenu.add(this._label_direction_cbmi);
        this._label_direction_cbmi.setToolTipText("To use radial node labels in radial and unrooted display types");
        this._screen_antialias_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._screen_antialias_cbmi);
        this._background_gradient_cbmi = new JCheckBoxMenuItem("Background Color Gradient");
        this._options_jmenu.add(this._background_gradient_cbmi);
        this._cycle_node_shape_mi = new JMenuItem("Cycle Node Shapes");
        this._options_jmenu.add(this._cycle_node_shape_mi);
        this._cycle_node_fill_mi = new JMenuItem("Cycle Node Fill Type");
        this._options_jmenu.add(this._cycle_node_fill_mi);
        this._choose_node_size_mi = new JMenuItem("Choose Node Shape Size");
        this._options_jmenu.add(this._choose_node_size_mi);
        this._choose_minimal_confidence_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_minimal_confidence_mi);
        this._overview_placment_mi = new JMenuItem("");
        this._options_jmenu.add(this._overview_placment_mi);
        this._switch_colors_mi = new JMenuItem("");
        this._options_jmenu.add(this._switch_colors_mi);
        this._choose_font_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_font_mi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrame.customizeMenuItemAsLabel(new JMenuItem("Search:"), this.getConfiguration()));
        this._search_case_senstive_cbmi = new JCheckBoxMenuItem("Case Sensitive");
        this._options_jmenu.add(this._search_case_senstive_cbmi);
        this._search_whole_words_only_cbmi = new JCheckBoxMenuItem("Match Complete Terms Only");
        this._options_jmenu.add(this._search_whole_words_only_cbmi);
        this._search_with_regex_cbmi = new JCheckBoxMenuItem("Search with Regular Expressions");
        this._options_jmenu.add(this._search_with_regex_cbmi);
        this._search_with_regex_cbmi.setToolTipText("To search using regular expressions (~Java/Perl syntax). For example, use \"^B.+\\d{2,}$\" to search for everything starting with a B and ending with at least two digits.");
        this._inverse_search_result_cbmi = new JCheckBoxMenuItem("Negate Result");
        this._options_jmenu.add(this._inverse_search_result_cbmi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrame.customizeMenuItemAsLabel(new JMenuItem("Graphics Export & Printing:"), this.getConfiguration()));
        this._antialias_print_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._antialias_print_cbmi);
        this._print_black_and_white_cbmi = new JCheckBoxMenuItem("Export in Black and White");
        this._options_jmenu.add(this._print_black_and_white_cbmi);
        this._print_using_actual_size_cbmi = new JCheckBoxMenuItem("Use Current Image Size for PDF export and Printing");
        this._options_jmenu.add(this._print_using_actual_size_cbmi);
        this._graphics_export_using_actual_size_cbmi = new JCheckBoxMenuItem("Use Current Image Size for PNG, JPG, and GIF export");
        this._options_jmenu.add(this._graphics_export_using_actual_size_cbmi);
        this._graphics_export_visible_only_cbmi = new JCheckBoxMenuItem("Limit to Visible ('Screenshot') for PNG, JPG, and GIF export");
        this._options_jmenu.add(this._graphics_export_visible_only_cbmi);
        this._print_size_mi = new JMenuItem("");
        this._options_jmenu.add(this._print_size_mi);
        this._choose_pdf_width_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_pdf_width_mi);
        this.customizeCheckBoxMenuItem(this._antialias_print_cbmi, this.getOptions().isAntialiasPrint());
        this.customizeCheckBoxMenuItem(this._print_black_and_white_cbmi, this.getOptions().isPrintBlackAndWhite());
        this.customizeCheckBoxMenuItem(this._graphics_export_visible_only_cbmi, this.getOptions().isGraphicsExportVisibleOnly());
        this.customizeCheckBoxMenuItem(this._print_using_actual_size_cbmi, this.getOptions().isPrintUsingActualSize());
        this.customizeCheckBoxMenuItem(this._graphics_export_using_actual_size_cbmi, this.getOptions().isGraphicsExportUsingActualSize());
        this.customizeJMenuItem(this._print_size_mi);
        this.customizeJMenuItem(this._choose_pdf_width_mi);
        this.customizeJMenuItem(this._choose_font_mi);
        this.customizeJMenuItem(this._choose_minimal_confidence_mi);
        this.customizeJMenuItem(this._switch_colors_mi);
        this.customizeJMenuItem(this._overview_placment_mi);
        this.customizeCheckBoxMenuItem(this._color_by_taxonomic_group_cbmi, this.getOptions().isColorByTaxonomicGroup());
        this.customizeCheckBoxMenuItem(this._label_direction_cbmi, this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL);
        this.customizeCheckBoxMenuItem(this._screen_antialias_cbmi, this.getOptions().isAntialiasScreen());
        this.customizeCheckBoxMenuItem(this._background_gradient_cbmi, this.getOptions().isBackgroundColorGradient());
        this.customizeCheckBoxMenuItem(this._show_domain_labels, this.getOptions().isShowDomainLabels());
        this.customizeCheckBoxMenuItem(this._show_annotation_ref_source, this.getOptions().isShowAnnotationRefSource());
        this.customizeCheckBoxMenuItem(this._abbreviate_scientific_names, this.getOptions().isAbbreviateScientificTaxonNames());
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_external_cbmi, this.getOptions().isShowDefaultNodeShapesExternal());
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_internal_cbmi, this.getOptions().isShowDefaultNodeShapesInternal());
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_for_marked_cbmi, this.getOptions().isShowDefaultNodeShapesForMarkedNodes());
        this.customizeJMenuItem(this._cycle_node_shape_mi);
        this.customizeJMenuItem(this._cycle_node_fill_mi);
        this.customizeJMenuItem(this._choose_node_size_mi);
        this.customizeCheckBoxMenuItem(this._color_labels_same_as_parent_branch, this.getOptions().isColorLabelsSameAsParentBranch());
        this.customizeCheckBoxMenuItem(this._search_case_senstive_cbmi, this.getOptions().isSearchCaseSensitive());
        this.customizeCheckBoxMenuItem(this._show_scale_cbmi, this.getOptions().isShowScale());
        this.customizeRadioButtonMenuItem(this._non_lined_up_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP);
        this.customizeRadioButtonMenuItem(this._uniform_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        this.customizeRadioButtonMenuItem(this._ext_node_dependent_cladogram_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        this.customizeCheckBoxMenuItem(this._show_overview_cbmi, this.getOptions().isShowOverview());
        this.customizeCheckBoxMenuItem(this._search_with_regex_cbmi, this.getOptions().isSearchWithRegex());
        this.customizeCheckBoxMenuItem(this._search_whole_words_only_cbmi, this.getOptions().isMatchWholeTermsOnly());
        this.customizeCheckBoxMenuItem(this._inverse_search_result_cbmi, this.getOptions().isInverseSearchResult());
        this.customizeCheckBoxMenuItem(this._show_confidence_stddev_cbmi, this.getOptions().isShowConfidenceStddev());
        this.customizeCheckBoxMenuItem(this._line_up_renderable_data_cbmi, this.getOptions().isLineUpRendarableNodeData());
        this.customizeCheckBoxMenuItem(this._right_line_up_domains_cbmi, this.getOptions().isRightLineUpDomains());
        this._jmenubar.add(this._options_jmenu);
    }

    void buildToolsMenu() {
        this._tools_menu = MainFrame.createMenu("Tools", this.getConfiguration());
        this._confcolor_item = new JMenuItem("Colorize Branches Depending on Confidence");
        this._tools_menu.add(this._confcolor_item);
        this.customizeJMenuItem(this._confcolor_item);
        this._taxcolor_item = new JMenuItem("Taxonomy Colorize Branches");
        this._tools_menu.add(this._taxcolor_item);
        this.customizeJMenuItem(this._taxcolor_item);
        this._tools_menu.addSeparator();
        this._remove_visual_styles_item = new JMenuItem("Delete All Visual Styles From Nodes");
        this._tools_menu.add(this._remove_visual_styles_item);
        this._remove_visual_styles_item.setToolTipText("To remove all node visual styles (fonts, colors) from the current phylogeny.");
        this.customizeJMenuItem(this._remove_visual_styles_item);
        this._remove_branch_color_item = new JMenuItem("Delete All Colors From Branches");
        this._tools_menu.add(this._remove_branch_color_item);
        this._remove_branch_color_item.setToolTipText("To remove all branch color values from the current phylogeny.");
        this.customizeJMenuItem(this._remove_branch_color_item);
        this._tools_menu.addSeparator();
        this._midpoint_root_item = new JMenuItem("Midpoint-Root");
        this._tools_menu.add(this._midpoint_root_item);
        this.customizeJMenuItem(this._midpoint_root_item);
        this._tools_menu.addSeparator();
        this._collapse_species_specific_subtrees = new JMenuItem("Collapse Species-Specific Subtrees");
        this._tools_menu.add(this._collapse_species_specific_subtrees);
        this.customizeJMenuItem(this._collapse_species_specific_subtrees);
        this._jmenubar.add(this._tools_menu);
    }

    void buildTypeMenu() {
        this._type_menu = MainFrame.createMenu("Type", this.getConfiguration());
        this._rectangular_type_cbmi = new JCheckBoxMenuItem("Rectangular");
        this._type_menu.add(this._rectangular_type_cbmi);
        this._euro_type_cbmi = new JCheckBoxMenuItem("Euro Type");
        this._type_menu.add(this._euro_type_cbmi);
        this._rounded_type_cbmi = new JCheckBoxMenuItem("Rounded");
        this._type_menu.add(this._rounded_type_cbmi);
        this._curved_type_cbmi = new JCheckBoxMenuItem("Curved");
        this._type_menu.add(this._curved_type_cbmi);
        this._triangular_type_cbmi = new JCheckBoxMenuItem("Triangular");
        this._type_menu.add(this._triangular_type_cbmi);
        this._convex_type_cbmi = new JCheckBoxMenuItem("Convex");
        this._type_menu.add(this._convex_type_cbmi);
        this._unrooted_type_cbmi = new JCheckBoxMenuItem("Unrooted (alpha)");
        this._type_menu.add(this._unrooted_type_cbmi);
        this._circular_type_cbmi = new JCheckBoxMenuItem("Circular (alpha)");
        this._type_menu.add(this._circular_type_cbmi);
        this.customizeCheckBoxMenuItem(this._rectangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._triangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._euro_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._rounded_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._curved_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._convex_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._unrooted_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._circular_type_cbmi, false);
        this._unrooted_type_cbmi.setToolTipText("In this display type, use mousewheel + Shift to rotate [or A and S]");
        this._circular_type_cbmi.setToolTipText("In this display type, use mousewheel + Shift to rotate [or A and S]");
        this.initializeTypeMenu(this.getOptions());
        this._jmenubar.add(this._type_menu);
    }

    void buildViewMenu() {
        this._view_jmenu = MainFrame.createMenu("View", this.getConfiguration());
        this._display_basic_information_item = new JMenuItem("Basic Tree Information");
        this._view_jmenu.add(this._display_basic_information_item);
        this._view_jmenu.addSeparator();
        this._view_as_XML_item = new JMenuItem("as phyloXML");
        this._view_jmenu.add(this._view_as_XML_item);
        this._view_as_NH_item = new JMenuItem("as Newick");
        this._view_jmenu.add(this._view_as_NH_item);
        this._view_as_nexus_item = new JMenuItem("as Nexus");
        this._view_jmenu.add(this._view_as_nexus_item);
        this.customizeJMenuItem(this._display_basic_information_item);
        this.customizeJMenuItem(this._view_as_NH_item);
        this.customizeJMenuItem(this._view_as_XML_item);
        this.customizeJMenuItem(this._view_as_nexus_item);
        this._jmenubar.add(this._view_jmenu);
    }

    void checkTextFrames() {
        if (this._textframes.size() > 5) {
            try {
                if (this._textframes.getFirst() != null) {
                    this._textframes.getFirst().removeMe();
                } else {
                    this._textframes.removeFirst();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    void clearCurrentExternalNodesDataBuffer() {
        this.getCurrentTreePanel().clearCurrentExternalNodesDataBuffer();
    }

    void customizeCheckBoxMenuItem(JCheckBoxMenuItem item, boolean is_selected) {
        if (item != null) {
            item.setFont(MainFrame.menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                item.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                item.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            item.setSelected(is_selected);
            item.addActionListener(this);
        }
    }

    void customizeJMenuItem(JMenuItem jmi) {
        if (jmi != null) {
            jmi.setFont(MainFrame.menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                jmi.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                jmi.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            jmi.addActionListener(this);
        }
    }

    void displayBasicInformation() {
        if (this.getMainPanel() != null && this.getMainPanel().getCurrentPhylogeny() != null && !this.getMainPanel().getCurrentPhylogeny().isEmpty()) {
            String title = "Basic Information";
            if (!ForesterUtil.isEmpty(this.getMainPanel().getCurrentPhylogeny().getName())) {
                title = title + " for \"" + this._mainpanel.getCurrentPhylogeny().getName() + "\"";
            }
            this.showTextFrame(AptxUtil.createBasicInformation(this.getMainPanel().getCurrentPhylogeny(), null), title);
        }
    }

    void executeGSDI() {
        if (!this.isOKforSDI(false, true)) {
            return;
        }
        if (!this._mainpanel.getCurrentPhylogeny().isRooted()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not rooted.", "Cannot execute GSDI", 0);
            return;
        }
        Phylogeny gene_tree = this._mainpanel.getCurrentPhylogeny().copy();
        gene_tree.setAllNodesToNotCollapse();
        gene_tree.recalculateNumberOfExternalDescendants(false);
        GSDI gsdi2 = null;
        Phylogeny species_tree = this._species_tree.copy();
        try {
            gsdi2 = new GSDI(gene_tree, species_tree, false, true, true, true);
        }
        catch (SDIException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error during GSDI", 0);
            return;
        }
        catch (Exception e) {
            AptxUtil.unexpectedException(e);
            return;
        }
        gene_tree.setRerootable(false);
        gene_tree.clearHashIdToNodeMap();
        gene_tree.recalculateNumberOfExternalDescendants(true);
        this._mainpanel.addPhylogenyInNewTab(gene_tree, this.getConfiguration(), "gene tree", null);
        this.getMainPanel().getControlPanel().setShowEvents(true);
        this.showWhole();
        int selected = this._mainpanel.getTabbedPane().getSelectedIndex();
        this._mainpanel.addPhylogenyInNewTab(species_tree, this.getConfiguration(), "species tree", null);
        this.showWhole();
        this._mainpanel.getTabbedPane().setSelectedIndex(selected);
        this.showWhole();
        this._mainpanel.getCurrentTreePanel().setEdited(true);
        int poly = PhylogenyMethods.countNumberOfPolytomies(species_tree);
        if (gsdi2.getStrippedExternalGeneTreeNodes().size() > 0) {
            JOptionPane.showMessageDialog(this, "Duplications: " + gsdi2.getDuplicationsSum() + "\nPotential duplications: " + gsdi2.getSpeciationOrDuplicationEventsSum() + "\nSpeciations: " + gsdi2.getSpeciationsSum() + "\nStripped gene tree nodes: " + gsdi2.getStrippedExternalGeneTreeNodes().size() + "\nTaxonomy linkage based on: " + (Object)((Object)gsdi2.getTaxCompBase()) + "\nNumber of polytomies in species tree used: " + poly + "\n", "GSDI successfully completed", 2);
        } else {
            JOptionPane.showMessageDialog(this, "Duplications: " + gsdi2.getDuplicationsSum() + "\nPotential duplications: " + gsdi2.getSpeciationOrDuplicationEventsSum() + "\nSpeciations: " + gsdi2.getSpeciationsSum() + "\nStripped gene tree nodes: " + gsdi2.getStrippedExternalGeneTreeNodes().size() + "\nTaxonomy linkage based on: " + (Object)((Object)gsdi2.getTaxCompBase()) + "\nNumber of polytomies in species tree used: " + poly + "\n", "GSDI successfully completed", 1);
        }
    }

    void executeGSDIR() {
        if (!this.isOKforSDI(false, false)) {
            return;
        }
        int p = PhylogenyMethods.countNumberOfPolytomies(this._mainpanel.getCurrentPhylogeny());
        if (p > 0 && (p != 1 || this._mainpanel.getCurrentPhylogeny().getRoot().getNumberOfDescendants() != 3)) {
            JOptionPane.showMessageDialog(this, "Gene tree is not completely binary", "Cannot execute GSDI", 0);
            return;
        }
        Phylogeny gene_tree = this._mainpanel.getCurrentPhylogeny().copy();
        gene_tree.setAllNodesToNotCollapse();
        gene_tree.recalculateNumberOfExternalDescendants(false);
        GSDIR gsdir = null;
        Phylogeny species_tree = this._species_tree.copy();
        try {
            gsdir = new GSDIR(gene_tree, species_tree, true, true, true);
        }
        catch (SDIException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error during GSDIR", 0);
            return;
        }
        catch (Exception e) {
            AptxUtil.unexpectedException(e);
            return;
        }
        Phylogeny result_gene_tree = gsdir.getMinDuplicationsSumGeneTree();
        result_gene_tree.setRerootable(false);
        result_gene_tree.clearHashIdToNodeMap();
        result_gene_tree.recalculateNumberOfExternalDescendants(true);
        PhylogenyMethods.orderAppearance(result_gene_tree.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME);
        this._mainpanel.addPhylogenyInNewTab(result_gene_tree, this.getConfiguration(), "gene tree", null);
        this.getMainPanel().getControlPanel().setShowEvents(true);
        this.showWhole();
        int selected = this._mainpanel.getTabbedPane().getSelectedIndex();
        this._mainpanel.addPhylogenyInNewTab(species_tree, this.getConfiguration(), "species tree", null);
        this.showWhole();
        this._mainpanel.getTabbedPane().setSelectedIndex(selected);
        this.showWhole();
        this._mainpanel.getCurrentTreePanel().setEdited(true);
        int poly = PhylogenyMethods.countNumberOfPolytomies(species_tree);
        if (gsdir.getStrippedExternalGeneTreeNodes().size() > 0) {
            JOptionPane.showMessageDialog(this, "Minimal duplications: " + gsdir.getMinDuplicationsSum() + "\nSpeciations: " + gsdir.getSpeciationsSum() + "\nStripped gene tree nodes: " + gsdir.getStrippedExternalGeneTreeNodes().size() + "\nTaxonomy linkage based on: " + (Object)((Object)gsdir.getTaxCompBase()) + "\nNumber of polytomies in species tree used: " + poly + "\n", "GSDIR successfully completed", 2);
        } else {
            JOptionPane.showMessageDialog(this, "Minimal duplications: " + gsdir.getMinDuplicationsSum() + "\nSpeciations: " + gsdir.getSpeciationsSum() + "\nStripped gene tree nodes: " + gsdir.getStrippedExternalGeneTreeNodes().size() + "\nTaxonomy linkage based on: " + (Object)((Object)gsdir.getTaxCompBase()) + "\nNumber of polytomies in species tree used: " + poly + "\n", "GSDIR successfully completed", 1);
        }
    }

    Configuration getConfiguration() {
        return this._configuration;
    }

    File getCurrentDir() {
        if ((this._current_dir == null || !this._current_dir.canRead()) && ForesterUtil.isWindows()) {
            try {
                this._current_dir = new File(WindowsUtils.getCurrentUserDesktopPath());
            }
            catch (Exception e) {
                this._current_dir = null;
            }
        }
        if (this._current_dir == null || !this._current_dir.canRead()) {
            if (System.getProperty("user.home") != null) {
                this._current_dir = new File(System.getProperty("user.home"));
            } else if (System.getProperty("user.dir") != null) {
                this._current_dir = new File(System.getProperty("user.dir"));
            }
        }
        return this._current_dir;
    }

    TreePanel getCurrentTreePanel() {
        return this.getMainPanel().getCurrentTreePanel();
    }

    JCheckBoxMenuItem getlabelDirectionCbmi() {
        return this._label_direction_cbmi;
    }

    MainPanel getMainPanel() {
        return this._mainpanel;
    }

    Options getOtions() {
        return this._options;
    }

    void initializeTypeMenu(Options options) {
        this.setTypeMenuToAllUnselected();
        try {
            switch (options.getPhylogenyGraphicsType()) {
                case CONVEX: {
                    this._convex_type_cbmi.setSelected(true);
                    break;
                }
                case CURVED: {
                    this._curved_type_cbmi.setSelected(true);
                    break;
                }
                case EURO_STYLE: {
                    this._euro_type_cbmi.setSelected(true);
                    break;
                }
                case ROUNDED: {
                    this._rounded_type_cbmi.setSelected(true);
                    break;
                }
                case TRIANGULAR: {
                    this._triangular_type_cbmi.setSelected(true);
                    break;
                }
                case UNROOTED: {
                    this._unrooted_type_cbmi.setSelected(true);
                    break;
                }
                case CIRCULAR: {
                    this._circular_type_cbmi.setSelected(true);
                    break;
                }
                default: {
                    this._rectangular_type_cbmi.setSelected(true);
                    break;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    boolean isOKforSDI(boolean species_tree_has_to_binary, boolean gene_tree_has_to_binary) {
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            return false;
        }
        if (this._species_tree == null || this._species_tree.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No species tree loaded", "Cannot execute GSDI", 0);
            return false;
        }
        if (species_tree_has_to_binary && !this._species_tree.isCompletelyBinary()) {
            JOptionPane.showMessageDialog(this, "Species tree is not completely binary", "Cannot execute GSDI", 0);
            return false;
        }
        if (gene_tree_has_to_binary && !this._mainpanel.getCurrentPhylogeny().isCompletelyBinary()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not completely binary", "Cannot execute GSDI", 0);
            return false;
        }
        return true;
    }

    boolean isSubtreeDisplayed() {
        if (this.getCurrentTreePanel() != null && this.getCurrentTreePanel().isCurrentTreeIsSubtree()) {
            JOptionPane.showMessageDialog(this, "This operation can only be performed on a complete tree, not on the currently displayed sub-tree only.", "Operation can not be exectuted on a sub-tree", 2);
            return true;
        }
        return false;
    }

    void removeAllTextFrames() {
        for (TextFrame tf : this._textframes) {
            if (tf == null) continue;
            tf.close();
        }
        this._textframes.clear();
    }

    void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    void setCurrentDir(File current_dir) {
        this._current_dir = current_dir;
    }

    void setOptions(Options options) {
        this._options = options;
    }

    void setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE type) {
        this.setTypeMenuToAllUnselected();
        try {
            switch (type) {
                case CIRCULAR: {
                    this._circular_type_cbmi.setSelected(true);
                    break;
                }
                case CONVEX: {
                    this._convex_type_cbmi.setSelected(true);
                    break;
                }
                case CURVED: {
                    this._curved_type_cbmi.setSelected(true);
                    break;
                }
                case EURO_STYLE: {
                    this._euro_type_cbmi.setSelected(true);
                    break;
                }
                case ROUNDED: {
                    this._rounded_type_cbmi.setSelected(true);
                    break;
                }
                case RECTANGULAR: {
                    this._rectangular_type_cbmi.setSelected(true);
                    break;
                }
                case TRIANGULAR: {
                    this._triangular_type_cbmi.setSelected(true);
                    break;
                }
                case UNROOTED: {
                    this._unrooted_type_cbmi.setSelected(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown type: " + (Object)((Object)type));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void setTypeMenuToAllUnselected() {
        if (this._convex_type_cbmi != null) {
            this._convex_type_cbmi.setSelected(false);
        }
        if (this._curved_type_cbmi != null) {
            this._curved_type_cbmi.setSelected(false);
        }
        if (this._euro_type_cbmi != null) {
            this._euro_type_cbmi.setSelected(false);
        }
        if (this._rounded_type_cbmi != null) {
            this._rounded_type_cbmi.setSelected(false);
        }
        if (this._triangular_type_cbmi != null) {
            this._triangular_type_cbmi.setSelected(false);
        }
        if (this._rectangular_type_cbmi != null) {
            this._rectangular_type_cbmi.setSelected(false);
        }
        if (this._unrooted_type_cbmi != null) {
            this._unrooted_type_cbmi.setSelected(false);
        }
        if (this._circular_type_cbmi != null) {
            this._circular_type_cbmi.setSelected(false);
        }
    }

    void showWhole() {
        this._mainpanel.getControlPanel().showWhole();
    }

    void switchColors() {
        TreeColorSet colorset = this.getMainPanel().getCurrentTreePanel().getTreeColorSet();
        ColorSchemeChooser csc = new ColorSchemeChooser(this.getMainPanel(), colorset);
        csc.setVisible(true);
        this.getMainPanel().setTreeColorSet(colorset);
    }

    void typeChanged(Object o) {
        this.updateTypeCheckboxes(this.getOptions(), o);
        this.updateOptions(this.getOptions());
        if (this.getCurrentTreePanel() != null) {
            Options.PHYLOGENY_GRAPHICS_TYPE previous_type = this.getCurrentTreePanel().getPhylogenyGraphicsType();
            Options.PHYLOGENY_GRAPHICS_TYPE new_type = this.getOptions().getPhylogenyGraphicsType();
            if (previous_type == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && new_type != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || previous_type == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && new_type != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || previous_type != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && new_type == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || previous_type != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && new_type == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().showWhole();
            }
            if (this.getCurrentTreePanel().isPhyHasBranchLengths() && new_type != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(true);
            } else {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(false);
            }
            this.getCurrentTreePanel().setPhylogenyGraphicsType(this.getOptions().getPhylogenyGraphicsType());
            MainFrame.updateScreenTextAntialias(this.getMainPanel().getTreePanels());
        }
    }

    void updateOptions(Options options) {
        options.setAntialiasScreen(this._screen_antialias_cbmi != null && this._screen_antialias_cbmi.isSelected());
        options.setBackgroundColorGradient(this._background_gradient_cbmi != null && this._background_gradient_cbmi.isSelected());
        options.setShowDomainLabels(this._show_domain_labels != null && this._show_domain_labels.isSelected());
        options.setShowAnnotationRefSource(this._show_annotation_ref_source != null && this._show_annotation_ref_source.isSelected());
        options.setAbbreviateScientificTaxonNames(this._abbreviate_scientific_names != null && this._abbreviate_scientific_names.isSelected());
        options.setColorLabelsSameAsParentBranch(this._color_labels_same_as_parent_branch != null && this._color_labels_same_as_parent_branch.isSelected());
        options.setShowDefaultNodeShapesInternal(this._show_default_node_shapes_internal_cbmi != null && this._show_default_node_shapes_internal_cbmi.isSelected());
        options.setShowDefaultNodeShapesExternal(this._show_default_node_shapes_external_cbmi != null && this._show_default_node_shapes_external_cbmi.isSelected());
        options.setShowDefaultNodeShapesForMarkedNodes(this._show_default_node_shapes_for_marked_cbmi != null && this._show_default_node_shapes_for_marked_cbmi.isSelected());
        if (this._non_lined_up_cladograms_rbmi != null && this._non_lined_up_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.NON_LINED_UP);
        } else if (this._uniform_cladograms_rbmi != null && this._uniform_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        } else if (this._ext_node_dependent_cladogram_rbmi != null && this._ext_node_dependent_cladogram_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        }
        options.setSearchCaseSensitive(this._search_case_senstive_cbmi != null && this._search_case_senstive_cbmi.isSelected());
        if (this._show_scale_cbmi != null && this._show_scale_cbmi.isEnabled()) {
            options.setShowScale(this._show_scale_cbmi.isSelected());
        }
        if (this._label_direction_cbmi != null) {
            if (this._label_direction_cbmi.isSelected()) {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
            } else {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
            }
        }
        options.setShowOverview(this._show_overview_cbmi != null && this._show_overview_cbmi.isSelected());
        options.setShowConfidenceStddev(this._show_confidence_stddev_cbmi != null && this._show_confidence_stddev_cbmi.isSelected());
        options.setMatchWholeTermsOnly(this._search_whole_words_only_cbmi != null && this._search_whole_words_only_cbmi.isSelected());
        options.setSearchWithRegex(this._search_with_regex_cbmi != null && this._search_with_regex_cbmi.isSelected());
        options.setInverseSearchResult(this._inverse_search_result_cbmi != null && this._inverse_search_result_cbmi.isSelected());
        options.setPrintUsingActualSize(this._print_using_actual_size_cbmi != null && this._print_using_actual_size_cbmi.isSelected());
        options.setGraphicsExportUsingActualSize(this._graphics_export_using_actual_size_cbmi != null && this._graphics_export_using_actual_size_cbmi.isSelected());
        options.setAntialiasPrint(this._antialias_print_cbmi != null && this._antialias_print_cbmi.isSelected());
        options.setPrintBlackAndWhite(this._print_black_and_white_cbmi != null && this._print_black_and_white_cbmi.isSelected());
        if (this._rectangular_type_cbmi != null && this._rectangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        } else if (this._triangular_type_cbmi != null && this._triangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
        } else if (this._curved_type_cbmi != null && this._curved_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
        } else if (this._convex_type_cbmi != null && this._convex_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
        } else if (this._euro_type_cbmi != null && this._euro_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
        } else if (this._rounded_type_cbmi != null && this._rounded_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
        } else if (this._unrooted_type_cbmi != null && this._unrooted_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
        } else if (this._circular_type_cbmi != null && this._circular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
        }
        if (this._color_by_taxonomic_group_cbmi != null && this._color_by_taxonomic_group_cbmi.isEnabled()) {
            options.setColorByTaxonomicGroup(this._color_by_taxonomic_group_cbmi.isSelected());
        }
        if (this._right_line_up_domains_cbmi != null && this._right_line_up_domains_cbmi.isEnabled()) {
            options.setRightLineUpDomains(this._right_line_up_domains_cbmi.isSelected());
        }
        if (this._line_up_renderable_data_cbmi != null && this._line_up_renderable_data_cbmi.isEnabled()) {
            options.setLineUpRendarableNodeData(this._line_up_renderable_data_cbmi.isSelected());
        }
        if (this._graphics_export_visible_only_cbmi != null) {
            options.setGraphicsExportVisibleOnly(this._graphics_export_visible_only_cbmi.isSelected());
            if (this._graphics_export_visible_only_cbmi.isSelected() && this._graphics_export_using_actual_size_cbmi != null) {
                this._graphics_export_using_actual_size_cbmi.setSelected(true);
                this._graphics_export_using_actual_size_cbmi.setEnabled(false);
            } else {
                this._graphics_export_using_actual_size_cbmi.setEnabled(true);
            }
        }
    }

    void updateTypeCheckboxes(Options options, Object o) {
        this.setTypeMenuToAllUnselected();
        ((JCheckBoxMenuItem)o).setSelected(true);
    }

    void viewAsNexus() {
        if (this.getMainPanel().getCurrentPhylogeny() != null && !this.getMainPanel().getCurrentPhylogeny().isEmpty()) {
            String title = "Nexus";
            if (!ForesterUtil.isEmpty(this.getMainPanel().getCurrentPhylogeny().getName())) {
                title = "\"" + this.getMainPanel().getCurrentPhylogeny().getName() + "\" in " + title;
            }
            this.showTextFrame(this.getMainPanel().getCurrentPhylogeny().toNexus(this.getOptions().getNhConversionSupportValueStyle()), title);
        }
    }

    void viewAsNH() {
        if (this.getMainPanel().getCurrentPhylogeny() != null && !this.getMainPanel().getCurrentPhylogeny().isEmpty()) {
            String title = "New Hampshire";
            if (!ForesterUtil.isEmpty(this.getMainPanel().getCurrentPhylogeny().getName())) {
                title = "\"" + this.getMainPanel().getCurrentPhylogeny().getName() + "\" in " + title;
            }
            this.showTextFrame(this.getMainPanel().getCurrentPhylogeny().toNewHampshire(this.getOptions().getNhConversionSupportValueStyle()), title);
        }
    }

    void viewAsXML() {
        if (this.getMainPanel().getCurrentPhylogeny() != null && !this.getMainPanel().getCurrentPhylogeny().isEmpty()) {
            String title = "phyloXML";
            if (!ForesterUtil.isEmpty(this.getMainPanel().getCurrentPhylogeny().getName())) {
                title = "\"" + this.getMainPanel().getCurrentPhylogeny().getName() + "\" in " + title;
            }
            this.showTextFrame(this.getMainPanel().getCurrentPhylogeny().toPhyloXML(0), title);
        }
    }

    static void setTextForGraphicsSizeChooserMenuItem(JMenuItem mi, Options o) {
        mi.setText("Enter Default Size for Graphics Export... (current: " + o.getPrintSizeX() + ", " + o.getPrintSizeY() + ")");
    }

    static void setTextForPdfLineWidthChooserMenuItem(JMenuItem mi, Options o) {
        mi.setText("Enter Default Line Width for PDF Export... (current: " + o.getPrintLineWidth() + ")");
    }

    static void setupScreenTextAntialias(List<TreePanel> treepanels, boolean antialias) {
        for (TreePanel tree_panel : treepanels) {
            tree_panel.setTextAntialias();
        }
    }
}

