/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.forester.archaeopteryx.AptxUtil;

public class FontChooser
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final String BOLD_ITALIC = "Bold Italic";
    private static final String ITALIC = "Italic";
    private static final String BOLD = "Bold";
    private static final String REGULAR = "Regular";
    private static final String DEFAULT_FONT_NAME = "Sans";
    public static final long serialVersionUID = 62256323L;
    private static final String[] STYLE = new String[]{"Regular", "Bold", "Italic", "Bold Italic"};
    private static final String[] SIZE = new String[]{"3", "4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "72"};
    private static final int OK_OPTION = 1;
    private static final int CANCEL_OPTION = 2;
    private Font _font;
    private int _option;
    private String _type;
    private int _style;
    private int _size;
    private final JList<String> _font_list = new JList<String>(AptxUtil.getAvailableFontFamiliesSorted());
    private final JList<String> _style_list = new JList<String>(STYLE);
    private final JList<String> _size_list = new JList<String>(SIZE);
    private final JTextField _fonts_tf = new JTextField();
    private final JTextField _style_tf = new JTextField();
    private final JTextField _size_tf = new JTextField();
    private final JLabel _fonts_label = new JLabel("Font:");
    private final JLabel _style_label = new JLabel("Style:");
    private final JLabel _size_label = new JLabel("Size:");
    private final JScrollPane _font_jsp = new JScrollPane(this._font_list);
    private final JScrollPane _style_jsp = new JScrollPane(this._style_list);
    private final JScrollPane _size_jsp = new JScrollPane(this._size_list);
    private final JButton _ok_button = new JButton("OK");
    private final JButton _cancel_button = new JButton("Cancel");
    private final JTextField _test_tf = new JTextField("AaBbZz012");

    public FontChooser() {
        this(new Font(DEFAULT_FONT_NAME, 0, 12));
    }

    public FontChooser(Font font) {
        Container container = this.getContentPane();
        JPanel panel = new JPanel();
        TitledBorder panel_border = new TitledBorder("Demo");
        this._font = font;
        this._type = this._font.getFontName();
        this._style = this._font.getStyle();
        this._size = this._font.getSize();
        this._font_list.setSelectionMode(0);
        this._style_list.setSelectionMode(0);
        this._size_list.setSelectionMode(0);
        this._font_jsp.setHorizontalScrollBarPolicy(31);
        this._style_jsp.setHorizontalScrollBarPolicy(31);
        this._size_jsp.setHorizontalScrollBarPolicy(31);
        panel.setBorder(panel_border);
        this._fonts_tf.setBounds(8, 32, 121, 20);
        this._font_jsp.setBounds(8, 56, 121, 82);
        this._style_tf.setBounds(136, 32, 121, 20);
        this._style_jsp.setBounds(136, 56, 121, 82);
        this._size_tf.setBounds(264, 32, 41, 20);
        this._size_jsp.setBounds(264, 56, 41, 82);
        this._ok_button.setBounds(320, 8, 89, 17);
        this._cancel_button.setBounds(320, 32, 89, 17);
        panel.setBounds(320, 64, 89, 73);
        container.add(this._fonts_label);
        container.add(this._fonts_tf);
        container.add(this._font_jsp);
        container.add(this._style_label);
        container.add(this._style_tf);
        container.add(this._style_jsp);
        container.add(this._size_label);
        container.add(this._size_tf);
        container.add(this._size_jsp);
        container.add(this._ok_button);
        container.add(this._cancel_button);
        container.add(panel);
        this._test_tf.setBounds(8, 25, 73, 30);
        panel.add(this._test_tf);
        container.setLayout(null);
        panel.setLayout(null);
        this.setSize(424, 177);
        this.setResizable(false);
        this.setModal(true);
        this._fonts_tf.addActionListener(this);
        this._size_tf.addActionListener(this);
        this._style_tf.addActionListener(this);
        this._cancel_button.addActionListener(this);
        this._ok_button.addActionListener(this);
        this._font_list.addListSelectionListener(this);
        this._style_list.addListSelectionListener(this);
        this._size_list.addListSelectionListener(this);
    }

    public FontChooser(String font_name, int font_style, int size) {
        this(new Font(font_name, font_style, size));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._fonts_tf) {
            boolean found = false;
            this._type = this._fonts_tf.getText();
            for (int i = 0; i < this._font_list.getModel().getSize(); ++i) {
                if (!this._font_list.getModel().getElementAt(i).startsWith(this._fonts_tf.getText().trim())) continue;
                this._font_list.setSelectedIndex(i);
                this.setScrollPos(this._font_jsp, this._font_list, i);
                found = true;
                break;
            }
            if (!found) {
                this._font_list.clearSelection();
            } else {
                this._test_tf.setFont(new Font(this._type, this._style, this._size));
            }
        } else if (e.getSource() == this._size_tf) {
            boolean found = false;
            this.parseSize();
            this._test_tf.setFont(new Font(this._type, this._style, this._size));
            for (int i = 0; i < this._size_list.getModel().getSize(); ++i) {
                if (!this._size_tf.getText().trim().equals(this._size_list.getModel().getElementAt(i))) continue;
                this._size_list.setSelectedIndex(i);
                this.setScrollPos(this._size_jsp, this._size_list, i);
                found = true;
                break;
            }
            if (!found) {
                this._size_list.clearSelection();
            }
        } else if (e.getSource() == this._style_tf) {
            if (this._style_tf.getText().equals(REGULAR)) {
                this._style = 0;
            } else if (this._style_tf.getText().equals(BOLD)) {
                this._style = 1;
            } else if (this._style_tf.getText().equals(ITALIC)) {
                this._style = 2;
            } else if (this._style_tf.getText().equals(BOLD_ITALIC)) {
                this._style = 0;
            }
            this._style_list.setSelectedIndex(this._style);
            this._test_tf.setFont(new Font(this._type, this._style, this._size));
        } else if (e.getSource() == this._ok_button) {
            this.parseSize();
            this._option = 1;
            this._font = new Font(this._type, this._style, this._size);
            this.setVisible(false);
        } else if (e.getSource() == this._cancel_button) {
            this._option = 2;
            this.setVisible(false);
        }
    }

    @Override
    public Font getFont() {
        return this._font;
    }

    public String getFontName() {
        return this._font.getFontName();
    }

    public int getFontSize() {
        return this._font.getSize();
    }

    public int getFontStyle() {
        return this._font.getStyle();
    }

    @Override
    public void setFont(Font font) {
        this._font = font;
    }

    public int showDialog(Component parent, String title) {
        int i;
        boolean found = false;
        this._option = 2;
        this.setTitle(title);
        this._test_tf.setFont(new Font(this._type, this._style, this._size));
        for (i = 0; i < this._font_list.getModel().getSize(); ++i) {
            this._font_list.setSelectedIndex(i);
            if (!this._font.getFamily().equals(this._font_list.getSelectedValue())) continue;
            found = true;
            this.setScrollPos(this._font_jsp, this._font_list, i);
            break;
        }
        if (!found) {
            this._font_list.clearSelection();
        }
        this._style_list.setSelectedIndex(this._font.getStyle());
        found = false;
        for (i = 0; i < this._size_list.getModel().getSize(); ++i) {
            this._size_list.setSelectedIndex(i);
            if (this._font.getSize() > Integer.parseInt(this._size_list.getSelectedValue())) continue;
            found = true;
            this.setScrollPos(this._size_jsp, this._size_list, i);
            break;
        }
        if (!found) {
            this._size_list.clearSelection();
        }
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
        return this._option;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this._font_list) {
            if (this._font_list.getSelectedValue() != null) {
                this._fonts_tf.setText(this._font_list.getSelectedValue());
            }
            this._type = this._fonts_tf.getText();
            this._test_tf.setFont(new Font(this._type, this._style, this._size));
        } else if (e.getSource() == this._style_list) {
            this._style_tf.setText(this._style_list.getSelectedValue());
            if (this._style_tf.getText().equals(REGULAR)) {
                this._style = 0;
            } else if (this._style_tf.getText().equals(BOLD)) {
                this._style = 1;
            } else if (this._style_tf.getText().equals(ITALIC)) {
                this._style = 2;
            } else if (this._style_tf.getText().equals(BOLD_ITALIC)) {
                this._style = 3;
            }
            this._test_tf.setFont(new Font(this._type, this._style, this._size));
        } else if (e.getSource() == this._size_list) {
            if (this._size_list.getSelectedValue() != null) {
                this._size_tf.setText(this._size_list.getSelectedValue());
            }
            this._size = Integer.parseInt(this._size_tf.getText().trim());
            this._test_tf.setFont(new Font(this._type, this._style, this._size));
        }
    }

    private void parseSize() {
        try {
            this._size = Integer.parseInt(this._size_tf.getText().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._size < 1) {
            this._size = 1;
        }
    }

    private void setScrollPos(JScrollPane sp2, JList<String> list, int index) {
        int unit_size = sp2.getVerticalScrollBar().getMaximum() / list.getModel().getSize();
        sp2.getVerticalScrollBar().setValue((index - 2) * unit_size);
    }
}

