/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.ColorSchemeChooser;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.DefaultFilter;
import org.forester.archaeopteryx.FontChooser;
import org.forester.archaeopteryx.GraphicsFileFilter;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MsaFileFilter;
import org.forester.archaeopteryx.NHFilter;
import org.forester.archaeopteryx.NHXFilter;
import org.forester.archaeopteryx.NexusFilter;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.PdfExporter;
import org.forester.archaeopteryx.PdfFilter;
import org.forester.archaeopteryx.Printer;
import org.forester.archaeopteryx.SequencesFileFilter;
import org.forester.archaeopteryx.TextFrame;
import org.forester.archaeopteryx.TolFilter;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.UrlTreeReader;
import org.forester.archaeopteryx.XMLFilter;
import org.forester.archaeopteryx.tools.AncestralTaxonomyInferrer;
import org.forester.archaeopteryx.tools.InferenceManager;
import org.forester.archaeopteryx.tools.ProcessPool;
import org.forester.archaeopteryx.tools.ProcessRunning;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.NodeDataField;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.sdi.GSDI;
import org.forester.sdi.GSDIR;
import org.forester.sdi.SDIException;
import org.forester.util.ForesterUtil;
import org.forester.util.WindowsUtils;

public abstract class MainFrame
extends JFrame
implements ActionListener {
    static final NHFilter nhfilter = new NHFilter();
    static final NHXFilter nhxfilter = new NHXFilter();
    static final XMLFilter xmlfilter = new XMLFilter();
    static final TolFilter tolfilter = new TolFilter();
    static final NexusFilter nexusfilter = new NexusFilter();
    static final PdfFilter pdffilter = new PdfFilter();
    static final GraphicsFileFilter graphicsfilefilter = new GraphicsFileFilter();
    static final MsaFileFilter msafilter = new MsaFileFilter();
    static final SequencesFileFilter seqsfilter = new SequencesFileFilter();
    static final DefaultFilter defaultfilter = new DefaultFilter();
    static final String USE_MOUSEWHEEL_SHIFT_TO_ROTATE = "In this display type, use mousewheel + Shift to rotate [or A and S]";
    static final String PHYLOXML_REF_TOOL_TIP = "Han MV and Zmasek CM (2009): \"phyloXML: XML for evolutionary biology and comparative genomics\", BMC Bioinformatics 10:356";
    static final String APTX_REF_TOOL_TIP = "Zmasek...";
    private static final long serialVersionUID = 3655000897845508358L;
    static final Font menu_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 10);
    static final String TYPE_MENU_HEADER = "Type";
    static final String RECTANGULAR_TYPE_CBMI_LABEL = "Rectangular";
    static final String EURO_TYPE_CBMI_LABEL = "Euro Type";
    static final String CURVED_TYPE_CBMI_LABEL = "Curved";
    static final String TRIANGULAR_TYPE_CBMI_LABEL = "Triangular";
    static final String CONVEX_TYPE_CBMI_LABEL = "Convex";
    static final String ROUNDED_TYPE_CBMI_LABEL = "Rounded";
    static final String UNROOTED_TYPE_CBMI_LABEL = "Unrooted (alpha)";
    static final String CIRCULAR_TYPE_CBMI_LABEL = "Circular (alpha)";
    static final String OPTIONS_HEADER = "Options";
    static final String SEARCH_SUBHEADER = "Search:";
    static final String DISPLAY_SUBHEADER = "Display:";
    static final String SEARCH_TERMS_ONLY_LABEL = "Match Complete Terms Only";
    static final String SEARCH_REGEX_LABEL = "Search with Regular Expressions";
    static final String SEARCH_CASE_SENSITIVE_LABEL = "Case Sensitive";
    static final String INVERSE_SEARCH_RESULT_LABEL = "Negate Result";
    static final String COLOR_BY_TAXONOMIC_GROUP = "Colorize by Taxonomic Group";
    static final String DISPLAY_SCALE_LABEL = "Scale";
    static final String NON_LINED_UP_CLADOGRAMS_LABEL = "Non-Lined Up Cladograms";
    static final String UNIFORM_CLADOGRAMS_LABEL = "Total Node Sum Dependent Cladograms";
    static final String LABEL_DIRECTION_LABEL = "Radial Labels";
    static final String LABEL_DIRECTION_TIP = "To use radial node labels in radial and unrooted display types";
    static final String SEARCH_WITH_REGEX_TIP = "To search using regular expressions (~Java/Perl syntax). For example, use \"^B.+\\d{2,}$\" to search for everything starting with a B and ending with at least two digits.";
    static final String SCREEN_ANTIALIAS_LABEL = "Antialias";
    static final String COLOR_LABELS_LABEL = "Colorize Labels Same as Parent Branch";
    static final String BG_GRAD_LABEL = "Background Color Gradient";
    static final String DISPLAY_NODE_BOXES_LABEL_EXT = "Shapes for External Nodes";
    static final String DISPLAY_NODE_BOXES_LABEL_INT = "Shapes for Internal Nodes";
    static final String DISPLAY_NODE_BOXES_LABEL_MARKED = "Shapes for Nodes with Visual Data";
    static final String SHOW_OVERVIEW_LABEL = "Overview";
    static final String FONT_SIZE_MENU_LABEL = "Font Size";
    static final String NONUNIFORM_CLADOGRAMS_LABEL = "External Node Sum Dependent Cladograms";
    static final String SHOW_DOMAIN_LABELS_LABEL = "Domain Labels";
    static final String SHOW_ANN_REF_SOURCE_LABEL = "Seq Annotation Ref Sources";
    static final String COLOR_LABELS_TIP = "To use parent branch colors for node labels as well, need to turn off taxonomy dependent colorization and turn on branch colorization for this to become apparent";
    static final String ABBREV_SN_LABEL = "Abbreviate Scientific Taxonomic Names";
    static final String TAXONOMY_COLORIZE_NODE_SHAPES_LABEL = "Colorize Node Shapes According to Taxonomy";
    static final String CYCLE_NODE_SHAPE_LABEL = "Cycle Node Shapes";
    static final String CYCLE_NODE_FILL_LABEL = "Cycle Node Fill Type";
    static final String CHOOSE_NODE_SIZE_LABEL = "Choose Node Shape Size";
    static final String SHOW_CONF_STDDEV_LABEL = "Confidence Standard Deviations";
    static final String USE_BRACKETS_FOR_CONF_IN_NH_LABEL = "Use Brackets for Confidence Values";
    static final String USE_INTERNAL_NAMES_FOR_CONF_IN_NH_LABEL = "Use Internal Node Names for Confidence Values";
    static final String SHOW_BASIC_TREE_INFORMATION_LABEL = "Basic Tree Information";
    static final String RIGHT_LINE_UP_DOMAINS = "Right-align Domain Architectures";
    static final String LINE_UP_RENDERABLE_DATA = "Line Up Diagrams (such as Domain Architectures)";
    static final String INFER_ANCESTOR_TAXONOMIES = "Infer Ancestor Taxonomies";
    static final String OBTAIN_DETAILED_TAXONOMIC_INFORMATION = "Obtain Detailed Taxonomic Information";
    JMenuBar _jmenubar;
    JMenu _file_jmenu;
    JMenu _tools_menu;
    JMenu _view_jmenu;
    JMenu _options_jmenu;
    JMenu _font_size_menu;
    JMenu _help_jmenu;
    JMenuItem[] _load_phylogeny_from_webservice_menu_items;
    JMenu _analysis_menu;
    JMenuItem _load_species_tree_item;
    JMenuItem _gsdi_item;
    JMenuItem _gsdir_item;
    JMenuItem _lineage_inference;
    JMenuItem _open_item;
    JMenuItem _open_url_item;
    JMenuItem _save_item;
    JMenuItem _save_all_item;
    JMenuItem _close_item;
    JMenuItem _exit_item;
    JMenuItem _new_item;
    JMenuItem _print_item;
    JMenuItem _write_to_pdf_item;
    JMenuItem _write_to_jpg_item;
    JMenuItem _write_to_gif_item;
    JMenuItem _write_to_tif_item;
    JMenuItem _write_to_png_item;
    JMenuItem _write_to_bmp_item;
    JMenuItem _midpoint_root_item;
    JMenuItem _taxcolor_item;
    JMenuItem _confcolor_item;
    JMenuItem _color_rank_jmi;
    JMenuItem _collapse_species_specific_subtrees;
    JMenuItem _obtain_detailed_taxonomic_information_jmi;
    JMenuItem _obtain_detailed_taxonomic_information_deleting_jmi;
    JMenuItem _obtain_seq_information_jmi;
    JMenuItem _move_node_names_to_tax_sn_jmi;
    JMenuItem _move_node_names_to_seq_names_jmi;
    JMenuItem _extract_tax_code_from_node_names_jmi;
    JMenuItem _annotate_item;
    JMenuItem _remove_branch_color_item;
    JMenuItem _remove_visual_styles_item;
    JMenuItem _delete_selected_nodes_item;
    JMenuItem _delete_not_selected_nodes_item;
    JMenuItem _super_tiny_fonts_item;
    JMenuItem _tiny_fonts_item;
    JMenuItem _small_fonts_item;
    JMenuItem _medium_fonts_item;
    JMenuItem _large_fonts_item;
    JMenuItem _choose_font_mi;
    JMenuItem _switch_colors_mi;
    JCheckBoxMenuItem _label_direction_cbmi;
    JCheckBoxMenuItem _screen_antialias_cbmi;
    JCheckBoxMenuItem _background_gradient_cbmi;
    JRadioButtonMenuItem _non_lined_up_cladograms_rbmi;
    JRadioButtonMenuItem _uniform_cladograms_rbmi;
    JRadioButtonMenuItem _ext_node_dependent_cladogram_rbmi;
    JCheckBoxMenuItem _color_by_taxonomic_group_cbmi;
    JCheckBoxMenuItem _show_scale_cbmi;
    JCheckBoxMenuItem _show_overview_cbmi;
    JCheckBoxMenuItem _show_domain_labels;
    JCheckBoxMenuItem _show_annotation_ref_source;
    JCheckBoxMenuItem _abbreviate_scientific_names;
    JCheckBoxMenuItem _color_labels_same_as_parent_branch;
    JMenuItem _overview_placment_mi;
    JMenuItem _choose_minimal_confidence_mi;
    JCheckBoxMenuItem _show_default_node_shapes_internal_cbmi;
    JCheckBoxMenuItem _show_default_node_shapes_external_cbmi;
    JCheckBoxMenuItem _show_default_node_shapes_for_marked_cbmi;
    JMenuItem _cycle_node_shape_mi;
    JMenuItem _cycle_node_fill_mi;
    JMenuItem _choose_node_size_mi;
    JMenuItem _cycle_data_return;
    JCheckBoxMenuItem _show_confidence_stddev_cbmi;
    JCheckBoxMenuItem _right_line_up_domains_cbmi;
    JCheckBoxMenuItem _line_up_renderable_data_cbmi;
    JCheckBoxMenuItem _graphics_export_visible_only_cbmi;
    JCheckBoxMenuItem _antialias_print_cbmi;
    JCheckBoxMenuItem _print_black_and_white_cbmi;
    JCheckBoxMenuItem _print_using_actual_size_cbmi;
    JCheckBoxMenuItem _graphics_export_using_actual_size_cbmi;
    JMenuItem _print_size_mi;
    JMenuItem _choose_pdf_width_mi;
    JCheckBoxMenuItem _internal_number_are_confidence_for_nh_parsing_cbmi;
    JRadioButtonMenuItem _extract_taxonomy_no_rbmi;
    JRadioButtonMenuItem _extract_taxonomy_agressive_rbmi;
    JRadioButtonMenuItem _extract_taxonomy_pfam_strict_rbmi;
    JRadioButtonMenuItem _extract_taxonomy_pfam_relaxed_rbmi;
    JCheckBoxMenuItem _replace_underscores_cbmi;
    JCheckBoxMenuItem _allow_errors_in_distance_to_parent_cbmi;
    JCheckBoxMenuItem _use_brackets_for_conf_in_nh_export_cbmi;
    JCheckBoxMenuItem _use_internal_names_for_conf_in_nh_export_cbmi;
    JCheckBoxMenuItem _search_case_senstive_cbmi;
    JCheckBoxMenuItem _search_whole_words_only_cbmi;
    JCheckBoxMenuItem _inverse_search_result_cbmi;
    JCheckBoxMenuItem _search_with_regex_cbmi;
    JMenu _type_menu;
    JCheckBoxMenuItem _rectangular_type_cbmi;
    JCheckBoxMenuItem _triangular_type_cbmi;
    JCheckBoxMenuItem _curved_type_cbmi;
    JCheckBoxMenuItem _convex_type_cbmi;
    JCheckBoxMenuItem _euro_type_cbmi;
    JCheckBoxMenuItem _rounded_type_cbmi;
    JCheckBoxMenuItem _unrooted_type_cbmi;
    JCheckBoxMenuItem _circular_type_cbmi;
    JMenuItem _view_as_NH_item;
    JMenuItem _view_as_XML_item;
    JMenuItem _view_as_nexus_item;
    JMenuItem _display_basic_information_item;
    JMenuItem _about_item;
    JMenuItem _help_item;
    JMenuItem _website_item;
    JMenuItem _phyloxml_website_item;
    JMenuItem _phyloxml_ref_item;
    JMenuItem _aptx_ref_item;
    File _current_dir;
    JFileChooser _writetopdf_filechooser;
    JFileChooser _save_filechooser;
    JFileChooser _writetographics_filechooser;
    JMenu _process_menu;
    MainPanel _mainpanel;
    Container _contentpane;
    final LinkedList<TextFrame> _textframes = new LinkedList();
    Configuration _configuration;
    Options _options;
    private Phylogeny _species_tree;
    InferenceManager _inference_manager;
    final ProcessPool _process_pool = ProcessPool.createInstance();
    private String _previous_node_annotation_ref;

    MainFrame() {
        this._writetopdf_filechooser = new JFileChooser();
        this._writetopdf_filechooser.setMultiSelectionEnabled(false);
        this._writetopdf_filechooser.addChoosableFileFilter(pdffilter);
        this._writetographics_filechooser = new JFileChooser();
        this._writetographics_filechooser.setMultiSelectionEnabled(false);
        this._writetographics_filechooser.addChoosableFileFilter(graphicsfilefilter);
        this._save_filechooser = new JFileChooser();
        this._save_filechooser.setMultiSelectionEnabled(false);
        this._save_filechooser.setFileFilter(xmlfilter);
        this._save_filechooser.addChoosableFileFilter(nhfilter);
        this._save_filechooser.addChoosableFileFilter(nexusfilter);
        this._save_filechooser.addChoosableFileFilter(this._save_filechooser.getAcceptAllFileFilter());
        try {
            String home_dir = System.getProperty("user.home");
            this._save_filechooser.setCurrentDirectory(new File(home_dir));
            this._writetopdf_filechooser.setCurrentDirectory(new File(home_dir));
            this._writetographics_filechooser.setCurrentDirectory(new File(home_dir));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        boolean is_applet = false;
        JApplet applet = null;
        if (this.getCurrentTreePanel() != null && (is_applet = this.getCurrentTreePanel().isApplet())) {
            applet = this.getCurrentTreePanel().obtainApplet();
        }
        if (o == this._exit_item) {
            this.close();
        } else if (o == this._gsdi_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.executeGSDI();
        } else if (o == this._gsdir_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.executeGSDIR();
        } else if (o == this._taxcolor_item) {
            this.taxColor();
        } else if (o == this._confcolor_item) {
            this.confColor();
        } else if (o == this._color_rank_jmi) {
            this.colorRank();
        } else if (o == this._collapse_species_specific_subtrees) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().collapseSpeciesSpecificSubtrees();
            }
        } else if (o == this._remove_branch_color_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.removeBranchColors();
        } else if (o == this._remove_visual_styles_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.removeVisualStyles();
        } else if (o == this._midpoint_root_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.midpointRoot();
        } else if (o == this._delete_selected_nodes_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.deleteSelectedNodes(true);
        } else if (o == this._delete_not_selected_nodes_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.deleteSelectedNodes(false);
        } else if (o == this._annotate_item) {
            this.annotateSequences();
        } else if (o == this._switch_colors_mi) {
            this.switchColors();
        } else if (o == this._display_basic_information_item) {
            if (this.getCurrentTreePanel() != null) {
                this.displayBasicInformation(this.getCurrentTreePanel().getTreeFile());
            }
        } else if (o == this._view_as_NH_item) {
            this.viewAsNH();
        } else if (o == this._view_as_XML_item) {
            this.viewAsXML();
        } else if (o == this._view_as_nexus_item) {
            this.viewAsNexus();
        } else if (o == this._super_tiny_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSuperTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._tiny_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._small_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSmallFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._medium_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setMediumFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._large_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setLargeFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._choose_font_mi) {
            this.chooseFont();
        } else if (o == this._choose_minimal_confidence_mi) {
            this.chooseMinimalConfidence();
        } else if (o == this._choose_node_size_mi) {
            MainFrame.chooseNodeSize(this.getOptions(), this);
        } else if (o == this._overview_placment_mi) {
            MainFrame.cycleOverview(this.getOptions(), this.getCurrentTreePanel());
        } else if (o == this._cycle_node_fill_mi) {
            MainFrame.cycleNodeFill(this.getOptions());
        } else if (o == this._cycle_node_shape_mi) {
            MainFrame.cycleNodeShape(this.getOptions());
        } else if (o == this._cycle_data_return) {
            MainFrame.cycleNodeDataReturn(this.getOptions(), this.getConfiguration());
        } else if (o == this._screen_antialias_cbmi) {
            this.updateOptions(this.getOptions());
            MainFrame.updateScreenTextAntialias(this.getMainPanel().getTreePanels());
        } else if (o == this._background_gradient_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_domain_labels) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_annotation_ref_source) {
            this.updateOptions(this.getOptions());
        } else if (o == this._abbreviate_scientific_names) {
            this.updateOptions(this.getOptions());
        } else if (o == this._color_labels_same_as_parent_branch) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_default_node_shapes_internal_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_default_node_shapes_external_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_default_node_shapes_for_marked_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._non_lined_up_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this.showWhole();
        } else if (o == this._uniform_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this.showWhole();
        } else if (o == this._ext_node_dependent_cladogram_rbmi) {
            this.updateOptions(this.getOptions());
            this.showWhole();
        } else if (o == this._search_case_senstive_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
        } else if (o == this._search_whole_words_only_cbmi) {
            if (this._search_with_regex_cbmi != null && this._search_whole_words_only_cbmi.isSelected()) {
                this._search_with_regex_cbmi.setSelected(false);
            }
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
        } else if (o == this._inverse_search_result_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
        } else if (o == this._search_with_regex_cbmi) {
            if (this._search_whole_words_only_cbmi != null && this._search_with_regex_cbmi.isSelected()) {
                this._search_whole_words_only_cbmi.setSelected(false);
            }
            if (this._search_case_senstive_cbmi != null && this._search_with_regex_cbmi.isSelected()) {
                this._search_case_senstive_cbmi.setSelected(true);
            }
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
        } else if (o == this._show_scale_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._color_by_taxonomic_group_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_confidence_stddev_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._use_brackets_for_conf_in_nh_export_cbmi) {
            if (this._use_brackets_for_conf_in_nh_export_cbmi.isSelected()) {
                this._use_internal_names_for_conf_in_nh_export_cbmi.setSelected(false);
            }
            this.updateOptions(this.getOptions());
        } else if (o == this._use_internal_names_for_conf_in_nh_export_cbmi) {
            if (this._use_internal_names_for_conf_in_nh_export_cbmi.isSelected()) {
                this._use_brackets_for_conf_in_nh_export_cbmi.setSelected(false);
            }
            this.updateOptions(this.getOptions());
        } else if (o == this._label_direction_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_overview_cbmi) {
            this.updateOptions(this.getOptions());
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().updateOvSizes();
            }
        } else if (o == this._line_up_renderable_data_cbmi) {
            if (!this._line_up_renderable_data_cbmi.isSelected()) {
                this._right_line_up_domains_cbmi.setSelected(false);
            }
            this.updateOptions(this.getOptions());
        } else if (o == this._right_line_up_domains_cbmi) {
            if (this._right_line_up_domains_cbmi.isSelected()) {
                this._line_up_renderable_data_cbmi.setSelected(true);
            }
            this.updateOptions(this.getOptions());
        } else if (o == this._rectangular_type_cbmi || o == this._triangular_type_cbmi || o == this._curved_type_cbmi || o == this._convex_type_cbmi || o == this._euro_type_cbmi || o == this._rounded_type_cbmi || o == this._unrooted_type_cbmi || o == this._circular_type_cbmi) {
            this.typeChanged(o);
        } else if (o == this._about_item) {
            MainFrame.about();
        } else if (o == this._help_item) {
            try {
                AptxUtil.openWebsite("https://sites.google.com/site/cmzmasek/home/software/archaeopteryx/documentation", is_applet, applet);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._website_item) {
            try {
                AptxUtil.openWebsite("https://sites.google.com/site/cmzmasek/home/software/archaeopteryx", is_applet, applet);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._phyloxml_website_item) {
            try {
                AptxUtil.openWebsite("http://www.phyloxml.org", is_applet, applet);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._aptx_ref_item) {
            try {
                AptxUtil.openWebsite("http://www.biomedcentral.com/bmcbioinformatics/", is_applet, applet);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._phyloxml_ref_item) {
            try {
                AptxUtil.openWebsite("http://www.biomedcentral.com/1471-2105/10/356/", is_applet, applet);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._write_to_pdf_item) {
            File curr_dir = MainFrame.writeToPdf(this._mainpanel.getCurrentPhylogeny(), this.getMainPanel(), this._writetopdf_filechooser, this._current_dir, this.getContentPane(), this);
            if (curr_dir != null) {
                this.setCurrentDir(curr_dir);
            }
        } else if (o == this._save_all_item) {
            this.writeAllToFile();
        } else if (o == this._write_to_jpg_item) {
            File new_dir = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.JPG, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (new_dir != null) {
                this.setCurrentDir(new_dir);
            }
        } else if (o == this._write_to_gif_item) {
            File new_dir = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.GIF, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (new_dir != null) {
                this.setCurrentDir(new_dir);
            }
        } else if (o == this._write_to_tif_item) {
            File new_dir = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.TIFF, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (new_dir != null) {
                this.setCurrentDir(new_dir);
            }
        } else if (o == this._write_to_bmp_item) {
            File new_dir = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.BMP, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (new_dir != null) {
                this.setCurrentDir(new_dir);
            }
        } else if (o == this._write_to_png_item) {
            File new_dir = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.PNG, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (new_dir != null) {
                this.setCurrentDir(new_dir);
            }
        } else if (o == this._print_item) {
            MainFrame.print(this.getCurrentTreePanel(), this.getOptions(), this);
        } else if (o == this._save_item) {
            File new_dir = MainFrame.writeToFile(this._mainpanel.getCurrentPhylogeny(), this.getMainPanel(), this._save_filechooser, this._current_dir, this.getContentPane(), this);
            if (new_dir != null) {
                this.setCurrentDir(new_dir);
            }
        } else if (o == this._graphics_export_visible_only_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._antialias_print_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._print_black_and_white_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._print_using_actual_size_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._graphics_export_using_actual_size_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._print_size_mi) {
            this.choosePrintSize();
        } else if (o == this._choose_pdf_width_mi) {
            this.choosePdfWidth();
        } else if (o == this._lineage_inference) {
            if (this.isSubtreeDisplayed()) {
                JOptionPane.showMessageDialog(this, "Subtree is shown.", "Cannot infer ancestral taxonomies", 0);
                return;
            }
            this.executeLineageInference();
        } else if (this._load_phylogeny_from_webservice_menu_items != null) {
            for (int i = 0; i < this._load_phylogeny_from_webservice_menu_items.length; ++i) {
                if (o != this._load_phylogeny_from_webservice_menu_items[i]) continue;
                this.readPhylogeniesFromWebservice(i);
            }
        }
        this._contentpane.repaint();
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public String getCurrentExternalNodesDataBuffer() {
        return this.getCurrentTreePanel().getCurrentExternalNodesDataBufferAsString();
    }

    public int getCurrentExternalNodesDataBufferChangeCounter() {
        return this.getCurrentTreePanel().getCurrentExternalNodesDataBufferChangeCounter();
    }

    public int getCurrentExternalNodesDataBufferLength() {
        return this.getCurrentTreePanel().getCurrentExternalNodesDataBufferAsString().length();
    }

    public InferenceManager getInferenceManager() {
        return this._inference_manager;
    }

    public MainPanel getMainPanel() {
        return this._mainpanel;
    }

    public Options getOptions() {
        return this._options;
    }

    public ProcessPool getProcessPool() {
        return this._process_pool;
    }

    public void showTextFrame(String s2, String title) {
        this.checkTextFrames();
        this._textframes.addLast(TextFrame.instantiate(s2, title, this._textframes));
    }

    public void showWhole() {
        this._mainpanel.getControlPanel().showWhole();
    }

    public void updateProcessMenu() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.doUpdateProcessMenu();
            }
        });
    }

    private void annotateSequences() {
        if (this.getCurrentTreePanel() != null) {
            List<PhylogenyNode> nodes = null;
            if (this.getCurrentTreePanel().getFoundNodes0() != null || this.getCurrentTreePanel().getFoundNodes1() != null) {
                nodes = this.getCurrentTreePanel().getFoundNodesAsListOfPhylogenyNodes();
            }
            if (nodes == null || nodes.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Need to select nodes, either via direct selection or via the \"Search\" function", "No nodes selected for annotation", 0);
                return;
            }
            Phylogeny phy = this.getMainPanel().getCurrentPhylogeny();
            if (phy != null && !phy.isEmpty()) {
                JTextField ref_field = new JTextField(10);
                JTextField desc_filed = new JTextField(20);
                ref_field.setText(ForesterUtil.isEmpty(this.getPreviousNodeAnnotationReference()) ? "" : this.getPreviousNodeAnnotationReference());
                JPanel my_panel = new JPanel();
                my_panel.add(new JLabel("Reference "));
                my_panel.add(ref_field);
                my_panel.add(Box.createHorizontalStrut(15));
                my_panel.add(new JLabel("Description "));
                my_panel.add(desc_filed);
                int result = JOptionPane.showConfirmDialog(null, my_panel, "Enter the sequence annotation(s) for the " + nodes.size() + " selected nodes", 2);
                if (result == 0) {
                    String ref = ref_field.getText();
                    String desc = desc_filed.getText();
                    if (!ForesterUtil.isEmpty(ref)) {
                        ref = ref.trim();
                        if ((ref = ref.replaceAll("\\s+", " ")).indexOf(58) < 1 || ref.indexOf(58) > ref.length() - 2 || ref.length() < 3) {
                            JOptionPane.showMessageDialog(this, "Reference needs to be in the form of \"GO:1234567\"", "Illegal Format for Annotation Reference", 0);
                            return;
                        }
                    }
                    if (ref != null) {
                        this.setPreviousNodeAnnotationReference(ref);
                    }
                    if (desc != null) {
                        desc = desc.trim();
                        desc = desc.replaceAll("\\s+", " ");
                    }
                    if (!ForesterUtil.isEmpty(ref) || !ForesterUtil.isEmpty(desc)) {
                        for (PhylogenyNode n : nodes) {
                            Annotation ann;
                            ForesterUtil.ensurePresenceOfSequence(n);
                            Annotation annotation = ann = ForesterUtil.isEmpty(ref) ? new Annotation() : new Annotation(ref);
                            if (!ForesterUtil.isEmpty(desc)) {
                                ann.setDesc(desc);
                            }
                            n.getNodeData().getSequence().addAnnotation(ann);
                        }
                    }
                    this.getMainPanel().getControlPanel().showAnnotations();
                }
            }
        }
    }

    private void chooseFont() {
        FontChooser fc = new FontChooser();
        fc.setFont(this.getMainPanel().getTreeFontSet().getLargeFont());
        fc.showDialog(this, "Select the Base Font");
        this.getMainPanel().getTreeFontSet().setBaseFont(fc.getFont());
    }

    private void chooseMinimalConfidence() {
        String s2 = (String)JOptionPane.showInputDialog(this, "Please enter the minimum for confidence values to be displayed.\n[current value: " + this.getOptions().getMinConfidenceValue() + "]\n", "Minimal Confidence Value", 3, null, null, this.getOptions().getMinConfidenceValue());
        if (!ForesterUtil.isEmpty(s2)) {
            boolean success = true;
            double m3 = 0.0;
            String m_str = s2.trim();
            if (!ForesterUtil.isEmpty(m_str)) {
                try {
                    m3 = Double.parseDouble(m_str);
                }
                catch (Exception ex) {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && m3 >= 0.0) {
                this.getOptions().setMinConfidenceValue(m3);
            }
        }
    }

    private void deleteSelectedNodes(boolean delete) {
        Phylogeny phy = this.getMainPanel().getCurrentPhylogeny();
        if (phy == null || phy.getNumberOfExternalNodes() < 2) {
            return;
        }
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        if (this.getCurrentTreePanel().getFoundNodes0() != null || this.getCurrentTreePanel().getFoundNodes1() != null) {
            List<PhylogenyNode> all_selected_nodes = this.getCurrentTreePanel().getFoundNodesAsListOfPhylogenyNodes();
            for (PhylogenyNode n : all_selected_nodes) {
                if (!n.isExternal()) continue;
                nodes.add(n);
            }
        }
        String function = "Retain";
        if (delete) {
            function = "Delete";
        }
        if (nodes == null || nodes.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Need to select external nodes, either via direct selection or via the \"Search\" function", "No external nodes selected to " + function.toLowerCase(), 0);
            return;
        }
        int todo = nodes.size();
        int ext = phy.getNumberOfExternalNodes();
        int res = todo;
        if (delete) {
            res = ext - todo;
        }
        if (res < 1) {
            JOptionPane.showMessageDialog(this, "Cannot delete all nodes", "Attempt to delete all nodes ", 0);
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, function + " " + todo + " external node(s), from a total of " + ext + " external nodes,\nresulting in tree with " + res + " nodes?", function + " external nodes", 2);
        if (result == 0) {
            if (!delete) {
                ArrayList<PhylogenyNode> to_delete = new ArrayList<PhylogenyNode>();
                Iterator<PhylogenyNode> it = phy.iteratorExternalForward();
                while (it.hasNext()) {
                    PhylogenyNode n = it.next();
                    if (nodes.contains(n)) continue;
                    to_delete.add(n);
                }
                for (PhylogenyNode n : to_delete) {
                    phy.deleteSubtree(n, true);
                }
            } else {
                for (PhylogenyNode n : nodes) {
                    phy.deleteSubtree(n, true);
                }
            }
            this.resetSearch();
            this.getCurrentTreePanel().setNodeInPreorderToNull();
            phy.externalNodesHaveChanged();
            phy.clearHashIdToNodeMap();
            phy.recalculateNumberOfExternalDescendants(true);
            this.getCurrentTreePanel().resetNodeIdToDistToLeafMap();
            this.getCurrentTreePanel().setEdited(true);
            this.repaint();
        }
    }

    private void doUpdateProcessMenu() {
        if (this._process_pool.size() > 0) {
            if (this._process_menu == null) {
                this._process_menu = MainFrame.createMenu("", this.getConfiguration());
                this._process_menu.setForeground(Color.RED);
            }
            this._process_menu.removeAll();
            String text = "processes running: " + this._process_pool.size();
            this._process_menu.setText(text);
            this._jmenubar.add(this._process_menu);
            for (int i = 0; i < this._process_pool.size(); ++i) {
                ProcessRunning p = this._process_pool.getProcessByIndex(i);
                this._process_menu.add(this.customizeJMenuItem(new JMenuItem(p.getName() + " [" + p.getStart() + "]")));
            }
        } else if (this._process_menu != null) {
            this._process_menu.removeAll();
            this._jmenubar.remove(this._process_menu);
        }
        this._jmenubar.validate();
        this._jmenubar.repaint();
        this.repaint();
    }

    private String getPreviousNodeAnnotationReference() {
        return this._previous_node_annotation_ref;
    }

    private void removeBranchColors() {
        if (this.getMainPanel().getCurrentPhylogeny() != null) {
            AptxUtil.removeBranchColors(this.getMainPanel().getCurrentPhylogeny());
        }
    }

    private void removeVisualStyles() {
        if (this.getMainPanel().getCurrentPhylogeny() != null) {
            AptxUtil.removeVisualStyles(this.getMainPanel().getCurrentPhylogeny());
        }
    }

    private void setPreviousNodeAnnotationReference(String previous_node_annotation_ref) {
        this._previous_node_annotation_ref = previous_node_annotation_ref;
    }

    private void writeAllToFile() {
        if (this.getMainPanel().getTabbedPane() == null || this.getMainPanel().getTabbedPane().getTabCount() < 1) {
            return;
        }
        File my_dir = this.getCurrentDir();
        if (my_dir != null) {
            this._save_filechooser.setCurrentDirectory(my_dir);
        }
        this._save_filechooser.setSelectedFile(new File(""));
        int result = this._save_filechooser.showSaveDialog(this._contentpane);
        File file = this._save_filechooser.getSelectedFile();
        this.setCurrentDir(this._save_filechooser.getCurrentDirectory());
        if (file != null && result == 0) {
            if (file.exists()) {
                int i = JOptionPane.showConfirmDialog(this, file + " already exists. Overwrite?", "Warning", 2, 2);
                if (i != 0) {
                    return;
                }
                try {
                    file.delete();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Failed to delete: " + file, "Error", 2);
                }
            }
            int count = this.getMainPanel().getTabbedPane().getTabCount();
            ArrayList<Phylogeny> trees = new ArrayList<Phylogeny>();
            for (int i = 0; i < count; ++i) {
                Phylogeny phy = this.getMainPanel().getPhylogeny(i);
                if (ForesterUtil.isEmpty(phy.getName()) && !ForesterUtil.isEmpty(this.getMainPanel().getTabbedPane().getTitleAt(i))) {
                    phy.setName(this.getMainPanel().getTabbedPane().getTitleAt(i));
                }
                trees.add(phy);
                this.getMainPanel().getTreePanels().get(i).setEdited(false);
            }
            PhylogenyWriter writer = new PhylogenyWriter();
            try {
                writer.toPhyloXML(file, trees, 0, ForesterUtil.LINE_SEPARATOR);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Failed to write to: " + file, "Error", 2);
            }
        }
    }

    void activateSaveAllIfNeeded() {
        if (this.getMainPanel().getTabbedPane() != null && this.getMainPanel().getTabbedPane().getTabCount() > 1) {
            this._save_all_item.setEnabled(true);
        } else {
            this._save_all_item.setEnabled(false);
        }
    }

    void buildFileMenu() {
        this._file_jmenu = MainFrame.createMenu("File", this.getConfiguration());
        this._save_item = new JMenuItem("Save Tree As...");
        this._file_jmenu.add(this._save_item);
        this._file_jmenu.addSeparator();
        this._write_to_pdf_item = new JMenuItem("Export to PDF file ...");
        this._file_jmenu.add(this._write_to_pdf_item);
        if (AptxUtil.canWriteFormat("tif") || AptxUtil.canWriteFormat("tiff") || AptxUtil.canWriteFormat("TIF")) {
            this._write_to_tif_item = new JMenuItem("Export to TIFF file...");
            this._file_jmenu.add(this._write_to_tif_item);
        }
        this._write_to_png_item = new JMenuItem("Export to PNG file...");
        this._file_jmenu.add(this._write_to_png_item);
        this._write_to_jpg_item = new JMenuItem("Export to JPG file...");
        this._file_jmenu.add(this._write_to_jpg_item);
        if (AptxUtil.canWriteFormat("gif")) {
            this._write_to_gif_item = new JMenuItem("Export to GIF file...");
            this._file_jmenu.add(this._write_to_gif_item);
        }
        if (AptxUtil.canWriteFormat("bmp")) {
            this._write_to_bmp_item = new JMenuItem("Export to BMP file...");
            this._file_jmenu.add(this._write_to_bmp_item);
        }
        this._file_jmenu.addSeparator();
        this._print_item = new JMenuItem("Print...");
        this._file_jmenu.add(this._print_item);
        this._file_jmenu.addSeparator();
        this._exit_item = new JMenuItem("Exit");
        this._file_jmenu.add(this._exit_item);
        this.customizeJMenuItem(this._save_item);
        this.customizeJMenuItem(this._write_to_pdf_item);
        this.customizeJMenuItem(this._write_to_png_item);
        this.customizeJMenuItem(this._write_to_jpg_item);
        this.customizeJMenuItem(this._write_to_gif_item);
        this.customizeJMenuItem(this._write_to_tif_item);
        this.customizeJMenuItem(this._write_to_bmp_item);
        this.customizeJMenuItem(this._print_item);
        this.customizeJMenuItem(this._exit_item);
        this._jmenubar.add(this._file_jmenu);
    }

    void buildFontSizeMenu() {
        this._font_size_menu = MainFrame.createMenu(FONT_SIZE_MENU_LABEL, this.getConfiguration());
        this._super_tiny_fonts_item = new JMenuItem("Super Tiny Fonts");
        this._font_size_menu.add(this._super_tiny_fonts_item);
        this._tiny_fonts_item = new JMenuItem("Tiny Fonts");
        this._font_size_menu.add(this._tiny_fonts_item);
        this._small_fonts_item = new JMenuItem("Small Fonts");
        this._font_size_menu.add(this._small_fonts_item);
        this._medium_fonts_item = new JMenuItem("Medium Fonts");
        this._font_size_menu.add(this._medium_fonts_item);
        this._large_fonts_item = new JMenuItem("Large Fonts");
        this._font_size_menu.add(this._large_fonts_item);
        this.customizeJMenuItem(this._super_tiny_fonts_item);
        this.customizeJMenuItem(this._tiny_fonts_item);
        this.customizeJMenuItem(this._small_fonts_item);
        this.customizeJMenuItem(this._medium_fonts_item);
        this.customizeJMenuItem(this._large_fonts_item);
        this._jmenubar.add(this._font_size_menu);
    }

    void buildHelpMenu() {
        this._help_jmenu = MainFrame.createMenu("Help", this.getConfiguration());
        this._help_item = new JMenuItem("Documentation");
        this._help_jmenu.add(this._help_item);
        this._help_jmenu.addSeparator();
        this._website_item = new JMenuItem("Archaeopteryx Home");
        this._help_jmenu.add(this._website_item);
        this._aptx_ref_item = new JMenuItem("Archaeopteryx Reference");
        this._phyloxml_website_item = new JMenuItem("phyloXML Home");
        this._help_jmenu.add(this._phyloxml_website_item);
        this._phyloxml_ref_item = new JMenuItem("phyloXML Reference");
        this._help_jmenu.add(this._phyloxml_ref_item);
        this._help_jmenu.addSeparator();
        this._about_item = new JMenuItem("About");
        this._help_jmenu.add(this._about_item);
        this.customizeJMenuItem(this._help_item);
        this.customizeJMenuItem(this._website_item);
        this.customizeJMenuItem(this._phyloxml_website_item);
        this.customizeJMenuItem(this._aptx_ref_item);
        this.customizeJMenuItem(this._phyloxml_ref_item);
        this.customizeJMenuItem(this._about_item);
        this._phyloxml_ref_item.setToolTipText(PHYLOXML_REF_TOOL_TIP);
        this._aptx_ref_item.setToolTipText(APTX_REF_TOOL_TIP);
        this._jmenubar.add(this._help_jmenu);
    }

    void buildTypeMenu() {
        this._type_menu = MainFrame.createMenu(TYPE_MENU_HEADER, this.getConfiguration());
        this._rectangular_type_cbmi = new JCheckBoxMenuItem(RECTANGULAR_TYPE_CBMI_LABEL);
        this._type_menu.add(this._rectangular_type_cbmi);
        this._euro_type_cbmi = new JCheckBoxMenuItem(EURO_TYPE_CBMI_LABEL);
        this._type_menu.add(this._euro_type_cbmi);
        this._rounded_type_cbmi = new JCheckBoxMenuItem(ROUNDED_TYPE_CBMI_LABEL);
        this._type_menu.add(this._rounded_type_cbmi);
        this._curved_type_cbmi = new JCheckBoxMenuItem(CURVED_TYPE_CBMI_LABEL);
        this._type_menu.add(this._curved_type_cbmi);
        this._triangular_type_cbmi = new JCheckBoxMenuItem(TRIANGULAR_TYPE_CBMI_LABEL);
        this._type_menu.add(this._triangular_type_cbmi);
        this._convex_type_cbmi = new JCheckBoxMenuItem(CONVEX_TYPE_CBMI_LABEL);
        this._type_menu.add(this._convex_type_cbmi);
        this._unrooted_type_cbmi = new JCheckBoxMenuItem(UNROOTED_TYPE_CBMI_LABEL);
        this._type_menu.add(this._unrooted_type_cbmi);
        this._circular_type_cbmi = new JCheckBoxMenuItem(CIRCULAR_TYPE_CBMI_LABEL);
        this._type_menu.add(this._circular_type_cbmi);
        this.customizeCheckBoxMenuItem(this._rectangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._triangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._euro_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._rounded_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._curved_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._convex_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._unrooted_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._circular_type_cbmi, false);
        this._unrooted_type_cbmi.setToolTipText(USE_MOUSEWHEEL_SHIFT_TO_ROTATE);
        this._circular_type_cbmi.setToolTipText(USE_MOUSEWHEEL_SHIFT_TO_ROTATE);
        this.initializeTypeMenu(this.getOptions());
        this._jmenubar.add(this._type_menu);
    }

    void buildViewMenu() {
        this._view_jmenu = MainFrame.createMenu("View", this.getConfiguration());
        this._display_basic_information_item = new JMenuItem(SHOW_BASIC_TREE_INFORMATION_LABEL);
        this._view_jmenu.add(this._display_basic_information_item);
        this._view_jmenu.addSeparator();
        this._view_as_XML_item = new JMenuItem("as phyloXML");
        this._view_jmenu.add(this._view_as_XML_item);
        this._view_as_NH_item = new JMenuItem("as Newick");
        this._view_jmenu.add(this._view_as_NH_item);
        this._view_as_nexus_item = new JMenuItem("as Nexus");
        this._view_jmenu.add(this._view_as_nexus_item);
        this.customizeJMenuItem(this._display_basic_information_item);
        this.customizeJMenuItem(this._view_as_NH_item);
        this.customizeJMenuItem(this._view_as_XML_item);
        this.customizeJMenuItem(this._view_as_nexus_item);
        this._jmenubar.add(this._view_jmenu);
    }

    void checkTextFrames() {
        if (this._textframes.size() > 5) {
            try {
                if (this._textframes.getFirst() != null) {
                    this._textframes.getFirst().removeMe();
                } else {
                    this._textframes.removeFirst();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    void choosePdfWidth() {
        String s2 = (String)JOptionPane.showInputDialog(this, "Please enter the default line width for PDF export.\n[current value: " + this.getOptions().getPrintLineWidth() + "]\n", "Line Width for PDF Export", 3, null, null, Float.valueOf(this.getOptions().getPrintLineWidth()));
        if (!ForesterUtil.isEmpty(s2)) {
            boolean success = true;
            float f = 0.0f;
            String m_str = s2.trim();
            if (!ForesterUtil.isEmpty(m_str)) {
                try {
                    f = Float.parseFloat(m_str);
                }
                catch (Exception ex) {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && (double)f > 0.0) {
                this.getOptions().setPrintLineWidth(f);
            }
        }
    }

    void choosePrintSize() {
        String s2 = (String)JOptionPane.showInputDialog(this, "Please enter values for width and height,\nseparated by a comma.\n[current values: " + this.getOptions().getPrintSizeX() + ", " + this.getOptions().getPrintSizeY() + "]\n[A4: " + 595 + ", " + 845 + "]\n[US Letter: " + 612 + ", " + 792 + "]", "Default Size for Graphics Export", 3, null, null, this.getOptions().getPrintSizeX() + ", " + this.getOptions().getPrintSizeY());
        if (!ForesterUtil.isEmpty(s2) && s2.indexOf(44) > 0) {
            boolean success = true;
            int x = 0;
            int y = 0;
            String[] str_ary = s2.split(",");
            if (str_ary.length == 2) {
                String x_str = str_ary[0].trim();
                String y_str = str_ary[1].trim();
                if (!ForesterUtil.isEmpty(x_str) && !ForesterUtil.isEmpty(y_str)) {
                    try {
                        x = Integer.parseInt(x_str);
                        y = Integer.parseInt(y_str);
                    }
                    catch (Exception ex) {
                        success = false;
                    }
                } else {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && x > 1 && y > 1) {
                this.getOptions().setPrintSizeX(x);
                this.getOptions().setPrintSizeY(y);
            }
        }
    }

    void close() {
        this.removeAllTextFrames();
        if (this._mainpanel != null) {
            this._mainpanel.terminate();
        }
        if (this._contentpane != null) {
            this._contentpane.removeAll();
        }
        this.setVisible(false);
        this.dispose();
    }

    void colorRank() {
        Object[] ranks;
        String rank;
        if (this._mainpanel.getCurrentTreePanel() != null && !ForesterUtil.isEmpty(rank = (String)JOptionPane.showInputDialog(this, "What rank should the colorization be based on", "Rank Selection", 3, null, ranks = AptxUtil.getAllPossibleRanks(), null))) {
            this._mainpanel.getCurrentTreePanel().colorRank(rank);
        }
    }

    void confColor() {
        if (this._mainpanel.getCurrentTreePanel() != null) {
            this._mainpanel.getCurrentTreePanel().confColor();
        }
    }

    void customizeCheckBoxMenuItem(JCheckBoxMenuItem item, boolean is_selected) {
        if (item != null) {
            item.setFont(menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                item.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                item.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            item.setSelected(is_selected);
            item.addActionListener(this);
        }
    }

    JMenuItem customizeJMenuItem(JMenuItem jmi) {
        if (jmi != null) {
            jmi.setFont(menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                jmi.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                jmi.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            jmi.addActionListener(this);
        }
        return jmi;
    }

    void customizeRadioButtonMenuItem(JRadioButtonMenuItem item, boolean is_selected) {
        if (item != null) {
            item.setFont(menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                item.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                item.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            item.setSelected(is_selected);
            item.addActionListener(this);
        }
    }

    void displayBasicInformation(File treefile) {
        if (this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            String title = "Basic Information";
            if (!ForesterUtil.isEmpty(this._mainpanel.getCurrentPhylogeny().getName())) {
                title = title + " for \"" + this._mainpanel.getCurrentPhylogeny().getName() + "\"";
            }
            this.showTextFrame(AptxUtil.createBasicInformation(this._mainpanel.getCurrentPhylogeny(), treefile), title);
        }
    }

    void exceptionOccuredDuringOpenFile(Exception e) {
        try {
            this._mainpanel.getCurrentTreePanel().setArrowCursor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(this, ForesterUtil.wordWrap(e.getLocalizedMessage(), 80), "Error during File|Open", 0);
    }

    void executeGSDI() {
        if (!this.isOKforSDI(false, true)) {
            return;
        }
        if (!this._mainpanel.getCurrentPhylogeny().isRooted()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not rooted.", "Cannot execute GSDI", 0);
            return;
        }
        Phylogeny gene_tree = this._mainpanel.getCurrentPhylogeny().copy();
        gene_tree.setAllNodesToNotCollapse();
        gene_tree.recalculateNumberOfExternalDescendants(false);
        GSDI gsdi2 = null;
        Phylogeny species_tree = this.getSpeciesTree().copy();
        try {
            gsdi2 = new GSDI(gene_tree, species_tree, false, true, true, true);
        }
        catch (SDIException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error during GSDI", 0);
            return;
        }
        catch (Exception e) {
            AptxUtil.unexpectedException(e);
            return;
        }
        gene_tree.setRerootable(false);
        gene_tree.clearHashIdToNodeMap();
        gene_tree.recalculateNumberOfExternalDescendants(true);
        this._mainpanel.addPhylogenyInNewTab(gene_tree, this.getConfiguration(), "gene tree", null);
        this.getMainPanel().getControlPanel().setShowEvents(true);
        this.showWhole();
        int selected = this._mainpanel.getTabbedPane().getSelectedIndex();
        this._mainpanel.addPhylogenyInNewTab(species_tree, this.getConfiguration(), "species tree", null);
        this.showWhole();
        this._mainpanel.getTabbedPane().setSelectedIndex(selected);
        this.showWhole();
        this._mainpanel.getCurrentTreePanel().setEdited(true);
        int poly = PhylogenyMethods.countNumberOfPolytomies(species_tree);
        if (gsdi2.getStrippedExternalGeneTreeNodes().size() > 0) {
            JOptionPane.showMessageDialog(this, "Duplications: " + gsdi2.getDuplicationsSum() + "\nPotential duplications: " + gsdi2.getSpeciationOrDuplicationEventsSum() + "\nSpeciations: " + gsdi2.getSpeciationsSum() + "\nStripped gene tree nodes: " + gsdi2.getStrippedExternalGeneTreeNodes().size() + "\nTaxonomy linkage based on: " + (Object)((Object)gsdi2.getTaxCompBase()) + "\nNumber of polytomies in species tree used: " + poly + "\n", "GSDI successfully completed", 2);
        } else {
            JOptionPane.showMessageDialog(this, "Duplications: " + gsdi2.getDuplicationsSum() + "\nPotential duplications: " + gsdi2.getSpeciationOrDuplicationEventsSum() + "\nSpeciations: " + gsdi2.getSpeciationsSum() + "\nStripped gene tree nodes: " + gsdi2.getStrippedExternalGeneTreeNodes().size() + "\nTaxonomy linkage based on: " + (Object)((Object)gsdi2.getTaxCompBase()) + "\nNumber of polytomies in species tree used: " + poly + "\n", "GSDI successfully completed", 1);
        }
    }

    void executeGSDIR() {
        if (!this.isOKforSDI(false, false)) {
            return;
        }
        int p = PhylogenyMethods.countNumberOfPolytomies(this._mainpanel.getCurrentPhylogeny());
        if (p > 0 && (p != 1 || this._mainpanel.getCurrentPhylogeny().getRoot().getNumberOfDescendants() != 3)) {
            JOptionPane.showMessageDialog(this, "Gene tree is not completely binary", "Cannot execute GSDI", 0);
            return;
        }
        Phylogeny gene_tree = this._mainpanel.getCurrentPhylogeny().copy();
        gene_tree.setAllNodesToNotCollapse();
        gene_tree.recalculateNumberOfExternalDescendants(false);
        GSDIR gsdir = null;
        Phylogeny species_tree = this.getSpeciesTree().copy();
        try {
            gsdir = new GSDIR(gene_tree, species_tree, true, true, true);
        }
        catch (SDIException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error during GSDIR", 0);
            return;
        }
        catch (Exception e) {
            AptxUtil.unexpectedException(e);
            return;
        }
        Phylogeny result_gene_tree = gsdir.getMinDuplicationsSumGeneTree();
        result_gene_tree.setRerootable(false);
        result_gene_tree.clearHashIdToNodeMap();
        result_gene_tree.recalculateNumberOfExternalDescendants(true);
        PhylogenyMethods.orderAppearance(result_gene_tree.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME);
        this._mainpanel.addPhylogenyInNewTab(result_gene_tree, this.getConfiguration(), "gene tree", null);
        this.getMainPanel().getControlPanel().setShowEvents(true);
        this.showWhole();
        int selected = this._mainpanel.getTabbedPane().getSelectedIndex();
        this._mainpanel.addPhylogenyInNewTab(species_tree, this.getConfiguration(), "species tree", null);
        this.showWhole();
        this._mainpanel.getTabbedPane().setSelectedIndex(selected);
        this.showWhole();
        this._mainpanel.getCurrentTreePanel().setEdited(true);
        int poly = PhylogenyMethods.countNumberOfPolytomies(species_tree);
        if (gsdir.getStrippedExternalGeneTreeNodes().size() > 0) {
            JOptionPane.showMessageDialog(this, "Minimal duplications: " + gsdir.getMinDuplicationsSum() + "\nSpeciations: " + gsdir.getSpeciationsSum() + "\nStripped gene tree nodes: " + gsdir.getStrippedExternalGeneTreeNodes().size() + "\nTaxonomy linkage based on: " + (Object)((Object)gsdir.getTaxCompBase()) + "\nNumber of polytomies in species tree used: " + poly + "\n", "GSDIR successfully completed", 2);
        } else {
            JOptionPane.showMessageDialog(this, "Minimal duplications: " + gsdir.getMinDuplicationsSum() + "\nSpeciations: " + gsdir.getSpeciationsSum() + "\nStripped gene tree nodes: " + gsdir.getStrippedExternalGeneTreeNodes().size() + "\nTaxonomy linkage based on: " + (Object)((Object)gsdir.getTaxCompBase()) + "\nNumber of polytomies in species tree used: " + poly + "\n", "GSDIR successfully completed", 1);
        }
    }

    void executeLineageInference() {
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            return;
        }
        if (!this._mainpanel.getCurrentPhylogeny().isRooted()) {
            JOptionPane.showMessageDialog(this, "Phylogeny is not rooted.", "Cannot infer ancestral taxonomies", 0);
            return;
        }
        AncestralTaxonomyInferrer inferrer = new AncestralTaxonomyInferrer(this, this._mainpanel.getCurrentTreePanel(), this._mainpanel.getCurrentPhylogeny().copy());
        new Thread(inferrer).start();
    }

    boolean GAndSDoHaveMoreThanOneSpeciesInComman(Phylogeny gene_tree) {
        if (gene_tree == null || gene_tree.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Gene tree and species tree have no species in common.", "Error during SDI", 0);
            return false;
        }
        if (gene_tree.getNumberOfExternalNodes() < 2) {
            JOptionPane.showMessageDialog(this, "Gene tree and species tree have only one species in common.", "Error during SDI", 0);
            return false;
        }
        return true;
    }

    ControlPanel getControlPanel() {
        return this.getMainPanel().getControlPanel();
    }

    File getCurrentDir() {
        if ((this._current_dir == null || !this._current_dir.canRead()) && ForesterUtil.isWindows()) {
            try {
                this._current_dir = new File(WindowsUtils.getCurrentUserDesktopPath());
            }
            catch (Exception e) {
                this._current_dir = null;
            }
        }
        if (this._current_dir == null || !this._current_dir.canRead()) {
            if (System.getProperty("user.home") != null) {
                this._current_dir = new File(System.getProperty("user.home"));
            } else if (System.getProperty("user.dir") != null) {
                this._current_dir = new File(System.getProperty("user.dir"));
            }
        }
        return this._current_dir;
    }

    TreePanel getCurrentTreePanel() {
        return this.getMainPanel().getCurrentTreePanel();
    }

    JMenu getHelpMenu() {
        return this._help_jmenu;
    }

    JCheckBoxMenuItem getlabelDirectionCbmi() {
        return this._label_direction_cbmi;
    }

    JMenuBar getMenuBarOfMainFrame() {
        return this._jmenubar;
    }

    final Phylogeny getSpeciesTree() {
        return this._species_tree;
    }

    void initializeTypeMenu(Options options) {
        this.setTypeMenuToAllUnselected();
        switch (options.getPhylogenyGraphicsType()) {
            case CONVEX: {
                this._convex_type_cbmi.setSelected(true);
                break;
            }
            case CURVED: {
                this._curved_type_cbmi.setSelected(true);
                break;
            }
            case EURO_STYLE: {
                this._euro_type_cbmi.setSelected(true);
                break;
            }
            case ROUNDED: {
                this._rounded_type_cbmi.setSelected(true);
                break;
            }
            case TRIANGULAR: {
                this._triangular_type_cbmi.setSelected(true);
                break;
            }
            case UNROOTED: {
                this._unrooted_type_cbmi.setSelected(true);
                break;
            }
            case CIRCULAR: {
                this._circular_type_cbmi.setSelected(true);
                break;
            }
            default: {
                this._rectangular_type_cbmi.setSelected(true);
            }
        }
    }

    boolean isOKforSDI(boolean species_tree_has_to_binary, boolean gene_tree_has_to_binary) {
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            return false;
        }
        if (this.getSpeciesTree() == null || this.getSpeciesTree().isEmpty()) {
            JOptionPane.showMessageDialog(this, "No species tree loaded", "Cannot execute GSDI", 0);
            return false;
        }
        if (species_tree_has_to_binary && !this.getSpeciesTree().isCompletelyBinary()) {
            JOptionPane.showMessageDialog(this, "Species tree is not completely binary", "Cannot execute GSDI", 0);
            return false;
        }
        if (gene_tree_has_to_binary && !this._mainpanel.getCurrentPhylogeny().isCompletelyBinary()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not completely binary", "Cannot execute GSDI", 0);
            return false;
        }
        return true;
    }

    boolean isSubtreeDisplayed() {
        if (this.getCurrentTreePanel() != null && this.getCurrentTreePanel().isCurrentTreeIsSubtree()) {
            JOptionPane.showMessageDialog(this, "This operation can only be performed on a complete tree, not on the currently displayed sub-tree only.", "Operation can not be exectuted on a sub-tree", 2);
            return true;
        }
        return false;
    }

    void midpointRoot() {
        if (this._mainpanel.getCurrentTreePanel() != null) {
            this._mainpanel.getCurrentTreePanel().midpointRoot();
        }
    }

    void readPhylogeniesFromWebservice(int i) {
        UrlTreeReader reader = new UrlTreeReader(this, i);
        new Thread(reader).start();
    }

    void removeAllTextFrames() {
        for (TextFrame tf : this._textframes) {
            if (tf == null) continue;
            tf.close();
        }
        this._textframes.clear();
    }

    void resetSearch() {
        this.getMainPanel().getCurrentTreePanel().setFoundNodes0(null);
        this.getMainPanel().getCurrentTreePanel().setFoundNodes1(null);
        this.getMainPanel().getControlPanel().setSearchFoundCountsOnLabel0(0);
        this.getMainPanel().getControlPanel().getSearchFoundCountsLabel0().setVisible(false);
        this.getMainPanel().getControlPanel().getSearchTextField0().setText("");
        this.getMainPanel().getControlPanel().getSearchResetButton0().setEnabled(false);
        this.getMainPanel().getControlPanel().getSearchResetButton0().setVisible(false);
        this.getMainPanel().getControlPanel().setSearchFoundCountsOnLabel1(0);
        this.getMainPanel().getControlPanel().getSearchFoundCountsLabel1().setVisible(false);
        this.getMainPanel().getControlPanel().getSearchTextField1().setText("");
        this.getMainPanel().getControlPanel().getSearchResetButton1().setEnabled(false);
        this.getMainPanel().getControlPanel().getSearchResetButton1().setVisible(false);
    }

    void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    void setCurrentDir(File current_dir) {
        this._current_dir = current_dir;
    }

    void setInferenceManager(InferenceManager i) {
        this._inference_manager = i;
    }

    void setOptions(Options options) {
        this._options = options;
    }

    void setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE type) {
        this.setTypeMenuToAllUnselected();
        switch (type) {
            case CIRCULAR: {
                this._circular_type_cbmi.setSelected(true);
                break;
            }
            case CONVEX: {
                this._convex_type_cbmi.setSelected(true);
                break;
            }
            case CURVED: {
                this._curved_type_cbmi.setSelected(true);
                break;
            }
            case EURO_STYLE: {
                this._euro_type_cbmi.setSelected(true);
                break;
            }
            case ROUNDED: {
                this._rounded_type_cbmi.setSelected(true);
                break;
            }
            case RECTANGULAR: {
                this._rectangular_type_cbmi.setSelected(true);
                break;
            }
            case TRIANGULAR: {
                this._triangular_type_cbmi.setSelected(true);
                break;
            }
            case UNROOTED: {
                this._unrooted_type_cbmi.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + (Object)((Object)type));
            }
        }
    }

    final void setSpeciesTree(Phylogeny species_tree) {
        this._species_tree = species_tree;
    }

    void setTypeMenuToAllUnselected() {
        this._convex_type_cbmi.setSelected(false);
        this._curved_type_cbmi.setSelected(false);
        this._euro_type_cbmi.setSelected(false);
        this._rounded_type_cbmi.setSelected(false);
        this._triangular_type_cbmi.setSelected(false);
        this._rectangular_type_cbmi.setSelected(false);
        this._unrooted_type_cbmi.setSelected(false);
        this._circular_type_cbmi.setSelected(false);
    }

    void switchColors() {
        TreeColorSet colorset = this._mainpanel.getTreeColorSet();
        ColorSchemeChooser csc = new ColorSchemeChooser(this.getMainPanel(), colorset);
        csc.setVisible(true);
    }

    void taxColor() {
        if (this._mainpanel.getCurrentTreePanel() != null) {
            this._mainpanel.getCurrentTreePanel().taxColor();
        }
    }

    void typeChanged(Object o) {
        this.updateTypeCheckboxes(this.getOptions(), o);
        this.updateOptions(this.getOptions());
        if (this.getCurrentTreePanel() != null) {
            Options.PHYLOGENY_GRAPHICS_TYPE previous_type = this.getCurrentTreePanel().getPhylogenyGraphicsType();
            Options.PHYLOGENY_GRAPHICS_TYPE new_type = this.getOptions().getPhylogenyGraphicsType();
            if (previous_type == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && new_type != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || previous_type == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && new_type != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || previous_type != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && new_type == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || previous_type != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && new_type == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().showWhole();
            }
            if (this.getCurrentTreePanel().isPhyHasBranchLengths() && new_type != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(true);
            } else {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(false);
            }
            this.getCurrentTreePanel().setPhylogenyGraphicsType(this.getOptions().getPhylogenyGraphicsType());
            MainFrame.updateScreenTextAntialias(this.getMainPanel().getTreePanels());
            if (this.getCurrentTreePanel().getControlPanel().getDynamicallyHideData() != null) {
                if (new_type == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
                    this.getCurrentTreePanel().getControlPanel().getDynamicallyHideData().setEnabled(false);
                } else {
                    this.getCurrentTreePanel().getControlPanel().getDynamicallyHideData().setEnabled(true);
                }
            }
        }
    }

    void updateOptions(Options options) {
        options.setAntialiasScreen(this._screen_antialias_cbmi != null && this._screen_antialias_cbmi.isSelected());
        options.setBackgroundColorGradient(this._background_gradient_cbmi != null && this._background_gradient_cbmi.isSelected());
        options.setShowDomainLabels(this._show_domain_labels != null && this._show_domain_labels.isSelected());
        options.setShowAnnotationRefSource(this._show_annotation_ref_source != null && this._show_annotation_ref_source.isSelected());
        options.setAbbreviateScientificTaxonNames(this._abbreviate_scientific_names != null && this._abbreviate_scientific_names.isSelected());
        options.setColorLabelsSameAsParentBranch(this._color_labels_same_as_parent_branch != null && this._color_labels_same_as_parent_branch.isSelected());
        options.setShowDefaultNodeShapesInternal(this._show_default_node_shapes_internal_cbmi != null && this._show_default_node_shapes_internal_cbmi.isSelected());
        options.setShowDefaultNodeShapesExternal(this._show_default_node_shapes_external_cbmi != null && this._show_default_node_shapes_external_cbmi.isSelected());
        options.setShowDefaultNodeShapesForMarkedNodes(this._show_default_node_shapes_for_marked_cbmi != null && this._show_default_node_shapes_for_marked_cbmi.isSelected());
        if (this._non_lined_up_cladograms_rbmi != null && this._non_lined_up_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.NON_LINED_UP);
        } else if (this._uniform_cladograms_rbmi != null && this._uniform_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        } else if (this._ext_node_dependent_cladogram_rbmi != null && this._ext_node_dependent_cladogram_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        }
        options.setSearchCaseSensitive(this._search_case_senstive_cbmi != null && this._search_case_senstive_cbmi.isSelected());
        if (this._show_scale_cbmi != null && this._show_scale_cbmi.isEnabled()) {
            options.setShowScale(this._show_scale_cbmi.isSelected());
        }
        if (this._label_direction_cbmi != null) {
            if (this._label_direction_cbmi.isSelected()) {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
            } else {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
            }
        }
        options.setShowOverview(this._show_overview_cbmi != null && this._show_overview_cbmi.isSelected());
        options.setShowConfidenceStddev(this._show_confidence_stddev_cbmi != null && this._show_confidence_stddev_cbmi.isSelected());
        if (this._color_by_taxonomic_group_cbmi != null && this._color_by_taxonomic_group_cbmi.isEnabled()) {
            options.setColorByTaxonomicGroup(this._color_by_taxonomic_group_cbmi.isSelected());
        }
        options.setPrintUsingActualSize(this._print_using_actual_size_cbmi != null && this._print_using_actual_size_cbmi.isSelected());
        options.setGraphicsExportUsingActualSize(this._graphics_export_using_actual_size_cbmi != null && this._graphics_export_using_actual_size_cbmi.isSelected());
        options.setAntialiasPrint(this._antialias_print_cbmi != null && this._antialias_print_cbmi.isSelected());
        if (this._use_brackets_for_conf_in_nh_export_cbmi != null && this._use_brackets_for_conf_in_nh_export_cbmi.isSelected()) {
            options.setNhConversionSupportValueStyle(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.IN_SQUARE_BRACKETS);
        } else if (this._use_internal_names_for_conf_in_nh_export_cbmi != null && this._use_internal_names_for_conf_in_nh_export_cbmi.isSelected()) {
            options.setNhConversionSupportValueStyle(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.AS_INTERNAL_NODE_NAMES);
        } else {
            options.setNhConversionSupportValueStyle(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.NONE);
        }
        options.setPrintBlackAndWhite(this._print_black_and_white_cbmi != null && this._print_black_and_white_cbmi.isSelected());
        options.setInternalNumberAreConfidenceForNhParsing(this._internal_number_are_confidence_for_nh_parsing_cbmi != null && this._internal_number_are_confidence_for_nh_parsing_cbmi.isSelected());
        if (this._extract_taxonomy_pfam_strict_rbmi != null && this._extract_taxonomy_pfam_strict_rbmi.isSelected()) {
            options.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_STRICT);
        } else if (this._extract_taxonomy_pfam_relaxed_rbmi != null && this._extract_taxonomy_pfam_relaxed_rbmi.isSelected()) {
            options.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED);
        } else if (this._extract_taxonomy_agressive_rbmi != null && this._extract_taxonomy_agressive_rbmi.isSelected()) {
            options.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
        } else if (this._extract_taxonomy_no_rbmi != null && this._extract_taxonomy_no_rbmi.isSelected()) {
            options.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
        }
        options.setReplaceUnderscoresInNhParsing(this._replace_underscores_cbmi != null && this._replace_underscores_cbmi.isSelected());
        options.setAllowErrorsInDistanceToParent(this._allow_errors_in_distance_to_parent_cbmi != null && this._allow_errors_in_distance_to_parent_cbmi.isSelected());
        options.setMatchWholeTermsOnly(this._search_whole_words_only_cbmi != null && this._search_whole_words_only_cbmi.isSelected());
        options.setSearchWithRegex(this._search_with_regex_cbmi != null && this._search_with_regex_cbmi.isSelected());
        options.setInverseSearchResult(this._inverse_search_result_cbmi != null && this._inverse_search_result_cbmi.isSelected());
        if (this._graphics_export_visible_only_cbmi != null) {
            options.setGraphicsExportVisibleOnly(this._graphics_export_visible_only_cbmi.isSelected());
            if (this._graphics_export_visible_only_cbmi.isSelected() && this._graphics_export_using_actual_size_cbmi != null) {
                this._graphics_export_using_actual_size_cbmi.setSelected(true);
                this._graphics_export_using_actual_size_cbmi.setEnabled(false);
            } else {
                this._graphics_export_using_actual_size_cbmi.setEnabled(true);
            }
        }
        if (this._rectangular_type_cbmi != null && this._rectangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        } else if (this._triangular_type_cbmi != null && this._triangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
        } else if (this._curved_type_cbmi != null && this._curved_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
        } else if (this._convex_type_cbmi != null && this._convex_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
        } else if (this._euro_type_cbmi != null && this._euro_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
        } else if (this._rounded_type_cbmi != null && this._rounded_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
        } else if (this._unrooted_type_cbmi != null && this._unrooted_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
        } else if (this._circular_type_cbmi != null && this._circular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
        }
        if (this._right_line_up_domains_cbmi != null && this._right_line_up_domains_cbmi.isEnabled()) {
            options.setRightLineUpDomains(this._right_line_up_domains_cbmi.isSelected());
        }
        if (this._line_up_renderable_data_cbmi != null && this._line_up_renderable_data_cbmi.isEnabled()) {
            options.setLineUpRendarableNodeData(this._line_up_renderable_data_cbmi.isSelected());
        }
    }

    void updateTypeCheckboxes(Options options, Object o) {
        this.setTypeMenuToAllUnselected();
        ((JCheckBoxMenuItem)o).setSelected(true);
    }

    void viewAsNexus() {
        if (this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            String title = "Nexus";
            if (!ForesterUtil.isEmpty(this._mainpanel.getCurrentPhylogeny().getName())) {
                title = "\"" + this.getMainPanel().getCurrentPhylogeny().getName() + "\" in " + title;
            }
            this.showTextFrame(this._mainpanel.getCurrentPhylogeny().toNexus(this.getOptions().getNhConversionSupportValueStyle()), title);
        }
    }

    void viewAsNH() {
        if (this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            String title = "New Hampshire";
            if (!ForesterUtil.isEmpty(this._mainpanel.getCurrentPhylogeny().getName())) {
                title = "\"" + this.getMainPanel().getCurrentPhylogeny().getName() + "\" in " + title;
            }
            this.showTextFrame(this._mainpanel.getCurrentPhylogeny().toNewHampshire(this.getOptions().getNhConversionSupportValueStyle()), title);
        }
    }

    void viewAsXML() {
        if (this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            String title = "phyloXML";
            if (!ForesterUtil.isEmpty(this._mainpanel.getCurrentPhylogeny().getName())) {
                title = "\"" + this.getMainPanel().getCurrentPhylogeny().getName() + "\" in " + title;
            }
            this.showTextFrame(this._mainpanel.getCurrentPhylogeny().toPhyloXML(0), title);
        }
    }

    private static void cycleNodeDataReturn(Options op, Configuration conf) {
        switch (op.getExtDescNodeDataToReturn()) {
            case UNKNOWN: {
                op.setExtDescNodeDataToReturn(NodeDataField.DOMAINS_ALL);
                break;
            }
            case DOMAINS_ALL: {
                op.setExtDescNodeDataToReturn(NodeDataField.DOMAINS_COLLAPSED_PER_PROTEIN);
                break;
            }
            case DOMAINS_COLLAPSED_PER_PROTEIN: {
                op.setExtDescNodeDataToReturn(NodeDataField.SEQ_ANNOTATIONS);
                break;
            }
            case SEQ_ANNOTATIONS: {
                op.setExtDescNodeDataToReturn(NodeDataField.GO_TERM_IDS);
                break;
            }
            case GO_TERM_IDS: {
                op.setExtDescNodeDataToReturn(NodeDataField.SEQUENCE_MOL_SEQ_FASTA);
                break;
            }
            case SEQUENCE_MOL_SEQ_FASTA: {
                if (conf != null && conf.getExtDescNodeDataToReturn() != null && conf.getExtDescNodeDataToReturn() != NodeDataField.DOMAINS_ALL && conf.getExtDescNodeDataToReturn() != NodeDataField.DOMAINS_COLLAPSED_PER_PROTEIN && conf.getExtDescNodeDataToReturn() != NodeDataField.SEQ_ANNOTATIONS && conf.getExtDescNodeDataToReturn() != NodeDataField.GO_TERM_IDS && conf.getExtDescNodeDataToReturn() != NodeDataField.SEQUENCE_MOL_SEQ_FASTA) {
                    op.setExtDescNodeDataToReturn(conf.getExtDescNodeDataToReturn());
                    break;
                }
                op.setExtDescNodeDataToReturn(NodeDataField.UNKNOWN);
                break;
            }
            default: {
                op.setExtDescNodeDataToReturn(NodeDataField.UNKNOWN);
            }
        }
    }

    static void about() {
        StringBuffer about = new StringBuffer("Archaeopteryx\nVersion 0.9909 experimental\n");
        about.append("Copyright (C) 2015 Christian M Zmasek\n");
        about.append("All Rights Reserved\n");
        about.append("License: GNU Lesser General Public License (LGPL)\n");
        about.append("Last modified: 150513\n");
        about.append("Based on: " + ForesterUtil.getForesterLibraryInformation() + "\n");
        about.append("phyloXML version : 1.10\n");
        about.append("phyloXML location: http://www.phyloxml.org\n");
        if (!ForesterUtil.isEmpty(ForesterUtil.JAVA_VERSION) && !ForesterUtil.isEmpty(ForesterUtil.JAVA_VENDOR)) {
            about.append("[your Java version: " + ForesterUtil.JAVA_VERSION + " " + ForesterUtil.JAVA_VENDOR + "]\n");
        }
        if (!(ForesterUtil.isEmpty(ForesterUtil.OS_NAME) || ForesterUtil.isEmpty(ForesterUtil.OS_ARCH) || ForesterUtil.isEmpty(ForesterUtil.OS_VERSION))) {
            about.append("[your OS: " + ForesterUtil.OS_NAME + " " + ForesterUtil.OS_ARCH + " " + ForesterUtil.OS_VERSION + "]\n");
        }
        Runtime rt = Runtime.getRuntime();
        long free_memory = rt.freeMemory() / 1000000L;
        long total_memory = rt.totalMemory() / 1000000L;
        about.append("[free memory: " + free_memory + "MB, total memory: " + total_memory + "MB]\n");
        about.append("[locale: " + Locale.getDefault() + "]\n");
        about.append("References:\n");
        about.append("Han MV and Zmasek CM (2009), BMC Bioinformatics, 10:356\n");
        about.append("For more information & download:\n");
        about.append("https://sites.google.com/site/cmzmasek/home/software/archaeopteryx\n");
        about.append("Documentation:\n");
        about.append("https://sites.google.com/site/cmzmasek/home/software/archaeopteryx/documentation\n");
        about.append("Comments: phyloxml@gmail.com");
        JOptionPane.showMessageDialog(null, about, "Archaeopteryx", -1);
    }

    static void chooseNodeSize(Options options, Component parent) {
        String s2 = (String)JOptionPane.showInputDialog(parent, "Please enter the default size for node shapes.\n[current value: " + options.getDefaultNodeShapeSize() + "]\n", "Node Shape Size", 3, null, null, options.getDefaultNodeShapeSize());
        if (!ForesterUtil.isEmpty(s2)) {
            short size;
            boolean success = true;
            double m3 = 0.0;
            String m_str = s2.trim();
            if (!ForesterUtil.isEmpty(m_str)) {
                try {
                    m3 = Double.parseDouble(m_str);
                }
                catch (Exception ex) {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && m3 >= 0.0 && (double)(size = ForesterUtil.roundToShort(m3)) >= 0.0) {
                options.setDefaultNodeShapeSize(size);
            }
        }
    }

    static String createCurrentFontDesc(TreeFontSet tree_font_set) {
        return tree_font_set.getLargeFont().getFamily() + " " + tree_font_set.getLargeFont().getSize();
    }

    static JMenu createMenu(String title, Configuration conf) {
        JMenu jmenu = new JMenu(title);
        if (!conf.isUseNativeUI()) {
            jmenu.setFont(menu_font);
            jmenu.setBackground(conf.getGuiMenuBackgroundColor());
            jmenu.setForeground(conf.getGuiMenuTextColor());
        }
        return jmenu;
    }

    static JMenuItem customizeMenuItemAsLabel(JMenuItem label, Configuration configuration) {
        label.setFont(menu_font.deriveFont(1));
        if (!configuration.isUseNativeUI()) {
            label.setBackground(configuration.getGuiMenuBackgroundColor());
            label.setForeground(configuration.getGuiMenuTextColor());
            label.setOpaque(true);
        }
        label.setSelected(false);
        label.setEnabled(false);
        return label;
    }

    static void cycleNodeFill(Options op) {
        switch (op.getDefaultNodeFill()) {
            case GRADIENT: {
                op.setDefaultNodeFill(NodeVisualData.NodeFill.SOLID);
                break;
            }
            case NONE: {
                op.setDefaultNodeFill(NodeVisualData.NodeFill.GRADIENT);
                break;
            }
            case SOLID: {
                op.setDefaultNodeFill(NodeVisualData.NodeFill.NONE);
                break;
            }
            default: {
                throw new RuntimeException("unknown fill: " + (Object)((Object)op.getDefaultNodeFill()));
            }
        }
    }

    static void cycleNodeShape(Options op) {
        switch (op.getDefaultNodeShape()) {
            case CIRCLE: {
                op.setDefaultNodeShape(NodeVisualData.NodeShape.RECTANGLE);
                break;
            }
            case RECTANGLE: {
                op.setDefaultNodeShape(NodeVisualData.NodeShape.CIRCLE);
                break;
            }
            default: {
                throw new RuntimeException("unknown shape: " + (Object)((Object)op.getDefaultNodeShape()));
            }
        }
    }

    static void cycleOverview(Options op, TreePanel tree_panel) {
        switch (op.getOvPlacement()) {
            case LOWER_LEFT: {
                op.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT);
                break;
            }
            case LOWER_RIGHT: {
                op.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_LEFT);
                break;
            }
            case UPPER_LEFT: {
                op.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_RIGHT);
                break;
            }
            case UPPER_RIGHT: {
                op.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_RIGHT);
                break;
            }
            default: {
                throw new RuntimeException("unknown placement: " + (Object)((Object)op.getOvPlacement()));
            }
        }
        if (tree_panel != null) {
            tree_panel.updateOvSettings();
        }
    }

    static void exceptionOccuredDuringSaveAs(Exception e, TreePanel tp, Component comp) {
        try {
            tp.setArrowCursor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(comp, "Exception" + e, "Error during File|SaveAs", 0);
    }

    static void print(TreePanel tp, Options op, Component c) {
        if (tp == null || tp.getPhylogeny() == null || tp.getPhylogeny().isEmpty()) {
            return;
        }
        if (!op.isPrintUsingActualSize()) {
            tp.calcParametersForPainting(op.getPrintSizeX() - 80, op.getPrintSizeY() - 140);
            tp.resetPreferredSize();
            tp.repaint();
        }
        String job_name = "Archaeopteryx";
        boolean error = false;
        String printer_name = null;
        try {
            printer_name = Printer.print(tp, "Archaeopteryx");
        }
        catch (Exception e) {
            error = true;
            JOptionPane.showMessageDialog(c, e.getMessage(), "Printing Error", 0);
        }
        if (!error && printer_name != null) {
            String msg = "Printing data sent to printer";
            if (printer_name.length() > 1) {
                msg = msg + " [" + printer_name + "]";
            }
            JOptionPane.showMessageDialog(c, msg, "Printing...", 1);
        }
        if (!op.isPrintUsingActualSize()) {
            tp.getControlPanel().showWhole();
        }
    }

    static void printPhylogenyToPdf(String file_name, Options opts, TreePanel tp, Component comp) {
        if (!opts.isPrintUsingActualSize()) {
            tp.calcParametersForPainting(opts.getPrintSizeX(), opts.getPrintSizeY());
            tp.resetPreferredSize();
            tp.repaint();
        }
        String pdf_written_to = "";
        boolean error = false;
        try {
            pdf_written_to = opts.isPrintUsingActualSize() ? PdfExporter.writePhylogenyToPdf(file_name, tp, tp.getWidth(), tp.getHeight()) : PdfExporter.writePhylogenyToPdf(file_name, tp, opts.getPrintSizeX(), opts.getPrintSizeY());
        }
        catch (IOException e) {
            error = true;
            JOptionPane.showMessageDialog(comp, e.getMessage(), "Error", 0);
        }
        catch (NoClassDefFoundError e) {
            error = true;
            String msg = "PDF support has been disabled due to licensing restrictions, you will need to provide the itextpdf jar (5.1 or newer) in the classpath for this to work. Error is: NoClassDefFoundError ";
            JOptionPane.showMessageDialog(comp, msg + e.getMessage(), "Error", 0);
        }
        if (!error) {
            if (!ForesterUtil.isEmpty(pdf_written_to)) {
                JOptionPane.showMessageDialog(comp, "Wrote PDF to: " + pdf_written_to, "Information", 1);
            } else {
                JOptionPane.showMessageDialog(comp, "There was an unknown problem when attempting to write to PDF file: \"" + file_name + "\"", "Error", 0);
            }
        }
        if (!opts.isPrintUsingActualSize()) {
            tp.getControlPanel().showWhole();
        }
    }

    static void setCycleDataReturnMenuItem(JMenuItem mi, Options options) {
        if (options != null && options.getExtDescNodeDataToReturn() != null) {
            mi.setText("Cycle Node Return Data... (current: " + options.getExtDescNodeDataToReturn().toString() + ")");
        } else {
            mi.setText("Cycle Node Return Data...");
        }
    }

    static void setCycleNodeFillMenuItem(JMenuItem mi, Options options) {
        if (options != null && options.getDefaultNodeFill() != null) {
            mi.setText("Cycle Node Shape Fill Type... (current: " + options.getDefaultNodeFill().toString().toLowerCase() + ")");
        } else {
            mi.setText("Cycle Node Shape Fill Type...");
        }
    }

    static void setCycleNodeShapeMenuItem(JMenuItem mi, Options options) {
        if (options != null && options.getDefaultNodeShape() != null) {
            mi.setText("Cycle Node Shape Fill Type... (current: " + options.getDefaultNodeShape().toString().toLowerCase() + ")");
        } else {
            mi.setText("Cycle Node Shape Fill Type...");
        }
    }

    static void setOvPlacementColorChooseMenuItem(JMenuItem mi, Options options) {
        if (options != null && options.getOvPlacement() != null) {
            mi.setText("Cycle Overview Placement... (current: " + (Object)((Object)options.getOvPlacement()) + ")");
        } else {
            mi.setText("Cycle Overview Placement...");
        }
    }

    static void setTextColorChooseMenuItem(JMenuItem mi, TreePanel tree_panel) {
        if (tree_panel != null && tree_panel.getTreeColorSet() != null) {
            mi.setText("Select Color Scheme... (current: " + tree_panel.getTreeColorSet().getCurrentColorSchemeName() + ")");
        } else {
            mi.setText("Select Color Scheme...");
        }
    }

    static void setTextForFontChooserMenuItem(JMenuItem mi, String font_desc) {
        mi.setText("Select Default Font... (current: " + font_desc + ")");
    }

    static void setTextForGraphicsSizeChooserMenuItem(JMenuItem mi, Options o) {
        mi.setText("Enter Default Size for Graphics Export... (current: " + o.getPrintSizeX() + ", " + o.getPrintSizeY() + ")");
    }

    static void setTextForPdfLineWidthChooserMenuItem(JMenuItem mi, Options o) {
        mi.setText("Enter Default Line Width for PDF Export... (current: " + o.getPrintLineWidth() + ")");
    }

    static void setTextMinSupportMenuItem(JMenuItem mi, Options options, TreePanel current_tree_panel) {
        if (current_tree_panel == null || current_tree_panel.getPhylogeny() == null) {
            mi.setEnabled(true);
        } else if (AptxUtil.isHasAtLeastOneBranchWithSupportValues(current_tree_panel.getPhylogeny())) {
            mi.setEnabled(true);
        } else {
            mi.setEnabled(false);
        }
        mi.setText("Enter Min Confidence Value... (current: " + options.getMinConfidenceValue() + ")");
    }

    static void setTextNodeSizeMenuItem(JMenuItem mi, Options options) {
        mi.setText("Enter Default Node Shape Size... (current: " + options.getDefaultNodeShapeSize() + ")");
    }

    static void updateScreenTextAntialias(List<TreePanel> treepanels) {
        for (TreePanel tree_panel : treepanels) {
            tree_panel.setTextAntialias();
        }
    }

    static boolean writeAsNewHampshire(TreePanel tp, Options op, boolean exception, File file) {
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toNewHampshire(tp.getPhylogeny(), true, op.getNhConversionSupportValueStyle(), file);
        }
        catch (Exception e) {
            exception = true;
            MainFrame.exceptionOccuredDuringSaveAs(e, tp, tp);
        }
        return exception;
    }

    static boolean writeAsNexus(TreePanel tp, Options op, boolean exception, File file) {
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toNexus(file, tp.getPhylogeny(), op.getNhConversionSupportValueStyle());
        }
        catch (Exception e) {
            exception = true;
            MainFrame.exceptionOccuredDuringSaveAs(e, tp, tp);
        }
        return exception;
    }

    static boolean writeAsPhyloXml(TreePanel tp, Options op, boolean exception, File file) {
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toPhyloXML(file, tp.getPhylogeny(), 0);
        }
        catch (Exception e) {
            exception = true;
            MainFrame.exceptionOccuredDuringSaveAs(e, tp, tp);
        }
        return exception;
    }

    static void writePhylogenyToGraphicsFile(String file_name, AptxUtil.GraphicsExportType type, MainPanel mp, Component comp, Container contentpane) {
        mp.getCurrentTreePanel().calcParametersForPainting(mp.getCurrentTreePanel().getWidth(), mp.getCurrentTreePanel().getHeight());
        String file_written_to = "";
        boolean error = false;
        try {
            file_written_to = AptxUtil.writePhylogenyToGraphicsFile(file_name, mp.getCurrentTreePanel().getWidth(), mp.getCurrentTreePanel().getHeight(), mp.getCurrentTreePanel(), mp.getControlPanel(), type, mp.getOptions());
        }
        catch (IOException e) {
            error = true;
            JOptionPane.showMessageDialog(comp, e.getMessage(), "Error", 0);
        }
        if (!error) {
            if (file_written_to != null && file_written_to.length() > 0) {
                JOptionPane.showMessageDialog(comp, "Wrote image to: " + file_written_to, "Graphics Export", 1);
            } else {
                JOptionPane.showMessageDialog(comp, "There was an unknown problem when attempting to write to an image file: \"" + file_name + "\"", "Error", 0);
            }
        }
        contentpane.repaint();
    }

    static File writeToFile(Phylogeny t, MainPanel mp, JFileChooser save_filechooser, File current_dir, Container contentpane, Component comp) {
        File new_file = null;
        if (t == null) {
            return null;
        }
        String initial_filename = null;
        if (mp.getCurrentTreePanel().getTreeFile() != null) {
            try {
                initial_filename = mp.getCurrentTreePanel().getTreeFile().getCanonicalPath();
            }
            catch (IOException e) {
                initial_filename = null;
            }
        }
        if (!ForesterUtil.isEmpty(initial_filename)) {
            save_filechooser.setSelectedFile(new File(initial_filename));
        } else {
            save_filechooser.setSelectedFile(new File(""));
        }
        File my_dir = current_dir;
        if (my_dir != null) {
            save_filechooser.setCurrentDirectory(my_dir);
        }
        int result = save_filechooser.showSaveDialog(contentpane);
        File file = save_filechooser.getSelectedFile();
        new_file = save_filechooser.getCurrentDirectory();
        boolean exception = false;
        if (file != null && result == 0) {
            String file_name;
            if (file.exists()) {
                int i = JOptionPane.showConfirmDialog(comp, file + " already exists.\nOverwrite?", "Overwrite?", 2, 3);
                if (i != 0) {
                    return null;
                }
                File to = new File(file.getAbsoluteFile().toString() + ".BAK");
                try {
                    ForesterUtil.copyFile(file, to);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(comp, "Failed to create backup copy " + to, "Failed to Create Backup Copy", 2);
                }
                try {
                    file.delete();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(comp, "Failed to delete: " + file, "Failed to Delete", 2);
                }
            }
            if (!(exception = save_filechooser.getFileFilter() == nhfilter ? MainFrame.writeAsNewHampshire(mp.getCurrentTreePanel(), mp.getOptions(), exception, file) : (save_filechooser.getFileFilter() == xmlfilter ? MainFrame.writeAsPhyloXml(mp.getCurrentTreePanel(), mp.getOptions(), exception, file) : (save_filechooser.getFileFilter() == nexusfilter ? MainFrame.writeAsNexus(mp.getCurrentTreePanel(), mp.getOptions(), exception, file) : ((file_name = file.getName().trim().toLowerCase()).endsWith(".nh") || file_name.endsWith(".newick") || file_name.endsWith(".phy") || file_name.endsWith(".tree") ? MainFrame.writeAsNewHampshire(mp.getCurrentTreePanel(), mp.getOptions(), exception, file) : (file_name.endsWith(".nex") || file_name.endsWith(".nexus") ? MainFrame.writeAsNexus(mp.getCurrentTreePanel(), mp.getOptions(), exception, file) : MainFrame.writeAsPhyloXml(mp.getCurrentTreePanel(), mp.getOptions(), exception, file))))))) {
                mp.setTitleOfSelectedTab(file.getName());
                mp.getCurrentTreePanel().setTreeFile(file);
                mp.getCurrentTreePanel().setEdited(false);
            }
        }
        return new_file;
    }

    static File writeToGraphicsFile(Phylogeny t, AptxUtil.GraphicsExportType type, MainPanel mp, JFileChooser writetographics_filechooser, Component component, Container contentpane, File current_dir) {
        File new_dir = null;
        if (t == null || t.isEmpty()) {
            return null;
        }
        String initial_filename = "";
        if (mp.getCurrentTreePanel().getTreeFile() != null) {
            initial_filename = mp.getCurrentTreePanel().getTreeFile().toString();
        }
        if (initial_filename.indexOf(46) > 0) {
            initial_filename = initial_filename.substring(0, initial_filename.lastIndexOf(46));
        }
        initial_filename = initial_filename + "." + (Object)((Object)type);
        writetographics_filechooser.setSelectedFile(new File(initial_filename));
        File my_dir = current_dir;
        if (my_dir != null) {
            writetographics_filechooser.setCurrentDirectory(my_dir);
        }
        int result = writetographics_filechooser.showSaveDialog(contentpane);
        File file = writetographics_filechooser.getSelectedFile();
        new_dir = writetographics_filechooser.getCurrentDirectory();
        if (file != null && result == 0) {
            if (!file.toString().toLowerCase().endsWith(type.toString())) {
                file = new File(file.toString() + "." + (Object)((Object)type));
            }
            if (file.exists()) {
                int i = JOptionPane.showConfirmDialog(component, file + " already exists. Overwrite?", "Warning", 2, 2);
                if (i != 0) {
                    return null;
                }
                try {
                    file.delete();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(component, "Failed to delete: " + file, "Error", 2);
                }
            }
            MainFrame.writePhylogenyToGraphicsFile(file.toString(), type, mp, component, contentpane);
        }
        return new_dir;
    }

    static File writeToPdf(Phylogeny t, MainPanel mp, JFileChooser writetopdf_filechooser, File curr_dir, Container contentpane, Component component) {
        if (t == null || t.isEmpty()) {
            return null;
        }
        String initial_filename = "";
        if (mp.getCurrentTreePanel().getTreeFile() != null) {
            initial_filename = mp.getCurrentTreePanel().getTreeFile().toString();
        }
        if (initial_filename.indexOf(46) > 0) {
            initial_filename = initial_filename.substring(0, initial_filename.lastIndexOf(46));
        }
        initial_filename = initial_filename + ".pdf";
        writetopdf_filechooser.setSelectedFile(new File(initial_filename));
        File my_dir = curr_dir;
        if (my_dir != null) {
            writetopdf_filechooser.setCurrentDirectory(my_dir);
        }
        int result = writetopdf_filechooser.showSaveDialog(contentpane);
        File file = writetopdf_filechooser.getSelectedFile();
        File new_current_dir = writetopdf_filechooser.getCurrentDirectory();
        if (file != null && result == 0) {
            int i;
            if (!file.toString().toLowerCase().endsWith(".pdf")) {
                file = new File(file.toString() + ".pdf");
            }
            if (file.exists() && (i = JOptionPane.showConfirmDialog(component, file + " already exists. Overwrite?", "WARNING", 2, 2)) != 0) {
                return null;
            }
            MainFrame.printPhylogenyToPdf(file.toString(), mp.getOptions(), mp.getCurrentTreePanel(), component);
        }
        return new_current_dir;
    }
}

