/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import org.forester.archaeopteryx.TreePanel;
import org.forester.util.ForesterUtil;

final class Printer {
    private Printer() {
    }

    static String print(TreePanel tree_panel, String job_name) throws PrinterException {
        if (tree_panel == null || tree_panel.getPhylogeny() == null) {
            throw new IllegalArgumentException("attempt to print null");
        }
        if (ForesterUtil.isEmpty(job_name)) {
            throw new IllegalArgumentException("attempt use null or empty print job name");
        }
        PrinterJob printer_job = PrinterJob.getPrinterJob();
        if (printer_job != null) {
            printer_job.setJobName(job_name);
            printer_job.setPrintable(tree_panel);
            boolean ok = printer_job.printDialog();
            if (ok) {
                printer_job.print();
                String print_service_name = printer_job.getPrintService().getName();
                if (!ForesterUtil.isEmpty(print_service_name)) {
                    return print_service_name;
                }
                return "";
            }
            return null;
        }
        throw new PrinterException("failed to access printer job");
    }
}

