/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.webservices;

import java.util.ArrayList;
import java.util.List;
import org.forester.archaeopteryx.webservices.BasicPhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.PhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.WebservicesManager;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;

public final class WebserviceUtil {
    public static final String PFAM_INST = "pfam";
    public static final String PFAM_NAME = "Pfam";
    public static final String PFAM_SERVER = "http://pfam.xfam.org";
    public static final String TOL_NAME = "Tree of Life (ToL)";
    public static final String TOL_URL_BASE = "http://tolweb.org/onlinecontributors/app?service=external&page=xml/TreeStructureService&node_id=";
    public static final String TOL_WEBSERVER = "http://tolweb.org/onlinecontributors/app?service=external&page=xml/TreeStructureService&node_id=__query__";
    public static final String TREE_BASE_DESC = "This data set was downloaded from TreeBASE, a relational database of phylogenetic knowledge. TreeBASE has been supported by the NSF, Harvard University, Yale University, SDSC and UC Davis. Please do not remove this acknowledgment.";
    public static final String TREE_BASE_INST = "treebase";
    public static final String TREE_BASE_NAME = "TreeBASE";
    public static final String TREE_FAM_INST = "tree_fam";
    public static final String TREE_FAM_NAME = "TreeFam";
    public static final String TREE_FAM_URL_BASE = "http://www.treefam.org/family/TF";
    public static final String TREEBASE_PHYLOWS_STUDY_URL_BASE = "http://purl.org/phylo/treebase/phylows/study/TB2:S";
    public static final String TREEBASE_PHYLOWS_TREE_URL_BASE = "http://purl.org/phylo/treebase/phylows/tree/TB2:Tr";

    public static List<PhylogeniesWebserviceClient> createDefaultClients() {
        ArrayList<PhylogeniesWebserviceClient> clients = new ArrayList<PhylogeniesWebserviceClient>();
        clients.add(new BasicPhylogeniesWebserviceClient(TREE_BASE_NAME, "Read Tree(s) from TreeBASE Study...", "Use TreeBASE to obtain evolutionary tree(s) from a study", "Please enter a TreeBASE study (\"S\") identifier (without the \"S\")\n(Examples: 14909, 14525, 15613, 15632)", WebservicesManager.WsPhylogenyFormat.TREEBASE_STUDY, null, "http://purl.org/phylo/treebase/phylows/study/TB2:S__query__?format=nexus", true, "http://www.treebase.org", TREE_BASE_INST));
        clients.add(new BasicPhylogeniesWebserviceClient(TREE_BASE_NAME, "Read Tree from TreeBASE...", "Use TreeBASE to obtain a evolutionary tree", "Please enter a TreeBASE tree (\"Tr\") identifier (without the \"Tr\")\n(Examples: 2406, 422, 2654, 825, 4931, 2518, 4934)", WebservicesManager.WsPhylogenyFormat.TREEBASE_TREE, null, "http://purl.org/phylo/treebase/phylows/tree/TB2:Tr__query__?format=nexus", true, "http://www.treebase.org", TREE_BASE_INST));
        clients.add(new BasicPhylogeniesWebserviceClient(PFAM_NAME, "Read Domain Tree from Pfam...", "Use  Pfam to obtain gene trees for seed alignments", "Please enter a Pfam (PF) accession number\n(Examples: 01849 for NAC, 00452 for Bcl-2, 00046 for Homeobox)", WebservicesManager.WsPhylogenyFormat.PFAM, null, "http://pfam.xfam.org/family/PF__query__/tree/download", false, PFAM_SERVER, PFAM_INST));
        clients.add(new BasicPhylogeniesWebserviceClient(TREE_FAM_NAME, "Read Gene Tree from TreeFam...", "Use TreeFam to obtain a gene tree", "Please enter a TreeFam (TF) accession number\n(Examples: 101004 for Cyclin D, 315938 for Hox, 105310 for Wnt)", WebservicesManager.WsPhylogenyFormat.NHX, null, "http://www.treefam.org/family/TF__query__/tree/newick", true, "http://www.treefam.org", TREE_FAM_INST));
        clients.add(new BasicPhylogeniesWebserviceClient(TOL_NAME, "Read Tree from Tree of Life (ToL)...", "Use ToL webservice to obtain a evolutionary tree", "Please enter a Tree of Life node identifier\n(Examples: 14923 for ray-finned fishes, 19386 for Cephalopoda, 2461 for Cnidaria)", WebservicesManager.WsPhylogenyFormat.TOL_XML_RESPONSE, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME, TOL_WEBSERVER, true, "http://tolweb.org", null));
        return clients;
    }

    public static void processInstructions(PhylogeniesWebserviceClient client, Phylogeny phylogeny) throws PhyloXmlDataFormatException {
        if (client.getProcessingInstructions().equals(TREE_FAM_INST)) {
            WebserviceUtil.processTreeFamTrees(phylogeny);
        } else if (client.getProcessingInstructions().equals(PFAM_INST)) {
            WebserviceUtil.extractSpTremblAccFromNodeName(phylogeny, "sptrembl");
            PhylogenyMethods.transferInternalNodeNamesToConfidence(phylogeny, "bootstrap");
        } else if (client.getProcessingInstructions().equals(TREE_BASE_INST)) {
            if (PhylogenyMethods.isInternalNamesLookLikeConfidences(phylogeny)) {
                PhylogenyMethods.transferInternalNodeNamesToConfidence(phylogeny, "");
            }
            WebserviceUtil.processTreeBaseTrees(phylogeny);
        }
    }

    static void extractSpTremblAccFromNodeName(Phylogeny phy, String source) {
        PreorderTreeIterator it = new PreorderTreeIterator(phy);
        while (it.hasNext()) {
            String acc_str;
            String name;
            int i;
            PhylogenyNode n = it.next();
            if (ForesterUtil.isEmpty(n.getName()) || (i = (name = n.getName()).lastIndexOf("/")) <= 0 || ForesterUtil.isEmpty(acc_str = name.substring(0, i))) continue;
            Sequence seq = new Sequence();
            Accession acc = new Accession(acc_str, source);
            seq.setAccession(acc);
            n.getNodeData().setSequence(seq);
        }
    }

    static void processTreeBaseTrees(Phylogeny phy) {
        phy.setDescription(TREE_BASE_DESC);
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            Sequence s2;
            Accession acc;
            PhylogenyNode n = it.next();
            if (ForesterUtil.isEmpty(n.getName()) || (acc = SequenceAccessionTools.parseAccessorFromString(n.getName())) == null) continue;
            if (!n.getNodeData().isHasSequence()) {
                n.getNodeData().addSequence(new Sequence());
            }
            if ((s2 = n.getNodeData().getSequence()).getAccession() != null) continue;
            s2.setAccession(acc);
        }
    }

    static void processTreeFamTrees(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.isExternal()) {
                Accession acc;
                n.getNodeData().setEvent(null);
                if (!ForesterUtil.isEmpty(n.getName()) && (acc = SequenceAccessionTools.parseAccessorFromString(n.getName())) != null) {
                    Sequence s2;
                    if (!n.getNodeData().isHasSequence()) {
                        n.getNodeData().addSequence(new Sequence());
                    }
                    if ((s2 = n.getNodeData().getSequence()).getAccession() == null) {
                        s2.setAccession(acc);
                    }
                }
            } else {
                if (n.getBranchData() != null && n.getBranchData().isHasConfidences() && n.getBranchData().getConfidence(0) != null) {
                    n.getBranchData().getConfidence(0).setType("bootstrap");
                }
                if (!ForesterUtil.isEmpty(n.getName())) {
                    Taxonomy t;
                    if (!n.getNodeData().isHasTaxonomy()) {
                        n.getNodeData().addTaxonomy(new Taxonomy());
                    }
                    if (ForesterUtil.isEmpty((t = n.getNodeData().getTaxonomy()).getScientificName())) {
                        t.setScientificName(n.getName());
                        n.setName("");
                    }
                }
            }
            if (!n.getNodeData().isHasTaxonomy() || n.getNodeData().getTaxonomy().getIdentifier() == null) continue;
            n.getNodeData().getTaxonomy().setIdentifier(new Identifier(n.getNodeData().getTaxonomy().getIdentifier().getValue(), "ncbi"));
        }
    }
}

