/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import org.forester.development.AbstractRenderer;
import org.forester.development.ResidueRenderer;
import org.forester.msa.Msa;

public class MsaRenderer
extends JComponent {
    private static final long serialVersionUID = -68078011081748093L;
    private final int _rows;
    private final int _columns;
    private int _wellSize;
    private AbstractRenderer[][] _wells;
    private double _min;
    private double _max;
    private double _mean;
    private Color _minColor;
    private Color _maxColor;
    private Color _meanColor;
    private boolean _useMean;
    private final Msa _msa;
    private final JComponent _parent;

    public static boolean isMouseEventAltered(MouseEvent event) {
        return event.isShiftDown() || event.isAltDown() || event.isControlDown() || event.isAltGraphDown() || event.isMetaDown();
    }

    public MsaRenderer(Msa msa, int unit_size, JComponent parent) {
        this._parent = parent;
        this._msa = msa;
        this._rows = this._msa.getNumberOfSequences();
        this._columns = this._msa.getLength();
        this.setWellSize(unit_size);
        this.addMouseListeners();
        this.initializeWells();
    }

    private void addMouseListeners() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent event) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
            }

            @Override
            public void mousePressed(MouseEvent event) {
            }

            @Override
            public void mouseReleased(MouseEvent event) {
            }
        });
    }

    public AbstractRenderer getAbstractRenderer(int row, int col) {
        return this._wells[row][col];
    }

    public int getColumns() {
        return this._columns;
    }

    private double getMax() {
        return this._max;
    }

    private Color getMaxColor() {
        return this._maxColor;
    }

    private double getMean() {
        return this._mean;
    }

    private Color getMeanColor() {
        return this._meanColor;
    }

    private double getMin() {
        return this._min;
    }

    private Color getMinColor() {
        return this._minColor;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = (this.getWellSize() + 1) * (this.getColumns() + 1);
        int hight = (this.getWellSize() + 1) * (this.getRows() + 1) + 30;
        return new Dimension(width, hight);
    }

    public int getRows() {
        return this._rows;
    }

    private int getWellSize() {
        return this._wellSize;
    }

    private void initializeWells() {
        this._wells = new AbstractRenderer[this.getRows() + 1][this.getColumns() + 1];
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getColumns() + 1; ++col) {
                if (col == this.getColumns()) continue;
                ResidueRenderer residueRenderer = new ResidueRenderer(this.getMsa().getResidueAt(row, col), this);
            }
        }
        for (int col = 0; col < this.getColumns() + 1; ++col) {
            if (col != this.getColumns()) continue;
        }
    }

    private Msa getMsa() {
        return this._msa;
    }

    public void inverseMarkedOfWell(int well_row, int well_col) {
        ResidueRenderer rend = (ResidueRenderer)this.getAbstractRenderer(well_row, well_col);
        if (rend.isMarked()) {
            rend.setIsMarked(false);
        } else {
            rend.setIsMarked(true);
        }
    }

    private boolean isUseMean() {
        return this._useMean;
    }

    @Override
    public void paint(Graphics g2) {
        g2.setColor(Color.white);
        for (int row = 0; row < this.getRows() + 1; ++row) {
            for (int col = 0; col < this.getColumns() + 1; ++col) {
                this.getAbstractRenderer(row, col).paint(g2);
            }
        }
    }

    public void resetWellColors() {
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getColumns(); ++col) {
                ResidueRenderer r = (ResidueRenderer)this.getAbstractRenderer(row, col);
                if (this.isUseMean()) {
                    r.resetWellColor(this.getMin(), this.getMax(), this.getMean(), this.getMinColor(), this.getMaxColor(), this.getMeanColor());
                    continue;
                }
                r.resetWellColor(this.getMin(), this.getMax(), this.getMinColor(), this.getMaxColor());
            }
        }
    }

    public void resetWellSize(int well_size) {
        this.setWellSize(well_size);
        int factor = well_size + 0;
        for (int row = 0; row < this.getRows() + 1; ++row) {
            for (int col = 0; col < this.getColumns() + 1; ++col) {
                AbstractRenderer r = this.getAbstractRenderer(row, col);
                r.setX(10 + factor * col);
                r.setY(factor * row + 30);
                r.setWellSize(well_size);
            }
        }
    }

    private void setAbstractRenderer(AbstractRenderer ar, int row, int col) {
        this._wells[row][col] = ar;
    }

    public void setFlaggedStatusOfOutlierWells(boolean set_flagged_to_this) {
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getColumns(); ++col) {
                ResidueRenderer residueRenderer = (ResidueRenderer)this.getAbstractRenderer(row, col);
            }
        }
    }

    public void setFlaggedStatusOfSelectedWells(boolean set_flagged_to_this) {
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getColumns(); ++col) {
                ResidueRenderer wr = (ResidueRenderer)this.getAbstractRenderer(row, col);
                if (!wr.isSelected()) continue;
                wr.setIsSelected(false);
            }
        }
    }

    public void setIsFlaggingStatusChangedToFalse() {
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getColumns(); ++col) {
                ResidueRenderer residueRenderer = (ResidueRenderer)this.getAbstractRenderer(row, col);
            }
        }
    }

    private void setIsSelectedOfAll(boolean isSelected) {
        for (int col = 0; col < this.getColumns() + 1; ++col) {
            this.setIsSelectedOfColumn(col, isSelected);
        }
    }

    private void setIsSelectedOfColumn(int column, boolean isSelected) {
        for (int row = 0; row < this.getRows() + 1; ++row) {
            this.getAbstractRenderer(row, column).setIsSelected(isSelected);
        }
    }

    private void setIsSelectedOfRow(int row, boolean isSelected) {
        for (int col = 0; col < this.getColumns() + 1; ++col) {
            this.getAbstractRenderer(row, col).setIsSelected(isSelected);
        }
    }

    private void setIsSelectedOfRowAlternating(int row, boolean even) {
        boolean selected = even;
        for (int col = 0; col < this.getColumns(); ++col) {
            this.getAbstractRenderer(row, col).setIsSelected(selected);
            selected = !selected;
        }
    }

    private void setIsSelectedToQuarter(int quarter) {
        boolean evenRow = false;
        boolean evenColumn = false;
        if (quarter <= 1) {
            evenRow = true;
            evenColumn = true;
        } else if (quarter == 2) {
            evenColumn = true;
        } else if (quarter == 3) {
            evenRow = true;
        }
        for (int row = 0; row < this.getRows(); ++row) {
            if (evenColumn) {
                this.setIsSelectedOfRowAlternating(row, evenRow);
            } else {
                this.setIsSelectedOfRow(row, false);
            }
            evenColumn = !evenColumn;
        }
    }

    public void setMarkedOfAllWellsToFalse() {
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getColumns(); ++col) {
                ResidueRenderer residueRenderer = (ResidueRenderer)this.getAbstractRenderer(row, col);
            }
        }
    }

    public void setMax(double max) {
        this._max = max;
    }

    void setMaxColor(Color maxColor) {
        this._maxColor = maxColor;
    }

    void setMean(double mean) {
        this._mean = mean;
    }

    public void setMeanColor(Color meanColor) {
        this._meanColor = meanColor;
    }

    public void setMin(double min2) {
        this._min = min2;
    }

    void setMinColor(Color minColor) {
        this._minColor = minColor;
    }

    public void setUseMean(boolean useMean) {
        this._useMean = useMean;
    }

    private void setWellSize(int wellSize) {
        this._wellSize = wellSize;
    }

    public void unSelectUnMarkAll() {
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getColumns(); ++col) {
                ResidueRenderer wr = (ResidueRenderer)this.getAbstractRenderer(row, col);
                wr.setIsSelected(false);
                wr.setIsMarked(false);
            }
        }
    }
}

