/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.distance;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.ForesterUtil;

public final class NeighborJoiningF {
    private BasicSymmetricalDistanceMatrix _d;
    private float[][] _d_values;
    private final DecimalFormat _df;
    private PhylogenyNode[] _external_nodes;
    private int[] _mappings;
    private int _n;
    private float[] _r;
    private final boolean _verbose;
    private int _min_i;
    private int _min_j;

    private NeighborJoiningF() {
        this._verbose = false;
        this._df = null;
    }

    private NeighborJoiningF(boolean verbose, int maximum_fraction_digits_for_distances) {
        if (maximum_fraction_digits_for_distances < 1 || maximum_fraction_digits_for_distances > 9) {
            throw new IllegalArgumentException("maximum fraction digits for distances is out of range: " + maximum_fraction_digits_for_distances);
        }
        this._verbose = verbose;
        this._df = new DecimalFormat();
        this._df.setMaximumFractionDigits(maximum_fraction_digits_for_distances);
        this._df.setRoundingMode(RoundingMode.HALF_UP);
    }

    public final Phylogeny execute(BasicSymmetricalDistanceMatrix distance) {
        this.reset(distance);
        Phylogeny phylogeny = new Phylogeny();
        while (this._n > 2) {
            this.updateM();
            int otu1 = this._min_i;
            int otu2 = this._min_j;
            PhylogenyNode node = new PhylogenyNode();
            float d = this._d_values[this._mappings[otu1]][this._mappings[otu2]];
            float d1 = d / 2.0f + (this._r[otu1] - this._r[otu2]) / (float)(2 * (this._n - 2));
            float d2 = d - d1;
            if (this._df == null) {
                this.getExternalPhylogenyNode(otu1).setDistanceToParent(d1);
                this.getExternalPhylogenyNode(otu2).setDistanceToParent(d2);
            } else {
                this.getExternalPhylogenyNode(otu1).setDistanceToParent(Double.parseDouble(this._df.format(d1)));
                this.getExternalPhylogenyNode(otu2).setDistanceToParent(Double.parseDouble(this._df.format(d2)));
            }
            node.addAsChild(this.getExternalPhylogenyNode(otu1));
            node.addAsChild(this.getExternalPhylogenyNode(otu2));
            if (this._verbose) {
                this.printProgress(otu1, otu2);
            }
            this.calculateDistancesFromNewNode(otu1, otu2, d);
            this._external_nodes[this._mappings[otu1]] = node;
            this.updateMappings(otu2);
            --this._n;
        }
        double d = this._d_values[this._mappings[0]][this._mappings[1]] / 2.0f;
        if (this._df == null) {
            this.getExternalPhylogenyNode(0).setDistanceToParent(d);
            this.getExternalPhylogenyNode(1).setDistanceToParent(d);
        } else {
            double dd = Double.parseDouble(this._df.format(d));
            this.getExternalPhylogenyNode(0).setDistanceToParent(dd);
            this.getExternalPhylogenyNode(1).setDistanceToParent(dd);
        }
        PhylogenyNode root = new PhylogenyNode();
        root.addAsChild(this.getExternalPhylogenyNode(0));
        root.addAsChild(this.getExternalPhylogenyNode(1));
        if (this._verbose) {
            this.printProgress(0, 1);
        }
        phylogeny.setRoot(root);
        phylogeny.setRooted(false);
        return phylogeny;
    }

    public final List<Phylogeny> execute(List<BasicSymmetricalDistanceMatrix> distances_list) {
        ArrayList<Phylogeny> pl = new ArrayList<Phylogeny>();
        for (BasicSymmetricalDistanceMatrix distances : distances_list) {
            pl.add(this.execute(distances));
        }
        return pl;
    }

    private final void calculateDistancesFromNewNode(int otu1, int otu2, float d) {
        int m_otu1 = this._mappings[otu1];
        int m_otu2 = this._mappings[otu2];
        for (int i = 0; i < this._n; ++i) {
            if (i == otu1 || i == otu2) continue;
            int m_i = this._mappings[i];
            if (otu1 < i) {
                if (otu2 > i) {
                    this._d_values[m_otu1][m_i] = (this._d_values[m_otu1][m_i] + this._d_values[m_i][m_otu2] - d) / 2.0f;
                    continue;
                }
                this._d_values[m_otu1][m_i] = (this._d_values[m_otu1][m_i] + this._d_values[m_otu2][m_i] - d) / 2.0f;
                continue;
            }
            this._d_values[m_i][m_otu1] = otu2 > i ? (this._d_values[m_i][m_otu1] + this._d_values[m_i][m_otu2] - d) / 2.0f : (this._d_values[m_i][m_otu1] + this._d_values[m_otu2][m_i] - d) / 2.0f;
        }
    }

    private final void calculateNetDivergences() {
        for (int i = 0; i < this._n; ++i) {
            float d = 0.0f;
            int m_i = this._mappings[i];
            for (int n = 0; n < this._n; ++n) {
                if (i == n) continue;
                if (i > n) {
                    d += this._d_values[this._mappings[n]][m_i];
                    continue;
                }
                d += this._d_values[m_i][this._mappings[n]];
            }
            this._r[i] = d;
        }
    }

    private final PhylogenyNode getExternalPhylogenyNode(int i) {
        return this._external_nodes[this._mappings[i]];
    }

    private final void initExternalNodes() {
        this._external_nodes = new PhylogenyNode[this._n];
        for (int i = 0; i < this._n; ++i) {
            this._external_nodes[i] = new PhylogenyNode();
            String id = this._d.getIdentifier(i);
            if (id != null) {
                this._external_nodes[i].setName(id);
            } else {
                this._external_nodes[i].setName(Integer.toString(i));
            }
            this._mappings[i] = i;
        }
    }

    private final void printProgress(int otu1, int otu2) {
        System.out.println("Node " + this.printProgressNodeToString(this.getExternalPhylogenyNode(otu1)) + " joins " + this.printProgressNodeToString(this.getExternalPhylogenyNode(otu2)));
    }

    private final String printProgressNodeToString(PhylogenyNode n) {
        if (n.isExternal()) {
            if (ForesterUtil.isEmpty(n.getName())) {
                return Long.toString(n.getId());
            }
            return n.getName();
        }
        return n.getId() + " (" + (ForesterUtil.isEmpty(n.getChildNode1().getName()) ? Long.valueOf(n.getChildNode1().getId()) : n.getChildNode1().getName()) + "+" + (ForesterUtil.isEmpty(n.getChildNode2().getName()) ? Long.valueOf(n.getChildNode2().getId()) : n.getChildNode2().getName()) + ")";
    }

    private final void reset(BasicSymmetricalDistanceMatrix distances) {
        this._n = distances.getSize();
        this._d = distances;
        this._r = new float[this._n];
        this._mappings = new int[this._n];
        this._d_values = new float[distances.getSize()][distances.getSize()];
        for (int i = 0; i < distances.getSize(); ++i) {
            for (int j = 0; j < distances.getSize(); ++j) {
                this._d_values[i][j] = (float)distances.getValue(i, j);
            }
        }
        this.initExternalNodes();
    }

    private final void updateM() {
        this.calculateNetDivergences();
        int n_minus_2 = this._n - 2;
        float min2 = Float.MAX_VALUE;
        this._min_i = -1;
        this._min_j = -1;
        for (int j = 1; j < this._n; ++j) {
            float r_j = this._r[j];
            int m_j = this._mappings[j];
            for (int i = 0; i < j; ++i) {
                float m3 = this._d_values[this._mappings[i]][m_j] - (this._r[i] + r_j) / (float)n_minus_2;
                if (!(m3 < min2)) continue;
                min2 = m3;
                this._min_i = i;
                this._min_j = j;
            }
        }
    }

    private final void updateMappings(int otu2) {
        for (int i = otu2; i < this._mappings.length - 1; ++i) {
            this._mappings[i] = this._mappings[i + 1];
        }
    }

    public static final NeighborJoiningF createInstance() {
        return new NeighborJoiningF();
    }

    public static final NeighborJoiningF createInstance(boolean verbose, int maximum_fraction_digits_for_distances) {
        return new NeighborJoiningF(verbose, maximum_fraction_digits_for_distances);
    }
}

