/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.distance;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.forester.evoinference.distance.Sarray;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.ForesterUtil;

public final class NeighborJoiningR {
    private static final DecimalFormat DF = new DecimalFormat("0.00000");
    private BasicSymmetricalDistanceMatrix _d;
    private double[][] _d_values;
    private final DecimalFormat _df;
    private PhylogenyNode[] _external_nodes;
    private int[] _mappings;
    private int _n;
    private double[] _r;
    private final boolean _verbose;
    private int _min_i;
    private int _min_j;
    private Sarray _s;
    private double _d_min;
    private int[] _rev_mappings;
    private double _umax;
    private double _rmax;

    private NeighborJoiningR() {
        this._verbose = false;
        this._df = null;
    }

    private NeighborJoiningR(boolean verbose, int maximum_fraction_digits_for_distances) {
        if (maximum_fraction_digits_for_distances < 1 || maximum_fraction_digits_for_distances > 9) {
            throw new IllegalArgumentException("maximum fraction digits for distances is out of range: " + maximum_fraction_digits_for_distances);
        }
        this._verbose = verbose;
        this._df = new DecimalFormat();
        this._df.setMaximumFractionDigits(maximum_fraction_digits_for_distances);
        this._df.setRoundingMode(RoundingMode.HALF_UP);
    }

    public final Phylogeny execute(BasicSymmetricalDistanceMatrix distance) {
        this.reset(distance);
        Phylogeny phylogeny = new Phylogeny();
        while (this._n > 2) {
            if (this._verbose) {
                System.out.println("N=" + this._n);
                System.out.println();
            }
            this.updateM();
            int otu1 = this._min_i;
            int otu2 = this._min_j;
            PhylogenyNode node = new PhylogenyNode();
            double d = this._d_values[otu1][this._mappings[otu2]];
            double d1 = d / 2.0 + (this._r[this._rev_mappings[otu1]] - this._r[otu2]) / (double)(2 * (this._n - 2));
            double d2 = d - d1;
            if (this._df == null) {
                this._external_nodes[otu1].setDistanceToParent(d1);
                this.getExternalPhylogenyNode(otu2).setDistanceToParent(d2);
            } else {
                this._external_nodes[otu1].setDistanceToParent(Double.parseDouble(this._df.format(d1)));
                this.getExternalPhylogenyNode(otu2).setDistanceToParent(Double.parseDouble(this._df.format(d2)));
            }
            node.addAsChild(this._external_nodes[otu1]);
            node.addAsChild(this.getExternalPhylogenyNode(otu2));
            if (this._verbose) {
                this.printProgress(otu1, otu2, node);
            }
            if (this._verbose) {
                System.out.println("otu1=" + otu1);
                System.out.println("otu2=" + otu2);
            }
            this.calculateDistancesFromNewNode(otu1, otu2, d);
            this._external_nodes[otu1] = node;
            this.updateMappings(otu2);
            --this._n;
            if (!this._verbose) continue;
            System.out.println("");
            System.out.println("----------------------------------------------------------------------------------");
            System.out.println("");
        }
        double d = this.getDvalue(0, 1) / 2.0;
        if (this._df == null) {
            this.getExternalPhylogenyNode(0).setDistanceToParent(d);
            this.getExternalPhylogenyNode(1).setDistanceToParent(d);
        } else {
            double dd = Double.parseDouble(this._df.format(d));
            this.getExternalPhylogenyNode(0).setDistanceToParent(dd);
            this.getExternalPhylogenyNode(1).setDistanceToParent(dd);
        }
        PhylogenyNode root = new PhylogenyNode();
        root.addAsChild(this.getExternalPhylogenyNode(0));
        root.addAsChild(this.getExternalPhylogenyNode(1));
        if (this._verbose) {
            this.printProgress(0, 1, root);
        }
        phylogeny.setRoot(root);
        phylogeny.setRooted(false);
        return phylogeny;
    }

    public final List<Phylogeny> execute(List<BasicSymmetricalDistanceMatrix> distances_list) {
        ArrayList<Phylogeny> pl = new ArrayList<Phylogeny>();
        for (BasicSymmetricalDistanceMatrix distances : distances_list) {
            pl.add(this.execute(distances));
        }
        return pl;
    }

    private final void calculateDistancesFromNewNode(int otu1, int otu2, double d) {
        for (int j = 0; j < this._n; ++j) {
            if (j == otu2 || j == this._rev_mappings[otu1]) continue;
            this.updateDvalue(otu1, otu2, j, d);
        }
        if (this._verbose) {
            System.out.println();
        }
    }

    private final void updateDvalue(int otu1, int otu2, int j, double d) {
        int mj = this._mappings[j];
        if (otu1 < mj) {
            this._s.removePairing(this._d_values[otu1][mj], otu1, mj);
        } else {
            this._s.removePairing(this._d_values[mj][otu1], mj, otu1);
        }
        if (this._mappings[otu2] < mj) {
            this._s.removePairing(this.getDvalue(j, otu2), this._mappings[otu2], mj);
        } else {
            this._s.removePairing(this.getDvalue(j, otu2), mj, this._mappings[otu2]);
        }
        if (otu1 < mj) {
            double new_d = (this._d_values[otu1][mj] + this.getDvalue(j, otu2) - d) / 2.0;
            this._s.addPairing(new_d, otu1, mj);
            this._d_values[otu1][mj] = new_d;
        } else {
            double new_d = (this._d_values[mj][otu1] + this.getDvalue(j, otu2) - d) / 2.0;
            this._s.addPairing(new_d, mj, otu1);
            this._d_values[mj][otu1] = new_d;
        }
    }

    private double getDvalue(int i, int j) {
        if (i < j) {
            return this._d_values[this._mappings[i]][this._mappings[j]];
        }
        return this._d_values[this._mappings[j]][this._mappings[i]];
    }

    private final void calculateNetDivergences() {
        this._rmax = -1.7976931348623157E308;
        for (int i = 0; i < this._n; ++i) {
            this._r[i] = this.calculateNetDivergence(i);
            if (!(this._r[i] > this._rmax)) continue;
            this._rmax = this._r[i];
        }
    }

    private double calculateNetDivergence(int i) {
        float d = 0.0f;
        for (int n = 0; n < this._n; ++n) {
            if (i == n) continue;
            d = (float)((double)d + this.getDvalue(n, i));
        }
        return d;
    }

    private final PhylogenyNode getExternalPhylogenyNode(int i) {
        return this._external_nodes[this._mappings[i]];
    }

    private final void initExternalNodes() {
        this._external_nodes = new PhylogenyNode[this._n];
        for (int i = 0; i < this._n; ++i) {
            this._external_nodes[i] = new PhylogenyNode();
            String id = this._d.getIdentifier(i);
            if (id != null) {
                this._external_nodes[i].setName(id);
            } else {
                this._external_nodes[i].setName(Integer.toString(i));
            }
            this._mappings[i] = i;
            this._rev_mappings[i] = i;
        }
    }

    private final void printProgress(int otu1, int otu2, PhylogenyNode node) {
        System.out.println("Node " + this.printProgressNodeToString(this._external_nodes[otu1]) + " joins " + this.printProgressNodeToString(this.getExternalPhylogenyNode(otu2)) + " [resulting in node " + this.printProgressNodeToString(node) + "]");
    }

    private final String printProgressNodeToString(PhylogenyNode n) {
        if (n.isExternal()) {
            if (ForesterUtil.isEmpty(n.getName())) {
                return Long.toString(n.getId());
            }
            return n.getName();
        }
        return n.getId() + " (" + (ForesterUtil.isEmpty(n.getChildNode1().getName()) ? Long.valueOf(n.getChildNode1().getId()) : n.getChildNode1().getName()) + "+" + (ForesterUtil.isEmpty(n.getChildNode2().getName()) ? Long.valueOf(n.getChildNode2().getId()) : n.getChildNode2().getName()) + ")";
    }

    private final void reset(BasicSymmetricalDistanceMatrix distances) {
        this._n = distances.getSize();
        this._d = distances;
        this._r = new double[this._n];
        this._mappings = new int[this._n];
        this._rev_mappings = new int[this._n];
        this._d_values = distances.getValues();
        this._s = new Sarray();
        this._s.initialize(distances);
        this.initExternalNodes();
        if (this._verbose) {
            System.out.println();
            this.printM();
            System.out.println("----------------------------------------------------------------------------------");
            System.out.println();
            System.out.println();
        }
    }

    private final void printM() {
        int j;
        for (j = 0; j < this._d_values.length; ++j) {
            System.out.print(this._external_nodes[j]);
            System.out.print("\t\t");
            for (int i = 0; i < this._d_values[j].length; ++i) {
                System.out.print(DF.format(this._d_values[i][j]));
                System.out.print(" ");
            }
            System.out.println();
        }
        for (j = 0; j < this._n; ++j) {
            System.out.print(this.getExternalPhylogenyNode(j));
            System.out.print("\t\t");
            for (int i = 0; i < this._n; ++i) {
                System.out.print(DF.format(this._d_values[this._mappings[i]][this._mappings[j]]));
                System.out.print(" ");
            }
            System.out.print("\t\t");
            for (Map.Entry<Integer, int[]> entry : this._s.getSentrySet(this._mappings[j])) {
                System.out.print(DF.format((double)entry.getKey().intValue() / 1000000.0) + "=");
                boolean first = true;
                for (int v : entry.getValue()) {
                    if (!first) {
                        System.out.print(",");
                    }
                    first = false;
                    System.out.print(v);
                }
                System.out.print("  ");
            }
            System.out.println();
        }
    }

    private final void updateM() {
        int m_j;
        double r_j;
        int j;
        this.calculateNetDivergences();
        Double min_m = Double.MAX_VALUE;
        this._min_i = -1;
        this._min_j = -1;
        int n_minus_2 = this._n - 2;
        if (this._verbose) {
            this.printM();
        }
        for (j = 1; j < this._n; ++j) {
            r_j = this._r[j];
            m_j = this._mappings[j];
            Iterator<Map.Entry<Integer, int[]>> iterator = this._s.getSentrySet(m_j).iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry<Integer, int[]> entry = iterator.next();
            for (int sorted_i : entry.getValue()) {
                double m3 = this._d_values[sorted_i][m_j] - (this._r[this._rev_mappings[sorted_i]] + r_j) / (double)n_minus_2;
                if (!(m3 < min_m)) continue;
                min_m = m3;
                this._min_i = sorted_i;
                this._min_j = j;
            }
        }
        block2: for (j = 1; j < this._n; ++j) {
            r_j = this._r[j];
            m_j = this._mappings[j];
            boolean first = true;
            for (Map.Entry<Integer, int[]> entry : this._s.getSentrySet(m_j)) {
                if (first) {
                    first = false;
                    continue;
                }
                for (int sorted_i : entry.getValue()) {
                    double d = this._d_values[sorted_i][m_j];
                    if (d - (this._umax + r_j) / (double)n_minus_2 > min_m) continue block2;
                    double m4 = d - (this._r[this._rev_mappings[sorted_i]] + r_j) / (double)n_minus_2;
                    if (!(m4 < min_m)) continue;
                    min_m = m4;
                    this._min_i = sorted_i;
                    this._min_j = j;
                }
            }
            if (!this._verbose) continue;
            System.out.println();
            for (Map.Entry<Integer, int[]> entry : this._s.getSentrySet(m_j)) {
                for (int sorted_i : entry.getValue()) {
                    System.out.print(sorted_i);
                    System.out.print("->");
                    System.out.print(DF.format(this._r[sorted_i]));
                    System.out.print("  ");
                }
            }
            System.out.println();
        }
        if (this._verbose) {
            System.out.println();
        }
    }

    private final void updateMappings(int otu2) {
        int i;
        for (i = otu2; i < this._mappings.length - 1; ++i) {
            this._mappings[i] = this._mappings[i + 1];
        }
        for (i = 0; i < this._n; ++i) {
            this._rev_mappings[this._mappings[i]] = i;
        }
    }

    public static final NeighborJoiningR createInstance() {
        return new NeighborJoiningR();
    }

    public static final NeighborJoiningR createInstance(boolean verbose, int maximum_fraction_digits_for_distances) {
        return new NeighborJoiningR(verbose, maximum_fraction_digits_for_distances);
    }
}

