/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.distance;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;

public final class Sarray {
    public static final int FACTOR = 1000000;
    private static final boolean DEBUG = true;
    private final List<SortedMap<Integer, int[]>> _data = new ArrayList<SortedMap<Integer, int[]>>();

    public final void addPairing(double key, int value, int j) {
        Sarray.addPairing((int)(1000000.0 * key), value, this.getS(j));
    }

    public final void addPairing(int key, int value, int j) {
        Sarray.addPairing(key, value, this.getS(j));
    }

    public final SortedMap<Integer, int[]> getS(int j) {
        return this._data.get(j);
    }

    public final int[] getValues(int key, int j) {
        return (int[])this.getS(j).get(key);
    }

    public final void initialize(BasicSymmetricalDistanceMatrix d) {
        for (int j = 0; j < d.getSize(); ++j) {
            TreeMap<Integer, int[]> map = new TreeMap<Integer, int[]>();
            this._data.add(map);
            for (int i = 0; i < j; ++i) {
                Sarray.addPairing((int)(1000000.0 * d.getValues()[i][j]), i, map);
            }
        }
    }

    public final void initialize(int size) {
        for (int j = 0; j < size; ++j) {
            TreeMap map = new TreeMap();
            this._data.add(map);
        }
    }

    public final void removePairing(double key, int value, int j) {
        this.removePairing((int)(key * 1000000.0), value, j);
    }

    public final void removePairing(int key, int value, int j) {
        SortedMap<Integer, int[]> m3 = this._data.get(j);
        int[] x = (int[])m3.get(key);
        if (x == null) {
            System.out.println();
            System.out.println("________________________________________________________________________________________");
            System.out.println(this.toString());
            throw new IllegalArgumentException("key " + key + " (->" + value + ") does not exist for row " + j);
        }
        if (x.length == 1) {
            m3.remove(key);
        } else {
            int[] xnew = new int[x.length - 1];
            int xc = 0;
            int i = 0;
            while (++i < x.length) {
                int xv = x[i];
                if (xv != value) {
                    xnew[xc++] = xv;
                }
                ++i;
            }
            m3.put(key, xnew);
        }
    }

    public final int size() {
        return this._data.size();
    }

    public final Set<Integer>[] toArray(int j) {
        return this._data.get(j).values().toArray(new Set[this._data.get(j).size()]);
    }

    public final String toString() {
        DecimalFormat df = new DecimalFormat("0.000000");
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < this.size(); ++j) {
            sb.append(j);
            sb.append(": ");
            for (Map.Entry<Integer, int[]> entry : this.getSentrySet(j)) {
                double key = entry.getKey().intValue();
                int[] values = entry.getValue();
                sb.append(df.format(key / 1000000.0) + "->");
                boolean first = true;
                for (int v : values) {
                    if (!first) {
                        sb.append(",");
                    }
                    first = false;
                    sb.append(v);
                }
                sb.append("  ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    final Set<Map.Entry<Integer, int[]>> getSentrySet(int j) {
        return this.getS(j).entrySet();
    }

    private static final void addPairing(int key, int value, SortedMap<Integer, int[]> m3) {
        if (!m3.containsKey(key)) {
            int[] x = new int[]{value};
            m3.put(key, x);
        } else {
            int[] x = new int[((int[])m3.get(key)).length + 1];
            for (int i = 0; i < x.length - 1; ++i) {
                x[i] = ((int[])m3.get(key))[i];
            }
            x[x.length - 1] = value;
            m3.put(key, x);
        }
    }
}

