/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import org.forester.go.GoXRef;

public class BasicGoXRef
implements GoXRef {
    private final String _xref;
    private final GoXRef.Type _type;

    public BasicGoXRef(String s2) {
        String[] sa = s2.split(":");
        if (sa.length < 2) {
            throw new IllegalArgumentException("unexpected format for GO xref: " + s2);
        }
        String type = sa[0].trim();
        this._type = type.equals("EC") ? GoXRef.Type.EC : (type.equals("MetaCyc") ? GoXRef.Type.META_CYC : (type.equals("Reactome") ? GoXRef.Type.REACTOME : (type.equals("RESID") ? GoXRef.Type.RESID : (type.equals("UM-BBD_enzymeID") ? GoXRef.Type.UM_BBD_ENZYME_ID : (type.equals("UM-BBD_pathwayID") ? GoXRef.Type.UM_BBD_PATHWAY_ID : (type.equals("UM-BBD_reactionID") ? GoXRef.Type.UM_BBD_REACTIONID : (type.equals("TC") ? GoXRef.Type.TC : (type.equals("AraCyc") ? GoXRef.Type.ARACYC : (type.equals("XX") ? GoXRef.Type.XX : (type.equals("PMID") ? GoXRef.Type.PMID : (type.equals("IMG") ? GoXRef.Type.IMG : (type.equals("GOC") ? GoXRef.Type.GOC : (type.equals("KEGG") ? GoXRef.Type.KEGG : (type.equals("Wikipedia") ? GoXRef.Type.WIKIPEDIA : (type.equals("RHEA") ? GoXRef.Type.RHEA : (type.equals("NIF_Subcellular") ? GoXRef.Type.NIF_SUBCELLULAR : (type.equals("CORUM") ? GoXRef.Type.CORUM : (type.equals("UniPathway") ? GoXRef.Type.UNIPATHWAY : (type.equals("PO") ? GoXRef.Type.PO : (type.equals("SABIO-RK") ? GoXRef.Type.SABIO_RK : GoXRef.Type.OTHER))))))))))))))))))));
        this._xref = sa[1].trim();
    }

    public BasicGoXRef(GoXRef.Type type, String xref) {
        this._type = type;
        this._xref = xref;
    }

    @Override
    public int compareTo(GoXRef xref) {
        return this.getXRef().compareTo(xref.getXRef());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check go xref equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check go xref equality to " + o + " [" + o.getClass() + "]");
        }
        return this.getXRef().equals(((GoXRef)o).getXRef()) && this.getType().equals((Object)((GoXRef)o).getType());
    }

    @Override
    public GoXRef.Type getType() {
        return this._type;
    }

    @Override
    public String getXRef() {
        return this._xref;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.getType()) {
            case EC: {
                sb.append("EC");
                break;
            }
            case META_CYC: {
                sb.append("MetaCyc");
                break;
            }
            case REACTOME: {
                sb.append("Reactome");
                break;
            }
            case RESID: {
                sb.append("RESID");
                break;
            }
            case UM_BBD_ENZYME_ID: {
                sb.append("UM-BBD_enzymeID");
                break;
            }
            case UM_BBD_PATHWAY_ID: {
                sb.append("UM-BBD_pathwayID");
                break;
            }
            case UM_BBD_REACTIONID: {
                sb.append("UM-BBD_reactionID");
                break;
            }
            case TC: {
                sb.append("TC");
                break;
            }
            case ARACYC: {
                sb.append("AraCyc");
                break;
            }
            case XX: {
                sb.append("XX");
                break;
            }
            case GOC: {
                sb.append("GOC");
                break;
            }
            case IMG: {
                sb.append("IMG");
                break;
            }
            case PMID: {
                sb.append("PMID");
                break;
            }
            case WIKIPEDIA: {
                sb.append("Wikipedia");
                break;
            }
            case OTHER: {
                sb.append("other");
                break;
            }
            default: {
                new AssertionError((Object)("unknown type: " + (Object)((Object)this.getType())));
            }
        }
        sb.append(":");
        sb.append(this.getXRef());
        return sb.toString();
    }
}

