/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.go.GoId;
import org.forester.go.GoTerm;
import org.forester.util.ForesterUtil;

public final class GoUtils {
    private GoUtils() {
    }

    public static LinkedHashMap<GoId, Integer> countCategories(List<GoTerm> categories, List<GoTerm> experiment_set, Map<GoId, GoTerm> all_go_terms) {
        LinkedHashMap<GoId, Integer> counts = new LinkedHashMap<GoId, Integer>();
        for (GoTerm experiment_term : experiment_set) {
            SortedSet<GoTerm> super_terms = GoUtils.getAllSuperGoTerms(experiment_term.getGoId(), all_go_terms);
            super_terms.add(experiment_term);
            for (GoTerm cat : categories) {
                if (!counts.containsKey(cat.getGoId())) {
                    counts.put(cat.getGoId(), 0);
                }
                if (!super_terms.contains(cat)) continue;
                counts.put(cat.getGoId(), 1 + counts.get(cat.getGoId()));
            }
        }
        return counts;
    }

    public static LinkedHashMap<GoId, Integer> countCategoriesId(List<GoId> categories, List<GoId> experiment_set, Map<GoId, GoTerm> all_go_terms) {
        LinkedHashMap<GoId, Integer> counts = new LinkedHashMap<GoId, Integer>();
        for (GoId experiment_id : experiment_set) {
            HashSet<GoId> super_ids = new HashSet<GoId>();
            for (GoTerm term : GoUtils.getAllSuperGoTerms(experiment_id, all_go_terms)) {
                super_ids.add(term.getGoId());
            }
            super_ids.add(experiment_id);
            for (GoId cat : categories) {
                if (!counts.containsKey(cat)) {
                    counts.put(cat, 0);
                }
                if (!super_ids.contains(cat)) continue;
                counts.put(cat, 1 + counts.get(cat));
            }
        }
        return counts;
    }

    public static Map<GoId, GoTerm> createGoIdToGoTermMap(List<GoTerm> go_terms) {
        HashMap<GoId, GoTerm> go_id_to_term_map = new HashMap<GoId, GoTerm>();
        for (GoTerm go_term : go_terms) {
            go_id_to_term_map.put(go_term.getGoId(), go_term);
            for (GoId alt_id : go_term.getAltIds()) {
                go_id_to_term_map.put(alt_id, go_term);
            }
        }
        return go_id_to_term_map;
    }

    public static SortedSet<GoId> getAllSuperGoIds(GoId go_id, Map<GoId, GoTerm> goid_to_term_map) {
        TreeSet<GoId> ids = new TreeSet<GoId>();
        SortedSet<GoTerm> terms = GoUtils.getAllSuperGoTerms(go_id, goid_to_term_map);
        for (GoTerm term : terms) {
            ids.add(term.getGoId());
        }
        return ids;
    }

    public static SortedSet<GoTerm> getAllSuperGoTerms(GoId go_id, List<GoTerm> go_terms) {
        Map<GoId, GoTerm> goid_to_term_map = GoUtils.createGoIdToGoTermMap(go_terms);
        return GoUtils.getAllSuperGoTerms(go_id, goid_to_term_map);
    }

    public static SortedSet<GoTerm> getAllSuperGoTerms(GoId go_id, Map<GoId, GoTerm> goid_to_term_map) {
        if (!goid_to_term_map.containsKey(go_id)) {
            throw new IllegalArgumentException("GO id [" + go_id + "] not found in GO id to term map");
        }
        GoTerm go_term = goid_to_term_map.get(go_id);
        return GoUtils.getAllSuperGoTerms(go_term, goid_to_term_map);
    }

    public static SortedSet<GoTerm> getAllSuperGoTerms(GoTerm go_term, Map<GoId, GoTerm> goid_to_term_map) {
        TreeSet<GoTerm> supers = new TreeSet<GoTerm>();
        GoUtils.getAllSuperGoTerms(go_term, goid_to_term_map, supers);
        return supers;
    }

    private static void getAllSuperGoTerms(GoTerm go_term, Map<GoId, GoTerm> goid_to_term_map, Set<GoTerm> supers) {
        if (go_term.getSuperGoIds() != null && go_term.getSuperGoIds().size() > 0) {
            for (GoId super_go_id : go_term.getSuperGoIds()) {
                if (!goid_to_term_map.containsKey(super_go_id)) {
                    throw new IllegalArgumentException("GO id [" + super_go_id + "] not found in GO id to term map");
                }
                GoTerm super_go_term = goid_to_term_map.get(super_go_id);
                supers.add(super_go_term);
                GoUtils.getAllSuperGoTerms(super_go_term, goid_to_term_map, supers);
            }
        }
    }

    public static GoTerm getPenultimateGoTerm(GoTerm go_term, Map<GoId, GoTerm> map) {
        GoTerm my_go_term;
        GoTerm penultimate = my_go_term = go_term;
        while (my_go_term.getSuperGoIds() != null && my_go_term.getSuperGoIds().size() > 0) {
            penultimate = my_go_term;
            if (!map.containsKey(my_go_term.getSuperGoIds().get(0))) {
                throw new IllegalArgumentException("GO-id [" + my_go_term.getSuperGoIds().get(0) + "] not found in map");
            }
            my_go_term = map.get(my_go_term.getSuperGoIds().get(0));
        }
        return penultimate;
    }

    public static GoTerm getUltimateGoTerm(GoTerm go_term, Map<GoId, GoTerm> map) {
        GoTerm my_go_term = go_term;
        while (my_go_term.getSuperGoIds() != null && my_go_term.getSuperGoIds().size() > 0) {
            if (!map.containsKey(my_go_term.getSuperGoIds().get(0))) {
                throw new IllegalArgumentException("GO-id [" + my_go_term.getSuperGoIds().get(0) + "] not found in map");
            }
            my_go_term = map.get(my_go_term.getSuperGoIds().get(0));
        }
        return my_go_term;
    }

    public static SortedMap<String, List<GoId>> parseGoIds(Object source, String start_of_comment_line, String start_of_label_line) throws IOException {
        Pattern label_matcher = Pattern.compile(start_of_label_line + "\\s*(.+?)");
        BufferedReader reader = ForesterUtil.obtainReader(source);
        TreeMap<String, List<GoId>> results = new TreeMap<String, List<GoId>>();
        String line = "";
        String label = "";
        boolean use_label = !ForesterUtil.isEmpty(start_of_label_line);
        boolean use_comment = !ForesterUtil.isEmpty(start_of_comment_line);
        ArrayList<GoId> current_list = new ArrayList<GoId>();
        while ((line = reader.readLine()) != null) {
            if (ForesterUtil.isEmpty(line = line.trim()) || use_comment && line.startsWith(start_of_comment_line)) continue;
            if (use_label && line.startsWith(start_of_label_line)) {
                Matcher matcher = label_matcher.matcher(line);
                if (!matcher.matches()) continue;
                if (!ForesterUtil.isEmpty(label)) {
                    results.put(label, current_list);
                    current_list = new ArrayList();
                }
                label = matcher.group(1);
                continue;
            }
            String[] s2 = line.split("\\s+");
            GoId id = new GoId(s2[0]);
            current_list.add(id);
        }
        if (ForesterUtil.isEmpty(label)) {
            label = "";
        }
        results.put(label, current_list);
        reader.close();
        return results;
    }
}

