/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.go.GoId;
import org.forester.go.PfamToGoMapping;
import org.forester.util.ForesterUtil;

public class PfamToGoParser {
    private static final String PFAM_TO_GO_FORMAT = "Pfam:\\S+\\s+(\\S+)\\s*>\\s*GO:.+;\\s*(\\S+)";
    private static final Pattern PFAM_TO_GO_PATTERN = Pattern.compile("Pfam:\\S+\\s+(\\S+)\\s*>\\s*GO:.+;\\s*(\\S+)");
    private static final String PFAMACC_TO_GO_FORMAT = "Pfam:(\\S+)\\s+\\S+\\s*>\\s*GO:.+;\\s*(\\S+)";
    private static final Pattern PFAMACC_TO_GO_PATTERN = Pattern.compile("Pfam:(\\S+)\\s+\\S+\\s*>\\s*GO:.+;\\s*(\\S+)");
    private final File _input_file;
    private int _mapping_count;
    private boolean _use_acc;

    public PfamToGoParser(File input_file) {
        this._input_file = input_file;
        this.init();
    }

    private File getInputFile() {
        return this._input_file;
    }

    public int getMappingCount() {
        return this._mapping_count;
    }

    private void init() {
        this.setMappingCount(0);
        this.setUseAccessors(false);
    }

    public boolean isUseAccessors() {
        return this._use_acc;
    }

    public List<PfamToGoMapping> parse() throws IOException {
        String error = ForesterUtil.isReadableFile(this.getInputFile());
        if (!ForesterUtil.isEmpty(error)) {
            throw new IOException(error);
        }
        BufferedReader br = new BufferedReader(new FileReader(this.getInputFile()));
        ArrayList<PfamToGoMapping> mappings = new ArrayList<PfamToGoMapping>();
        int line_number = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ++line_number;
                if ((line = line.trim()).length() <= 0 || line.startsWith("!")) continue;
                Matcher m3 = null;
                m3 = this.isUseAccessors() ? PFAMACC_TO_GO_PATTERN.matcher(line) : PFAM_TO_GO_PATTERN.matcher(line);
                if (!m3.matches()) {
                    throw new IOException("unexpected format [\"" + line + "\"]");
                }
                if (m3.groupCount() != 2) {
                    throw new IOException("unexpected format [\"" + line + "\"]");
                }
                String pfam = m3.group(1);
                String go = m3.group(2);
                if (ForesterUtil.isEmpty(pfam) || ForesterUtil.isEmpty(go)) {
                    throw new IOException("unexpected format [\"" + line + "\"]");
                }
                PfamToGoMapping map = new PfamToGoMapping(pfam, new GoId(go));
                ++this._mapping_count;
                mappings.add(map);
            }
        }
        catch (Exception e) {
            throw new IOException("parsing problem: " + e.getMessage() + " [at line " + line_number + "]");
        }
        return mappings;
    }

    private void setMappingCount(int mapping_count) {
        this._mapping_count = mapping_count;
    }

    public void setUseAccessors(boolean use_ids) {
        this._use_acc = use_ids;
    }
}

