/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.forester.go.BasicGoRelationship;
import org.forester.go.BasicGoSubset;
import org.forester.go.BasicGoTerm;
import org.forester.go.BasicGoXRef;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoRelationship;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.GoXRef;
import org.forester.go.OBOparser;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.util.ForesterUtil;

public class TestGo {
    private static final double ZERO_DIFF = 1.0E-9;

    public static boolean isEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-9;
    }

    public static boolean test(File test_dir) {
        System.out.print("  GO ID: ");
        if (!TestGo.testGoId()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Namespace: ");
        if (!TestGo.testNamespace()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic GO term: ");
        if (!TestGo.testBasicGoTerm()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  OBO parser: ");
        if (!TestGo.testOBOparser(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Pfam to GO mapping: ");
        if (!TestGo.testPfamToGoMapping()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Pfam to GO parser: ");
        if (!TestGo.testPfamToGoParser(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Super terms: ");
        if (!TestGo.testSuperTermGetting(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Super term counting: ");
        if (!TestGo.testSuperTermCounting(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        return true;
    }

    private static boolean testBasicGoTerm() {
        try {
            BasicGoTerm gt1 = new BasicGoTerm("GO:0047579", "4-hydroxymandelate oxidase activity", "molecular_function", false);
            BasicGoTerm gt2 = new BasicGoTerm("GO:0047579", "4-hydroxymandelate oxidase activity", "molecular_function", false);
            BasicGoTerm gt3 = new BasicGoTerm("GO:0047579", "?", "molecular_function", true);
            BasicGoTerm gt4 = new BasicGoTerm("GO:0047579", "4-hydroxymandelate oxidase activity", "biological_process", false);
            BasicGoTerm gt5 = new BasicGoTerm("GO:0047578", "4-hydroxymandelate oxidase activity", "molecular_function", false);
            if (!((Object)gt1).equals(gt2)) {
                return false;
            }
            if (!((Object)gt1).equals(gt3)) {
                return false;
            }
            if (((Object)gt1).equals(gt4)) {
                return false;
            }
            if (((Object)gt1).hashCode() != ((Object)gt4).hashCode()) {
                return false;
            }
            if (((Object)gt1).equals(gt5)) {
                return false;
            }
            GoTerm gt6 = (GoTerm)gt5.copy();
            if (!gt6.equals(gt5)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testGoId() {
        try {
            GoId id1 = new GoId("GO:0042617");
            GoId id2 = new GoId("GO:0042630");
            GoId id3 = new GoId("GO:0042630");
            if (id1.equals(id2)) {
                return false;
            }
            if (!id2.equals(id3)) {
                return false;
            }
            if (!id1.toString().equals("GO:0042617")) {
                return false;
            }
            if (id2.hashCode() != id3.hashCode()) {
                return false;
            }
            if (id1.hashCode() == id2.hashCode()) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testNamespace() {
        try {
            GoNameSpace b = new GoNameSpace("Biological_process");
            GoNameSpace c = new GoNameSpace("Cellular_Component");
            GoNameSpace m3 = new GoNameSpace("molecular_function");
            GoNameSpace m22 = new GoNameSpace(GoNameSpace.GoNamespaceType.MOLECULAR_FUNCTION);
            if (b.equals(c)) {
                return false;
            }
            if (!m3.equals(m22)) {
                return false;
            }
            if (!b.toString().equals("biological_process")) {
                return false;
            }
            if (!c.toString().equals("cellular_component")) {
                return false;
            }
            if (!m3.toString().equals("molecular_function")) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testOBOparser(File test_dir) {
        try {
            OBOparser parser = new OBOparser(new File(test_dir + ForesterUtil.getFileSeparator() + "obo_test"), OBOparser.ReturnType.BASIC_GO_TERM);
            List<GoTerm> go_terms = parser.parse();
            if (parser.getGoTermCount() != 26) {
                return false;
            }
            GoTerm g0 = go_terms.get(0);
            GoTerm g1 = go_terms.get(1);
            GoTerm g3 = go_terms.get(2);
            GoTerm g2 = go_terms.get(25);
            if (!g0.getComment().equals("")) {
                return false;
            }
            if (!g0.getDefinition().equals("\"The distribution of mitochondria, including the mitochondrial genome, into daughter cells after mitosis or meiosis, mediated by interactions between mitochondria and the cytoskeleton.\" [GOC:mcc, PMID:10873824, PMID:11389764]")) {
                return false;
            }
            if (!g0.getGoId().getId().equals("GO:0000001")) {
                return false;
            }
            if (g0.getGoNameSpace().equals((Object)GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS)) {
                return false;
            }
            if (g0.getGoNameSpace().getType() != GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS) {
                return false;
            }
            if (g0.getGoRelationships().size() != 0) {
                return false;
            }
            if (g0.getGoXRefs().size() != 0) {
                return false;
            }
            if (!g0.getName().equals("mitochondrion inheritance")) {
                return false;
            }
            if (g0.getSuperGoIds().size() != 2) {
                return false;
            }
            if (!g0.isObsolete()) {
                return false;
            }
            if (!g1.getComment().equals("comment")) {
                return false;
            }
            if (!g1.getDefinition().equals("\"The maintenance of the structure and integrity of the mitochondrial genome.\" [GOC:ai]")) {
                return false;
            }
            if (!g1.getGoId().getId().equals("GO:0000002")) {
                return false;
            }
            if (g1.getGoNameSpace().equals((Object)GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS)) {
                return false;
            }
            if (g1.getGoNameSpace().getType() != GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS) {
                return false;
            }
            if (g1.getGoRelationships().size() != 1) {
                return false;
            }
            if (g1.getGoXRefs().size() != 5) {
                return false;
            }
            if (!g1.getName().equals("mitochondrial genome maintenance")) {
                return false;
            }
            if (g1.getSuperGoIds().size() != 1) {
                return false;
            }
            if (g1.isObsolete()) {
                return false;
            }
            if (!g1.getGoXRefs().get(0).equals(new BasicGoXRef("EC:2.4.1.-"))) {
                return false;
            }
            if (!g1.getGoXRefs().get(0).getXRef().equals("2.4.1.-")) {
                return false;
            }
            if (g1.getGoXRefs().get(0).getType() != GoXRef.Type.EC) {
                return false;
            }
            if (g1.getGoXRefs().get(0).equals(new BasicGoXRef("EC:2.4.1.1"))) {
                return false;
            }
            if (g1.getGoXRefs().get(0).equals(new BasicGoXRef("Reactome:2.4.1.-"))) {
                return false;
            }
            if (!g1.getGoXRefs().get(1).equals(new BasicGoXRef("Reactome:7672"))) {
                return false;
            }
            if (!g1.getGoXRefs().get(2).equals(new BasicGoXRef("MetaCyc:SIROHEME-FERROCHELAT-RXN"))) {
                return false;
            }
            if (!g1.getGoXRefs().get(3).equals(new BasicGoXRef("RESID:AA02376"))) {
                return false;
            }
            if (!g1.getGoXRefs().get(4).equals(new BasicGoXRef("UM-BBD_enzymeID:e0271"))) {
                return false;
            }
            if (!g1.getGoRelationships().get(0).equals(new BasicGoRelationship("part_of GO:0007052"))) {
                return false;
            }
            if (!g1.getGoRelationships().get(0).getGoId().equals(new GoId("GO:0007052"))) {
                return false;
            }
            if (!g1.getGoRelationships().get(0).getGoId().getId().equals("GO:0007052")) {
                return false;
            }
            if (g1.getGoRelationships().get(0).getType() != GoRelationship.Type.PART_OF) {
                return false;
            }
            if (g1.getGoRelationships().get(0).equals(new BasicGoRelationship("part_of GO:1007052"))) {
                return false;
            }
            if (!g1.getSuperGoIds().get(0).equals(new GoId("GO:0007005"))) {
                return false;
            }
            if (g1.getSuperGoIds().get(0).equals(new GoId("GO:1007005"))) {
                return false;
            }
            if (!g2.getGoId().getId().equals("GO:0000030")) {
                return false;
            }
            if (!g2.getGoId().equals(new GoId("GO:0000030"))) {
                return false;
            }
            if (g2.getGoId().getId().equals("GO:0000031")) {
                return false;
            }
            if (g2.getGoId().equals(new GoId("GO:0000031"))) {
                return false;
            }
            if (g3.getGoSubsets().size() != 3) {
                return false;
            }
            if (!g3.getGoSubsets().contains(new BasicGoSubset("goslim_generic"))) {
                return false;
            }
            if (!g3.getGoSubsets().contains(new BasicGoSubset("goslim_plant"))) {
                return false;
            }
            if (!g3.getGoSubsets().contains(new BasicGoSubset("gosubset_prok"))) {
                return false;
            }
            if (g3.getGoSubsets().contains(new BasicGoSubset("goslim_candida"))) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testPfamToGoMapping() {
        try {
            PfamToGoMapping pg0 = new PfamToGoMapping("A", new GoId("GO:0000001"));
            PfamToGoMapping pg1 = new PfamToGoMapping("A", new GoId("GO:0000001"));
            PfamToGoMapping pg2 = new PfamToGoMapping("B", new GoId("GO:0000001"));
            PfamToGoMapping pg3 = new PfamToGoMapping("A", new GoId("GO:0000002"));
            PfamToGoMapping pg4 = new PfamToGoMapping("B", new GoId("GO:0000002"));
            if (!pg0.equals(pg0)) {
                return false;
            }
            if (!pg0.equals(pg1)) {
                return false;
            }
            if (pg0.equals(pg2)) {
                return false;
            }
            if (pg0.equals(pg3)) {
                return false;
            }
            if (pg0.equals(pg4)) {
                return false;
            }
            if (pg0.compareTo(pg3) != 0) {
                return false;
            }
            if (pg0.compareTo(pg2) >= 0) {
                return false;
            }
            if (pg2.compareTo(pg0) <= 0) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testPfamToGoParser(File test_dir) {
        try {
            PfamToGoParser parser = new PfamToGoParser(new File(test_dir + ForesterUtil.getFileSeparator() + "pfam_to_go_test"));
            List<PfamToGoMapping> mappings = parser.parse();
            if (parser.getMappingCount() != 426) {
                return false;
            }
            if (mappings.size() != 426) {
                return false;
            }
            PfamToGoMapping m0 = mappings.get(0);
            PfamToGoMapping m1 = mappings.get(1);
            PfamToGoMapping m22 = mappings.get(2);
            PfamToGoMapping m3 = mappings.get(3);
            PfamToGoMapping m4 = mappings.get(4);
            PfamToGoMapping m5 = mappings.get(5);
            PfamToGoMapping m424 = mappings.get(424);
            PfamToGoMapping m425 = mappings.get(425);
            if (!m0.getKey().equals("7tm_1")) {
                return false;
            }
            if (!m0.getValue().equals(new GoId("GO:0001584"))) {
                return false;
            }
            if (m0.getKey().equals("7tm_x")) {
                return false;
            }
            if (m0.getValue().equals(new GoId("GO:0001585"))) {
                return false;
            }
            if (!m1.getKey().equals("7tm_1")) {
                return false;
            }
            if (!m1.getValue().equals(new GoId("GO:0007186"))) {
                return false;
            }
            if (!m22.getKey().equals("7tm_1")) {
                return false;
            }
            if (!m22.getValue().equals(new GoId("GO:0016021"))) {
                return false;
            }
            if (!m3.getKey().equals("7tm_2")) {
                return false;
            }
            if (!m3.getValue().equals(new GoId("GO:0004930"))) {
                return false;
            }
            if (!m4.getKey().equals("7tm_2")) {
                return false;
            }
            if (!m4.getValue().equals(new GoId("GO:0016020"))) {
                return false;
            }
            if (!m5.getKey().equals("7tm_3")) {
                return false;
            }
            if (!m5.getValue().equals(new GoId("GO:0008067"))) {
                return false;
            }
            if (!m424.getKey().equals("OMPdecase")) {
                return false;
            }
            if (!m424.getValue().equals(new GoId("GO:0006207"))) {
                return false;
            }
            if (!m425.getKey().equals("Bac_DNA_binding")) {
                return false;
            }
            if (!m425.getValue().equals(new GoId("GO:0003677"))) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testSuperTermCounting(File test_dir) {
        try {
            OBOparser parser = new OBOparser(new File(test_dir + ForesterUtil.getFileSeparator() + "gene_ontology_edit.obo"), OBOparser.ReturnType.BASIC_GO_TERM);
            List<GoTerm> all_go_terms = parser.parse();
            if (parser.getGoTermCount() != 27748) {
                return false;
            }
            Map<GoId, GoTerm> goid_to_term_map = GoUtils.createGoIdToGoTermMap(all_go_terms);
            ArrayList<GoTerm> categories = new ArrayList<GoTerm>();
            ArrayList<GoTerm> experiment_set = new ArrayList<GoTerm>();
            experiment_set.add(new BasicGoTerm(new GoId("GO:0005690"), "snRNP U4atac", GoNameSpace.createUnassigned(), false));
            experiment_set.add(new BasicGoTerm(new GoId("GO:0009698"), "phenylpropanoid metabolic process", GoNameSpace.createUnassigned(), false));
            experiment_set.add(new BasicGoTerm(new GoId("GO:0008150"), "biological_process", GoNameSpace.createUnassigned(), false));
            experiment_set.add(new BasicGoTerm(new GoId("GO:0006915"), "apoptosis", GoNameSpace.createUnassigned(), false));
            experiment_set.add(new BasicGoTerm(new GoId("GO:0001783"), "B cell apoptosis", GoNameSpace.createUnassigned(), false));
            experiment_set.add(new BasicGoTerm(new GoId("GO:0010657"), "muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
            experiment_set.add(new BasicGoTerm(new GoId("GO:0010657"), "muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
            experiment_set.add(new BasicGoTerm(new GoId("GO:0010658"), "striated muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
            experiment_set.add(new BasicGoTerm(new GoId("GO:0043065"), "positive regulation of apoptosis", GoNameSpace.createUnassigned(), false));
            categories.add(new BasicGoTerm(new GoId("GO:0016265"), "death", GoNameSpace.createUnassigned(), false));
            categories.add(new BasicGoTerm(new GoId("GO:0006915"), "apoptosis", GoNameSpace.createUnassigned(), false));
            categories.add(new BasicGoTerm(new GoId("GO:0008150"), "biological_process", GoNameSpace.createUnassigned(), false));
            categories.add(new BasicGoTerm(new GoId("GO:0010657"), "muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
            categories.add(new BasicGoTerm(new GoId("GO:0010658"), "striated muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
            categories.add(new BasicGoTerm(new GoId("GO:0046242"), "o-xylene biosynthetic process", GoNameSpace.createUnassigned(), false));
            categories.add(new BasicGoTerm(new GoId("GO:0016326"), "kinesin motor activity", GoNameSpace.createUnassigned(), false));
            categories.add(new BasicGoTerm(new GoId("GO:0005575"), "cellular_component", GoNameSpace.createUnassigned(), false));
            categories.add(new BasicGoTerm(new GoId("GO:0032502"), "developmental process", GoNameSpace.createUnassigned(), false));
            categories.add(new BasicGoTerm(new GoId("GO:0051094"), "positive regulation of developmental process", GoNameSpace.createUnassigned(), false));
            categories.add(new BasicGoTerm(new GoId("GO:0048522"), "positive regulation of cellular process", GoNameSpace.createUnassigned(), false));
            LinkedHashMap<GoId, Integer> counts = GoUtils.countCategories(categories, experiment_set, goid_to_term_map);
            if ((Integer)counts.get(new GoId("GO:0016265")) != 5) {
                return false;
            }
            if ((Integer)counts.get(new GoId("GO:0006915")) != 5) {
                return false;
            }
            if ((Integer)counts.get(new GoId("GO:0008150")) != 8) {
                return false;
            }
            if ((Integer)counts.get(new GoId("GO:0010657")) != 3) {
                return false;
            }
            if ((Integer)counts.get(new GoId("GO:0010658")) != 1) {
                return false;
            }
            if ((Integer)counts.get(new GoId("GO:0046242")) != 0) {
                return false;
            }
            if ((Integer)counts.get(new GoId("GO:0016326")) != 0) {
                return false;
            }
            if ((Integer)counts.get(new GoId("GO:0005575")) != 1) {
                return false;
            }
            if ((Integer)counts.get(new GoId("GO:0032502")) != 5) {
                return false;
            }
            if ((Integer)counts.get(new GoId("GO:0051094")) != 1) {
                return false;
            }
            if ((Integer)counts.get(new GoId("GO:0048522")) != 1) {
                return false;
            }
            ArrayList<GoId> categories_id = new ArrayList<GoId>();
            ArrayList<GoId> experiment_set_id = new ArrayList<GoId>();
            experiment_set_id.add(new GoId("GO:0005690"));
            experiment_set_id.add(new GoId("GO:0009698"));
            experiment_set_id.add(new GoId("GO:0008150"));
            experiment_set_id.add(new GoId("GO:0006915"));
            experiment_set_id.add(new GoId("GO:0001783"));
            experiment_set_id.add(new GoId("GO:0010657"));
            experiment_set_id.add(new GoId("GO:0010657"));
            experiment_set_id.add(new GoId("GO:0010658"));
            categories_id.add(new GoId("GO:0016265"));
            categories_id.add(new GoId("GO:0006915"));
            categories_id.add(new GoId("GO:0008150"));
            categories_id.add(new GoId("GO:0010657"));
            categories_id.add(new GoId("GO:0010658"));
            categories_id.add(new GoId("GO:0046242"));
            categories_id.add(new GoId("GO:0016326"));
            categories_id.add(new GoId("GO:0005575"));
            LinkedHashMap<GoId, Integer> counts_id = GoUtils.countCategoriesId(categories_id, experiment_set_id, goid_to_term_map);
            if ((Integer)counts_id.get(new GoId("GO:0016265")) != 5) {
                return false;
            }
            if ((Integer)counts_id.get(new GoId("GO:0006915")) != 5) {
                return false;
            }
            if ((Integer)counts_id.get(new GoId("GO:0008150")) != 7) {
                return false;
            }
            if ((Integer)counts_id.get(new GoId("GO:0010657")) != 3) {
                return false;
            }
            if ((Integer)counts_id.get(new GoId("GO:0010658")) != 1) {
                return false;
            }
            if ((Integer)counts_id.get(new GoId("GO:0046242")) != 0) {
                return false;
            }
            if ((Integer)counts_id.get(new GoId("GO:0016326")) != 0) {
                return false;
            }
            if ((Integer)counts_id.get(new GoId("GO:0005575")) != 1) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testSuperTermGetting(File test_dir) {
        try {
            OBOparser parser = new OBOparser(new File(test_dir + ForesterUtil.getFileSeparator() + "gene_ontology_edit.obo"), OBOparser.ReturnType.BASIC_GO_TERM);
            List<GoTerm> go_terms = parser.parse();
            if (parser.getGoTermCount() != 27748) {
                return false;
            }
            Map<GoId, GoTerm> goid_to_term_map = GoUtils.createGoIdToGoTermMap(go_terms);
            SortedSet<GoTerm> b_cell_selection = GoUtils.getAllSuperGoTerms(new GoId("GO:0002339"), goid_to_term_map);
            if (b_cell_selection.size() != 2) {
                return false;
            }
            if (!b_cell_selection.contains(new BasicGoTerm(new GoId("GO:0002376"), "immune system process", GoNameSpace.createBiologicalProcess(), false))) {
                return false;
            }
            if (!b_cell_selection.contains(new BasicGoTerm(new GoId("GO:0008150"), "biological process", GoNameSpace.createBiologicalProcess(), false))) {
                return false;
            }
            SortedSet<GoTerm> b_cell_differentation = GoUtils.getAllSuperGoTerms(new GoId("GO:0030183"), goid_to_term_map);
            if (b_cell_differentation.size() != 12) {
                return false;
            }
            SortedSet<GoTerm> biological_process = GoUtils.getAllSuperGoTerms(new GoId("GO:0008150"), goid_to_term_map);
            if (biological_process.size() != 0) {
                return false;
            }
            SortedSet<GoTerm> protein_aa_phosphorylation = GoUtils.getAllSuperGoTerms(new GoId("GO:0006468"), goid_to_term_map);
            if (protein_aa_phosphorylation.size() != 16) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }
}

