/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nexus;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.forester.evoinference.matrix.character.BasicCharacterStateMatrix;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.io.parsers.nexus.NexusFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.parsers.util.PhylogenyParserException;

public class PaupLogParser {
    private static final String DATA_MATRIX_AND_RECONSTRUCTED_STATES_FOR_INTERNAL_NODES = "data matrix and reconstructed states for internal nodes";
    private Object _nexus_source;

    private Object getNexusSource() {
        return this._nexus_source;
    }

    public CharacterStateMatrix<CharacterStateMatrix.BinaryStates> parse() throws IOException {
        String line;
        BufferedReader reader = ParserUtils.createReader(this.getNexusSource());
        boolean saw_line = false;
        int identifier_index = 0;
        boolean first_block = true;
        boolean saw_data_matrix_line = false;
        ArrayList<String> identifiers = new ArrayList<String>();
        ArrayList states = new ArrayList();
        boolean done = false;
        while ((line = reader.readLine()) != null && !done) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.startsWith(">")) continue;
            if (identifier_index > 0 && line.startsWith("Tree ") || line.startsWith("Character change list")) {
                done = true;
                continue;
            }
            if (line.toLowerCase().startsWith(DATA_MATRIX_AND_RECONSTRUCTED_STATES_FOR_INTERNAL_NODES)) {
                saw_line = false;
                saw_data_matrix_line = true;
                identifier_index = 0;
                if (first_block && line.indexOf("continued") > 0) {
                    first_block = false;
                }
            }
            if (saw_data_matrix_line && line.startsWith("----------")) {
                saw_line = true;
                continue;
            }
            if (!saw_line || line.indexOf(32) <= 0) continue;
            String[] s2 = line.split("\\s+");
            if (s2.length != 2) {
                throw new NexusFormatException("unexpected format at line: " + line);
            }
            String identifier = s2[0];
            String row = s2[1];
            if (first_block) {
                if (identifiers.contains(identifier)) {
                    throw new NexusFormatException("identifier [" + identifier + "] is not unique in line: " + line);
                }
                identifiers.add(identifier);
                states.add(new ArrayList());
            } else if (!identifiers.contains(identifier)) {
                throw new NexusFormatException("new identifier [" + identifier + "] at line: " + line);
            }
            for (int c = 0; c < row.length(); ++c) {
                char ch = row.charAt(c);
                if (ch == '0') {
                    ((List)states.get(identifier_index)).add(CharacterStateMatrix.BinaryStates.ABSENT);
                    continue;
                }
                if (ch == '1') {
                    ((List)states.get(identifier_index)).add(CharacterStateMatrix.BinaryStates.PRESENT);
                    continue;
                }
                throw new NexusFormatException("unknown character state [" + ch + "] at line: " + line);
            }
            ++identifier_index;
        }
        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(states);
        int i = 0;
        for (String identifier : identifiers) {
            matrix.setIdentifier(i++, identifier);
        }
        return matrix;
    }

    public void setSource(Object nexus_source) throws PhylogenyParserException, IOException {
        if (nexus_source == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        this._nexus_source = nexus_source;
    }
}

