/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nhx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.IteratingPhylogenyParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public final class NHXParser
implements PhylogenyParser,
IteratingPhylogenyParser {
    public static final Pattern MB_BL_PATTERN = Pattern.compile("length.median=([^,]+)");
    public static final Pattern MB_PROB_PATTERN = Pattern.compile("prob=([^,]+)");
    public static final Pattern MB_PROB_SD_PATTERN = Pattern.compile("prob.stddev=([^,]+)");
    public static final Pattern NUMBERS_ONLY_PATTERN = Pattern.compile("^[0-9\\.]+$");
    public static final boolean REPLACE_UNDERSCORES_DEFAULT = false;
    private static final boolean ALLOW_ERRORS_IN_DISTANCE_TO_PARENT_DEFAULT = false;
    private static final byte BUFFERED_READER = 3;
    private static final byte CHAR_ARRAY = 2;
    private static final boolean GUESS_IF_SUPPORT_VALUES = true;
    private static final boolean GUESS_ROOTEDNESS_DEFAULT = true;
    private static final boolean IGNORE_QUOTES_DEFAULT = false;
    private static final byte STRING = 0;
    private static final byte STRING_BUFFER = 1;
    private static final byte STRING_BUILDER = 4;
    private static final char BELL = '\u0007';
    private boolean _allow_errors_in_distance_to_parent;
    private int _clade_level;
    private StringBuilder _current_anotation;
    private PhylogenyNode _current_node;
    private Phylogeny _current_phylogeny;
    private boolean _guess_rootedness;
    private int _i;
    private boolean _ignore_quotes;
    private boolean _in_comment = false;
    private boolean _in_double_quote = false;
    private boolean _in_open_bracket = false;
    private boolean _in_single_quote = false;
    private byte _input_type;
    private BufferedReader _my_source_br = null;
    private char[] _my_source_charary = null;
    private StringBuffer _my_source_sbuff = null;
    private StringBuilder _my_source_sbuil = null;
    private String _my_source_str = null;
    private Phylogeny _next;
    private Object _nhx_source;
    private boolean _replace_underscores;
    private boolean _saw_closing_paren;
    private boolean _saw_colon = false;
    private boolean _saw_open_bracket = false;
    private Object _source;
    private int _source_length;
    private TAXONOMY_EXTRACTION _taxonomy_extraction;

    public NHXParser() {
        this.init();
    }

    @Override
    public String getName() {
        return "NH/NHX Parser";
    }

    public final TAXONOMY_EXTRACTION getTaxonomyExtraction() {
        return this._taxonomy_extraction;
    }

    @Override
    public final boolean hasNext() {
        return this._next != null;
    }

    @Override
    public final Phylogeny next() throws NHXFormatException, IOException {
        Phylogeny phy = this._next;
        this.parseNext();
        return phy;
    }

    @Override
    public final Phylogeny[] parse() throws IOException {
        ArrayList<Phylogeny> l = new ArrayList<Phylogeny>();
        while (this.hasNext()) {
            l.add(this.next());
        }
        Phylogeny[] p = new Phylogeny[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            p[i] = (Phylogeny)l.get(i);
        }
        this.reset();
        return p;
    }

    @Override
    public final void reset() throws NHXFormatException, IOException {
        this._i = 0;
        this._next = null;
        this._in_comment = false;
        this._saw_colon = false;
        this._saw_open_bracket = false;
        this._in_open_bracket = false;
        this._in_double_quote = false;
        this._in_single_quote = false;
        this._clade_level = 0;
        this._current_anotation = new StringBuilder();
        this._current_phylogeny = null;
        this._current_node = null;
        this._my_source_str = null;
        this._my_source_sbuff = null;
        this._my_source_sbuil = null;
        this._my_source_charary = null;
        this.determineAndProcessSourceType(this._source);
        switch (this._input_type) {
            case 0: {
                this._my_source_br = null;
                this._my_source_str = (String)this._nhx_source;
                break;
            }
            case 1: {
                this._my_source_br = null;
                this._my_source_sbuff = (StringBuffer)this._nhx_source;
                break;
            }
            case 4: {
                this._my_source_br = null;
                this._my_source_sbuil = (StringBuilder)this._nhx_source;
                break;
            }
            case 2: {
                this._my_source_br = null;
                this._my_source_charary = (char[])this._nhx_source;
                break;
            }
            case 3: {
                this._my_source_br = (BufferedReader)this._nhx_source;
                break;
            }
            default: {
                throw new RuntimeException("unknown input type");
            }
        }
        this.parseNext();
    }

    public final void setGuessRootedness(boolean guess_rootedness) {
        this._guess_rootedness = guess_rootedness;
    }

    public final void setIgnoreQuotes(boolean ignore_quotes) {
        this._ignore_quotes = ignore_quotes;
    }

    public final void setReplaceUnderscores(boolean replace_underscores) {
        this._replace_underscores = replace_underscores;
    }

    @Override
    public final void setSource(Object nhx_source) throws NHXFormatException, IOException {
        this._source = nhx_source;
        this.reset();
    }

    public final void setTaxonomyExtraction(TAXONOMY_EXTRACTION taxonomy_extraction) {
        this._taxonomy_extraction = taxonomy_extraction;
    }

    public final void setAllowErrorsInDistanceToParent(boolean allow_errors_in_distance_to_parent) {
        this._allow_errors_in_distance_to_parent = allow_errors_in_distance_to_parent;
    }

    private final void determineAndProcessSourceType(Object nhx_source) throws IOException {
        if (nhx_source == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        if (nhx_source instanceof String) {
            this._input_type = 0;
            this._source_length = ((String)nhx_source).length();
            this._nhx_source = nhx_source;
        } else if (nhx_source instanceof StringBuilder) {
            this._input_type = (byte)4;
            this._source_length = ((StringBuilder)nhx_source).length();
            this._nhx_source = nhx_source;
        } else if (nhx_source instanceof StringBuffer) {
            this._input_type = 1;
            this._source_length = ((StringBuffer)nhx_source).length();
            this._nhx_source = nhx_source;
        } else if (nhx_source instanceof StringBuilder) {
            this._input_type = (byte)4;
            this._source_length = ((StringBuilder)nhx_source).length();
            this._nhx_source = nhx_source;
        } else if (nhx_source instanceof char[]) {
            this._input_type = (byte)2;
            this._source_length = ((char[])nhx_source).length;
            this._nhx_source = nhx_source;
        } else if (nhx_source instanceof File) {
            File f;
            String error;
            this._input_type = (byte)3;
            this._source_length = 0;
            if (this._my_source_br != null) {
                // empty if block
            }
            if (!ForesterUtil.isEmpty(error = ForesterUtil.isReadableFile(f = (File)nhx_source))) {
                throw new PhylogenyParserException(error);
            }
            this._nhx_source = new BufferedReader(new FileReader(f));
        } else if (nhx_source instanceof URL) {
            this._input_type = (byte)3;
            this._source_length = 0;
            if (this._my_source_br != null) {
                // empty if block
            }
            InputStreamReader isr = new InputStreamReader(((URL)nhx_source).openStream());
            this._nhx_source = new BufferedReader(isr);
        } else if (nhx_source instanceof InputStream) {
            this._input_type = (byte)3;
            this._source_length = 0;
            if (this._my_source_br != null) {
                // empty if block
            }
            InputStreamReader isr = new InputStreamReader((InputStream)nhx_source);
            this._nhx_source = new BufferedReader(isr);
        } else {
            throw new IllegalArgumentException(this.getClass() + " can only parse objects of type String, StringBuffer, StringBuilder, char[], File, InputStream, or URL  [attempt to parse object of " + nhx_source.getClass() + "].");
        }
    }

    private final Phylogeny finishPhylogeny() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        if (this._current_phylogeny != null) {
            PhylogenyNode root;
            NHXParser.parseNHX(this._current_anotation != null ? this._current_anotation.toString() : "", this._current_phylogeny.getRoot(), this.getTaxonomyExtraction(), this.isReplaceUnderscores(), this.isAllowErrorsInDistanceToParent(), true);
            if (NHXParser.isBranchLengthsLikeBootstrapValues(this._current_phylogeny)) {
                NHXParser.moveBranchLengthsToConfidenceValues(this._current_phylogeny);
            }
            if (this.isGuessRootedness() && ((root = this._current_phylogeny.getRoot()).getDistanceToParent() >= 0.0 || !ForesterUtil.isEmpty(root.getName()) || !ForesterUtil.isEmpty(PhylogenyMethods.getSpecies(root)) || root.isHasAssignedEvent())) {
                this._current_phylogeny.setRooted(true);
            }
            return this._current_phylogeny;
        }
        return null;
    }

    private final Phylogeny finishSingleNodePhylogeny() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        PhylogenyNode new_node = new PhylogenyNode();
        NHXParser.parseNHX(this._current_anotation.toString(), new_node, this.getTaxonomyExtraction(), this.isReplaceUnderscores(), this.isAllowErrorsInDistanceToParent(), true);
        this._current_phylogeny = new Phylogeny();
        this._current_phylogeny.setRoot(new_node);
        return this._current_phylogeny;
    }

    private final void init() {
        this.setTaxonomyExtraction(TAXONOMY_EXTRACTION.NO);
        this.setReplaceUnderscores(false);
        this.setGuessRootedness(true);
        this.setIgnoreQuotes(false);
        this.setAllowErrorsInDistanceToParent(false);
    }

    private final boolean isAllowErrorsInDistanceToParent() {
        return this._allow_errors_in_distance_to_parent;
    }

    private final boolean isGuessRootedness() {
        return this._guess_rootedness;
    }

    private final boolean isIgnoreQuotes() {
        return this._ignore_quotes;
    }

    private final boolean isReplaceUnderscores() {
        return this._replace_underscores;
    }

    private final void parseNext() throws IOException, NHXFormatException {
        if (this._source == null) {
            throw new IOException("source is not set");
        }
        while (true) {
            char c = '\b';
            if (this._input_type == 3) {
                int ci = this._my_source_br.read();
                if (ci < 0) break;
                c = (char)ci;
            } else {
                if (this._i >= this._source_length) break;
                switch (this._input_type) {
                    case 0: {
                        c = this._my_source_str.charAt(this._i);
                        break;
                    }
                    case 1: {
                        c = this._my_source_sbuff.charAt(this._i);
                        break;
                    }
                    case 4: {
                        c = this._my_source_sbuil.charAt(this._i);
                        break;
                    }
                    case 2: {
                        c = this._my_source_charary[this._i];
                    }
                }
            }
            if (!this._in_single_quote && !this._in_double_quote) {
                if (c == ':') {
                    this._saw_colon = true;
                } else if (c >= '!' && c <= '~' && this._saw_colon && c != '[' && c != '.' && (c < '0' || c > '9')) {
                    this._saw_colon = false;
                }
                if (this._in_open_bracket && c == ']') {
                    this._in_open_bracket = false;
                }
            }
            if (c >= ' ' && c <= '~' && (!this.isIgnoreQuotes() || c != ' ' && c != '\"' && c != '\'') && (c != ' ' || this._in_single_quote || this._in_double_quote) && (this._clade_level != 0 || c != ';' || this._in_single_quote || this._in_double_quote)) {
                if (this._in_comment) {
                    if (c == ']') {
                        this._in_comment = false;
                    }
                } else if (this._in_double_quote) {
                    if (c == '\"') {
                        this._in_double_quote = false;
                    } else {
                        this._current_anotation.append(NHXParser.changeCharInParens(c));
                    }
                } else if (c == '\"' && !this._in_single_quote) {
                    this._in_double_quote = true;
                } else if (this._in_single_quote) {
                    if (c == '\'') {
                        this._in_single_quote = false;
                    } else {
                        this._current_anotation.append(NHXParser.changeCharInParens(c));
                    }
                } else if (c == '\'') {
                    this._in_single_quote = true;
                } else if (c == '[') {
                    this._saw_open_bracket = true;
                    this._in_open_bracket = true;
                } else if (this._saw_open_bracket) {
                    if (c != ']') {
                        if (c == '&') {
                            this._current_anotation.append("[&");
                        } else if (this._saw_colon) {
                            this._current_anotation.append("[" + c);
                        } else {
                            this._in_comment = true;
                        }
                    }
                    this._saw_open_bracket = false;
                } else if (c == '(' && !this._in_open_bracket) {
                    Phylogeny phy = this.processOpenParen();
                    if (phy != null) {
                        ++this._i;
                        this._next = phy;
                        return;
                    }
                } else if (c == ')' && !this._in_open_bracket) {
                    this.processCloseParen();
                } else if (c == ',' && !this._in_open_bracket) {
                    this.processComma();
                } else {
                    this._current_anotation.append(c);
                }
            }
            ++this._i;
        }
        if (this._clade_level != 0) {
            throw new PhylogenyParserException("error in NH (Newick) formatted data: most likely cause: number of open parens does not equal number of close parens");
        }
        if (this._current_phylogeny != null) {
            this._next = this.finishPhylogeny();
            this._current_phylogeny = null;
            this._current_anotation = null;
        } else if (this._current_anotation != null && this._current_anotation.length() > 0) {
            this._next = this.finishSingleNodePhylogeny();
            this._current_anotation = null;
        } else {
            this._next = null;
        }
    }

    private static final char changeCharInParens(char c) {
        if (c == ':') {
            c = (char)7;
        } else if (c == '[') {
            c = (char)123;
        } else if (c == ']') {
            c = (char)125;
        }
        return c;
    }

    private final void processCloseParen() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        if (this._clade_level < 0) {
            throw new PhylogenyParserException("error in NH (Newick)/NHX formatted data: most likely cause: number of close parens is larger than number of open parens");
        }
        --this._clade_level;
        if (!this._saw_closing_paren) {
            PhylogenyNode new_node = new PhylogenyNode();
            NHXParser.parseNHX(this._current_anotation.toString(), new_node, this.getTaxonomyExtraction(), this.isReplaceUnderscores(), this.isAllowErrorsInDistanceToParent(), true);
            this._current_anotation = new StringBuilder();
            this._current_node.addAsChild(new_node);
        } else {
            NHXParser.parseNHX(this._current_anotation.toString(), this._current_node.getLastChildNode(), this.getTaxonomyExtraction(), this.isReplaceUnderscores(), this.isAllowErrorsInDistanceToParent(), true);
            this._current_anotation = new StringBuilder();
        }
        if (!this._current_node.isRoot()) {
            this._current_node = this._current_node.getParent();
        }
        this._saw_closing_paren = true;
    }

    private final void processComma() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        if (!this._saw_closing_paren) {
            PhylogenyNode new_node = new PhylogenyNode();
            NHXParser.parseNHX(this._current_anotation.toString(), new_node, this.getTaxonomyExtraction(), this.isReplaceUnderscores(), this.isAllowErrorsInDistanceToParent(), true);
            if (this._current_node == null) {
                throw new NHXFormatException("format might not be NH or NHX");
            }
            this._current_node.addAsChild(new_node);
        } else {
            NHXParser.parseNHX(this._current_anotation.toString(), this._current_node.getLastChildNode(), this.getTaxonomyExtraction(), this.isReplaceUnderscores(), this.isAllowErrorsInDistanceToParent(), true);
        }
        this._current_anotation = new StringBuilder();
        this._saw_closing_paren = false;
    }

    private final Phylogeny processOpenParen() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        Phylogeny phy = null;
        PhylogenyNode new_node = new PhylogenyNode();
        if (this._clade_level == 0) {
            if (this._current_phylogeny != null) {
                phy = this.finishPhylogeny();
            }
            this._clade_level = 1;
            this._current_anotation = new StringBuilder();
            this._current_phylogeny = new Phylogeny();
            this._current_phylogeny.setRoot(new_node);
        } else {
            ++this._clade_level;
            this._current_node.addAsChild(new_node);
        }
        this._current_node = new_node;
        this._saw_closing_paren = false;
        return phy;
    }

    private static final NHXParser createInstance(Object nhx_source) throws NHXFormatException, IOException {
        NHXParser parser = new NHXParser();
        parser.setSource(nhx_source);
        return parser;
    }

    public static final Phylogeny[] parse(Object nhx_source) throws NHXFormatException, IOException {
        return NHXParser.createInstance(nhx_source).parse();
    }

    public static final void parseNHX(String s2, PhylogenyNode node_to_annotate, TAXONOMY_EXTRACTION taxonomy_extraction, boolean replace_underscores, boolean allow_errors_in_distance_to_parent, boolean replace_bell) throws NHXFormatException, PhyloXmlDataFormatException {
        if (taxonomy_extraction != TAXONOMY_EXTRACTION.NO && replace_underscores) {
            throw new IllegalArgumentException("cannot extract taxonomies and replace under scores at the same time");
        }
        if (s2 != null && s2.length() > 0) {
            StringTokenizer t;
            if (replace_underscores) {
                s2 = s2.replaceAll("_+", " ");
            }
            s2 = s2.replaceAll("\\s+", " ").trim();
            boolean is_nhx = false;
            int ob = s2.indexOf("[");
            if (ob > -1) {
                String b = "";
                is_nhx = true;
                int cb = s2.indexOf("]");
                if (cb < 0) {
                    throw new NHXFormatException("error in NHX formatted data: no closing \"]\" in \"" + s2 + "\"");
                }
                if (s2.indexOf("&&NHX") == ob + 1) {
                    b = s2.substring(ob + 6, cb);
                } else {
                    String bracketed = s2.substring(ob + 1, cb);
                    Matcher numbers_only = NUMBERS_ONLY_PATTERN.matcher(bracketed);
                    if (numbers_only.matches()) {
                        b = ":B=" + bracketed;
                    } else if (s2.indexOf("prob=") > -1) {
                        NHXParser.processMrBayes3Data(s2, node_to_annotate);
                    }
                }
                s2 = s2.substring(0, ob) + b;
                if (s2.indexOf("[") > -1 || s2.indexOf("]") > -1) {
                    throw new NHXFormatException("error in NHX formatted data: more than one \"]\" or \"[\"");
                }
            }
            if ((t = new StringTokenizer(s2, ":")).countTokens() > 0) {
                if (!s2.startsWith(":")) {
                    if (s2.indexOf(7) <= -1 || !replace_bell) {
                        node_to_annotate.setName(t.nextToken());
                    } else {
                        node_to_annotate.setName(t.nextToken().replace('\u0007', ':'));
                    }
                    if (!replace_underscores && !is_nhx && taxonomy_extraction != TAXONOMY_EXTRACTION.NO) {
                        ParserUtils.extractTaxonomyDataFromNodeName(node_to_annotate, taxonomy_extraction);
                    }
                }
                while (t.hasMoreTokens()) {
                    s2 = t.nextToken();
                    if (s2.indexOf(7) > -1 && replace_bell) {
                        s2 = s2.replace('\u0007', ':');
                    }
                    if (s2.indexOf(61) < 0) {
                        if (node_to_annotate.getDistanceToParent() != -1024.0 && !allow_errors_in_distance_to_parent) {
                            throw new NHXFormatException("error in NHX formatted data: more than one distance to parent:\"" + s2 + "\"");
                        }
                        node_to_annotate.setDistanceToParent(NHXParser.doubleValue(s2, allow_errors_in_distance_to_parent));
                        continue;
                    }
                    if (s2.startsWith("S=")) {
                        if (!node_to_annotate.getNodeData().isHasTaxonomy()) {
                            node_to_annotate.getNodeData().setTaxonomy(new Taxonomy());
                        }
                        node_to_annotate.getNodeData().getTaxonomy().setScientificName(s2.substring(2));
                        continue;
                    }
                    if (s2.startsWith("D=")) {
                        if (s2.charAt(2) == 'Y' || s2.charAt(2) == 'T') {
                            node_to_annotate.getNodeData().setEvent(Event.createSingleDuplicationEvent());
                            continue;
                        }
                        if (s2.charAt(2) == 'N' || s2.charAt(2) == 'F') {
                            node_to_annotate.getNodeData().setEvent(Event.createSingleSpeciationEvent());
                            continue;
                        }
                        if (s2.charAt(2) == '?') {
                            node_to_annotate.getNodeData().setEvent(Event.createSingleSpeciationOrDuplicationEvent());
                            continue;
                        }
                        throw new NHXFormatException("error in NHX formatted data: :D=Y or :D=N or :D=?");
                    }
                    if (s2.startsWith("B=")) {
                        PhylogenyMethods.setConfidence(node_to_annotate, NHXParser.doubleValue(s2.substring(2), false));
                        continue;
                    }
                    if (s2.startsWith("T=")) {
                        if (!node_to_annotate.getNodeData().isHasTaxonomy()) {
                            node_to_annotate.getNodeData().setTaxonomy(new Taxonomy());
                        }
                        node_to_annotate.getNodeData().getTaxonomy().setIdentifier(new Identifier(s2.substring(2)));
                        continue;
                    }
                    if (s2.startsWith("AC=")) {
                        if (!node_to_annotate.getNodeData().isHasSequence()) {
                            node_to_annotate.getNodeData().setSequence(new Sequence());
                        }
                        node_to_annotate.getNodeData().getSequence().setAccession(new Accession(s2.substring(3), "?"));
                        continue;
                    }
                    if (!s2.startsWith("GN=")) continue;
                    if (!node_to_annotate.getNodeData().isHasSequence()) {
                        node_to_annotate.getNodeData().setSequence(new Sequence());
                    }
                    node_to_annotate.getNodeData().getSequence().setName(s2.substring(3));
                }
            }
        }
    }

    private static final double doubleValue(String str, boolean allow_errors) throws NHXFormatException {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException ex) {
            if (!allow_errors) {
                throw new NHXFormatException("error in NH/NHX formatted data: failed to parse number from \"" + str + "\"");
            }
            return 0.0;
        }
    }

    private static final boolean isBranchLengthsLikeBootstrapValues(Phylogeny p) {
        PhylogenyNodeIterator it = p.iteratorExternalForward();
        double d0 = it.next().getDistanceToParent();
        if (d0 < 10.0 || !it.hasNext()) {
            return false;
        }
        while (it.hasNext()) {
            double d = it.next().getDistanceToParent();
            if (d == d0 && !(d < 10.0)) continue;
            return false;
        }
        return true;
    }

    private static final void moveBranchLengthsToConfidenceValues(Phylogeny p) {
        PhylogenyNodeIterator it = p.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            PhylogenyMethods.setBootstrapConfidence(n, n.getDistanceToParent());
            n.setDistanceToParent(-1024.0);
        }
    }

    private static final void processMrBayes3Data(String s2, PhylogenyNode node_to_annotate) throws NHXFormatException {
        Matcher mb_bl_matcher;
        Matcher mb_prob_matcher;
        double sd = -1.0;
        Matcher mb_prob_sd_matcher = MB_PROB_SD_PATTERN.matcher(s2);
        if (mb_prob_sd_matcher.find()) {
            try {
                sd = Double.parseDouble(mb_prob_sd_matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new NHXFormatException("failed to parse probability standard deviation (Mr Bayes output) from \"" + s2 + "\"");
            }
        }
        if ((mb_prob_matcher = MB_PROB_PATTERN.matcher(s2)).find()) {
            double prob = -1.0;
            try {
                prob = Double.parseDouble(mb_prob_matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new NHXFormatException("failed to parse probability (Mr Bayes output) from \"" + s2 + "\"");
            }
            if (prob >= 0.0) {
                if (sd >= 0.0) {
                    node_to_annotate.getBranchData().addConfidence(new Confidence(prob, "posterior probability", sd));
                } else {
                    node_to_annotate.getBranchData().addConfidence(new Confidence(prob, "posterior probability"));
                }
            }
        }
        if ((mb_bl_matcher = MB_BL_PATTERN.matcher(s2)).find()) {
            double bl = -1.0;
            try {
                bl = Double.parseDouble(mb_bl_matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new NHXFormatException("failed to parse median branch length (Mr Bayes output) from \"" + s2 + "\"");
            }
            if (bl >= 0.0) {
                node_to_annotate.setDistanceToParent(bl);
            }
        }
    }

    public static enum TAXONOMY_EXTRACTION {
        AGGRESSIVE,
        NO,
        PFAM_STYLE_RELAXED,
        PFAM_STYLE_STRICT;

    }
}

