/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.ProteinDomain;

public class ProteinDomainParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private ProteinDomainParser() {
    }

    @Override
    public ProteinDomain parse(XmlElement element) throws PhyloXmlDataFormatException {
        String name = "";
        int f = -1;
        int t = -1;
        double conf = -1.0;
        String id = "";
        try {
            f = Integer.parseInt(element.getAttribute("from"));
            t = Integer.parseInt(element.getAttribute("to"));
            conf = Double.parseDouble(element.getAttribute("confidence"));
            if (element.isHasAttribute("id")) {
                id = element.getAttribute("id");
            }
        }
        catch (Exception e) {
            throw new PhyloXmlDataFormatException("failed to parse element [" + element + "]: " + e.getMessage());
        }
        name = element.getValueAsString();
        if (f == -1) {
            throw new PhyloXmlDataFormatException("\"from\" attribute not set in: " + element);
        }
        if (t == -1) {
            throw new PhyloXmlDataFormatException("\"to\" attribute not set in: " + element);
        }
        if (conf < 0.0) {
            throw new PhyloXmlDataFormatException("\"confidence\" attribute either negative or not set in: " + element);
        }
        return new ProteinDomain(name, f, t, id, conf);
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new ProteinDomainParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

