/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import java.net.URI;
import java.net.URISyntaxException;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Uri;

public class UriParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private UriParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhyloXmlDataFormatException {
        String type = "";
        String desc = "";
        URI uri = null;
        try {
            uri = new URI(element.getValueAsString());
        }
        catch (URISyntaxException e) {
            throw new PhyloXmlDataFormatException("ill formatted Uri: " + element.getValueAsString());
        }
        if (element.isHasAttribute("desc")) {
            desc = element.getAttribute("desc");
        }
        if (element.isHasAttribute("type")) {
            type = element.getAttribute("type");
        }
        return new Uri(uri, desc, type);
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new UriParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

