/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;

public final class ParserUtils {
    private static final String SN_BN = "[A-Z][a-z]{2,30}[_ ][a-z]{3,30}";
    public static final String TAX_CODE = "(?:[A-Z9][A-Z]{2}[A-Z0-9]{2})|RAT|PIG|PEA";
    public static final String TAX_CODE_LO = "(?:[A-Z]{5})|RAT|PIG|PEA";
    public static final Pattern TAXOMONY_CODE_PATTERN_A = Pattern.compile("(?:\\b|_)((?:[A-Z9][A-Z]{2}[A-Z0-9]{2})|RAT|PIG|PEA)(?:\\b|_)");
    public static final Pattern TAXOMONY_CODE_PATTERN_A_LO = Pattern.compile("_((?:[A-Z]{5})|RAT|PIG|PEA)(?:\\b|_)");
    public static final Pattern TAXOMONY_CODE_PATTERN_BRACKETED = Pattern.compile("\\[((?:[A-Z9][A-Z]{2}[A-Z0-9]{2})|RAT|PIG|PEA)\\]");
    public static final Pattern TAXOMONY_CODE_PATTERN_PFR = Pattern.compile("(?:\\b|_)[a-zA-Z0-9]{3,}_((?:[A-Z9][A-Z]{2}[A-Z0-9]{2})|RAT|PIG|PEA)\\b");
    public static final Pattern TAXOMONY_SN_PATTERN_GENUS = Pattern.compile("([A-Z][a-z]{2,30})");
    public static final Pattern TAXOMONY_SN_PATTERN_SN = Pattern.compile("(?:\\b|_)([A-Z][a-z]{2,30}[_ ][a-z]{3,30})(?:(\\s*$)|([_ ][a-z]*[A-Z0-9]))");
    public static final Pattern TAXOMONY_SN_PATTERN_SNS = Pattern.compile("(?:\\b|_)([A-Z][a-z]{2,30}[_ ][a-z]{3,30}[_ ][a-z]{3,30})[_ ][a-z]*[A-Z0-9]");
    public static final Pattern TAXOMONY_SN_PATTERN_SNS2 = Pattern.compile("[A-Z0-9][a-z]*[_ ]([A-Z][a-z]{2,30}[_ ][a-z]{3,30}[_ ][a-z]{3,30})\\s*$");
    public static final Pattern TAXOMONY_SN_PATTERN_SP = Pattern.compile("(?:\\b|_)([A-Z][a-z]{2,30}[_ ]sp\\.?)(?:\\b|_)?");
    public static final Pattern TAXOMONY_SN_PATTERN_STRAIN_1 = Pattern.compile("(?:\\b|_)([A-Z][a-z]{2,30}[_ ][a-z]{3,30}[_ ](?:str|subsp|ssp|var)[a-z]{0,5}\\.?[_ ]\\S{1,60})(?:\\b|_)");
    public static final Pattern TAXOMONY_SN_PATTERN_STRAIN_2 = Pattern.compile("(?:\\b|_)([A-Z][a-z]{2,30}[_ ][a-z]{3,30}[_ ]\\((?:str|subsp|ssp|var)[a-z]{0,5}\\.?[_ ]\\S{1,60}\\))");
    public static final Pattern TAXOMONY_SN_PATTERN_STRAIN_SUBSTRAIN = Pattern.compile("(?:\\b|_)([A-Z][a-z]{2,30}[_ ][a-z]{3,30}[_ ]str[a-z]{0,3}\\.?[_ ]\\S{1,60}[_ ]substr[a-z]{0,3}\\.?[_ ]\\S{1,60})(?:\\b|_)");
    private static final Pattern TAXOMONY_CODE_PATTERN_PFS = Pattern.compile("(?:\\b|_)[A-Z0-9]{4,}_((?:[A-Z9][A-Z]{2}[A-Z0-9]{2})|RAT|PIG|PEA)/\\d+-\\d+\\b");
    private static final Pattern TAXOMONY_UNIPROT_ID_PATTERN_PFR = Pattern.compile("(?:\\b|_)[A-Z0-9]{1,}_(\\d{1,7})\\b");
    private static final Pattern TAXOMONY_UNIPROT_ID_PATTERN_PFS = Pattern.compile("(?:\\b|_)[A-Z0-9]{4,}_(\\d{1,7})/\\d+-\\d+\\b");

    public static final PhylogenyParser createParserDependingFileContents(File file, boolean phyloxml_validate_against_xsd) throws FileNotFoundException, IOException {
        PhylogenyParser parser = null;
        String first_line = ForesterUtil.getFirstLine(file).trim().toLowerCase();
        if (first_line.startsWith("<")) {
            ClassLoader cl;
            URL xsd_url;
            parser = PhyloXmlParser.createPhyloXmlParser();
            if (phyloxml_validate_against_xsd && (xsd_url = (cl = PhyloXmlParser.class.getClassLoader()).getResource("resources/phyloxml.xsd")) != null) {
                ((PhyloXmlParser)parser).setValidateAgainstSchema(xsd_url.toString());
            }
        } else {
            parser = first_line.startsWith("nexus") || first_line.startsWith("#nexus") || first_line.startsWith("# nexus") || first_line.startsWith("begin") ? new NexusPhylogeniesParser() : new NHXParser();
        }
        return parser;
    }

    public static final PhylogenyParser createParserDependingOnFileType(File file, boolean phyloxml_validate_against_xsd) throws FileNotFoundException, IOException {
        PhylogenyParser parser = null;
        parser = ParserUtils.createParserDependingOnSuffix(file.getName(), phyloxml_validate_against_xsd);
        if (parser == null) {
            parser = ParserUtils.createParserDependingFileContents(file, phyloxml_validate_against_xsd);
        }
        if (parser != null && file.toString().toLowerCase().endsWith(".zip")) {
            if (parser instanceof PhyloXmlParser) {
                ((PhyloXmlParser)parser).setZippedInputstream(true);
            } else if (parser instanceof TolParser) {
                ((TolParser)parser).setZippedInputstream(true);
            }
        }
        return parser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final PhylogenyParser createParserDependingOnUrlContents(URL url, boolean phyloxml_validate_against_xsd) throws FileNotFoundException, IOException {
        String lc_filename = url.getFile().toString().toLowerCase();
        PhylogenyParser parser = ParserUtils.createParserDependingOnSuffix(lc_filename, phyloxml_validate_against_xsd);
        if (parser == null) {
            String first_line = ForesterUtil.getFirstLine(url).trim().toLowerCase();
            if (first_line.startsWith("<")) {
                parser = PhyloXmlParser.createPhyloXmlParser();
                if (phyloxml_validate_against_xsd) {
                    ClassLoader cl = PhyloXmlParser.class.getClassLoader();
                    URL xsd_url = cl.getResource("resources/phyloxml.xsd");
                    if (xsd_url == null) throw new RuntimeException("failed to get URL for phyloXML XSD from jar file from [resources/phyloxml.xsd]");
                    ((PhyloXmlParser)parser).setValidateAgainstSchema(xsd_url.toString());
                }
            } else {
                parser = first_line.startsWith("nexus") || first_line.startsWith("#nexus") || first_line.startsWith("# nexus") || first_line.startsWith("begin") ? new NexusPhylogeniesParser() : new NHXParser();
            }
        }
        if (parser == null || !lc_filename.endsWith(".zip")) return parser;
        if (parser instanceof PhyloXmlParser) {
            ((PhyloXmlParser)parser).setZippedInputstream(true);
            return parser;
        } else {
            if (!(parser instanceof TolParser)) return parser;
            ((TolParser)parser).setZippedInputstream(true);
        }
        return parser;
    }

    public static BufferedReader createReader(Object source) throws IOException, FileNotFoundException {
        BufferedReader reader = null;
        if (source instanceof File || source instanceof String) {
            File f = null;
            f = source instanceof File ? (File)source : new File((String)source);
            if (!f.exists()) {
                throw new IOException("[" + f.getAbsolutePath() + "] does not exist");
            }
            if (!f.isFile()) {
                throw new IOException("[" + f.getAbsolutePath() + "] is not a file");
            }
            if (!f.canRead()) {
                throw new IOException("[" + f.getAbsolutePath() + "] is not a readable");
            }
            reader = new BufferedReader(new FileReader(f));
        } else if (source instanceof InputStream) {
            reader = new BufferedReader(new InputStreamReader((InputStream)source));
        } else if (source instanceof StringBuffer || source instanceof StringBuilder) {
            reader = new BufferedReader(new StringReader(source.toString()));
        } else {
            throw new IllegalArgumentException("attempt to parse object of type [" + source.getClass() + "] (can only parse objects of type File/String, InputStream, StringBuffer, or StringBuilder)");
        }
        return reader;
    }

    public static final String extractScientificNameFromNodeName(String name) {
        Matcher m_ss = TAXOMONY_SN_PATTERN_STRAIN_SUBSTRAIN.matcher(name);
        if (m_ss.find()) {
            String s2 = m_ss.group(1).replace('_', ' ');
            if (s2.indexOf(" str ") > 4) {
                s2 = s2.replaceFirst(" str ", " str. ");
            }
            if (s2.indexOf(" substr ") > 4) {
                s2 = s2.replaceFirst(" substr ", " substr. ");
            }
            return s2;
        }
        Matcher m_str1 = TAXOMONY_SN_PATTERN_STRAIN_1.matcher(name);
        if (m_str1.find()) {
            String s3 = m_str1.group(1).replace('_', ' ');
            if (s3.indexOf(" str ") > 4) {
                s3 = s3.replaceFirst(" str ", " str. ");
            } else if (s3.indexOf(" subsp ") > 4) {
                s3 = s3.replaceFirst(" subsp ", " subsp. ");
            } else if (s3.indexOf(" ssp ") > 4) {
                s3 = s3.replaceFirst(" ssp ", " subsp. ");
            } else if (s3.indexOf(" ssp. ") > 4) {
                s3 = s3.replaceFirst(" ssp. ", " subsp. ");
            } else if (s3.indexOf(" var ") > 4) {
                s3 = s3.replaceFirst(" var ", " var. ");
            }
            return s3;
        }
        Matcher m_str2 = TAXOMONY_SN_PATTERN_STRAIN_2.matcher(name);
        if (m_str2.find()) {
            String s4 = m_str2.group(1).replace('_', ' ');
            if (s4.indexOf(" (str ") > 4) {
                s4 = s4.replaceFirst(" \\(str ", " (str. ");
            } else if (s4.indexOf(" (subsp ") > 4) {
                s4 = s4.replaceFirst(" \\(subsp ", " (subsp. ");
            } else if (s4.indexOf(" (ssp ") > 4) {
                s4 = s4.replaceFirst(" \\(ssp ", " (subsp. ");
            } else if (s4.indexOf(" (ssp. ") > 4) {
                s4 = s4.replaceFirst(" \\(ssp. ", " (subsp. ");
            } else if (s4.indexOf(" (var ") > 4) {
                s4 = s4.replaceFirst(" \\(var ", " (var. ");
            }
            return s4;
        }
        Matcher m_sns = TAXOMONY_SN_PATTERN_SNS.matcher(name);
        if (m_sns.find()) {
            return m_sns.group(1).replace('_', ' ');
        }
        Matcher m_sns2 = TAXOMONY_SN_PATTERN_SNS2.matcher(name);
        if (m_sns2.find()) {
            return m_sns2.group(1).replace('_', ' ');
        }
        Matcher m_sn = TAXOMONY_SN_PATTERN_SN.matcher(name);
        if (m_sn.find()) {
            return m_sn.group(1).replace('_', ' ');
        }
        Matcher m_sp = TAXOMONY_SN_PATTERN_SP.matcher(name);
        if (m_sp.find()) {
            String s5 = m_sp.group(1).replace('_', ' ');
            if (s5.endsWith(" sp")) {
                s5 = s5 + ".";
            }
            return s5;
        }
        return null;
    }

    public static final String extractTaxonomyCodeFromNodeName(String name, NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction) {
        Matcher m3 = TAXOMONY_CODE_PATTERN_PFS.matcher(name);
        if (m3.find()) {
            return m3.group(1);
        }
        if (taxonomy_extraction == NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED || taxonomy_extraction == NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE) {
            m3 = TAXOMONY_CODE_PATTERN_PFR.matcher(name);
            if (m3.find()) {
                return m3.group(1);
            }
            if (taxonomy_extraction == NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE && (m3 = TAXOMONY_CODE_PATTERN_A.matcher(name)).find()) {
                return m3.group(1);
            }
        }
        return null;
    }

    public static final String extractTaxonomyDataFromNodeName(PhylogenyNode node, NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction) throws PhyloXmlDataFormatException {
        String sn;
        if (taxonomy_extraction == NHXParser.TAXONOMY_EXTRACTION.NO) {
            throw new IllegalArgumentException();
        }
        String id = ParserUtils.extractUniprotTaxonomyIdFromNodeName(node.getName(), taxonomy_extraction);
        if (!ForesterUtil.isEmpty(id)) {
            if (!node.getNodeData().isHasTaxonomy()) {
                node.getNodeData().setTaxonomy(new Taxonomy());
            }
            node.getNodeData().getTaxonomy().setIdentifier(new Identifier(id, "uniprot"));
            return id;
        }
        String code = null;
        if (taxonomy_extraction == NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE && ForesterUtil.isEmpty(code = ParserUtils.extractTaxonomyCodeFromNodeNameLettersOnly(node.getName())) && !ForesterUtil.isEmpty(sn = ParserUtils.extractScientificNameFromNodeName(node.getName()))) {
            if (!node.getNodeData().isHasTaxonomy()) {
                node.getNodeData().setTaxonomy(new Taxonomy());
            }
            node.getNodeData().getTaxonomy().setScientificName(sn);
            return sn;
        }
        if (ForesterUtil.isEmpty(code)) {
            code = ParserUtils.extractTaxonomyCodeFromNodeName(node.getName(), taxonomy_extraction);
        }
        if (!ForesterUtil.isEmpty(code)) {
            if (!node.getNodeData().isHasTaxonomy()) {
                node.getNodeData().setTaxonomy(new Taxonomy());
            }
            node.getNodeData().getTaxonomy().setTaxonomyCode(code);
            return code;
        }
        return null;
    }

    public static final String extractUniprotTaxonomyIdFromNodeName(String name, NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction) {
        Matcher m3 = TAXOMONY_UNIPROT_ID_PATTERN_PFS.matcher(name);
        if (m3.find()) {
            return m3.group(1);
        }
        if ((taxonomy_extraction == NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED || taxonomy_extraction == NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE) && (m3 = TAXOMONY_UNIPROT_ID_PATTERN_PFR.matcher(name)).find()) {
            return m3.group(1);
        }
        return null;
    }

    public static final Phylogeny[] readPhylogenies(File file) throws FileNotFoundException, IOException {
        return PhylogenyMethods.readPhylogenies(ParserUtils.createParserDependingOnFileType(file, true), file);
    }

    public static final Phylogeny[] readPhylogenies(String file_name) throws FileNotFoundException, IOException {
        return ParserUtils.readPhylogenies(new File(file_name));
    }

    private static final PhylogenyParser createParserDependingOnSuffix(String filename, boolean phyloxml_validate_against_xsd) {
        PhylogenyParser parser = null;
        String filename_lc = filename.toLowerCase();
        if (filename_lc.endsWith(".tol") || filename_lc.endsWith(".tolxml") || filename_lc.endsWith(".tol.zip")) {
            parser = new TolParser();
        } else if (filename_lc.endsWith(".xml") || filename_lc.endsWith("phyloxml") || filename_lc.endsWith(".zip")) {
            ClassLoader cl;
            URL xsd_url;
            parser = PhyloXmlParser.createPhyloXmlParser();
            if (phyloxml_validate_against_xsd && (xsd_url = (cl = PhyloXmlParser.class.getClassLoader()).getResource("resources/phyloxml.xsd")) != null) {
                ((PhyloXmlParser)parser).setValidateAgainstSchema(xsd_url.toString());
            }
        } else if (filename_lc.endsWith(".nexus") || filename_lc.endsWith(".nex") || filename_lc.endsWith(".nx")) {
            parser = new NexusPhylogeniesParser();
        } else if (filename_lc.endsWith(".nhx") || filename_lc.endsWith(".nh") || filename_lc.endsWith(".newick") || filename_lc.endsWith(".nwk")) {
            parser = new NHXParser();
        }
        return parser;
    }

    private static final String extractTaxonomyCodeFromNodeNameLettersOnly(String name) {
        Matcher m3 = TAXOMONY_CODE_PATTERN_A_LO.matcher(name);
        if (m3.find()) {
            return m3.group(1);
        }
        return null;
    }
}

