/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.writers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.forester.io.writers.PhyloXmlNodeWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PostOrderStackObject;
import org.forester.util.ForesterUtil;

public final class PhylogenyWriter {
    public static final boolean INDENT_PHYLOXML_DEAFULT = true;
    public static final String PHYLO_XML_INTENDATION_BASE = "  ";
    public static final String PHYLO_XML_VERSION_ENCODING_LINE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String PHYLO_XML_NAMESPACE_LINE = "<phyloxml xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.phyloxml.org http://www.phyloxml.org/1.10/phyloxml.xsd\" xmlns=\"http://www.phyloxml.org\">";
    public static final String PHYLO_XML_END = "</phyloxml>";
    private boolean _saw_comma;
    private StringBuffer _buffer;
    private Writer _writer;
    private PhylogenyNode _root;
    private boolean _has_next;
    private Stack<PostOrderStackObject> _stack;
    private boolean _nh_write_distance_to_parent;
    PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE _nh_conversion_support_style;
    private boolean _indent_phyloxml;
    private int _node_level;
    private int _phyloxml_level;
    private FORMAT _format;

    public PhylogenyWriter() {
        this.setIndentPhyloxml(true);
        this.setNhConversionSupportStyle(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.NONE);
    }

    private void appendPhylogenyLevelPhyloXml(Writer writer, Phylogeny tree) throws IOException {
        String indentation = new String();
        if (!ForesterUtil.isEmpty(tree.getName())) {
            PhylogenyDataUtil.appendElement(writer, "name", tree.getName(), indentation);
        }
        if (tree.getIdentifier() != null) {
            if (ForesterUtil.isEmpty(tree.getIdentifier().getProvider())) {
                PhylogenyDataUtil.appendElement(writer, "id", tree.getIdentifier().getValue(), indentation);
            }
            PhylogenyDataUtil.appendElement(writer, "id", tree.getIdentifier().getValue(), "provider", tree.getIdentifier().getProvider(), indentation);
        }
        if (!ForesterUtil.isEmpty(tree.getDescription())) {
            PhylogenyDataUtil.appendElement(writer, "description", tree.getDescription(), indentation);
        }
        if (tree.getConfidence() != null) {
            if (ForesterUtil.isEmpty(tree.getConfidence().getType())) {
                PhylogenyDataUtil.appendElement(writer, "confidence", tree.getConfidence().getValue() + "", indentation);
            }
            PhylogenyDataUtil.appendElement(writer, "confidence", tree.getConfidence().getValue() + "", "type", tree.getConfidence().getType(), indentation);
        }
    }

    private StringBuffer createIndentation() {
        if (!this.isIndentPhyloxml()) {
            return null;
        }
        StringBuffer sb = new StringBuffer(this.getNodeLevel() * 2);
        for (int i = 0; i < this.getNodeLevel(); ++i) {
            sb.append(PHYLO_XML_INTENDATION_BASE);
        }
        return sb;
    }

    private void decreaseNodeLevel() {
        --this._node_level;
    }

    private StringBuffer getBuffer() {
        return this._buffer;
    }

    private int getNodeLevel() {
        return this._node_level;
    }

    private StringBuffer getOutput(Phylogeny tree) throws IOException {
        if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
            throw new RuntimeException("method inappropriately called");
        }
        if (tree != null) {
            this.reset(tree);
            while (this.isHasNext()) {
                this.next();
            }
            if (this.getOutputFormt() == FORMAT.NH) {
                this.getBuffer().append(';');
            }
            return this.getBuffer();
        }
        return new StringBuffer(0);
    }

    private FORMAT getOutputFormt() {
        return this._format;
    }

    private int getPhyloXmlLevel() {
        return this._phyloxml_level;
    }

    private PhylogenyNode getRoot() {
        return this._root;
    }

    private Stack<PostOrderStackObject> getStack() {
        return this._stack;
    }

    private Writer getWriter() {
        return this._writer;
    }

    private void increaseNodeLevel() {
        ++this._node_level;
    }

    private boolean isHasNext() {
        return this._has_next;
    }

    private boolean isIndentPhyloxml() {
        return this._indent_phyloxml;
    }

    private boolean isSawComma() {
        return this._saw_comma;
    }

    private boolean isWriteDistanceToParentInNH() {
        return this._nh_write_distance_to_parent;
    }

    private void next() throws IOException {
        while (true) {
            PostOrderStackObject si = this.getStack().pop();
            PhylogenyNode node = si.getNode();
            int phase = si.getPhase();
            if (phase > node.getNumberOfDescendants()) {
                this.setHasNext(node != this.getRoot());
                if (this.getOutputFormt() != FORMAT.PHYLO_XML || node.isExternal()) {
                    if (!node.isRoot() && node.isFirstChildNode()) {
                        this.increaseNodeLevel();
                    }
                    if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
                        this.writeNode(node, this.createIndentation());
                    } else {
                        this.writeNode(node, null);
                    }
                }
                if (!node.isRoot()) {
                    if (!node.isLastChildNode()) {
                        this.writeCladeSeparator();
                    } else {
                        this.writeCloseClade();
                    }
                }
                return;
            }
            this.getStack().push(new PostOrderStackObject(node, phase + 1));
            if (!node.isInternal()) continue;
            this.getStack().push(new PostOrderStackObject(node.getChildNode(phase - 1), 1));
            this.writeOpenClade(node);
            if (this.getOutputFormt() != FORMAT.PHYLO_XML || phase != 1) continue;
            this.writeNode(node, this.createIndentation());
        }
    }

    private void reset(Phylogeny tree) {
        this.setBuffer(new StringBuffer());
        this.setWriter(null);
        this.setSawComma(false);
        this.setHasNext(true);
        this.setRoot(tree.getRoot());
        this.setStack(new Stack<PostOrderStackObject>());
        this.getStack().push(new PostOrderStackObject(tree.getRoot(), 1));
        this.setNodeLevel(1);
    }

    private void reset(Writer writer, Phylogeny tree) {
        this.setBuffer(null);
        this.setWriter(writer);
        this.setSawComma(false);
        this.setHasNext(true);
        this.setRoot(tree.getRoot());
        this.setStack(new Stack<PostOrderStackObject>());
        this.getStack().push(new PostOrderStackObject(tree.getRoot(), 1));
        this.setNodeLevel(1);
    }

    private void setBuffer(StringBuffer buffer) {
        this._buffer = buffer;
    }

    private void setHasNext(boolean has_next) {
        this._has_next = has_next;
    }

    public void setIndentPhyloxml(boolean indent_phyloxml) {
        this._indent_phyloxml = indent_phyloxml;
    }

    private void setNodeLevel(int level) {
        this._node_level = level;
    }

    private void setOutputFormt(FORMAT format) {
        this._format = format;
    }

    private void setPhyloXmlLevel(int phyloxml_level) {
        this._phyloxml_level = phyloxml_level;
    }

    private void setRoot(PhylogenyNode root) {
        this._root = root;
    }

    private void setSawComma(boolean saw_comma) {
        this._saw_comma = saw_comma;
    }

    private void setStack(Stack<PostOrderStackObject> stack) {
        this._stack = stack;
    }

    private void setWriteDistanceToParentInNH(boolean nh_write_distance_to_parent) {
        this._nh_write_distance_to_parent = nh_write_distance_to_parent;
    }

    private void setWriter(Writer writer) {
        this._writer = writer;
    }

    public void toNewHampshire(List<Phylogeny> trees, boolean write_distance_to_parent, File out_file, String separator) throws IOException {
        Iterator<Phylogeny> it = trees.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            sb.append(this.toNewHampshire(it.next(), write_distance_to_parent));
            sb.append(separator);
        }
        this.writeToFile(sb, out_file);
    }

    public StringBuffer toNewHampshire(Phylogeny tree, boolean nh_write_distance_to_parent, PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE svs) throws IOException {
        this.setOutputFormt(FORMAT.NH);
        this.setNhConversionSupportStyle(svs);
        this.setWriteDistanceToParentInNH(nh_write_distance_to_parent);
        return this.getOutput(tree);
    }

    public StringBuffer toNewHampshire(Phylogeny tree, boolean nh_write_distance_to_parent) throws IOException {
        this.setOutputFormt(FORMAT.NH);
        this.setWriteDistanceToParentInNH(nh_write_distance_to_parent);
        return this.getOutput(tree);
    }

    public void toNewHampshire(Phylogeny tree, boolean write_distance_to_parent, File out_file) throws IOException {
        this.writeToFile(this.toNewHampshire(tree, write_distance_to_parent), out_file);
    }

    public void toNewHampshire(Phylogeny tree, boolean write_distance_to_parent, PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE svs, File out_file) throws IOException {
        this.writeToFile(this.toNewHampshire(tree, write_distance_to_parent, svs), out_file);
    }

    public void toNewHampshire(Phylogeny[] trees, boolean write_distance_to_parent, File out_file, String separator) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (Phylogeny element : trees) {
            sb.append(this.toNewHampshire(element, write_distance_to_parent));
            sb.append(separator);
        }
        this.writeToFile(sb, out_file);
    }

    public void toNewHampshireX(List<Phylogeny> trees, File out_file, String separator) throws IOException {
        Iterator<Phylogeny> it = trees.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            sb.append(this.toNewHampshireX(it.next()));
            sb.append(separator);
        }
        this.writeToFile(sb, out_file);
    }

    public StringBuffer toNewHampshireX(Phylogeny tree) throws IOException {
        this.setOutputFormt(FORMAT.NHX);
        return this.getOutput(tree);
    }

    public void toNewHampshireX(Phylogeny tree, File out_file) throws IOException {
        this.writeToFile(this.toNewHampshireX(tree), out_file);
    }

    public void toNewHampshireX(Phylogeny[] trees, File out_file, String separator) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (Phylogeny element : trees) {
            sb.append(this.toNewHampshireX(element));
            sb.append(separator);
        }
        this.writeToFile(sb, out_file);
    }

    public void toNexus(File out_file, Phylogeny tree, PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE svs) throws IOException {
        BufferedWriter writer = new BufferedWriter(new PrintWriter(out_file));
        ArrayList<Phylogeny> trees = new ArrayList<Phylogeny>(1);
        trees.add(tree);
        PhylogenyWriter.writeNexusStart(writer);
        PhylogenyWriter.writeNexusTaxaBlock(writer, tree);
        PhylogenyWriter.writeNexusTreesBlock(writer, trees, svs);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public StringBuffer toNexus(Phylogeny tree, PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE svs) throws IOException {
        StringWriter string_writer = new StringWriter();
        BufferedWriter writer = new BufferedWriter(string_writer);
        ArrayList<Phylogeny> trees = new ArrayList<Phylogeny>(1);
        trees.add(tree);
        PhylogenyWriter.writeNexusStart(writer);
        PhylogenyWriter.writeNexusTaxaBlock(writer, tree);
        PhylogenyWriter.writeNexusTreesBlock(writer, trees, svs);
        ((Writer)writer).flush();
        ((Writer)writer).close();
        return string_writer.getBuffer();
    }

    public void toPhyloXML(File out_file, List<Phylogeny> trees, int phyloxml_level, String separator) throws IOException {
        BufferedWriter writer = new BufferedWriter(new PrintWriter(out_file));
        this.toPhyloXML((Writer)writer, trees, phyloxml_level, separator);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public void toPhyloXML(File out_file, Phylogeny tree, int phyloxml_level) throws IOException {
        BufferedWriter writer = new BufferedWriter(new PrintWriter(out_file));
        PhylogenyWriter.writePhyloXmlStart(writer);
        this.toPhyloXMLNoPhyloXmlSource(writer, tree, phyloxml_level);
        PhylogenyWriter.writePhyloXmlEnd(writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public StringBuffer toPhyloXML(Phylogeny tree, int phyloxml_level) throws IOException {
        StringWriter string_writer = new StringWriter();
        BufferedWriter writer = new BufferedWriter(string_writer);
        this.setPhyloXmlLevel(phyloxml_level);
        this.setOutputFormt(FORMAT.PHYLO_XML);
        PhylogenyWriter.writePhyloXmlStart(writer);
        this.writeOutput(writer, tree);
        PhylogenyWriter.writePhyloXmlEnd(writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
        return string_writer.getBuffer();
    }

    public void toPhyloXML(Phylogeny[] trees, int phyloxml_level, File out_file, String separator) throws IOException {
        BufferedWriter writer = new BufferedWriter(new PrintWriter(out_file));
        this.toPhyloXML((Writer)writer, trees, phyloxml_level, separator);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public void toPhyloXML(Phylogeny phy, int phyloxml_level, File out_file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new PrintWriter(out_file));
        this.toPhyloXML(writer, phy, phyloxml_level);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public void toPhyloXML(Writer writer, List<Phylogeny> trees, int phyloxml_level, String separator) throws IOException {
        PhylogenyWriter.writePhyloXmlStart(writer);
        Iterator<Phylogeny> it = trees.iterator();
        while (it.hasNext()) {
            this.toPhyloXMLNoPhyloXmlSource(writer, it.next(), phyloxml_level);
            writer.write(separator);
        }
        PhylogenyWriter.writePhyloXmlEnd(writer);
    }

    public void toPhyloXML(Writer writer, Phylogeny tree, int phyloxml_level) throws IOException {
        this.setPhyloXmlLevel(phyloxml_level);
        this.setOutputFormt(FORMAT.PHYLO_XML);
        PhylogenyWriter.writePhyloXmlStart(writer);
        this.writeOutput(writer, tree);
        PhylogenyWriter.writePhyloXmlEnd(writer);
    }

    public void toPhyloXML(Writer writer, Phylogeny[] trees, int phyloxml_level, String separator) throws IOException {
        PhylogenyWriter.writePhyloXmlStart(writer);
        for (Phylogeny phylogeny : trees) {
            this.toPhyloXMLNoPhyloXmlSource(writer, phylogeny, phyloxml_level);
            writer.write(separator);
        }
        PhylogenyWriter.writePhyloXmlEnd(writer);
    }

    private void toPhyloXMLNoPhyloXmlSource(Writer writer, Phylogeny tree, int phyloxml_level) throws IOException {
        this.setPhyloXmlLevel(phyloxml_level);
        this.setOutputFormt(FORMAT.PHYLO_XML);
        this.writeOutput(writer, tree);
    }

    private void writeCladeSeparator() {
        this.setSawComma(true);
        if (this.getOutputFormt() == FORMAT.NHX || this.getOutputFormt() == FORMAT.NH) {
            this.getBuffer().append(",");
        }
    }

    private void writeCloseClade() throws IOException {
        this.decreaseNodeLevel();
        if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
            this.getWriter().write(ForesterUtil.LINE_SEPARATOR);
            if (this.isIndentPhyloxml()) {
                this.getWriter().write(this.createIndentation().toString());
            }
            PhylogenyDataUtil.appendClose(this.getWriter(), "clade");
        } else if (this.getOutputFormt() == FORMAT.NHX || this.getOutputFormt() == FORMAT.NH) {
            this.getBuffer().append(")");
        }
    }

    private void writeNode(PhylogenyNode node, StringBuffer indentation) throws IOException {
        if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
            if (node.isExternal()) {
                this.getWriter().write(ForesterUtil.LINE_SEPARATOR);
                if (indentation != null) {
                    this.getWriter().write(indentation.toString());
                }
                PhylogenyDataUtil.appendOpen(this.getWriter(), "clade");
            }
            PhyloXmlNodeWriter.toPhyloXml(this.getWriter(), node, this.getPhyloXmlLevel(), indentation != null ? indentation.toString() : "");
            if (node.isExternal()) {
                this.getWriter().write(ForesterUtil.LINE_SEPARATOR);
                if (indentation != null) {
                    this.getWriter().write(indentation.toString());
                }
                PhylogenyDataUtil.appendClose(this.getWriter(), "clade");
            }
        } else if (this.getOutputFormt() == FORMAT.NHX) {
            this.getBuffer().append(node.toNewHampshireX());
        } else if (this.getOutputFormt() == FORMAT.NH) {
            this.getBuffer().append(node.toNewHampshire(this.isWriteDistanceToParentInNH(), this.getNhConversionSupportStyle()));
        }
    }

    private PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE getNhConversionSupportStyle() {
        return this._nh_conversion_support_style;
    }

    private void setNhConversionSupportStyle(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE nh_conversion_support_style) {
        this._nh_conversion_support_style = nh_conversion_support_style;
    }

    private void writeOpenClade(PhylogenyNode node) throws IOException {
        if (!this.isSawComma()) {
            if (!node.isRoot() && node.isFirstChildNode()) {
                this.increaseNodeLevel();
            }
            if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
                this.getWriter().write(ForesterUtil.LINE_SEPARATOR);
                if (this.isIndentPhyloxml()) {
                    this.getWriter().write(this.createIndentation().toString());
                }
                if (node.isCollapse()) {
                    PhylogenyDataUtil.appendOpen(this.getWriter(), "clade", "collapse", "true");
                } else {
                    PhylogenyDataUtil.appendOpen(this.getWriter(), "clade");
                }
            } else if (this.getOutputFormt() == FORMAT.NHX || this.getOutputFormt() == FORMAT.NH) {
                this.getBuffer().append("(");
            }
        }
        this.setSawComma(false);
    }

    private void writeOutput(Writer writer, Phylogeny tree) throws IOException {
        if (this.getOutputFormt() != FORMAT.PHYLO_XML) {
            throw new RuntimeException("method inappropriately called");
        }
        if (tree != null) {
            this.reset(writer, tree);
            String unit = "";
            String type = "";
            if (!ForesterUtil.isEmpty(tree.getDistanceUnit())) {
                unit = tree.getDistanceUnit();
            }
            if (!ForesterUtil.isEmpty(tree.getType())) {
                type = tree.getType();
            }
            PhylogenyDataUtil.appendOpen(writer, "phylogeny", "rooted", tree.isRooted() + "", "branch_length_unit", unit, "type", type, "rerootable", tree.isRerootable() + "");
            this.appendPhylogenyLevelPhyloXml(writer, tree);
            while (this.isHasNext()) {
                this.next();
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
            PhylogenyDataUtil.appendClose(writer, "phylogeny");
        }
    }

    private void writeToFile(StringBuffer sb, File out_file) throws IOException {
        if (out_file.exists()) {
            throw new IOException("attempt to overwrite existing file \"" + out_file.getAbsolutePath() + "\"");
        }
        PrintWriter out = new PrintWriter((Writer)new FileWriter(out_file), true);
        if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
            out.print(PHYLO_XML_VERSION_ENCODING_LINE);
            out.print(ForesterUtil.LINE_SEPARATOR);
            out.print(PHYLO_XML_NAMESPACE_LINE);
            out.print(ForesterUtil.LINE_SEPARATOR);
        }
        out.print(sb);
        if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
            out.print(ForesterUtil.LINE_SEPARATOR);
            out.print(PHYLO_XML_END);
        }
        out.flush();
        out.close();
    }

    public static PhylogenyWriter createPhylogenyWriter() {
        return new PhylogenyWriter();
    }

    private static void writeNexusStart(Writer writer) throws IOException {
        writer.write("#NEXUS");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    public static void writeNexusTaxaBlock(Writer writer, Phylogeny tree) throws IOException {
        writer.write("Begin Taxa;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(" ");
        writer.write("Dimensions");
        writer.write(" ");
        writer.write("NTax");
        writer.write("=");
        writer.write(String.valueOf(tree.getNumberOfExternalNodes()));
        writer.write(";");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(" ");
        writer.write("TaxLabels");
        PhylogenyNodeIterator it = tree.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode node = it.next();
            writer.write(" ");
            String data = "";
            if (!ForesterUtil.isEmpty(node.getName())) {
                data = node.getName();
            } else if (node.getNodeData().isHasTaxonomy()) {
                if (!ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getTaxonomyCode())) {
                    data = node.getNodeData().getTaxonomy().getTaxonomyCode();
                } else if (!ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getScientificName())) {
                    data = node.getNodeData().getTaxonomy().getScientificName();
                } else if (!ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getCommonName())) {
                    data = node.getNodeData().getTaxonomy().getCommonName();
                }
            } else if (node.getNodeData().isHasSequence()) {
                if (!ForesterUtil.isEmpty(node.getNodeData().getSequence().getName())) {
                    data = node.getNodeData().getSequence().getName();
                } else if (!ForesterUtil.isEmpty(node.getNodeData().getSequence().getSymbol())) {
                    data = node.getNodeData().getSequence().getSymbol();
                } else if (!ForesterUtil.isEmpty(node.getNodeData().getSequence().getGeneName())) {
                    data = node.getNodeData().getSequence().getGeneName();
                }
            }
            writer.write(ForesterUtil.santitizeStringForNH(data).toString());
        }
        writer.write(";");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("End;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    public static void writeNexusTreesBlock(Writer writer, List<Phylogeny> trees, PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE svs) throws IOException {
        writer.write("Begin Trees;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        int i = 1;
        for (Phylogeny phylogeny : trees) {
            writer.write(" ");
            writer.write("Tree");
            writer.write(" ");
            if (!ForesterUtil.isEmpty(phylogeny.getName())) {
                writer.write("'");
                writer.write(phylogeny.getName());
                writer.write("'");
            } else {
                writer.write("tree");
                writer.write(String.valueOf(i));
            }
            writer.write("=");
            if (phylogeny.isRooted()) {
                writer.write("[&R]");
            } else {
                writer.write("[&U]");
            }
            writer.write(phylogeny.toNewHampshire(svs));
            writer.write(ForesterUtil.LINE_SEPARATOR);
            ++i;
        }
        writer.write("End;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    private static void writePhyloXmlEnd(Writer writer) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(PHYLO_XML_END);
    }

    private static void writePhyloXmlStart(Writer writer) throws IOException {
        writer.write(PHYLO_XML_VERSION_ENCODING_LINE);
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(PHYLO_XML_NAMESPACE_LINE);
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    public static enum FORMAT {
        NH,
        NHX,
        PHYLO_XML,
        NEXUS;

    }
}

