/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import java.util.List;
import org.forester.msa.BasicMsa;
import org.forester.msa.Msa;
import org.forester.msa.MsaMethods;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;

public final class DeleteableMsa
extends BasicMsa {
    private int _length = 0;
    private int[] _mapped_col_positions = null;
    private int[] _mapped_row_positions = null;
    private int _seqs = 0;

    private DeleteableMsa(BasicMsa msa) {
        super(msa);
        int i;
        this._mapped_col_positions = new int[msa.getLength()];
        this._mapped_row_positions = new int[msa.getNumberOfSequences()];
        for (i = 0; i < this._mapped_col_positions.length; ++i) {
            this._mapped_col_positions[i] = i;
        }
        for (i = 0; i < this._mapped_row_positions.length; ++i) {
            this._mapped_row_positions[i] = i;
        }
        this._length = msa.getLength();
        this._seqs = msa.getNumberOfSequences();
    }

    public final double[] calcGappiness() {
        int length = this.getLength();
        double[] gappiness = new double[length];
        int seqs = this.getNumberOfSequences();
        for (int row = 0; row < seqs; ++row) {
            for (int col = 0; col < length; ++col) {
            }
        }
        return gappiness;
    }

    public static int calcGapSumPerColumn(Msa msa, int col) {
        int gap_rows = 0;
        for (int j = 0; j < msa.getNumberOfSequences(); ++j) {
            if (!msa.isGapAt(j, col)) continue;
            ++gap_rows;
        }
        return gap_rows;
    }

    public short determineMaxIdLength() {
        short max = 0;
        for (int row = 0; row < this.getNumberOfSequences(); ++row) {
            short l = (short)this.getIdentifier(row).length();
            if (l <= max) continue;
            max = l;
        }
        return max;
    }

    public final void deleteGapColumns(double max_allowed_gap_ratio) {
        if (max_allowed_gap_ratio < 0.0 || max_allowed_gap_ratio > 1.0) {
            throw new IllegalArgumentException("max allowed gap ration is out of range: " + max_allowed_gap_ratio);
        }
        for (int col = this.getLength() - 1; col >= 0; --col) {
            boolean delete;
            boolean bl = delete = (double)MsaMethods.calcGapSumPerColumn(this, col) / (double)this.getNumberOfSequences() > max_allowed_gap_ratio;
            if (!delete) continue;
            this.deleteColumn(col);
        }
    }

    public final void deleteGapOnlyColumns() {
        for (int col = this.getLength() - 1; col >= 0; --col) {
            if (!this.isAllGap(col)) continue;
            this.deleteColumn(col);
        }
    }

    public final MolecularSequence deleteRow(String id, boolean return_removed_seq) {
        int row = -1;
        for (int r = 0; r < this.getNumberOfSequences(); ++r) {
            if (!this.getIdentifier(r).equals(id)) continue;
            row = r;
            break;
        }
        if (row < 0) {
            throw new IllegalArgumentException("id [" + id + "] not found");
        }
        MolecularSequence s2 = null;
        StringBuilder sb = null;
        if (return_removed_seq) {
            s2 = this.getSequence(row);
            char[] x = s2.getMolecularSequence();
            sb = new StringBuilder(x.length);
            for (char element : x) {
                if (element == '-') continue;
                sb.append(element);
            }
        }
        this.deleteRow(row);
        if (return_removed_seq) {
            return new BasicSequence(new String(s2.getIdentifier()), sb.toString(), s2.getType());
        }
        return null;
    }

    @Override
    public final String getIdentifier(int row) {
        this.checkRow(row);
        return super.getIdentifier(this._mapped_row_positions[row]);
    }

    @Override
    public final int getLength() {
        return this._length;
    }

    @Override
    public final int getNumberOfSequences() {
        return this._seqs;
    }

    @Override
    public final char getResidueAt(int row, int col) {
        this.checkRow(row);
        this.checkColumn(col);
        return super.getResidueAt(this._mapped_row_positions[row], this._mapped_col_positions[col]);
    }

    @Override
    public MolecularSequence getSequence(int row) {
        this.checkRow(row);
        return new BasicSequence(this.getIdentifier(row), this.getSequenceAsString(row).toString(), this.getType());
    }

    public final boolean isAllGap(int col) {
        int m_col = this._mapped_col_positions[col];
        for (int j = 0; j < this.getNumberOfSequences(); ++j) {
            if (super.getResidueAt(this._mapped_row_positions[j], m_col) == '-') continue;
            return false;
        }
        return true;
    }

    @Override
    public final void setIdentifier(int row, String id) {
        this.checkRow(row);
        super.setIdentifier(this._mapped_row_positions[row], id);
    }

    @Override
    public final void setResidueAt(int row, int col, char residue) {
        this.checkRow(row);
        this.checkColumn(col);
        super.setResidueAt(this._mapped_row_positions[row], this._mapped_col_positions[col], residue);
    }

    private final void checkColumn(int col) {
        if (col >= this._length || col < 0) {
            throw new IllegalArgumentException("column " + col + " is out of range");
        }
    }

    private final void checkRow(int row) {
        if (row >= this._seqs || row < 0) {
            throw new IllegalArgumentException("row " + row + " is out of range");
        }
    }

    private final void deleteColumn(int col) {
        this.checkColumn(col);
        for (int c = col; c < this._length - 1; ++c) {
            this._mapped_col_positions[c] = this._mapped_col_positions[c + 1];
        }
        --this._length;
    }

    private final void deleteRow(int row) {
        this.checkRow(row);
        for (int r = row; r < this._seqs - 1; ++r) {
            this._mapped_row_positions[r] = this._mapped_row_positions[r + 1];
        }
        --this._seqs;
    }

    public static final DeleteableMsa createInstance(List<MolecularSequence> seqs) {
        return new DeleteableMsa((BasicMsa)BasicMsa.createInstance(seqs));
    }

    public static final DeleteableMsa createInstance(Msa msa) {
        return new DeleteableMsa((BasicMsa)msa);
    }
}

