/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa_compactor;

import com.approximatrix.charting.coordsystem.BoxCoordSystem;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.MultiScatterDataModel;
import com.approximatrix.charting.render.MultiScatterChartRenderer;
import com.approximatrix.charting.swing.ChartPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.forester.msa_compactor.MsaProperties;
import org.forester.util.ForesterUtil;

public final class Chart
extends JDialog
implements ActionListener {
    private static final NumberFormat NF_1 = new DecimalFormat("0.##");
    private static final long serialVersionUID = -5292420246132943515L;
    private ChartPanel _chart_panel = null;
    private final int _initial_number_of_seqs;
    private final JMenuItem _m_exit = new JMenuItem();
    private final List<MsaProperties> _msa_props;
    private final boolean _show_msa_qual;
    private final String _title;

    private Chart(List<MsaProperties> msa_props, int initial_number_of_seqs, boolean show_msa_qual, String title) {
        this._msa_props = msa_props;
        this._title = title;
        this._initial_number_of_seqs = initial_number_of_seqs;
        this._show_msa_qual = show_msa_qual;
        this.setTitle("msa compactor");
        this.setSize(600, 500);
        this.setResizable(true);
        JPanel content_pane = new JPanel();
        content_pane.setLayout(new BorderLayout());
        this.setContentPane(content_pane);
        JMenuBar menu_bar = new JMenuBar();
        JMenu file_menu = new JMenu();
        file_menu.setText("File");
        this._m_exit.setText("Exit");
        file_menu.add(this._m_exit);
        menu_bar.add(file_menu);
        this.setJMenuBar(menu_bar);
        this.setDefaultCloseOperation(2);
        this._m_exit.addActionListener(this);
        content_pane.add((Component)this.obtainChartPanel(), "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._m_exit) {
            this.dispose();
        }
    }

    private ChartPanel obtainChartPanel() {
        if (this._chart_panel == null) {
            MultiScatterDataModel model = new MultiScatterDataModel();
            double[][] seqs_length = new double[this._msa_props.size()][2];
            int max_length = -1;
            int min_length = Integer.MAX_VALUE;
            double max_gap_ratio = -1.0;
            double min_gap_ratio = Double.MAX_VALUE;
            double max_avg_gap_count = -1.0;
            double min_avg_gap_count = Double.MAX_VALUE;
            for (int i = 0; i < this._msa_props.size(); ++i) {
                double avg_gap_count;
                double gap_ratio;
                seqs_length[i][0] = this._initial_number_of_seqs - this._msa_props.get(i).getNumberOfSequences();
                int length = this._msa_props.get(i).getLength();
                seqs_length[i][1] = length;
                if (length > max_length) {
                    max_length = length;
                }
                if (length < min_length) {
                    min_length = length;
                }
                if ((gap_ratio = this._msa_props.get(i).getGapRatio()) > max_gap_ratio) {
                    max_gap_ratio = gap_ratio;
                }
                if (gap_ratio < min_gap_ratio) {
                    min_gap_ratio = gap_ratio;
                }
                if ((avg_gap_count = this._msa_props.get(i).getAvgNumberOfGaps()) > max_avg_gap_count) {
                    max_avg_gap_count = avg_gap_count;
                }
                if (!(avg_gap_count < min_avg_gap_count)) continue;
                min_avg_gap_count = avg_gap_count;
            }
            model.addData(seqs_length, "Length (" + Chart.minMaxToString(min_length, max_length) + ")");
            model.setSeriesLine("Series Length", true);
            model.setSeriesMarker("Series Length", false);
            double[][] seqs_gaps = new double[this._msa_props.size()][2];
            double max_ent7 = -1.0;
            double max_ent21 = -1.0;
            double min_ent7 = Double.MAX_VALUE;
            double min_ent21 = Double.MAX_VALUE;
            if (this._show_msa_qual) {
                for (int i = 0; i < this._msa_props.size(); ++i) {
                    double ent21;
                    double ent7 = this._msa_props.get(i).getEntropy7();
                    if (ent7 > max_ent7) {
                        max_ent7 = ent7;
                    }
                    if (ent7 < max_ent7) {
                        min_ent7 = ent7;
                    }
                    if ((ent21 = this._msa_props.get(i).getEntropy21()) > min_ent21) {
                        max_ent21 = ent21;
                    }
                    if (!(ent21 < min_ent21)) continue;
                    min_ent21 = ent21;
                }
            }
            double gap_ratio_factor = (double)max_length / 2.0 / max_gap_ratio;
            double avg_gaps_counts_factor = (double)max_length / 2.0 / max_avg_gap_count;
            double ent7_factor = (double)max_length / 2.0 / max_ent7;
            double ent21_factor = (double)max_length / 2.0 / max_ent21;
            for (int i = 0; i < this._msa_props.size(); ++i) {
                seqs_gaps[i][0] = this._initial_number_of_seqs - this._msa_props.get(i).getNumberOfSequences();
                seqs_gaps[i][1] = ForesterUtil.roundToInt(this._msa_props.get(i).getGapRatio() * gap_ratio_factor);
            }
            model.addData(seqs_gaps, "Gap Ratio (" + Chart.minMaxToString(min_gap_ratio, max_gap_ratio) + ")");
            model.setSeriesLine("Series Gap Ratio", true);
            model.setSeriesMarker("Series Gap Ratio", false);
            double[][] gap_counts = new double[this._msa_props.size()][2];
            for (int i = 0; i < this._msa_props.size(); ++i) {
                gap_counts[i][0] = this._initial_number_of_seqs - this._msa_props.get(i).getNumberOfSequences();
                gap_counts[i][1] = ForesterUtil.roundToInt(this._msa_props.get(i).getAvgNumberOfGaps() * avg_gaps_counts_factor);
            }
            model.addData(gap_counts, "Mean Gap Count (" + Chart.minMaxToString(min_avg_gap_count, max_avg_gap_count) + ")");
            model.setSeriesLine("Series Mean Gap Count", true);
            model.setSeriesMarker("Series Mean Gap Count", false);
            if (this._show_msa_qual) {
                double[][] entropy7 = new double[this._msa_props.size()][2];
                for (int i = 0; i < this._msa_props.size(); ++i) {
                    entropy7[i][0] = this._initial_number_of_seqs - this._msa_props.get(i).getNumberOfSequences();
                    entropy7[i][1] = ForesterUtil.roundToInt(this._msa_props.get(i).getEntropy7() * ent7_factor);
                }
                model.addData(entropy7, "Entropy norm 7 (" + Chart.minMaxToString(min_ent7, max_ent7) + ")");
                model.setSeriesLine("Series Entropy norm 7", true);
                model.setSeriesMarker("Series Entropy norm 7", false);
                double[][] entropy21 = new double[this._msa_props.size()][2];
                for (int i = 0; i < this._msa_props.size(); ++i) {
                    entropy21[i][0] = this._initial_number_of_seqs - this._msa_props.get(i).getNumberOfSequences();
                    entropy21[i][1] = ForesterUtil.roundToInt(this._msa_props.get(i).getEntropy21() * ent21_factor);
                }
                model.addData(entropy21, "Entropy norm 21 (" + Chart.minMaxToString(min_ent21, max_ent21) + ")");
                model.setSeriesLine("Series Entropy norm 21", true);
                model.setSeriesMarker("Series Entropy norm 21", false);
            }
            BoxCoordSystem coord = new BoxCoordSystem(model);
            coord.setUnitFont(coord.getUnitFont().deriveFont(16.0f));
            coord.setXAxisUnit("Number of Removed Sequences");
            coord.setPaintGrid(true);
            coord.setYAxisUnit("MSA Length");
            this._chart_panel = new ChartPanel(model, this._title);
            this._chart_panel.setCoordSystem(coord);
            MultiScatterChartRenderer renderer = new MultiScatterChartRenderer((CoordSystem)coord, model);
            renderer.setAllowBuffer(false);
            this._chart_panel.addChartRenderer(renderer, 0);
        }
        return this._chart_panel;
    }

    private static final String minMaxToString(double min2, double max) {
        return NF_1.format(min2) + "-" + NF_1.format(max);
    }

    public static void display(List<MsaProperties> msa_props, int initial_number_of_seqs, boolean show_msa_qual, String title) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Chart chart = new Chart(msa_props, initial_number_of_seqs, show_msa_qual, title);
        chart.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Chart temp = new Chart(null, 0, true, "title");
        temp.setVisible(true);
    }
}

