/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import org.forester.pccx.BranchCountingBasedScoringMethod;
import org.forester.pccx.ModelingUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class LogBranchLengthBasedScoringMethod
extends BranchCountingBasedScoringMethod {
    public static final double MIN_ALLOWED_BL_VALUE = 1.0E-4;
    public static final double MAX_ALLOWED_BL_VALUE = 1.0;

    @Override
    double calculateScoreContributionPerExternalNode(PhylogenyNode external_node, PhylogenyNode current_node) {
        double score_contribution = 0.0;
        score_contribution = current_node == external_node ? external_node.getDistanceToParent() : ModelingUtils.calculateBranchLengthSum(external_node, current_node);
        if (score_contribution > 1.0) {
            score_contribution = 1.0;
        } else if (score_contribution < 1.0E-4) {
            score_contribution = 1.0E-4;
        }
        return -Math.log(score_contribution);
    }

    @Override
    public String getDesciption() {
        return "sum of -ln(branch-length-sum) [for self: -ln(branch-length)] [min branch length: 1.0E-4, max branch length: 1.0]";
    }

    @Override
    public double getNormalizationFactor(Phylogeny phylogeny) {
        double s2 = 0.0;
        double d = 0.0;
        PhylogenyNodeIterator iter = phylogeny.iteratorExternalForward();
        while (iter.hasNext()) {
            d = iter.next().getDistanceToParent();
            if (d > 1.0) {
                d = 1.0;
            } else if (d < 1.0E-4) {
                d = 1.0E-4;
            }
            s2 += -Math.log(d);
        }
        return 1.0 / s2;
    }
}

