/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public final class ModelingUtils {
    static double calculateBranchLengthSum(PhylogenyNode n1, PhylogenyNode n2) {
        PhylogenyNode lca = PhylogenyMethods.calculateLCA(n1, n2);
        return ModelingUtils.calculateBranchLengthSumHelper(n1, lca) + ModelingUtils.calculateBranchLengthSumHelper(n2, lca);
    }

    private static double calculateBranchLengthSumHelper(PhylogenyNode outer, PhylogenyNode inner) {
        double l = 0.0;
        for (PhylogenyNode my_outer = outer; my_outer != inner; my_outer = my_outer.getParent()) {
            if (!(my_outer.getDistanceToParent() > 0.0)) continue;
            l += my_outer.getDistanceToParent();
        }
        return l;
    }

    static int calculateBranchSum(PhylogenyNode n1, PhylogenyNode n2) {
        PhylogenyNode lca = PhylogenyMethods.calculateLCA(n1, n2);
        return ModelingUtils.calculateBranchSumHelper(n1, lca) + ModelingUtils.calculateBranchSumHelper(n2, lca);
    }

    private static int calculateBranchSumHelper(PhylogenyNode outer, PhylogenyNode inner) {
        int s2 = 0;
        for (PhylogenyNode my_outer = outer; my_outer != inner; my_outer = my_outer.getParent()) {
            ++s2;
        }
        return s2;
    }

    static SortedMap<PhylogenyNode, Double> setUpExternalCoverageHashMap(Phylogeny phylogeny) {
        TreeMap<PhylogenyNode, Double> external_node_coverage = new TreeMap<PhylogenyNode, Double>();
        PhylogenyNodeIterator iter = phylogeny.iteratorExternalForward();
        while (iter.hasNext()) {
            external_node_coverage.put(iter.next(), 0.0);
        }
        return external_node_coverage;
    }
}

