/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Confidence
implements PhylogenyData,
Comparable<Confidence> {
    public static final int CONFIDENCE_DEFAULT_VALUE = -9999;
    private double _value;
    private double _sd;
    private String _type;
    public static final NumberFormat FORMATTER;

    public Confidence() {
        this.init();
    }

    public Confidence(double value, String type) {
        this.setValue(value);
        this.setType(type);
        this.setStandardDeviation(-9999.0);
    }

    public Confidence(double value, String type, double sd) {
        this.setValue(value);
        this.setType(type);
        this.setStandardDeviation(sd);
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer().append(ForesterUtil.FORMATTER_6.format(this.getValue()));
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getType())) {
            sb.append("[");
            sb.append(this.getType());
            sb.append("] ");
        }
        sb.append(ForesterUtil.FORMATTER_6.format(this.getValue()));
        if (this.getStandardDeviation() != -9999.0) {
            sb.append(" (sd=");
            sb.append(this.getStandardDeviation());
            sb.append(")");
        }
        return sb;
    }

    @Override
    public int compareTo(Confidence confidence) {
        if (this == confidence) {
            return 0;
        }
        return this.getType().compareToIgnoreCase(confidence.getType());
    }

    @Override
    public PhylogenyData copy() {
        return new Confidence(this.getValue(), this.getType(), this.getStandardDeviation());
    }

    public String getType() {
        return this._type;
    }

    public double getValue() {
        return this._value;
    }

    public double getStandardDeviation() {
        return this._sd;
    }

    public void init() {
        this.setValue(-9999.0);
        this.setType("");
        this.setStandardDeviation(-9999.0);
    }

    @Override
    public boolean isEqual(PhylogenyData confidence) {
        if (confidence == null) {
            return false;
        }
        if (!(confidence instanceof Confidence)) {
            return false;
        }
        Confidence s2 = (Confidence)confidence;
        if (s2.getValue() != this.getValue()) {
            return false;
        }
        return s2.getType().equals(this.getType());
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setValue(double value) {
        this._value = value;
    }

    public void setStandardDeviation(double sd) {
        this._sd = sd;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        sb.append("B=");
        sb.append(FORMATTER.format(ForesterUtil.round(this.getValue(), 9)));
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.getValue() == -9999.0) {
            return;
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        if (this.getStandardDeviation() != -9999.0) {
            PhylogenyDataUtil.appendElement(writer, "confidence", FORMATTER.format(ForesterUtil.round(this.getValue(), 9)), "type", ForesterUtil.isEmpty(this.getType()) ? "unknown" : this.getType(), "stddev", String.valueOf(ForesterUtil.round(this.getStandardDeviation(), 9)));
        } else {
            PhylogenyDataUtil.appendElement(writer, "confidence", FORMATTER.format(ForesterUtil.round(this.getValue(), 9)), "type", ForesterUtil.isEmpty(this.getType()) ? "unknown" : this.getType());
        }
    }

    public String toString() {
        return this.asText().toString();
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        FORMATTER = new DecimalFormat("#.#########", dfs);
        FORMATTER.setMaximumFractionDigits(9);
    }
}

