/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Reference;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;

public class NodeData
implements PhylogenyData {
    private String _node_name;
    private Event _event;
    private List<Sequence> _sequences;
    private List<Taxonomy> _taxonomies;
    private List<Distribution> _distributions;
    private Date _date;
    private BinaryCharacters _binary_characters;
    private PropertiesMap _properties;
    private List<Reference> _references;
    private List<Double> _vector;
    private NodeVisualData _node_visual_data;

    public NodeData() {
        this.init();
    }

    private void init() {
        this._node_name = "";
        this._event = null;
        this._sequences = null;
        this._taxonomies = null;
        this._distributions = null;
        this._date = null;
        this._binary_characters = null;
        this._properties = null;
        this._references = null;
        this._vector = null;
        this._node_visual_data = null;
    }

    public void addDistribution(Distribution distribution) {
        if (this._distributions == null) {
            this._distributions = new ArrayList<Distribution>();
        }
        this._distributions.add(distribution);
    }

    public void addReference(Reference reference) {
        if (this._references == null) {
            this._references = new ArrayList<Reference>();
        }
        this._references.add(reference);
    }

    public void addSequence(Sequence sequence) {
        if (this._sequences == null) {
            this._sequences = new ArrayList<Sequence>();
        }
        this._sequences.add(sequence);
    }

    public void addTaxonomy(Taxonomy taxonomy) {
        if (this._taxonomies == null) {
            this._taxonomies = new ArrayList<Taxonomy>();
        }
        this._taxonomies.add(taxonomy);
    }

    @Override
    public StringBuffer asSimpleText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer asText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PhylogenyData copy() {
        NodeData new_data = new NodeData();
        new_data.setNodeName(this.getNodeName());
        if (this.getSequences() != null && this.getSequences().size() > 0) {
            new_data.setSequences(new ArrayList<Sequence>());
            for (Sequence s2 : this.getSequences()) {
                if (s2 == null) continue;
                new_data.addSequence((Sequence)s2.copy());
            }
        }
        if (this.isHasEvent()) {
            new_data.setEvent((Event)this.getEvent().copy());
        }
        if (this.getTaxonomies() != null && this.getTaxonomies().size() > 0) {
            new_data.setTaxonomies(new ArrayList<Taxonomy>());
            for (Taxonomy t : this.getTaxonomies()) {
                if (t == null) continue;
                new_data.addTaxonomy((Taxonomy)t.copy());
            }
        }
        if (this.isHasBinaryCharacters()) {
            new_data.setBinaryCharacters((BinaryCharacters)this.getBinaryCharacters().copy());
        }
        if (this.getReferences() != null && this.getReferences().size() > 0) {
            new_data.setReferences(new ArrayList<Reference>());
            for (Reference r : this.getReferences()) {
                if (r == null) continue;
                new_data.addReference((Reference)r.copy());
            }
        }
        if (this.getDistributions() != null && this.getDistributions().size() > 0) {
            new_data.setDistributions(new ArrayList<Distribution>());
            for (Distribution d : this.getDistributions()) {
                if (d == null) continue;
                new_data.addDistribution((Distribution)d.copy());
            }
        }
        if (this.getNodeVisualData() != null && !this.getNodeVisualData().isEmpty()) {
            new_data.setNodeVisualData((NodeVisualData)this.getNodeVisualData().copy());
        }
        if (this.isHasDate()) {
            new_data.setDate((Date)this.getDate().copy());
        }
        if (this.isHasProperties()) {
            new_data.setProperties((PropertiesMap)this.getProperties().copy());
        }
        return new_data;
    }

    public BinaryCharacters getBinaryCharacters() {
        return this._binary_characters;
    }

    public Date getDate() {
        return this._date;
    }

    public Distribution getDistribution() {
        return this.getDistribution(0);
    }

    public Distribution getDistribution(int index) {
        if (this._distributions == null) {
            return null;
        }
        return this._distributions.get(index);
    }

    public List<Distribution> getDistributions() {
        return this._distributions;
    }

    public Event getEvent() {
        return this._event;
    }

    public PropertiesMap getProperties() {
        return this._properties;
    }

    public Reference getReference() {
        return this.getReference(0);
    }

    public Reference getReference(int index) {
        if (this._references == null) {
            return null;
        }
        return this._references.get(index);
    }

    public List<Reference> getReferences() {
        return this._references;
    }

    public Sequence getSequence() {
        return this.getSequence(0);
    }

    public Sequence getSequence(int index) {
        if (this._sequences == null) {
            return null;
        }
        return this._sequences.get(index);
    }

    public List<Sequence> getSequences() {
        return this._sequences;
    }

    public List<Taxonomy> getTaxonomies() {
        return this._taxonomies;
    }

    public Taxonomy getTaxonomy() {
        return this.getTaxonomy(0);
    }

    public Taxonomy getTaxonomy(int index) {
        if (this._taxonomies == null) {
            return null;
        }
        return this._taxonomies.get(index);
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        throw new NoSuchMethodError();
    }

    public boolean isHasBinaryCharacters() {
        return this.getBinaryCharacters() != null;
    }

    public boolean isEmpty() {
        return ForesterUtil.isEmpty(this._node_name) && !this.isHasSequence() && !this.isHasTaxonomy() && !this.isHasBinaryCharacters() && !this.isHasDate() && !this.isHasDistribution() && !this.isHasEvent() && !this.isHasProperties() && !this.isHasReference() && (this._vector == null || this._vector.isEmpty());
    }

    public boolean isHasDate() {
        return this.getDate() != null && (!ForesterUtil.isEmpty(this.getDate().getDesc()) || !ForesterUtil.isNull(this.getDate().getMax()) || !ForesterUtil.isNull(this.getDate().getMin()) || !ForesterUtil.isNull(this.getDate().getValue()) || !ForesterUtil.isEmpty(this.getDate().getUnit()));
    }

    public boolean isHasDistribution() {
        return this.getDistributions() != null && this.getDistributions().size() > 0 && (!ForesterUtil.isEmpty(this.getDistribution().getDesc()) || this.getDistribution().getPoints() != null && this.getDistribution().getPoints().size() > 0 || this.getDistribution().getPolygons() != null && this.getDistribution().getPolygons().size() > 0);
    }

    public boolean isHasEvent() {
        return this.getEvent() != null;
    }

    public boolean isHasProperties() {
        return this.getProperties() != null && this.getProperties().size() > 0;
    }

    public boolean isHasReference() {
        return this.getReferences() != null && this.getReferences().size() > 0 && (!ForesterUtil.isEmpty(this.getReference().getDoi()) || !ForesterUtil.isEmpty(this.getReference().getDescription()));
    }

    public boolean isHasSequence() {
        return this.getSequences() != null && this.getSequences().size() > 0 && this.getSequences().get(0) != null;
    }

    public boolean isHasTaxonomy() {
        return this.getTaxonomies() != null && this.getTaxonomies().size() > 0 && this.getTaxonomies().get(0) != null;
    }

    public void setBinaryCharacters(BinaryCharacters binary_characters) {
        this._binary_characters = binary_characters;
    }

    public void setDate(Date date) {
        this._date = date;
    }

    public void setDistribution(Distribution distribution) {
        if (this._distributions == null) {
            this._distributions = new ArrayList<Distribution>();
        }
        if (this._distributions.size() == 0) {
            this._distributions.add(distribution);
        } else {
            this._distributions.set(0, distribution);
        }
    }

    public void setDistribution(int index, Distribution distribution) {
        if (this._distributions == null) {
            this._distributions = new ArrayList<Distribution>();
        }
        this._distributions.set(index, distribution);
    }

    private void setDistributions(List<Distribution> distributions) {
        this._distributions = distributions;
    }

    public void setEvent(Event event) {
        this._event = event;
    }

    public void setProperties(PropertiesMap custom_data) {
        this._properties = custom_data;
    }

    public void setReference(int index, Reference reference) {
        if (this._references == null) {
            this._references = new ArrayList<Reference>();
        }
        this._references.set(index, reference);
    }

    public void setReference(Reference reference) {
        if (this._references == null) {
            this._references = new ArrayList<Reference>();
        }
        if (this._references.size() == 0) {
            this._references.add(reference);
        } else {
            this._references.set(0, reference);
        }
    }

    private void setReferences(List<Reference> references) {
        this._references = references;
    }

    public void setSequence(int index, Sequence sequence) {
        if (this._sequences == null) {
            this._sequences = new ArrayList<Sequence>();
        }
        this._sequences.set(index, sequence);
    }

    public void setSequence(Sequence sequence) {
        if (this._sequences == null) {
            this._sequences = new ArrayList<Sequence>();
        }
        if (this._sequences.size() == 0) {
            this._sequences.add(sequence);
        } else {
            this._sequences.set(0, sequence);
        }
    }

    private void setSequences(List<Sequence> sequences) {
        this._sequences = sequences;
    }

    private void setTaxonomies(List<Taxonomy> taxonomies) {
        this._taxonomies = taxonomies;
    }

    public void setTaxonomy(int index, Taxonomy taxonomy) {
        if (this._taxonomies == null) {
            this._taxonomies = new ArrayList<Taxonomy>();
        }
        this._taxonomies.set(index, taxonomy);
    }

    public void setTaxonomy(Taxonomy taxonomy) {
        if (this._taxonomies == null) {
            this._taxonomies = new ArrayList<Taxonomy>();
        }
        if (this._taxonomies.size() == 0) {
            this._taxonomies.add(taxonomy);
        } else {
            this._taxonomies.set(0, taxonomy);
        }
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        if (this.isHasTaxonomy()) {
            sb.append(this.getTaxonomy().toNHX());
        }
        if (this.isHasSequence()) {
            sb.append(this.getSequence().toNHX());
        }
        if (this.isHasEvent()) {
            sb.append(this.getEvent().toNHX());
        }
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.isHasTaxonomy()) {
            for (Taxonomy t : this.getTaxonomies()) {
                if (t.isEmpty()) continue;
                t.toPhyloXML(writer, level, indentation);
            }
        }
        if (this.isHasSequence()) {
            for (Sequence s2 : this.getSequences()) {
                if (s2.isEmpty()) continue;
                s2.toPhyloXML(writer, level, indentation);
            }
        }
        if (this.isHasEvent()) {
            this.getEvent().toPhyloXML(writer, level, indentation);
        }
        if (this.isHasBinaryCharacters()) {
            this.getBinaryCharacters().toPhyloXML(writer, level, indentation);
        }
        if (this.isHasDistribution()) {
            for (Distribution d : this.getDistributions()) {
                d.toPhyloXML(writer, level, indentation);
            }
        }
        if (this.isHasDate()) {
            this.getDate().toPhyloXML(writer, level, indentation);
        }
        if (this.isHasReference()) {
            for (Reference r : this.getReferences()) {
                r.toPhyloXML(writer, level, indentation);
            }
        }
        if (this.isHasProperties()) {
            this.getProperties().toPhyloXML(writer, level, indentation.substring(0, indentation.length() - 2));
        }
        if (level == 0 && this.getNodeVisualData() != null && !this.getNodeVisualData().isEmpty()) {
            this.getNodeVisualData().toPhyloXML(writer, level, indentation.substring(0, indentation.length() - 2));
        }
        if (this.getVector() != null && !this.getVector().isEmpty() && (this.getProperties() == null || this.getProperties().getPropertiesWithGivenReferencePrefix("vector:index=").isEmpty())) {
            List<Property> ps = this.vectorToProperties(this.getVector());
            String my_indent = indentation.substring(0, indentation.length() - 2);
            for (Property p : ps) {
                p.toPhyloXML(writer, level, my_indent);
            }
        }
    }

    private List<Property> vectorToProperties(List<Double> vector) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (int i = 0; i < vector.size(); ++i) {
            properties.add(new Property("vector:index=" + i, String.valueOf(vector.get(i)), "", "xsd:decimal", Property.AppliesTo.NODE));
        }
        return properties;
    }

    public void setVector(List<Double> vector) {
        this._vector = vector;
    }

    public List<Double> getVector() {
        return this._vector;
    }

    public String getNodeName() {
        return this._node_name;
    }

    public void setNodeName(String node_name) {
        this._node_name = node_name;
    }

    public void setNodeVisualData(NodeVisualData node_visual_data) {
        this._node_visual_data = node_visual_data;
    }

    public NodeVisualData getNodeVisualData() {
        return this._node_visual_data;
    }
}

