/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.MultipleUris;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.data.Uri;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;

public class Sequence
implements PhylogenyData,
MultipleUris,
Comparable<Sequence> {
    private Accession _accession;
    private SortedSet<Annotation> _annotations;
    private DomainArchitecture _da;
    private String _gene_name;
    private String _location;
    private String _mol_sequence;
    private boolean _mol_sequence_is_aligned;
    private String _name;
    private List<SequenceRelation> _seq_relations;
    private String _source_id;
    private String _symbol;
    private String _type;
    private List<Uri> _uris;
    private SortedSet<Accession> _xrefs;

    public Sequence() {
        this.init();
    }

    public Sequence(MolecularSequence mol_seq) {
        String type;
        this.init();
        this.setMolecularSequence(mol_seq.getMolecularSequenceAsString());
        this.setName(mol_seq.getIdentifier());
        if (mol_seq.getType() == MolecularSequence.TYPE.AA) {
            type = "protein";
        } else if (mol_seq.getType() == MolecularSequence.TYPE.DNA) {
            type = "dna";
        } else if (mol_seq.getType() == MolecularSequence.TYPE.RNA) {
            type = "rna";
        } else {
            throw new IllegalArgumentException("unknown sequence type " + (Object)((Object)mol_seq.getType()));
        }
        try {
            this.setType(type);
        }
        catch (PhyloXmlDataFormatException e) {
            throw new IllegalArgumentException("don't know how to handle type " + (Object)((Object)mol_seq.getType()));
        }
    }

    public void addAnnotation(Annotation annotation) {
        this.getAnnotations().add(annotation);
    }

    public void addCrossReference(Accession cross_reference) {
        if (this.getCrossReferences() == null) {
            this.setCrossReferences(new TreeSet<Accession>());
        }
        this.getCrossReferences().add(cross_reference);
    }

    public void addSequenceRelation(SequenceRelation sr) {
        this.getSequenceRelations().add(sr);
    }

    @Override
    public void addUri(Uri uri) {
        if (this.getUris() == null) {
            this.setUris(new ArrayList<Uri>());
        }
        this.getUris().add(uri);
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer sb = new StringBuffer();
        if (this.getAccession() != null) {
            sb.append("[");
            sb.append(this.getAccession());
            sb.append("] ");
        }
        if (!ForesterUtil.isEmpty(this.getName())) {
            sb.append(this.getName());
            sb.append(" ");
        }
        if (!ForesterUtil.isEmpty(this.getLocation())) {
            sb.append(this.getLocation());
        }
        return sb;
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public int compareTo(Sequence o) {
        if (!ForesterUtil.isEmpty(this.getName()) && !ForesterUtil.isEmpty(o.getName())) {
            return this.getName().compareTo(o.getName());
        }
        if (!ForesterUtil.isEmpty(this.getSymbol()) && !ForesterUtil.isEmpty(o.getSymbol())) {
            return this.getSymbol().compareTo(o.getSymbol());
        }
        if (!ForesterUtil.isEmpty(this.getGeneName()) && !ForesterUtil.isEmpty(o.getGeneName())) {
            return this.getGeneName().compareTo(o.getGeneName());
        }
        if (this.getAccession() != null && o.getAccession() != null && !ForesterUtil.isEmpty(this.getAccession().getValue()) && !ForesterUtil.isEmpty(o.getAccession().getValue())) {
            return this.getAccession().getValue().compareTo(o.getAccession().getValue());
        }
        if (!ForesterUtil.isEmpty(this.getMolecularSequence()) && !ForesterUtil.isEmpty(o.getMolecularSequence())) {
            return this.getMolecularSequence().compareTo(o.getMolecularSequence());
        }
        return 0;
    }

    @Override
    public PhylogenyData copy() {
        Sequence seq = new Sequence();
        seq.setAnnotations(this.getAnnotations());
        seq.setName(this.getName());
        seq.setGeneName(this.getGeneName());
        try {
            seq.setSymbol(this.getSymbol());
        }
        catch (PhyloXmlDataFormatException e) {
            e.printStackTrace();
        }
        seq.setMolecularSequence(this.getMolecularSequence());
        seq.setMolecularSequenceAligned(this.isMolecularSequenceAligned());
        seq.setLocation(this.getLocation());
        if (this.getAccession() != null) {
            seq.setAccession((Accession)this.getAccession().copy());
        } else {
            seq.setAccession(null);
        }
        try {
            seq.setType(this.getType());
        }
        catch (PhyloXmlDataFormatException e) {
            e.printStackTrace();
        }
        if (this.getUris() != null) {
            seq.setUris(new ArrayList<Uri>());
            for (Uri uri : this.getUris()) {
                if (uri == null) continue;
                seq.getUris().add(uri);
            }
        }
        if (this.getDomainArchitecture() != null) {
            seq.setDomainArchitecture((DomainArchitecture)this.getDomainArchitecture().copy());
        } else {
            seq.setDomainArchitecture(null);
        }
        if (this.getCrossReferences() != null) {
            seq.setCrossReferences(new TreeSet<Accession>());
            for (Accession x : this.getCrossReferences()) {
                if (x == null) continue;
                seq.getCrossReferences().add(x);
            }
        }
        return seq;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        return this.isEqual((Sequence)o);
    }

    public Accession getAccession() {
        return this._accession;
    }

    public Annotation getAnnotation(int i) {
        return (Annotation)this.getAnnotations().toArray()[i];
    }

    public SortedSet<Annotation> getAnnotations() {
        if (this._annotations == null) {
            this._annotations = new TreeSet<Annotation>();
        }
        return this._annotations;
    }

    public SortedSet<Accession> getCrossReferences() {
        return this._xrefs;
    }

    public DomainArchitecture getDomainArchitecture() {
        return this._da;
    }

    public String getGeneName() {
        return this._gene_name;
    }

    public String getLocation() {
        return this._location;
    }

    public String getMolecularSequence() {
        return this._mol_sequence;
    }

    public String getName() {
        return this._name;
    }

    public List<SequenceRelation> getSequenceRelations() {
        if (this._seq_relations == null) {
            this._seq_relations = new ArrayList<SequenceRelation>();
        }
        return this._seq_relations;
    }

    public String getSourceId() {
        return this._source_id;
    }

    public String getSymbol() {
        return this._symbol;
    }

    public String getType() {
        return this._type;
    }

    @Override
    public Uri getUri(int index) {
        return this.getUris().get(index);
    }

    @Override
    public List<Uri> getUris() {
        return this._uris;
    }

    public int hashCode() {
        if (this.getAccession() != null) {
            return this.getAccession().hashCode();
        }
        int result = this.getName().hashCode();
        if (this.getSymbol().length() > 0) {
            result ^= this.getName().hashCode();
        }
        if (this.getGeneName().length() > 0) {
            result ^= this.getGeneName().hashCode();
        }
        if (this.getMolecularSequence().length() > 0) {
            result ^= this.getMolecularSequence().hashCode();
        }
        return result;
    }

    public boolean hasSequenceRelations() {
        return this._seq_relations.size() > 0;
    }

    public void init() {
        this.setName("");
        this.setGeneName("");
        this.setMolecularSequence("");
        this.setMolecularSequenceAligned(false);
        this.setLocation("");
        this.setAccession(null);
        try {
            this.setSymbol("");
        }
        catch (PhyloXmlDataFormatException e) {
            e.printStackTrace();
        }
        try {
            this.setType("");
        }
        catch (PhyloXmlDataFormatException e) {
            e.printStackTrace();
        }
        this.setDomainArchitecture(null);
        this.setUris(null);
        this.setSequenceRelations(null);
        this.setSourceId(null);
        this.setCrossReferences(null);
        this.setAnnotations(null);
    }

    public boolean isEmpty() {
        return this.getAccession() == null && ForesterUtil.isEmpty(this.getName()) && ForesterUtil.isEmpty(this.getSymbol()) && ForesterUtil.isEmpty(this.getGeneName()) && ForesterUtil.isEmpty(this.getType()) && ForesterUtil.isEmpty(this.getLocation()) && ForesterUtil.isEmpty(this.getSourceId()) && ForesterUtil.isEmpty(this.getMolecularSequence()) && this.getDomainArchitecture() == null && ForesterUtil.isEmpty(this._annotations) && ForesterUtil.isEmpty(this._uris) && ForesterUtil.isEmpty(this._seq_relations) && (this.getCrossReferences() == null || this.getCrossReferences().isEmpty());
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        if (this == data) {
            return true;
        }
        Sequence s2 = (Sequence)data;
        if (this.getAccession() != null && s2.getAccession() != null) {
            return this.getAccession().isEqual(s2.getAccession());
        }
        return s2.getMolecularSequence().equals(this.getMolecularSequence()) && s2.getName().equals(this.getName()) && s2.getSymbol().equals(this.getSymbol()) && s2.getGeneName().equals(this.getGeneName());
    }

    public boolean isMolecularSequenceAligned() {
        return this._mol_sequence_is_aligned;
    }

    public void setAccession(Accession accession) {
        this._accession = accession;
    }

    public void setDomainArchitecture(DomainArchitecture ds) {
        this._da = ds;
    }

    public void setGeneName(String gene_name) {
        this._gene_name = gene_name;
    }

    public void setLocation(String description) {
        this._location = description;
    }

    public void setMolecularSequence(String mol_sequence) {
        this._mol_sequence = mol_sequence;
    }

    public void setMolecularSequenceAligned(boolean aligned) {
        this._mol_sequence_is_aligned = aligned;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setSourceId(String source_id) {
        this._source_id = source_id;
    }

    public void setSymbol(String symbol) throws PhyloXmlDataFormatException {
        if (!ForesterUtil.isEmpty(symbol) && !PhyloXmlUtil.SEQUENCE_SYMBOL_PATTERN.matcher(symbol).matches()) {
            throw new PhyloXmlDataFormatException("illegal sequence symbol: [" + symbol + "]");
        }
        this._symbol = symbol;
    }

    public void setType(String type) throws PhyloXmlDataFormatException {
        if (!ForesterUtil.isEmpty(type) && !PhyloXmlUtil.SEQUENCE_TYPES.contains(type)) {
            throw new PhyloXmlDataFormatException("illegal sequence type: [" + type + "]");
        }
        this._type = type;
    }

    @Override
    public void setUris(List<Uri> uris) {
        this._uris = uris;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        if (this.getName().length() > 0) {
            sb.append(":");
            sb.append("GN=");
            sb.append(ForesterUtil.replaceIllegalNhxCharacters(this.getName()));
        }
        if (this.getAccession() != null) {
            this.getAccession().toNHX();
        }
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        String my_ind = indentation + "  ";
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "sequence", "type", this.getType());
        if (!ForesterUtil.isEmpty(this.getSymbol())) {
            PhylogenyDataUtil.appendElement(writer, "symbol", this.getSymbol(), indentation);
        }
        if (this.getAccession() != null && !ForesterUtil.isEmpty(this.getAccession().getValue())) {
            this.getAccession().toPhyloXML(writer, level, indentation);
        }
        if (!ForesterUtil.isEmpty(this.getName())) {
            PhylogenyDataUtil.appendElement(writer, "name", this.getName(), indentation);
        }
        if (!ForesterUtil.isEmpty(this.getGeneName())) {
            PhylogenyDataUtil.appendElement(writer, "gene_name", this.getGeneName(), indentation);
        }
        if (!ForesterUtil.isEmpty(this.getLocation())) {
            PhylogenyDataUtil.appendElement(writer, "location", this.getLocation(), indentation);
        }
        if (!ForesterUtil.isEmpty(this.getMolecularSequence())) {
            PhylogenyDataUtil.appendElement(writer, "mol_seq", this.getMolecularSequence(), "is_aligned", String.valueOf(this.isMolecularSequenceAligned()), indentation);
        }
        if (this.getUris() != null && !this.getUris().isEmpty()) {
            for (Uri uri : this.getUris()) {
                if (uri == null) continue;
                uri.toPhyloXML(writer, level, indentation);
            }
        }
        if (this.getAnnotations() != null && !this.getAnnotations().isEmpty()) {
            for (PhylogenyData phylogenyData : this.getAnnotations()) {
                phylogenyData.toPhyloXML(writer, level, my_ind);
            }
        }
        if (this.getCrossReferences() != null && !this.getCrossReferences().isEmpty()) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(my_ind);
            PhylogenyDataUtil.appendOpen(writer, "cross_references");
            for (PhylogenyData phylogenyData : this.getCrossReferences()) {
                phylogenyData.toPhyloXML(writer, level, my_ind);
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(my_ind);
            PhylogenyDataUtil.appendClose(writer, "cross_references");
        }
        if (this.getDomainArchitecture() != null) {
            this.getDomainArchitecture().toPhyloXML(writer, level, my_ind);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "sequence");
    }

    public String toString() {
        return this.asText().toString();
    }

    private void setAnnotations(SortedSet<Annotation> annotations) {
        this._annotations = annotations;
    }

    private void setCrossReferences(TreeSet<Accession> cross_references) {
        this._xrefs = cross_references;
    }

    private void setSequenceRelations(List<SequenceRelation> seq_relations) {
        this._seq_relations = seq_relations;
    }
}

