/*
 * Decompiled with CFR 0.152.
 */
package org.forester.protein;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.protein.ProteinId;
import org.forester.species.BasicSpecies;
import org.forester.species.Species;
import org.forester.util.ForesterUtil;

public class BasicProtein
implements Protein {
    private final ProteinId _id;
    private final int _length;
    private final Species _species;
    private String _name;
    private String _desc;
    private String _accession;
    private final List<Domain> _protein_domains;
    public static Comparator<Domain> DomainMidPositionComparator = new Comparator<Domain>(){

        @Override
        public int compare(Domain d1, Domain d2) {
            int m22;
            int m1 = d1.getTo() + d1.getFrom();
            return m1 < (m22 = d2.getTo() + d2.getFrom()) ? -1 : (m1 > m22 ? 1 : d1.getDomainId().compareTo(d2.getDomainId()));
        }
    };

    public BasicProtein(String id_str, String species_str, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("attempt to create protein of length " + length);
        }
        if (ForesterUtil.isEmpty(id_str)) {
            throw new IllegalArgumentException("attempt to create protein with null or empty identifier");
        }
        if (ForesterUtil.isEmpty(species_str)) {
            throw new IllegalArgumentException("attempt to create protein with null or empty species");
        }
        this._id = new ProteinId(id_str);
        this._species = new BasicSpecies(species_str);
        this._length = length;
        this._protein_domains = new ArrayList<Domain>();
        this.init();
    }

    @Override
    public void addProteinDomain(Domain protein_domain) {
        this.getProteinDomains().add(protein_domain);
    }

    @Override
    public boolean contains(List<String> query_domain_ids, boolean in_nc_order) {
        if (!in_nc_order) {
            for (String query_domain_id : query_domain_ids) {
                if (this.getProteinDomainIds().contains(query_domain_id)) continue;
                return false;
            }
            return true;
        }
        int current_start_position = -1;
        block1: for (String query_domain_id : query_domain_ids) {
            if (this.getProteinDomainIds().contains(query_domain_id)) {
                List<Domain> found_domains = this.getProteinDomains(query_domain_id);
                TreeSet<Integer> ordered_start_positions = new TreeSet<Integer>();
                for (Domain found_domain : found_domains) {
                    ordered_start_positions.add(found_domain.getFrom());
                }
                Iterator<Domain> iterator = ordered_start_positions.iterator();
                while (iterator.hasNext()) {
                    int start_position = (Integer)((Object)iterator.next());
                    if (start_position <= current_start_position) continue;
                    current_start_position = start_position;
                    continue block1;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public String getAccession() {
        return this._accession;
    }

    @Override
    public String getDescription() {
        return this._desc;
    }

    @Override
    public List<Domain> getDomainsSortedByPosition() {
        ArrayList<Domain> domains = new ArrayList<Domain>(this.getProteinDomains().size());
        for (Domain domain : this.getProteinDomains()) {
            domains.add(domain);
        }
        Collections.sort(domains, DomainMidPositionComparator);
        return domains;
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int getNumberOfProteinDomains() {
        return this.getProteinDomains().size();
    }

    @Override
    public Domain getProteinDomain(int index) {
        return this._protein_domains.get(index);
    }

    @Override
    public int getProteinDomainCount(String domain_id) {
        return this.getProteinDomains(domain_id).size();
    }

    @Override
    public List<Domain> getProteinDomains() {
        return this._protein_domains;
    }

    @Override
    public List<Domain> getProteinDomains(String domain_id) {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        for (Domain domain : this.getProteinDomains()) {
            if (!domain.getDomainId().equals(domain_id)) continue;
            domains.add(domain);
        }
        return domains;
    }

    @Override
    public ProteinId getProteinId() {
        return this._id;
    }

    @Override
    public Species getSpecies() {
        return this._species;
    }

    public void setAccession(String accession) {
        this._accession = accession;
    }

    public void setDescription(String description) {
        this._desc = description;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String toDomainArchitectureString(String separator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Domain d : this.getDomainsSortedByPosition()) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(d.getDomainId());
        }
        return sb.toString();
    }

    public String toDomainArchitectureString(String separator, int repeats_limit, String repeat_separator) {
        if (repeats_limit < 3) {
            throw new IllegalArgumentException("repeats limit cannot be smaller than 3");
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder buffer = new StringBuilder();
        String prev_id = "";
        int counter = 1;
        for (Domain d : this.getDomainsSortedByPosition()) {
            String id = d.getDomainId();
            if (prev_id.equals(id)) {
                ++counter;
            } else {
                counter = 1;
                sb.append((CharSequence)buffer);
                buffer = new StringBuilder();
            }
            if (counter < repeats_limit) {
                buffer.append(id);
                buffer.append(separator);
            } else if (counter == repeats_limit) {
                buffer = new StringBuilder();
                buffer.append(id);
                buffer.append(repeat_separator);
                buffer.append(id);
                buffer.append(repeat_separator);
                buffer.append(id);
                buffer.append(separator);
            }
            prev_id = id;
        }
        sb.append(buffer.substring(0, buffer.length() - 1));
        return sb.toString();
    }

    public String toString() {
        return this.toDomainArchitectureString("~");
    }

    private List<String> getProteinDomainIds() {
        ArrayList<String> ids = new ArrayList<String>(this.getProteinDomains().size());
        for (Domain domain : this.getProteinDomains()) {
            ids.add(domain.getDomainId());
        }
        return ids;
    }

    private void init() {
        this._desc = "";
        this._accession = "";
        this._name = "";
    }
}

