/*
 * Decompiled with CFR 0.152.
 */
package org.forester.rio;

import java.io.File;
import org.forester.datastructures.IntMatrix;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.rio.RIO;
import org.forester.sdi.SDIutil;
import org.forester.util.ForesterUtil;

public final class TestRIO {
    private static final String PATH_TO_TEST_DATA = System.getProperty("user.dir") + ForesterUtil.getFileSeparator() + "test_data" + ForesterUtil.getFileSeparator();

    public static void main(String[] args) {
        if (!TestRIO.testRIO_GSDIR()) {
            System.out.println("testRIO GSDIR failed");
        }
        if (!TestRIO.testRIO_GSDIR_Iterating()) {
            System.out.println("testRIO GSDIR iterating failed");
        } else {
            System.out.println("OK");
        }
    }

    public static boolean test() {
        if (!TestRIO.testRIO_GSDIR()) {
            return false;
        }
        return TestRIO.testRIO_GSDIR_Iterating();
    }

    private static boolean testRIO_GSDIR() {
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            NHXParser nhx = new NHXParser();
            nhx.setReplaceUnderscores(false);
            nhx.setIgnoreQuotes(true);
            nhx.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
            String gene_trees_00_str = "(MOUSE,RAT);(MOUSE,RAT);(MOUSE,RAT);(RAT,MOUSE);";
            Phylogeny[] gene_trees_00 = factory.create("(MOUSE,RAT);(MOUSE,RAT);(MOUSE,RAT);(RAT,MOUSE);", nhx);
            String species_trees_00_str = "(MOUSE,RAT);";
            Phylogeny species_tree_00 = factory.create("(MOUSE,RAT);", new NHXParser())[0];
            species_tree_00.setRooted(true);
            PhylogenyMethods.transferNodeNameToField(species_tree_00, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
            RIO rio2 = RIO.executeAnalysis(gene_trees_00, species_tree_00, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rio2.getAnalyzedGeneTrees().length != 4) {
                return false;
            }
            if (rio2.getExtNodesOfAnalyzedGeneTrees() != 2) {
                return false;
            }
            if (rio2.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.CODE) {
                return false;
            }
            if (rio2.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            IntMatrix m3 = RIO.calculateOrthologTable(rio2.getAnalyzedGeneTrees(), true);
            if (!m3.getRowAsString(0, ',').equals("MOUSE,4,4")) {
                System.out.println(m3.toString());
                return false;
            }
            if (!m3.getRowAsString(1, ',').equals("RAT,4,4")) {
                System.out.println(m3.toString());
                return false;
            }
            String gene_trees_000_str = "(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE]);(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE])";
            Phylogeny[] gene_trees_000 = factory.create("(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE]);(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE])", nhx);
            String species_trees_000_str = "[&&NHX:S=MOUSE];";
            Phylogeny species_tree_000 = factory.create("[&&NHX:S=MOUSE];", new NHXParser())[0];
            species_tree_000.setRooted(true);
            rio2 = RIO.executeAnalysis(gene_trees_000, species_tree_000, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rio2.getAnalyzedGeneTrees().length != 2) {
                return false;
            }
            if (rio2.getExtNodesOfAnalyzedGeneTrees() != 2) {
                return false;
            }
            if (rio2.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME) {
                return false;
            }
            if (rio2.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            m3 = RIO.calculateOrthologTable(rio2.getAnalyzedGeneTrees(), true);
            if (!m3.getRowAsString(0, ',').equals("MOUSE1,2,0")) {
                System.out.println(m3.toString());
                return false;
            }
            if (!m3.getRowAsString(1, ',').equals("MOUSE2,0,2")) {
                System.out.println(m3.toString());
                return false;
            }
            String gene_trees_0000_str = "(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE]);(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE]);(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE])";
            Phylogeny[] gene_trees_0000 = factory.create("(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE]);(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE]);(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE])", nhx);
            String species_trees_0000_str = "([&&NHX:S=MOUSE]);";
            Phylogeny species_tree_0000 = factory.create("([&&NHX:S=MOUSE]);", new NHXParser())[0];
            species_tree_0000.setRooted(true);
            rio2 = RIO.executeAnalysis(gene_trees_0000, species_tree_0000, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rio2.getAnalyzedGeneTrees().length != 3) {
                return false;
            }
            if (rio2.getExtNodesOfAnalyzedGeneTrees() != 2) {
                return false;
            }
            if (rio2.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME) {
                return false;
            }
            if (rio2.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            m3 = RIO.calculateOrthologTable(rio2.getAnalyzedGeneTrees(), true);
            if (!m3.getRowAsString(0, ',').equals("MOUSE1,3,0")) {
                System.out.println(m3.toString());
                return false;
            }
            if (!m3.getRowAsString(1, ',').equals("MOUSE2,0,3")) {
                System.out.println(m3.toString());
                return false;
            }
            String gene_trees_x_str = "(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE])";
            Phylogeny[] gene_trees_x = factory.create("(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE])", nhx);
            String species_trees_x_str = "[&&NHX:S=MOUSE];";
            Phylogeny species_tree_x = factory.create("[&&NHX:S=MOUSE];", new NHXParser())[0];
            species_tree_x.setRooted(true);
            rio2 = RIO.executeAnalysis(gene_trees_x, species_tree_x, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rio2.getAnalyzedGeneTrees().length != 1) {
                return false;
            }
            if (rio2.getExtNodesOfAnalyzedGeneTrees() != 2) {
                return false;
            }
            if (rio2.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME) {
                return false;
            }
            if (rio2.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            m3 = RIO.calculateOrthologTable(rio2.getAnalyzedGeneTrees(), true);
            if (!m3.getRowAsString(0, ',').equals("MOUSE1,1,0")) {
                System.out.println(m3.toString());
                return false;
            }
            if (!m3.getRowAsString(1, ',').equals("MOUSE2,0,1")) {
                System.out.println(m3.toString());
                return false;
            }
            String gene_trees_xx_str = "(MOUSE1[&&NHX:S=MOUSE],RAT1[&&NHX:S=RAT])";
            Phylogeny[] gene_trees_xx = factory.create("(MOUSE1[&&NHX:S=MOUSE],RAT1[&&NHX:S=RAT])", nhx);
            String species_trees_xx_str = "([&&NHX:S=MOUSE],[&&NHX:S=RAT]);";
            Phylogeny species_tree_xx = factory.create("([&&NHX:S=MOUSE],[&&NHX:S=RAT]);", new NHXParser())[0];
            species_tree_xx.setRooted(true);
            rio2 = RIO.executeAnalysis(gene_trees_xx, species_tree_xx, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rio2.getAnalyzedGeneTrees().length != 1) {
                return false;
            }
            if (rio2.getExtNodesOfAnalyzedGeneTrees() != 2) {
                return false;
            }
            if (rio2.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME) {
                return false;
            }
            if (rio2.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            m3 = RIO.calculateOrthologTable(rio2.getAnalyzedGeneTrees(), true);
            if (!m3.getRowAsString(0, ',').equals("MOUSE1,1,1")) {
                System.out.println(m3.toString());
                return false;
            }
            if (!m3.getRowAsString(1, ',').equals("RAT1,1,1")) {
                System.out.println(m3.toString());
                return false;
            }
            String gene_trees_1_str = "(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);((((MOUSE,RAT),HUMAN),(ARATH,YEAST)),CAEEL);((MOUSE,RAT),(((ARATH,YEAST),CAEEL),HUMAN));(((((MOUSE,HUMAN),RAT),CAEEL),YEAST),ARATH);((((HUMAN,MOUSE),RAT),(ARATH,YEAST)),CAEEL);";
            Phylogeny[] gene_trees_1 = factory.create("(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);((((MOUSE,RAT),HUMAN),(ARATH,YEAST)),CAEEL);((MOUSE,RAT),(((ARATH,YEAST),CAEEL),HUMAN));(((((MOUSE,HUMAN),RAT),CAEEL),YEAST),ARATH);((((HUMAN,MOUSE),RAT),(ARATH,YEAST)),CAEEL);", nhx);
            String species_trees_1_str = "(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);";
            Phylogeny species_tree_1 = factory.create("(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);", new NHXParser())[0];
            species_tree_1.setRooted(true);
            PhylogenyMethods.transferNodeNameToField(species_tree_1, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
            rio2 = RIO.executeAnalysis(gene_trees_1, species_tree_1, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rio2.getAnalyzedGeneTrees().length != 5) {
                return false;
            }
            if (rio2.getExtNodesOfAnalyzedGeneTrees() != 6) {
                return false;
            }
            if (rio2.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.CODE) {
                return false;
            }
            if (rio2.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            m3 = RIO.calculateOrthologTable(rio2.getAnalyzedGeneTrees(), true);
            if (!m3.getRowAsString(0, ',').equals("ARATH,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(1, ',').equals("CAEEL,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(2, ',').equals("HUMAN,5,5,5,5,3,5")) {
                return false;
            }
            if (!m3.getRowAsString(3, ',').equals("MOUSE,5,5,5,5,3,5")) {
                return false;
            }
            if (!m3.getRowAsString(4, ',').equals("RAT,5,5,3,3,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(5, ',').equals("YEAST,5,5,5,5,5,5")) {
                return false;
            }
            Phylogeny[] gene_trees_2 = factory.create("(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);((((MOUSE,RAT),HUMAN),(ARATH,YEAST)),CAEEL);((MOUSE,RAT),(((ARATH,YEAST),CAEEL),HUMAN));(((((MOUSE,HUMAN),RAT),CAEEL),YEAST),ARATH);((((HUMAN,MOUSE),RAT),(ARATH,YEAST)),CAEEL);", nhx);
            String species_trees_2_str = "((((MOUSE,RAT,HUMAN),CAEEL),YEAST),ARATH);";
            Phylogeny species_tree_2 = factory.create("((((MOUSE,RAT,HUMAN),CAEEL),YEAST),ARATH);", new NHXParser())[0];
            species_tree_2.setRooted(true);
            PhylogenyMethods.transferNodeNameToField(species_tree_2, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
            rio2 = RIO.executeAnalysis(gene_trees_2, species_tree_2);
            m3 = RIO.calculateOrthologTable(rio2.getAnalyzedGeneTrees(), true);
            if (!m3.getRowAsString(0, ',').equals("ARATH,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(1, ',').equals("CAEEL,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(2, ',').equals("HUMAN,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(3, ',').equals("MOUSE,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(4, ',').equals("RAT,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(5, ',').equals("YEAST,5,5,5,5,5,5")) {
                return false;
            }
            RIO r0 = RIO.executeAnalysis(new File(PATH_TO_TEST_DATA + "rio_mb_taxcode.run1.t"), new File(PATH_TO_TEST_DATA + "rio_tol_1.xml"), SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", -1, -1, true, false, true);
            if (r0.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.CODE) {
                return false;
            }
            if (r0.getAnalyzedGeneTrees().length != 201) {
                return false;
            }
            if (r0.getExtNodesOfAnalyzedGeneTrees() != 6) {
                System.out.println(r0.getExtNodesOfAnalyzedGeneTrees());
                return false;
            }
            if (r0.getIntNodesOfAnalyzedGeneTrees() != 5) {
                return false;
            }
            if (r0.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            if (ForesterUtil.roundToInt(r0.getDuplicationsStatistics().median()) != 1) {
                return false;
            }
            m3 = RIO.calculateOrthologTable(r0.getAnalyzedGeneTrees(), true);
            if (!m3.getRowAsString(0, ',').equals("A7SHU1_NEMVE,201,201,200,200,200,200")) {
                System.out.println(m3.getRowAsString(0, ','));
                return false;
            }
            if (!m3.getRowAsString(1, ',').equals("BCDO2_HUMAN,201,201,200,200,200,43")) {
                System.out.println(m3.getRowAsString(1, ','));
                return false;
            }
            if (!m3.getRowAsString(2, ',').equals("BCDO2_MOUSE,200,200,201,201,201,43")) {
                System.out.println(m3.getRowAsString(2, ','));
                return false;
            }
            if (!m3.getRowAsString(3, ',').equals("H2ZH97_CIOSA,200,200,201,201,201,201")) {
                System.out.println(m3.getRowAsString(3, ','));
                return false;
            }
            if (!m3.getRowAsString(4, ',').equals("Q1RLW1_DANRE,200,200,201,201,201,43")) {
                System.out.println(m3.getRowAsString(4, ','));
                return false;
            }
            if (!m3.getRowAsString(5, ',').equals("Q6DIN7_XENTR,200,43,43,201,43,201")) {
                System.out.println(m3.getRowAsString(5, ','));
                return false;
            }
            r0 = RIO.executeAnalysis(new File(PATH_TO_TEST_DATA + "rio_mb_taxid.run1.t"), new File(PATH_TO_TEST_DATA + "rio_tol_1.xml"), SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", -1, -1, true, false, true);
            if (r0.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.ID) {
                return false;
            }
            if (r0.getAnalyzedGeneTrees().length != 201) {
                return false;
            }
            if (r0.getExtNodesOfAnalyzedGeneTrees() != 6) {
                return false;
            }
            if (r0.getIntNodesOfAnalyzedGeneTrees() != 5) {
                return false;
            }
            if (r0.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            if (ForesterUtil.roundToInt(r0.getDuplicationsStatistics().median()) != 1) {
                return false;
            }
            m3 = RIO.calculateOrthologTable(r0.getAnalyzedGeneTrees(), true);
            if (!m3.getRowAsString(0, ',').equals("A7SHU1_45351,201,200,201,200,200,200")) {
                System.out.println(m3.getRowAsString(0, ','));
                return false;
            }
            if (!m3.getRowAsString(1, ',').equals("BCDO2_10090,200,201,200,201,201,43")) {
                System.out.println(m3.getRowAsString(1, ','));
                return false;
            }
            if (!m3.getRowAsString(2, ',').equals("BCDO2_9606,201,200,201,200,200,43")) {
                System.out.println(m3.getRowAsString(2, ','));
                return false;
            }
            if (!m3.getRowAsString(3, ',').equals("H2ZH97_51511,200,201,200,201,201,201")) {
                System.out.println(m3.getRowAsString(3, ','));
                return false;
            }
            if (!m3.getRowAsString(4, ',').equals("Q1RLW1_7955,200,201,200,201,201,43")) {
                System.out.println(m3.getRowAsString(4, ','));
                return false;
            }
            if (!m3.getRowAsString(5, ',').equals("Q6DIN7_8364,200,43,43,201,43,201")) {
                System.out.println(m3.getRowAsString(5, ','));
                return false;
            }
            r0 = RIO.executeAnalysis(new File(PATH_TO_TEST_DATA + "rio_mb_taxsn.run1.t"), new File(PATH_TO_TEST_DATA + "rio_tol_1.xml"), SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", -1, -1, true, false, true);
            if (r0.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME) {
                return false;
            }
            if (r0.getAnalyzedGeneTrees().length != 201) {
                return false;
            }
            if (r0.getExtNodesOfAnalyzedGeneTrees() != 6) {
                System.out.println(r0.getExtNodesOfAnalyzedGeneTrees());
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testRIO_GSDIR_Iterating() {
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            NHXParser nhx = new NHXParser();
            nhx.setReplaceUnderscores(false);
            nhx.setIgnoreQuotes(true);
            nhx.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
            String gene_trees_1_str = "(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);((((MOUSE,RAT),HUMAN),(ARATH,YEAST)),CAEEL);((MOUSE,RAT),(((ARATH,YEAST),CAEEL),HUMAN));(((((MOUSE,HUMAN),RAT),CAEEL),YEAST),ARATH);((((HUMAN,MOUSE),RAT),(ARATH,YEAST)),CAEEL);";
            nhx.setSource("(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);((((MOUSE,RAT),HUMAN),(ARATH,YEAST)),CAEEL);((MOUSE,RAT),(((ARATH,YEAST),CAEEL),HUMAN));(((((MOUSE,HUMAN),RAT),CAEEL),YEAST),ARATH);((((HUMAN,MOUSE),RAT),(ARATH,YEAST)),CAEEL);");
            String species_trees_1_str = "(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);";
            Phylogeny species_tree_1 = factory.create("(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);", new NHXParser())[0];
            species_tree_1.setRooted(true);
            PhylogenyMethods.transferNodeNameToField(species_tree_1, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
            RIO rio2 = RIO.executeAnalysis(nhx, species_tree_1, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rio2.getExtNodesOfAnalyzedGeneTrees() != 6) {
                return false;
            }
            if (rio2.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.CODE) {
                return false;
            }
            if (rio2.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            IntMatrix m3 = rio2.getOrthologTable();
            if (!m3.getRowAsString(0, ',').equals("ARATH,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(1, ',').equals("CAEEL,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(2, ',').equals("HUMAN,5,5,5,5,3,5")) {
                return false;
            }
            if (!m3.getRowAsString(3, ',').equals("MOUSE,5,5,5,5,3,5")) {
                return false;
            }
            if (!m3.getRowAsString(4, ',').equals("RAT,5,5,3,3,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(5, ',').equals("YEAST,5,5,5,5,5,5")) {
                return false;
            }
            String species_trees_2_str = "((((MOUSE,RAT,HUMAN),CAEEL),YEAST),ARATH);";
            Phylogeny species_tree_2 = factory.create("((((MOUSE,RAT,HUMAN),CAEEL),YEAST),ARATH);", new NHXParser())[0];
            species_tree_2.setRooted(true);
            PhylogenyMethods.transferNodeNameToField(species_tree_2, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
            rio2 = RIO.executeAnalysis(nhx, species_tree_2, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            m3 = rio2.getOrthologTable();
            if (!m3.getRowAsString(0, ',').equals("ARATH,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(1, ',').equals("CAEEL,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(2, ',').equals("HUMAN,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(3, ',').equals("MOUSE,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(4, ',').equals("RAT,5,5,5,5,5,5")) {
                return false;
            }
            if (!m3.getRowAsString(5, ',').equals("YEAST,5,5,5,5,5,5")) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }
}

