/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyBranch;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.GSDI;
import org.forester.sdi.GSDII;
import org.forester.sdi.GSDIsummaryResult;
import org.forester.sdi.NodesLinkingResult;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIutil;
import org.forester.util.BasicDescriptiveStatistics;

public class GSDIR
implements GSDII {
    private final int _min_duplications_sum;
    private final int _speciations_sum;
    private final BasicDescriptiveStatistics _duplications_sum_stats;
    private Phylogeny _min_duplications_sum_gene_tree;
    private final List<PhylogenyNode> _stripped_gene_tree_nodes;
    private final List<PhylogenyNode> _stripped_species_tree_nodes;
    private final Set<PhylogenyNode> _mapped_species_tree_nodes;
    private final SDIutil.TaxonomyComparisonBase _tax_comp_base;
    private final SortedSet<String> _scientific_names_mapped_to_reduced_specificity;

    public GSDIR(Phylogeny gene_tree, Phylogeny species_tree, boolean strip_gene_tree, boolean strip_species_tree, boolean transfer_taxonomy) throws SDIException {
        NodesLinkingResult nodes_linking_result = GSDI.linkNodesOfG(gene_tree, species_tree, strip_gene_tree, strip_species_tree);
        this._stripped_gene_tree_nodes = nodes_linking_result.getStrippedGeneTreeNodes();
        this._stripped_species_tree_nodes = nodes_linking_result.getStrippedSpeciesTreeNodes();
        this._mapped_species_tree_nodes = nodes_linking_result.getMappedSpeciesTreeNodes();
        this._scientific_names_mapped_to_reduced_specificity = nodes_linking_result.getScientificNamesMappedToReducedSpecificity();
        this._tax_comp_base = nodes_linking_result.getTaxCompBase();
        ArrayList<PhylogenyBranch> gene_tree_branches_post_order = new ArrayList<PhylogenyBranch>();
        PhylogenyNodeIterator it = gene_tree.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.isRoot() || n.getParent().isRoot() && gene_tree.getRoot().getNumberOfDescendants() == 2) continue;
            gene_tree_branches_post_order.add(new PhylogenyBranch(n, n.getParent()));
        }
        if (gene_tree.getRoot().getNumberOfDescendants() == 2) {
            gene_tree_branches_post_order.add(new PhylogenyBranch(gene_tree.getRoot().getChildNode1(), gene_tree.getRoot().getChildNode2()));
        }
        int min_duplications_sum = Integer.MAX_VALUE;
        int speciations_sum = 0;
        this._duplications_sum_stats = new BasicDescriptiveStatistics();
        for (PhylogenyBranch branch : gene_tree_branches_post_order) {
            GSDIR.reRoot(branch, gene_tree);
            PhylogenyMethods.preOrderReId(species_tree);
            GSDIsummaryResult gsdi_result = GSDI.geneTreePostOrderTraversal(gene_tree, true, min_duplications_sum);
            if (gsdi_result == null) continue;
            if (gsdi_result.getDuplicationsSum() < min_duplications_sum) {
                min_duplications_sum = gsdi_result.getDuplicationsSum();
                speciations_sum = gsdi_result.getSpeciationsSum();
                this._min_duplications_sum_gene_tree = gene_tree.copy();
                if (transfer_taxonomy) {
                    GSDIR.transferTaxonomy(this._min_duplications_sum_gene_tree);
                }
            } else if (gsdi_result.getDuplicationsSum() == min_duplications_sum) {
                ArrayList<Phylogeny> l = new ArrayList<Phylogeny>();
                l.add(this._min_duplications_sum_gene_tree);
                l.add(gene_tree);
                int index = GSDIR.getIndexesOfShortestTree(l).get(0);
                if (index == 1) {
                    this._min_duplications_sum_gene_tree = gene_tree.copy();
                    if (transfer_taxonomy) {
                        GSDIR.transferTaxonomy(this._min_duplications_sum_gene_tree);
                    }
                }
            }
            this._duplications_sum_stats.addValue(gsdi_result.getDuplicationsSum());
        }
        this._min_duplications_sum = min_duplications_sum;
        this._speciations_sum = speciations_sum;
    }

    public BasicDescriptiveStatistics getDuplicationsSumStats() {
        return this._duplications_sum_stats;
    }

    @Override
    public Set<PhylogenyNode> getMappedExternalSpeciesTreeNodes() {
        return this._mapped_species_tree_nodes;
    }

    public int getMinDuplicationsSum() {
        return this._min_duplications_sum;
    }

    public Phylogeny getMinDuplicationsSumGeneTree() {
        return this._min_duplications_sum_gene_tree;
    }

    @Override
    public final SortedSet<String> getReMappedScientificNamesFromGeneTree() {
        return this._scientific_names_mapped_to_reduced_specificity;
    }

    @Override
    public int getSpeciationsSum() {
        return this._speciations_sum;
    }

    @Override
    public List<PhylogenyNode> getStrippedExternalGeneTreeNodes() {
        return this._stripped_gene_tree_nodes;
    }

    @Override
    public List<PhylogenyNode> getStrippedSpeciesTreeNodes() {
        return this._stripped_species_tree_nodes;
    }

    @Override
    public SDIutil.TaxonomyComparisonBase getTaxCompBase() {
        return this._tax_comp_base;
    }

    public static final List<Integer> getIndexesOfShortestTree(List<Phylogeny> assigned_trees) {
        ArrayList<Integer> shortests = new ArrayList<Integer>();
        boolean depth = true;
        double x = Double.MAX_VALUE;
        for (int i = 0; i < assigned_trees.size(); ++i) {
            double d;
            Phylogeny phy = assigned_trees.get(i);
            if (i == 0 && PhylogenyMethods.calculateMaxDistanceToRoot(phy) > 0.0) {
                depth = false;
            }
            if ((d = depth ? (double)PhylogenyMethods.calculateMaxDepth(phy) : PhylogenyMethods.calculateMaxDistanceToRoot(phy)) < x) {
                x = d;
                shortests.clear();
                shortests.add(i);
                continue;
            }
            if (d != x) continue;
            shortests.add(i);
        }
        return shortests;
    }

    static final void reRoot(PhylogenyBranch b, Phylogeny phy) {
        PhylogenyNode n1 = b.getFirstNode();
        PhylogenyNode n2 = b.getSecondNode();
        if (n1.isExternal()) {
            phy.reRoot(n1);
        } else if (n2.isExternal()) {
            phy.reRoot(n2);
        } else if (n2 == n1.getChildNode1() || n2 == n1.getChildNode2()) {
            phy.reRoot(n2);
        } else if (n1 == n2.getChildNode1() || n1 == n2.getChildNode2()) {
            phy.reRoot(n1);
        } else {
            throw new IllegalArgumentException("reRoot( Branch b ): b is not a branch.");
        }
    }

    private static final void transferTaxonomy(Phylogeny gt) {
        PhylogenyNodeIterator it = gt.iteratorPostorder();
        while (it.hasNext()) {
            GSDI.transferTaxonomy(it.next());
        }
    }
}

