/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyBranch;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.GSDIR;
import org.forester.sdi.SDI;
import org.forester.sdi.SDIException;

public class SDIR {
    private static final double ZERO_DIFF = 1.0E-6;
    private int _count;
    private int _min_dup;
    private int _min_cost;
    private double _min_height;
    private double _min_diff;
    private long _time_sdi;

    public SDIR() {
        this.init();
    }

    public int getCount() {
        return this._count;
    }

    public double getMinimalDiffInSubTreeHeights() {
        return this._min_diff;
    }

    public int getMinimalDuplications() {
        return this._min_dup;
    }

    public int getMinimalMappingCost() {
        return this._min_cost;
    }

    public double getMinimalTreeHeight() {
        return this._min_height;
    }

    public long getTimeSumSDI() {
        return this._time_sdi;
    }

    public Phylogeny[] infer(Phylogeny gene_tree, Phylogeny species_tree, boolean minimize_mapping_cost, boolean minimize_sum_of_dup, boolean minimize_height, boolean return_trees, int max_trees_to_return) throws SDIException {
        PhylogenyNode n;
        this.init();
        SDI sdise = null;
        ArrayList<Phylogeny> trees = new ArrayList<Phylogeny>();
        Phylogeny[] tree_array = null;
        List<PhylogenyBranch> branches = null;
        Phylogeny g2 = null;
        PhylogenyNode prev_root = null;
        PhylogenyNode prev_root_c1 = null;
        PhylogenyNode prev_root_c2 = null;
        int duplications = 0;
        int cost = 0;
        int counter = 0;
        int min_duplications = Integer.MAX_VALUE;
        int min_cost = Integer.MAX_VALUE;
        int j = 0;
        double height = 0.0;
        double diff = 0.0;
        double min_height = Double.MAX_VALUE;
        double min_diff = 0.0;
        double[] height__diff = new double[2];
        boolean smaller = false;
        boolean equal = false;
        boolean prev_root_was_dup = false;
        if (max_trees_to_return < 1) {
            max_trees_to_return = 1;
        }
        if (minimize_mapping_cost && minimize_sum_of_dup) {
            minimize_sum_of_dup = false;
        }
        if (!(minimize_mapping_cost || minimize_sum_of_dup || minimize_height)) {
            throw new IllegalArgumentException("parameter to minimize not given for rooting of phylogeny");
        }
        g2 = gene_tree.copy();
        if (g2.getNumberOfExternalNodes() <= 1) {
            g2.setRooted(true);
            this.setMinimalDuplications(0);
            this.setMinimalTreeHeight(0.0);
            tree_array = new Phylogeny[]{g2};
            return tree_array;
        }
        PhylogenyNodeIterator iter = g2.iteratorPostorder();
        while (iter.hasNext()) {
            n = iter.next();
            if (n.isRoot()) {
                if (n.getNumberOfDescendants() == 2 || n.getNumberOfDescendants() == 3) continue;
                throw new SDIException("gene tree has " + n.getNumberOfDescendants() + " descendents at its root");
            }
            if (n.isExternal() || n.getNumberOfDescendants() == 2) continue;
            throw new SDIException("gene tree is not completely binary");
        }
        iter = species_tree.iteratorPostorder();
        while (iter.hasNext()) {
            n = iter.next();
            if (n.isExternal() || n.getNumberOfDescendants() == 2) continue;
            throw new SDIException("species tree (after stripping) is not completely binary");
        }
        g2.reRoot(g2.getFirstExternalNode());
        branches = SDIR.getBranchesInPreorder(g2);
        if (minimize_mapping_cost || minimize_sum_of_dup) {
            sdise = new SDI(g2, species_tree);
            duplications = sdise.getDuplicationsSum();
        }
        HashSet<PhylogenyBranch> used_root_placements = new HashSet<PhylogenyBranch>();
        for (j = 0; j < branches.size(); ++j) {
            PhylogenyBranch current_branch;
            block43: {
                block45: {
                    block46: {
                        block47: {
                            block48: {
                                block49: {
                                    block44: {
                                        prev_root = g2.getRoot();
                                        prev_root_c1 = prev_root.getChildNode1();
                                        prev_root_c2 = prev_root.getChildNode2();
                                        prev_root_was_dup = prev_root.isDuplication();
                                        current_branch = branches.get(j);
                                        GSDIR.reRoot(current_branch, g2);
                                        if (minimize_mapping_cost || minimize_sum_of_dup) {
                                            duplications = sdise.updateM(prev_root_was_dup, prev_root_c1, prev_root_c2);
                                        }
                                        if (used_root_placements.contains(current_branch)) break block43;
                                        if (!minimize_mapping_cost) break block44;
                                        cost = sdise.computeMappingCostL();
                                        if (minimize_height && cost <= min_cost) {
                                            height__diff = SDIR.moveRootOnBranchToMinHeight(g2);
                                            height = height__diff[0];
                                            diff = height__diff[1];
                                        }
                                        if (cost == min_cost) {
                                            if (minimize_height) {
                                                equal = false;
                                                smaller = false;
                                                if (height < min_height) {
                                                    min_height = height;
                                                    counter = 1;
                                                    smaller = true;
                                                } else if (height == min_height) {
                                                    ++counter;
                                                    equal = true;
                                                }
                                                if (Math.abs(diff) < min_diff) {
                                                    min_diff = Math.abs(diff);
                                                }
                                            }
                                            if (return_trees) {
                                                if (minimize_height) {
                                                    if (smaller) {
                                                        trees.clear();
                                                        trees.add(g2.copy());
                                                    } else if (equal && trees.size() < max_trees_to_return) {
                                                        trees.add(g2.copy());
                                                    }
                                                } else {
                                                    ++counter;
                                                    if (trees.size() < max_trees_to_return) {
                                                        trees.add(g2.copy());
                                                    }
                                                }
                                            } else if (!minimize_height) {
                                                ++counter;
                                            }
                                        } else if (cost < min_cost) {
                                            if (minimize_height) {
                                                min_height = height;
                                                min_diff = Math.abs(diff);
                                            }
                                            if (return_trees) {
                                                trees.clear();
                                                trees.add(g2.copy());
                                            }
                                            counter = 1;
                                            min_cost = cost;
                                        }
                                        if (duplications < min_duplications) {
                                            min_duplications = duplications;
                                        }
                                        break block43;
                                    }
                                    if (!minimize_sum_of_dup) break block45;
                                    if (minimize_height && duplications <= min_duplications) {
                                        height__diff = SDIR.moveRootOnBranchToMinHeight(g2);
                                        height = height__diff[0];
                                        diff = height__diff[1];
                                    }
                                    if (duplications != min_duplications) break block46;
                                    if (minimize_height) {
                                        equal = false;
                                        smaller = false;
                                        if (height < min_height) {
                                            min_height = height;
                                            counter = 1;
                                            smaller = true;
                                        } else if (height == min_height) {
                                            ++counter;
                                            equal = true;
                                        }
                                        if (Math.abs(diff) < min_diff) {
                                            min_diff = Math.abs(diff);
                                        }
                                    }
                                    if (!return_trees) break block47;
                                    if (!minimize_height) break block48;
                                    if (!smaller) break block49;
                                    trees.clear();
                                    trees.add(g2.copy());
                                    break block43;
                                }
                                if (!equal || trees.size() >= max_trees_to_return) break block43;
                                trees.add(g2.copy());
                                break block43;
                            }
                            ++counter;
                            if (trees.size() >= max_trees_to_return) break block43;
                            trees.add(g2.copy());
                            break block43;
                        }
                        if (minimize_height) break block43;
                        ++counter;
                        break block43;
                    }
                    if (duplications >= min_duplications) break block43;
                    if (minimize_height) {
                        min_height = height;
                        min_diff = Math.abs(diff);
                    }
                    if (return_trees) {
                        trees.clear();
                        trees.add(g2.copy());
                    }
                    counter = 1;
                    min_duplications = duplications;
                    break block43;
                }
                if (minimize_height) {
                    height__diff = SDIR.moveRootOnBranchToMinHeight(g2);
                    height = height__diff[0];
                    diff = height__diff[1];
                    if (Math.abs(diff) < 1.0E-6) {
                        sdise = new SDI(g2, species_tree);
                        min_duplications = sdise.getDuplicationsSum();
                        min_height = height;
                        min_diff = Math.abs(diff);
                        counter = 1;
                        if (!return_trees) break;
                        trees.add(g2.copy());
                        break;
                    }
                }
            }
            used_root_placements.add(current_branch);
        }
        if (return_trees) {
            trees.trimToSize();
            tree_array = new Phylogeny[trees.size()];
            for (int i = 0; i < trees.size(); ++i) {
                tree_array[i] = (Phylogeny)trees.get(i);
                tree_array[i].recalculateNumberOfExternalDescendants(false);
            }
        }
        this.setCount(counter);
        this.setMinimalDuplications(min_duplications);
        this.setMinimalMappingCost(min_cost);
        this.setMinimalTreeHeight(min_height);
        this.setMinimalDiffInSubTreeHeights(Math.abs(min_diff));
        return tree_array;
    }

    private void init() {
        this._count = -1;
        this._min_dup = Integer.MAX_VALUE;
        this._min_cost = Integer.MAX_VALUE;
        this._min_height = Double.MAX_VALUE;
        this._min_diff = Double.MAX_VALUE;
        this._time_sdi = -1L;
    }

    private void setCount(int i) {
        this._count = i;
    }

    private void setMinimalDiffInSubTreeHeights(double d) {
        this._min_diff = d;
    }

    private void setMinimalDuplications(int i) {
        this._min_dup = i;
    }

    private void setMinimalMappingCost(int i) {
        this._min_cost = i;
    }

    private void setMinimalTreeHeight(double d) {
        this._min_height = d;
    }

    public static List<PhylogenyBranch> getBranchesInPreorder(Phylogeny t) {
        ArrayList<PhylogenyBranch> branches = new ArrayList<PhylogenyBranch>();
        if (t.isEmpty() || t.getNumberOfExternalNodes() <= 1) {
            return branches;
        }
        if (t.getNumberOfExternalNodes() == 2) {
            branches.add(new PhylogenyBranch(t.getRoot().getChildNode1(), t.getRoot().getChildNode2()));
            return branches;
        }
        HashSet<Long> one = new HashSet<Long>();
        HashSet<Long> two = new HashSet<Long>();
        PhylogenyNode node = t.getRoot();
        while (!node.isRoot() || !two.contains(node.getId())) {
            if (!node.isExternal() && !two.contains(node.getId())) {
                if (!one.contains(node.getId()) && !two.contains(node.getId())) {
                    one.add(node.getId());
                    node = node.getChildNode1();
                } else {
                    two.add(node.getId());
                    node = node.getChildNode2();
                }
                if (!node.getParent().isRoot()) {
                    branches.add(new PhylogenyBranch(node, node.getParent()));
                    continue;
                }
                if (node.isExternal()) continue;
                branches.add(new PhylogenyBranch(t.getRoot().getChildNode1(), t.getRoot().getChildNode2()));
                continue;
            }
            if (!node.getParent().isRoot() && !node.isExternal()) {
                branches.add(new PhylogenyBranch(node, node.getParent()));
            }
            node = node.getParent();
        }
        return branches;
    }

    private static double[] moveRootOnBranchToMinHeight(Phylogeny t) {
        PhylogenyNode root = t.getRoot();
        if (root.getNumberOfDescendants() != 2) {
            throw new IllegalArgumentException("attempt to move root to minimize height on root where number of child nodes does not equal two");
        }
        PhylogenyNode child0 = root.getChildNode(0);
        PhylogenyNode child1 = root.getChildNode(1);
        double newdist = 0.5 * ((child0.getDistanceToParent() > 0.0 ? child0.getDistanceToParent() : 0.0) + (child1.getDistanceToParent() > 0.0 ? child1.getDistanceToParent() : 0.0));
        child0.setDistanceToParent(newdist);
        child1.setDistanceToParent(newdist);
        double d = child0.getDistanceToParent();
        double diff = 0.0;
        double height = 0.0;
        double[] height_diff = new double[2];
        double l0 = t.calculateSubtreeHeight(t.getRoot().getChildNode(0));
        double l1 = t.calculateSubtreeHeight(t.getRoot().getChildNode(1));
        diff = l0 - l1;
        height = t.getHeight();
        if (d > 0.0) {
            if (2.0 * d > Math.abs(diff)) {
                child0.setDistanceToParent(d - diff / 2.0);
                child1.setDistanceToParent(d + diff / 2.0);
                height_diff[0] = height - Math.abs(diff / 2.0);
                height_diff[1] = 0.0;
            } else {
                if (diff > 0.0) {
                    child0.setDistanceToParent(0.0);
                    child1.setDistanceToParent(2.0 * d);
                    height_diff[1] = diff - 2.0 * d;
                } else {
                    child0.setDistanceToParent(2.0 * d);
                    child1.setDistanceToParent(0.0);
                    height_diff[1] = diff + 2.0 * d;
                }
                height_diff[0] = height - d;
            }
        } else {
            height_diff[0] = height;
            height_diff[1] = diff;
        }
        return height_diff;
    }
}

