/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.SDIException;
import org.forester.util.ForesterUtil;

public class SDIutil {
    public static final TaxonomyComparisonBase determineTaxonomyComparisonBase(Phylogeny gene_tree) throws SDIException {
        int with_id_count = 0;
        int with_code_count = 0;
        int with_sn_count = 0;
        int max = 0;
        PhylogenyNodeIterator iter = gene_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode g2 = iter.next();
            if (!g2.getNodeData().isHasTaxonomy()) continue;
            Taxonomy tax = g2.getNodeData().getTaxonomy();
            if (tax.getIdentifier() != null && !ForesterUtil.isEmpty(tax.getIdentifier().getValue()) && ++with_id_count > max) {
                max = with_id_count;
            }
            if (!ForesterUtil.isEmpty(tax.getTaxonomyCode()) && ++with_code_count > max) {
                max = with_code_count;
            }
            if (ForesterUtil.isEmpty(tax.getScientificName()) || ++with_sn_count <= max) continue;
            max = with_sn_count;
        }
        if (max == 0) {
            throw new SDIException("gene tree has no taxonomic data");
        }
        if (max == 1) {
            throw new SDIException("gene tree has only one node with taxonomic data");
        }
        if (max == with_id_count) {
            return TaxonomyComparisonBase.ID;
        }
        if (max == with_sn_count) {
            return TaxonomyComparisonBase.SCIENTIFIC_NAME;
        }
        return TaxonomyComparisonBase.CODE;
    }

    public static final Phylogeny parseSpeciesTree(Phylogeny gene_tree, File species_tree_file, boolean replace_undescores_in_nhx_trees, boolean ignore_quotes_in_nhx_trees, NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction_in_nhx_trees) throws FileNotFoundException, PhyloXmlDataFormatException, IOException, SDIException {
        Phylogeny species_tree;
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        PhylogenyParser p = ParserUtils.createParserDependingOnFileType(species_tree_file, true);
        if (p instanceof PhyloXmlParser) {
            species_tree = factory.create(species_tree_file, p)[0];
        } else {
            if (p instanceof NHXParser) {
                NHXParser nhx = (NHXParser)p;
                nhx.setReplaceUnderscores(replace_undescores_in_nhx_trees);
                nhx.setIgnoreQuotes(ignore_quotes_in_nhx_trees);
                nhx.setTaxonomyExtraction(taxonomy_extraction_in_nhx_trees);
            } else if (p instanceof NexusPhylogeniesParser) {
                NexusPhylogeniesParser nex = (NexusPhylogeniesParser)p;
                nex.setReplaceUnderscores(replace_undescores_in_nhx_trees);
                nex.setIgnoreQuotes(ignore_quotes_in_nhx_trees);
                nex.setTaxonomyExtraction(taxonomy_extraction_in_nhx_trees);
            }
            species_tree = factory.create(species_tree_file, p)[0];
            species_tree.setRooted(true);
            TaxonomyComparisonBase comp_base = SDIutil.determineTaxonomyComparisonBase(gene_tree);
            switch (comp_base) {
                case SCIENTIFIC_NAME: {
                    PhylogenyMethods.transferNodeNameToField(species_tree, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME, true);
                    break;
                }
                case CODE: {
                    PhylogenyMethods.transferNodeNameToField(species_tree, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
                    break;
                }
                case ID: {
                    PhylogenyMethods.transferNodeNameToField(species_tree, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_ID, true);
                    break;
                }
                default: {
                    throw new SDIException("unable to determine comparison base");
                }
            }
        }
        return species_tree;
    }

    static String taxonomyToString(PhylogenyNode n, TaxonomyComparisonBase base) {
        switch (base) {
            case ID: {
                Identifier id = n.getNodeData().getTaxonomy().getIdentifier();
                if (id == null) {
                    return null;
                }
                return id.getValuePlusProvider();
            }
            case CODE: {
                return n.getNodeData().getTaxonomy().getTaxonomyCode();
            }
            case SCIENTIFIC_NAME: {
                return n.getNodeData().getTaxonomy().getScientificName();
            }
        }
        throw new IllegalArgumentException("unknown comparison base for taxonomies: " + (Object)((Object)base));
    }

    public static enum TaxonomyComparisonBase {
        ID{

            public String toString() {
                return "taxonomy id";
            }
        }
        ,
        CODE{

            public String toString() {
                return "taxonomy code/mnemonic";
            }
        }
        ,
        SCIENTIFIC_NAME{

            public String toString() {
                return "scientific name";
            }
        };

    }

    public static enum ALGORITHM {
        GSDIR,
        GSDI,
        SDI,
        SDIR;

    }
}

