/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sequence;

import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;

public class BasicSequence
implements MolecularSequence {
    private final char[] _mol_sequence;
    private String _identifier;
    private final MolecularSequence.TYPE _type;

    public BasicSequence(String identifier, String mol_sequence, MolecularSequence.TYPE type) {
        BasicSequence.check(identifier, mol_sequence);
        this._mol_sequence = mol_sequence.toCharArray();
        this._identifier = identifier;
        this._type = type;
    }

    private static final void check(String identifier, String mol_sequence) {
        if (ForesterUtil.isEmpty(identifier)) {
            throw new IllegalArgumentException("identifier of sequence cannot be empty");
        }
        if (ForesterUtil.isEmpty(mol_sequence)) {
            throw new IllegalArgumentException("molecular sequence cannot be empty");
        }
    }

    public BasicSequence(String identifier, char[] mol_sequence, MolecularSequence.TYPE type) {
        if (ForesterUtil.isEmpty(identifier)) {
            throw new IllegalArgumentException("identifier of sequence cannot be empty");
        }
        if (mol_sequence == null || mol_sequence.length < 1) {
            throw new IllegalArgumentException("molecular sequence cannot be empty");
        }
        this._mol_sequence = mol_sequence;
        this._identifier = identifier;
        this._type = type;
    }

    public void setIdentifier(String id) {
        this._identifier = id;
    }

    @Override
    public String getIdentifier() {
        return this._identifier;
    }

    @Override
    public int getLength() {
        return this._mol_sequence.length;
    }

    @Override
    public char[] getMolecularSequence() {
        return this._mol_sequence;
    }

    @Override
    public char getResidueAt(int position) {
        return this._mol_sequence[position];
    }

    @Override
    public MolecularSequence.TYPE getType() {
        return this._type;
    }

    @Override
    public int getNumberOfGapResidues() {
        int gaps = 0;
        for (char element : this._mol_sequence) {
            if (element != '-') continue;
            ++gaps;
        }
        return gaps;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MolecularSequence other = (MolecularSequence)obj;
        return this.getMolecularSequenceAsString().equals(other.getMolecularSequenceAsString());
    }

    public int hashCode() {
        return this.getMolecularSequenceAsString().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._identifier.toString());
        sb.append(": ");
        sb.append(this.getMolecularSequenceAsString());
        return sb.toString();
    }

    public static MolecularSequence copySequence(MolecularSequence seq) {
        char[] s2 = new char[seq.getMolecularSequence().length];
        for (int i = 0; i < seq.getMolecularSequence().length; ++i) {
            s2[i] = seq.getMolecularSequence()[i];
        }
        return new BasicSequence(new String(seq.getIdentifier()), s2, seq.getType());
    }

    public static MolecularSequence createAaSequence(String identifier, String mol_sequence) {
        BasicSequence.check(identifier, mol_sequence);
        return new BasicSequence(identifier, mol_sequence.toUpperCase().replaceAll("\\.", GAP_STR).replaceAll("[^ARNDBCQEZGHILKMFPSTWYVXUO\\-\\*]", Character.toString('X')), MolecularSequence.TYPE.AA);
    }

    public static MolecularSequence createDnaSequence(String identifier, String mol_sequence) {
        BasicSequence.check(identifier, mol_sequence);
        return new BasicSequence(identifier, mol_sequence.toUpperCase().replaceAll("\\.", GAP_STR).replaceAll("[^ACGTRYMKWSN\\-\\*]", Character.toString('N')), MolecularSequence.TYPE.DNA);
    }

    public static MolecularSequence createRnaSequence(String identifier, String mol_sequence) {
        BasicSequence.check(identifier, mol_sequence);
        return new BasicSequence(identifier, mol_sequence.toUpperCase().replaceAll("\\.", GAP_STR).replaceAll("[^ACGURYMKWSN\\-\\*]", Character.toString('N')), MolecularSequence.TYPE.RNA);
    }

    @Override
    public String getMolecularSequenceAsString() {
        return new String(this.getMolecularSequence());
    }

    @Override
    public boolean isGapAt(int position) {
        return this.getResidueAt(position) == '-';
    }
}

