/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.species.Species;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarity;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.PairwiseDomainSimilarity;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;
import org.forester.surfacing.PrintableSpeciesSpecificDcData;
import org.forester.surfacing.SpeciesSpecificDcData;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class BasicDomainSimilarityCalculator
implements DomainSimilarityCalculator {
    final DomainSimilarity.DomainSimilaritySortField _sort;
    private final boolean _calc_similarity_score;
    private final boolean _sort_by_species_count_first;
    private final boolean _treat_as_binary_comparison;
    private final boolean _verbose;

    public BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField sort, boolean sort_by_species_count_first, boolean treat_as_binary_comparison, boolean calc_similarity_score, boolean verbose) {
        this._sort = sort;
        this._sort_by_species_count_first = sort_by_species_count_first;
        this._treat_as_binary_comparison = treat_as_binary_comparison;
        this._calc_similarity_score = calc_similarity_score;
        this._verbose = verbose;
    }

    public BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField sort, boolean sort_by_species_count_first, boolean treat_as_binary_comparison, boolean calc_similarity_score) {
        this._sort = sort;
        this._sort_by_species_count_first = sort_by_species_count_first;
        this._treat_as_binary_comparison = treat_as_binary_comparison;
        this._calc_similarity_score = calc_similarity_score;
        this._verbose = false;
    }

    @Override
    public SortedSet<DomainSimilarity> calculateSimilarities(PairwiseDomainSimilarityCalculator pairwise_calculator, List<GenomeWideCombinableDomains> cdc_list, boolean ignore_domains_without_combinations_in_any_genome, boolean ignore_domains_specific_to_one_genome) {
        if (cdc_list.size() < 2) {
            throw new IllegalArgumentException("attempt to calculate multiple combinable domains similarity for less than two combinale domains collections");
        }
        TreeSet<DomainSimilarity> similarities = new TreeSet<DomainSimilarity>();
        TreeSet<String> keys = new TreeSet<String>();
        for (GenomeWideCombinableDomains cdc : cdc_list) {
            keys.addAll(cdc.getAllCombinableDomainsIds().keySet());
        }
        DecimalFormat pf = new DecimalFormat("000000");
        int counter = 1;
        if (this._verbose) {
            System.out.println(keys.size());
        }
        for (String key : keys) {
            if (this._verbose) {
                ForesterUtil.updateProgress(counter, pf);
            }
            ++counter;
            ArrayList<CombinableDomains> same_id_cd_list = new ArrayList<CombinableDomains>(cdc_list.size());
            ArrayList<Species> species_with_key_id_domain = new ArrayList<Species>();
            for (GenomeWideCombinableDomains cdc : cdc_list) {
                if (!cdc.contains(key)) continue;
                same_id_cd_list.add(cdc.get(key));
                species_with_key_id_domain.add(cdc.getSpecies());
            }
            if (ignore_domains_without_combinations_in_any_genome) {
                boolean without_combinations = true;
                for (CombinableDomains cd2 : same_id_cd_list) {
                    if (cd2.getNumberOfCombinableDomains() <= 0) continue;
                    without_combinations = false;
                    break;
                }
                if (without_combinations) continue;
            }
            if (same_id_cd_list.size() > 0) {
                if (ignore_domains_specific_to_one_genome && same_id_cd_list.size() <= 1) continue;
                DomainSimilarity s2 = this.calculateSimilarity(pairwise_calculator, same_id_cd_list);
                if (s2 != null) {
                    similarities.add(s2);
                    continue;
                }
                throw new RuntimeException("similarity is null: this should not have happened");
            }
            throw new RuntimeException("this should not have happened");
        }
        if (this._verbose) {
            System.out.println();
        }
        return similarities;
    }

    public boolean isCalcSimilarityScore() {
        return this._calc_similarity_score;
    }

    private DomainSimilarity calculateSimilarity(PairwiseDomainSimilarityCalculator pairwise_calculator, List<CombinableDomains> domains_list) {
        if (domains_list.size() == 1) {
            TreeMap<Species, SpeciesSpecificDcData> species_data = new TreeMap<Species, SpeciesSpecificDcData>();
            species_data.put(domains_list.get(0).getSpecies(), BasicDomainSimilarityCalculator.createSpeciesSpecificDomainSimilariyData(domains_list.get(0)));
            if (!this.isCalcSimilarityScore()) {
                return new DomainSimilarity(domains_list.get(0), 0, 0, species_data, this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison());
            }
            return new DomainSimilarity(domains_list.get(0), 1.0, 1.0, 1.0, 1.0, 0.0, 0, 0, 0, species_data, this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison());
        }
        BasicDescriptiveStatistics stat = null;
        if (this.isCalcSimilarityScore()) {
            stat = new BasicDescriptiveStatistics();
        }
        TreeMap<Species, SpeciesSpecificDcData> species_data = new TreeMap<Species, SpeciesSpecificDcData>();
        species_data.put(domains_list.get(0).getSpecies(), BasicDomainSimilarityCalculator.createSpeciesSpecificDomainSimilariyData(domains_list.get(0)));
        int max_difference_in_counts = 0;
        int max_difference = 0;
        boolean is_domain_combination_based = pairwise_calculator instanceof CombinationsBasedPairwiseDomainSimilarityCalculator;
        for (int i = 1; i < domains_list.size(); ++i) {
            species_data.put(domains_list.get(i).getSpecies(), BasicDomainSimilarityCalculator.createSpeciesSpecificDomainSimilariyData(domains_list.get(i)));
            CombinableDomains domains_i = domains_list.get(i);
            for (int j = 0; j < i; ++j) {
                PairwiseDomainSimilarity pairwise_similarity = pairwise_calculator.calculateSimilarity(domains_i, domains_list.get(j));
                int difference_in_counts = pairwise_similarity.getDifferenceInCounts();
                int difference = 0;
                difference = is_domain_combination_based ? ((CombinationsBasedPairwiseDomainSimilarity)pairwise_similarity).getNumberOfDifferentDomains() : difference_in_counts;
                if (Math.abs(difference_in_counts) > Math.abs(max_difference_in_counts)) {
                    max_difference_in_counts = difference_in_counts;
                }
                if (Math.abs(difference) > Math.abs(max_difference)) {
                    max_difference = difference;
                }
                if (!this.isCalcSimilarityScore()) continue;
                stat.addValue(pairwise_similarity.getSimilarityScore());
            }
        }
        if (this.isCalcSimilarityScore()) {
            if (stat.getN() < 1) {
                throw new RuntimeException("empty descriptive statistics: this should not have happened");
            }
            if (stat.getN() != 1 && this.isTreatAsBinaryComparison()) {
                throw new IllegalArgumentException("attmpt to treat similarity with N not equal to one as binary comparison");
            }
        }
        if (!this.isTreatAsBinaryComparison() && max_difference_in_counts < 0) {
            max_difference_in_counts = Math.abs(max_difference_in_counts);
            if (!is_domain_combination_based) {
                max_difference = Math.abs(max_difference);
            }
        }
        DomainSimilarity similarity = null;
        similarity = !this.isCalcSimilarityScore() ? new DomainSimilarity(domains_list.get(0), max_difference_in_counts, max_difference, species_data, this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison()) : (stat.getN() == 1 ? new DomainSimilarity(domains_list.get(0), stat.getMin(), stat.getMax(), stat.arithmeticMean(), stat.median(), 0.0, stat.getN(), max_difference_in_counts, max_difference, species_data, this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison()) : new DomainSimilarity(domains_list.get(0), stat.getMin(), stat.getMax(), stat.arithmeticMean(), stat.median(), stat.sampleStandardDeviation(), stat.getN(), max_difference_in_counts, max_difference, species_data, this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison()));
        return similarity;
    }

    private boolean isSortBySpeciesCountFirst() {
        return this._sort_by_species_count_first;
    }

    private boolean isTreatAsBinaryComparison() {
        return this._treat_as_binary_comparison;
    }

    private static SpeciesSpecificDcData createSpeciesSpecificDomainSimilariyData(CombinableDomains cd2) {
        PrintableSpeciesSpecificDcData sd = new PrintableSpeciesSpecificDcData(cd2.getKeyDomainCount(), cd2.getNumberOfCombinableDomains());
        for (String prot : cd2.getKeyDomainProteins()) {
            sd.addKeyDomainProtein(prot);
        }
        for (String domain : cd2.getCombinableDomains()) {
            sd.addProteinsExhibitingCombinationCount(domain, cd2.getNumberOfProteinsExhibitingCombination(domain));
        }
        return sd;
    }
}

