/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.species.Species;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;

public class DomainLengths {
    final String _domain_id;
    final SortedMap<Species, DescriptiveStatistics> _length_statistics;

    public DomainLengths(String domain_id) {
        this._domain_id = domain_id;
        this._length_statistics = new TreeMap<Species, DescriptiveStatistics>();
    }

    public void addLength(Species species, int domain_length) {
        if (!this.getLengthStatistics().containsKey(species)) {
            this.addLengthStatistics(species, new BasicDescriptiveStatistics());
        }
        this.getLengthStatistic(species).addValue(domain_length);
    }

    public DescriptiveStatistics calculateMeanBasedStatistics() {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (DescriptiveStatistics s2 : this.getLengthStatisticsList()) {
            stats.addValue(s2.arithmeticMean());
        }
        return stats;
    }

    public double calculateZScoreForSpecies(Species species) {
        double species_mean = this.getLengthStatistic(species).arithmeticMean();
        DescriptiveStatistics domain_stats = this.calculateMeanBasedStatistics();
        double population_sd = domain_stats.sampleStandardDeviation();
        double population_mean = domain_stats.arithmeticMean();
        return (species_mean - population_mean) / population_sd;
    }

    public String getDomainId() {
        return this._domain_id;
    }

    public DescriptiveStatistics getLengthStatistic(Species species) {
        return (DescriptiveStatistics)this.getLengthStatistics().get(species);
    }

    public List<DescriptiveStatistics> getLengthStatisticsList() {
        ArrayList<DescriptiveStatistics> list = new ArrayList<DescriptiveStatistics>();
        for (DescriptiveStatistics stats : this._length_statistics.values()) {
            list.add(stats);
        }
        return list;
    }

    public List<Species> getMeanBasedOutlierSpecies(double z_score_limit) {
        ArrayList<Species> species = new ArrayList<Species>();
        if (this.getSpeciesList().size() > 1) {
            for (Species s2 : this.getSpeciesList()) {
                double z = this.calculateZScoreForSpecies(s2);
                if (z_score_limit < 0.0) {
                    if (!(z <= z_score_limit)) continue;
                    species.add(s2);
                    continue;
                }
                if (!(z_score_limit > 0.0) || !(z >= z_score_limit)) continue;
                species.add(s2);
            }
        }
        return species;
    }

    public List<Species> getSpeciesList() {
        ArrayList<Species> list = new ArrayList<Species>();
        for (Species s2 : this._length_statistics.keySet()) {
            list.add(s2);
        }
        return list;
    }

    public boolean isHasLengthStatistic(Species species) {
        return this.getLengthStatistics().containsKey(species);
    }

    private void addLengthStatistics(Species species, DescriptiveStatistics length_statistic) {
        if (this.getLengthStatistics().containsKey(species)) {
            throw new IllegalArgumentException("length statistics for [" + species.getSpeciesId() + "] already added");
        }
        this.getLengthStatistics().put(species, length_statistic);
    }

    private SortedMap<Species, DescriptiveStatistics> getLengthStatistics() {
        return this._length_statistics;
    }
}

