/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.awt.Color;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.phylogeny.Phylogeny;
import org.forester.species.Species;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.SpeciesSpecificDcData;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.ForesterUtil;

public class DomainSimilarity
implements Comparable<DomainSimilarity> {
    public static final String SPECIES_SEPARATOR = "  ";
    private static final int EQUAL = 0;
    private static final String NO_SPECIES = "     ";
    private static final boolean OUTPUT_TAXCODES_PER_DOMAIN = false;
    private final CombinableDomains _combinable_domains;
    private DomainSimilarityCalculator.Detailedness _detailedness;
    private final double _max;
    private final int _max_difference;
    private final int _max_difference_in_counts;
    private final double _mean;
    private final double _min;
    private final int _n;
    private final double _sd;
    private final SortedMap<Species, SpeciesSpecificDcData> _species_data;
    private List<Species> _species_order;
    private final boolean _treat_as_binary_comparison;

    public DomainSimilarity(CombinableDomains combinable_domains, double min2, double max, double mean, double median, double sd, int n, int max_difference_in_counts, int max_difference, SortedMap<Species, SpeciesSpecificDcData> species_data, boolean sort_by_species_count_first, boolean treat_as_binary_comparison) {
        if (combinable_domains == null) {
            throw new IllegalArgumentException("attempt to use null combinable domains");
        }
        if (species_data == null) {
            throw new IllegalArgumentException("attempt to use null species data");
        }
        if (species_data.size() < 1) {
            throw new IllegalArgumentException("attempt to use empty species data");
        }
        if (n < 0) {
            throw new IllegalArgumentException("attempt to use N less than 0");
        }
        if (species_data.size() > 1 && n < 1) {
            throw new IllegalArgumentException("attempt to use N less than 1");
        }
        if (sd < 0.0) {
            throw new IllegalArgumentException("attempt to use negative SD");
        }
        if (max < min2) {
            throw new IllegalArgumentException("attempt to use max smaller than min");
        }
        this.init();
        this._combinable_domains = combinable_domains;
        this._min = min2;
        this._max = max;
        this._mean = mean;
        this._sd = sd;
        this._n = n;
        this._max_difference_in_counts = max_difference_in_counts;
        this._max_difference = max_difference;
        this._species_data = species_data;
        this._treat_as_binary_comparison = treat_as_binary_comparison;
        int s2 = species_data.size();
        if (s2 * s2 - s2 != this.getN() * 2) {
            throw new IllegalArgumentException("illegal species count and n: species count:" + s2 + ", n:" + this._n + " for domain " + combinable_domains.getKeyDomain());
        }
        if (s2 > 2) {
            if (this.getMaximalDifferenceInCounts() < 0) {
                throw new IllegalArgumentException("attempt to use negative max difference in counts with more than two species");
            }
            if (this.getMaximalDifference() < 0) {
                throw new IllegalArgumentException("attempt to use negative max difference with more than two species");
            }
        }
    }

    public DomainSimilarity(CombinableDomains combinable_domains, int max_difference_in_counts, int max_difference, SortedMap<Species, SpeciesSpecificDcData> species_data, boolean sort_by_species_count_first, boolean treat_as_binary_comparison) {
        if (combinable_domains == null) {
            throw new IllegalArgumentException("attempt to use null combinable domains");
        }
        if (species_data == null) {
            throw new IllegalArgumentException("attempt to use null species data");
        }
        if (species_data.size() < 1) {
            throw new IllegalArgumentException("attempt to use empty species data");
        }
        this.init();
        this._combinable_domains = combinable_domains;
        this._min = -1.0;
        this._max = -1.0;
        this._mean = -1.0;
        this._sd = -1.0;
        this._n = -1;
        this._max_difference_in_counts = max_difference_in_counts;
        this._max_difference = max_difference;
        this._species_data = species_data;
        this._treat_as_binary_comparison = treat_as_binary_comparison;
        int s2 = species_data.size();
        if (s2 > 2) {
            if (this.getMaximalDifferenceInCounts() < 0) {
                throw new IllegalArgumentException("attempt to use negative max difference in counts with more than two species");
            }
            if (this.getMaximalDifference() < 0) {
                throw new IllegalArgumentException("attempt to use negative max difference with more than two species");
            }
        }
    }

    @Override
    public int compareTo(DomainSimilarity domain_similarity) {
        if (this == domain_similarity) {
            return 0;
        }
        if (domain_similarity == null) {
            throw new IllegalArgumentException("attempt to compare " + this.getClass() + " to null");
        }
        if (domain_similarity.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to compare " + this.getClass() + " to " + domain_similarity.getClass());
        }
        return this.compareByDomainId(domain_similarity);
    }

    public SortedSet<String> getCombinableDomainIds(Species species_of_combinable_domain) {
        TreeSet<String> sorted_ids = new TreeSet<String>();
        if (this.getSpeciesData().containsKey(species_of_combinable_domain)) {
            for (String id : ((SpeciesSpecificDcData)this.getSpeciesData().get(species_of_combinable_domain)).getCombinableDomainIdToCountsMap().keySet()) {
                sorted_ids.add(id);
            }
        }
        return sorted_ids;
    }

    public String getDomainId() {
        return this.getCombinableDomains().getKeyDomain();
    }

    public int getMaximalDifference() {
        return this._max_difference;
    }

    public int getMaximalDifferenceInCounts() {
        return this._max_difference_in_counts;
    }

    public double getMaximalSimilarityScore() {
        return this._max;
    }

    public double getMeanSimilarityScore() {
        return this._mean;
    }

    public double getMinimalSimilarityScore() {
        return this._min;
    }

    public int getN() {
        return this._n;
    }

    public SortedSet<Species> getSpecies() {
        TreeSet<Species> species = new TreeSet<Species>();
        for (Species s2 : this.getSpeciesData().keySet()) {
            species.add(s2);
        }
        return species;
    }

    public List<Species> getSpeciesCustomOrder() {
        return this._species_order;
    }

    public SortedMap<Species, SpeciesSpecificDcData> getSpeciesData() {
        return this._species_data;
    }

    public double getStandardDeviationOfSimilarityScore() {
        return this._sd;
    }

    public void setDetailedness(DomainSimilarityCalculator.Detailedness detailedness) {
        this._detailedness = detailedness;
    }

    public void setSpeciesOrder(List<Species> species_order) {
        if (!species_order.containsAll(this.getSpeciesData().keySet())) {
            throw new IllegalArgumentException("list to order species must contain all species of multiple combinable domains similarity");
        }
        this._species_order = species_order;
    }

    public StringBuffer toStringBuffer(PRINT_OPTION print_option, Map<String, Integer> tax_code_to_id_map, Phylogeny phy) {
        switch (print_option) {
            case SIMPLE_TAB_DELIMITED: {
                return this.toStringBufferSimpleTabDelimited();
            }
            case HTML: {
                return this.toStringBufferDetailedHTML(tax_code_to_id_map, phy, false);
            }
        }
        throw new AssertionError((Object)("Unknown print option: " + (Object)((Object)print_option)));
    }

    private void addSpeciesSpecificDomainData(StringBuffer sb, Species species, boolean html, Map<String, Integer> tax_code_to_id_map, Phylogeny phy) {
        if (html) {
            sb.append("<tr>");
            sb.append("<td>");
            this.addTaxWithLink(sb, species.getSpeciesId(), tax_code_to_id_map, phy);
            sb.append("</td>");
        } else {
            sb.append(species.getSpeciesId());
        }
        if (this.getDetaildness() != DomainSimilarityCalculator.Detailedness.BASIC) {
            if (!html) {
                sb.append("\t");
            }
            sb.append(((SpeciesSpecificDcData)this.getSpeciesData().get(species)).toStringBuffer(this.getDetaildness(), html));
        }
        if (html) {
            sb.append("</tr>");
        } else {
            sb.append("\n\t");
        }
    }

    private void addTaxWithLink(StringBuffer sb, String tax_code, Map<String, Integer> tax_code_to_id_map, Phylogeny phy) {
        String hex = null;
        if (phy != null && !phy.isEmpty()) {
            hex = SurfacingUtil.obtainHexColorStringDependingOnTaxonomyGroup(tax_code, phy);
        }
        sb.append("<b>");
        if (!ForesterUtil.isEmpty(tax_code) && tax_code_to_id_map != null && tax_code_to_id_map.containsKey(tax_code)) {
            if (!ForesterUtil.isEmpty(hex)) {
                sb.append("<a href=\"");
                sb.append("http://www.uniprot.org/taxonomy/");
                sb.append(tax_code_to_id_map.get(tax_code));
                sb.append("\" target=\"tw\"><span style=\"color:");
                sb.append(hex);
                sb.append("\">");
                sb.append(tax_code);
                sb.append("</span></a>");
            } else {
                sb.append("<a href=\"");
                sb.append("http://www.uniprot.org/taxonomy/");
                sb.append(tax_code_to_id_map.get(tax_code));
                sb.append("\" target=\"tw\">");
                sb.append(tax_code);
                sb.append("</a>");
            }
        } else {
            sb.append(tax_code);
        }
        sb.append("</b>");
    }

    private int compareByDomainId(DomainSimilarity other) {
        return this.getDomainId().compareToIgnoreCase(other.getDomainId());
    }

    private CombinableDomains getCombinableDomains() {
        return this._combinable_domains;
    }

    private DomainSimilarityCalculator.Detailedness getDetaildness() {
        return this._detailedness;
    }

    private StringBuffer getDomainDataInAlphabeticalOrder() {
        TreeMap m3 = new TreeMap();
        StringBuffer sb = new StringBuffer();
        for (Species species : this.getSpeciesData().keySet()) {
            for (String combable_dom : this.getCombinableDomainIds(species)) {
                if (!m3.containsKey(combable_dom)) {
                    m3.put(combable_dom, new TreeSet());
                }
                ((SortedSet)m3.get(combable_dom)).add(species.getSpeciesId());
            }
        }
        for (Map.Entry entry : m3.entrySet()) {
            sb.append("<a href=\"http://pfam.xfam.org/family/" + (String)entry.getKey() + "\">" + (String)entry.getKey() + "</a>");
            sb.append(" ");
            sb.append("<span style=\"font-size:7px\">");
            for (String tax : (SortedSet)entry.getValue()) {
                String hex = SurfacingUtil.obtainHexColorStringDependingOnTaxonomyGroup(tax, null);
                if (!ForesterUtil.isEmpty(hex)) {
                    sb.append("<span style=\"color:");
                    sb.append(hex);
                    sb.append("\">");
                    sb.append(tax);
                    sb.append("</span>");
                } else {
                    sb.append(tax);
                }
                sb.append(" ");
            }
            sb.append("</span>");
            sb.append("<br>\n");
        }
        return sb;
    }

    private StringBuffer getSpeciesDataInAlphabeticalOrder(boolean html, Map<String, Integer> tax_code_to_id_map, Phylogeny phy) {
        StringBuffer sb = new StringBuffer();
        sb.append("<table>");
        for (Species species : this.getSpeciesData().keySet()) {
            this.addSpeciesSpecificDomainData(sb, species, html, tax_code_to_id_map, phy);
        }
        sb.append("</table>");
        return sb;
    }

    private StringBuffer getSpeciesDataInCustomOrder(boolean html, Map<String, Integer> tax_code_to_id_map, Phylogeny phy) {
        StringBuffer sb = new StringBuffer();
        for (Species order_species : this.getSpeciesCustomOrder()) {
            if (this.getSpeciesData().keySet().contains(order_species)) {
                this.addSpeciesSpecificDomainData(sb, order_species, html, tax_code_to_id_map, phy);
                continue;
            }
            sb.append(NO_SPECIES);
            sb.append(SPECIES_SEPARATOR);
        }
        return sb;
    }

    private StringBuffer getTaxonomyGroupDistribution(Phylogeny tol) {
        TreeMap domain_to_species_set_map = new TreeMap();
        for (Species species : this.getSpeciesData().keySet()) {
            for (String combable_dom : this.getCombinableDomainIds(species)) {
                if (!domain_to_species_set_map.containsKey(combable_dom)) {
                    domain_to_species_set_map.put(combable_dom, new HashSet());
                }
                ((Set)domain_to_species_set_map.get(combable_dom)).add(species.getSpeciesId());
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<table>");
        for (Map.Entry domain_to_species_set : domain_to_species_set_map.entrySet()) {
            Object tax_code2;
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            for (Object tax_code2 : (Set)domain_to_species_set.getValue()) {
                String group = SurfacingUtil.obtainTaxonomyGroup((String)tax_code2, tol);
                if (!ForesterUtil.isEmpty(group)) {
                    if (!counts.containsKey(group)) {
                        counts.put(group, 1);
                        continue;
                    }
                    counts.put(group, (Integer)counts.get(group) + 1);
                    continue;
                }
                return null;
            }
            TreeMap counts_to_groups = new TreeMap(new Comparator<Integer>(){

                @Override
                public int compare(Integer first, Integer second) {
                    return second.compareTo(first);
                }
            });
            tax_code2 = counts.entrySet().iterator();
            while (tax_code2.hasNext()) {
                Map.Entry group_to_counts = (Map.Entry)tax_code2.next();
                int c = (Integer)group_to_counts.getValue();
                if (!counts_to_groups.containsKey(c)) {
                    counts_to_groups.put(c, new TreeSet());
                }
                ((SortedSet)counts_to_groups.get(c)).add(group_to_counts.getKey());
            }
            sb.append("<tr>");
            sb.append("<td>");
            sb.append("<a href=\"http://pfam.xfam.org/family/" + (String)domain_to_species_set.getKey() + "\">" + (String)domain_to_species_set.getKey() + "</a>");
            sb.append(" ");
            sb.append("</td>");
            boolean first = true;
            for (Map.Entry count_to_groups : counts_to_groups.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("<tr>");
                    sb.append("<td>");
                    sb.append("</td>");
                }
                sb.append("<td>");
                SortedSet groups = (SortedSet)count_to_groups.getValue();
                sb.append(count_to_groups.getKey());
                sb.append(" ");
                for (String group : groups) {
                    Color color = ForesterUtil.obtainColorDependingOnTaxonomyGroup(group);
                    if (color == null) {
                        throw new IllegalArgumentException("no color found for taxonomy group\"" + group + "\"");
                    }
                    String hex = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
                    sb.append("<span style=\"color:");
                    sb.append(hex);
                    sb.append("\">");
                    sb.append(" ");
                    sb.append(group);
                    sb.append("</span>");
                }
                sb.append("</td>");
                sb.append("</tr>");
            }
            sb.append(ForesterUtil.getLineSeparator());
        }
        sb.append("</table>");
        return sb;
    }

    private void init() {
        this._detailedness = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
    }

    private boolean isTreatAsBinaryComparison() {
        return this._treat_as_binary_comparison;
    }

    private StringBuffer toStringBufferDetailedHTML(Map<String, Integer> tax_code_to_id_map, Phylogeny phy, boolean output_tax_codes_per_domain) {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr>");
        sb.append("<td>");
        sb.append("<b>");
        sb.append("<a href=\"http://pfam.xfam.org/family/" + this.getDomainId() + "\" target=\"pfam_window\">" + this.getDomainId() + "</a>");
        sb.append("</b>");
        sb.append("<a name=\"" + this.getDomainId() + "\">");
        sb.append("</td>");
        sb.append("<td>");
        sb.append("<a href=\"http://scholar.google.com/scholar?q=" + this.getDomainId() + "\" target=\"gs_window\">gs</a>");
        sb.append("</td>");
        if (this.getMaximalSimilarityScore() > 0.0) {
            sb.append("<td>");
            sb.append(ForesterUtil.round(this.getMeanSimilarityScore(), 3));
            sb.append("</td>");
        }
        sb.append("<td>");
        sb.append(this.getMaximalDifference());
        sb.append("</td>");
        sb.append("<td>");
        if (this.isTreatAsBinaryComparison()) {
            sb.append(this.getMaximalDifferenceInCounts());
        } else {
            sb.append(Math.abs(this.getMaximalDifferenceInCounts()));
        }
        sb.append("</td>");
        if (!this.isTreatAsBinaryComparison()) {
            sb.append("<td>");
            sb.append("<b>");
            sb.append(this.getSpeciesData().size());
            sb.append("</b>");
            sb.append("</td>");
        }
        if (this.getSpeciesCustomOrder() == null || this.getSpeciesCustomOrder().isEmpty()) {
            sb.append("<td>");
            sb.append(this.getSpeciesDataInAlphabeticalOrder(true, tax_code_to_id_map, phy));
            if (output_tax_codes_per_domain) {
                sb.append(this.getDomainDataInAlphabeticalOrder());
            }
            sb.append(this.getTaxonomyGroupDistribution(phy));
            sb.append("</td>");
        } else {
            sb.append("<td>");
            sb.append(this.getSpeciesDataInCustomOrder(true, tax_code_to_id_map, phy));
            if (output_tax_codes_per_domain) {
                sb.append(this.getDomainDataInAlphabeticalOrder());
            }
            sb.append(this.getTaxonomyGroupDistribution(phy));
            sb.append("</td>");
        }
        sb.append("</tr>");
        return sb;
    }

    private StringBuffer toStringBufferSimpleTabDelimited() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDomainId());
        sb.append("\t");
        sb.append(this.getSpeciesDataInAlphabeticalOrder(false, null, null));
        sb.append("\n");
        return sb;
    }

    class ValueComparator
    implements Comparator<String> {
        private final Map<String, Integer> _base;

        public ValueComparator(Map<String, Integer> base) {
            this._base = base;
        }

        @Override
        public int compare(String a, String b) {
            if (this._base.get(a) >= this._base.get(b)) {
                return -1;
            }
            return 1;
        }
    }

    public static enum PRINT_OPTION {
        HTML,
        SIMPLE_TAB_DELIMITED;

    }

    public static enum DomainSimilaritySortField {
        ABS_MAX_COUNTS_DIFFERENCE,
        DOMAIN_ID,
        MAX,
        MAX_COUNTS_DIFFERENCE,
        MAX_DIFFERENCE,
        MEAN,
        MIN,
        SD,
        SPECIES_COUNT;

    }

    public static enum DomainSimilarityScoring {
        COMBINATIONS,
        DOMAINS,
        PROTEINS;

    }
}

