/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.tools.TreeSplitMatrix;
import org.forester.util.ForesterUtil;

public final class ConfidenceAssessor {
    private ConfidenceAssessor() {
    }

    private static final void addExternalNodesToMap(Map<PhylogenyNode, Set<PhylogenyNode>> node_to_ext_nodes_map, PhylogenyNode node) {
        HashSet<PhylogenyNode> ex_descs = new HashSet<PhylogenyNode>();
        for (PhylogenyNode n : node.getAllExternalDescendants()) {
            if (ex_descs.contains(n)) {
                throw new IllegalArgumentException("node [" + n.toString() + "] of target is not unique");
            }
            ex_descs.add(n);
        }
        node_to_ext_nodes_map.put(node, ex_descs);
    }

    private static final void checkPreconditions(String confidence_type, Phylogeny[] evaluators, Phylogeny target, double value, int first, int last) {
        if (first < 0 || last < 0) {
            throw new IllegalArgumentException("attempt to set first or last evaluator topology to use to a number less than zero");
        }
        if (evaluators.length < 1) {
            throw new IllegalArgumentException("need at least one evaluator topology");
        }
        if (ForesterUtil.isEmpty(confidence_type)) {
            throw new IllegalArgumentException("attempt to use empty confidence type");
        }
        if (value <= 0.0) {
            throw new IllegalArgumentException("attempt to use zero or negative 'count value'");
        }
        if (!(first == 0 && last == 0 || last < evaluators.length && last > first)) {
            throw new IllegalArgumentException("illegal value for last evaluator topology to use");
        }
        HashSet<PhylogenyNode> nodes = new HashSet<PhylogenyNode>();
        PhylogenyNodeIterator it = target.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode node = it.next();
            if (nodes.contains(node)) {
                throw new IllegalArgumentException("node [" + node + "] in target is not unique");
            }
            nodes.add(node);
            List<Confidence> confidences = node.getBranchData().getConfidences();
            for (Confidence confidence : confidences) {
                if (!confidence.getType().equals(confidence_type)) continue;
                throw new IllegalArgumentException("confidence [" + confidence_type + "] is already present in target");
            }
        }
    }

    public static final void evaluate(String confidence_type, Phylogeny[] evaluators, Phylogeny target, boolean strict, double value) {
        ConfidenceAssessor.evaluate(confidence_type, evaluators, target, strict, value, 0, 0);
    }

    public static final void evaluate(String confidence_type, Phylogeny[] evaluators, Phylogeny target, boolean strict, double value, int first, int last) {
        ConfidenceAssessor.checkPreconditions(confidence_type, evaluators, target, value, first, last);
        boolean all = true;
        if (first != 0 || last != 0) {
            all = false;
        }
        int counter = 0;
        HashMap<PhylogenyNode, Set<PhylogenyNode>> node_to_ext_nodes_map = new HashMap<PhylogenyNode, Set<PhylogenyNode>>();
        for (Phylogeny evaluator : evaluators) {
            if (all || counter >= first && counter <= last) {
                if (strict && evaluator.getNumberOfExternalNodes() != target.getNumberOfExternalNodes()) {
                    throw new IllegalArgumentException("evaluator #" + counter + " does not have the same number of external nodes [" + evaluator.getNumberOfExternalNodes() + "] than the corresponding target [" + target.getNumberOfExternalNodes() + "]");
                }
                TreeSplitMatrix s2 = new TreeSplitMatrix(evaluator, strict, target);
                PhylogenyNodeIterator it = target.iteratorPostorder();
                while (it.hasNext()) {
                    PhylogenyNode node = it.next();
                    if (node.isExternal() || node.isRoot() || node.getParent().isRoot() && target.getRoot().getNumberOfDescendants() == 2 && (target.getRoot().getChildNode1().isExternal() || target.getRoot().getChildNode2().isExternal())) continue;
                    if (!node_to_ext_nodes_map.containsKey(node)) {
                        ConfidenceAssessor.addExternalNodesToMap(node_to_ext_nodes_map, node);
                    }
                    Set ex_descs = (Set)node_to_ext_nodes_map.get(node);
                    Confidence c = ConfidenceAssessor.obtainConfidence(node, confidence_type);
                    if (!s2.match(ex_descs)) continue;
                    c.setValue(c.getValue() + value);
                }
            }
            ++counter;
        }
    }

    private static final Confidence obtainConfidence(PhylogenyNode n, String confidence_type) {
        List<Confidence> confidences = n.getBranchData().getConfidences();
        Confidence match = null;
        for (Confidence confidence : confidences) {
            if (!confidence.getType().equals(confidence_type)) continue;
            if (match != null) {
                throw new IllegalArgumentException("confidence [" + confidence_type + "] is not unique");
            }
            match = confidence;
        }
        if (match == null) {
            match = new Confidence(0.0, confidence_type);
            confidences.add(match);
        }
        return match;
    }
}

