/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public final class SupportCount {
    private SupportCount() {
    }

    public static double compare(Phylogeny phylogeny, Phylogeny evaluator_phylogeny, boolean strip_evaluator_phylogeny, boolean update_support_in_phylogeny, boolean re_root) {
        String[] seq_names_to_keep = null;
        if (strip_evaluator_phylogeny) {
            seq_names_to_keep = phylogeny.getAllExternalNodeNames();
            SupportCount.strip(seq_names_to_keep, evaluator_phylogeny);
        }
        if (re_root) {
            String child0_name = phylogeny.getFirstExternalNode().getName();
            phylogeny.reRoot(phylogeny.getNode(child0_name));
            evaluator_phylogeny.reRoot(evaluator_phylogeny.getNode(child0_name));
        }
        Map<Long, ArrayList<String>> phylogeny_external_names_per_node = SupportCount.extractExternalNamesPerNode(phylogeny);
        return SupportCount.compare(phylogeny, evaluator_phylogeny, phylogeny_external_names_per_node, update_support_in_phylogeny, -1.0);
    }

    private static double compare(Phylogeny phylogeny, Phylogeny evaluator_phylogeny, Map<Long, ArrayList<String>> phylogeny_external_names_per_node, boolean update_support_in_phylogeny, double similarity_threshold) {
        int matching_branches = 0;
        int phylogeny_total_internal_branches = 0;
        PhylogenyNodeIterator it = phylogeny.iteratorPostorder();
        while (it.hasNext()) {
            if (it.next().isExternal()) continue;
            ++phylogeny_total_internal_branches;
        }
        HashMap<PhylogenyNode, Double> support_values = new HashMap<PhylogenyNode, Double>();
        PhylogenyNodeIterator evaluator_phylogeny_it = evaluator_phylogeny.iteratorPostorder();
        block1: while (evaluator_phylogeny_it.hasNext()) {
            ArrayList<String> c1 = new ArrayList<String>();
            for (PhylogenyNode element : evaluator_phylogeny_it.next().getAllExternalDescendants()) {
                c1.add(element.getName());
            }
            for (Long id : phylogeny_external_names_per_node.keySet()) {
                List c2 = phylogeny_external_names_per_node.get(id);
                if (c2.size() != c1.size() || !c2.containsAll(c1)) continue;
                if (c2.size() > 1) {
                    ++matching_branches;
                }
                if (!update_support_in_phylogeny) continue block1;
                PhylogenyNode node = phylogeny.getNode(id.intValue());
                double d = PhylogenyMethods.getConfidenceValue(node);
                d = d < 1.0 ? 1.0 : (d += 1.0);
                support_values.put(node, new Double(d));
                continue block1;
            }
        }
        double similarity = (double)matching_branches / (double)phylogeny_total_internal_branches;
        if (similarity_threshold < 0.0 || similarity >= similarity_threshold) {
            for (PhylogenyNode node : support_values.keySet()) {
                double b = (Double)support_values.get(node);
                if (b < 0.0) {
                    b = 0.0;
                }
                PhylogenyMethods.setBootstrapConfidence(node, b);
            }
        }
        return similarity;
    }

    public static void count(Phylogeny phylogeny, Phylogeny[] evaluator_phylogenies, boolean strip_evaluator_phylogenies, boolean verbose) {
        SupportCount.count(phylogeny, evaluator_phylogenies, strip_evaluator_phylogenies, -1.0, verbose);
    }

    public static List<Phylogeny> count(Phylogeny phylogeny, Phylogeny[] evaluator_phylogenies, boolean strip_evaluator_phylogenies, double similarity_threshold, boolean verbose) {
        String[] seq_names_to_keep = null;
        ArrayList<Phylogeny> evaluator_phylogenies_above_threshold = new ArrayList<Phylogeny>();
        if (strip_evaluator_phylogenies) {
            seq_names_to_keep = phylogeny.getAllExternalNodeNames();
        }
        String child0_name = phylogeny.getFirstExternalNode().getName();
        phylogeny.reRoot(phylogeny.getNode(child0_name));
        Map<Long, ArrayList<String>> phylogeny_external_names_per_node = SupportCount.extractExternalNamesPerNode(phylogeny);
        if (verbose) {
            System.out.println();
            System.out.println("evaluator phylogeny #: similarity score (max is 1.0)");
            System.out.println("----------------------------------------------------");
            System.out.println();
        }
        for (int i = 0; i < evaluator_phylogenies.length; ++i) {
            Phylogeny evaluator_phylogeny = evaluator_phylogenies[i];
            evaluator_phylogeny.reRoot(evaluator_phylogeny.getNode(child0_name));
            Phylogeny unstripped_evaluator_phylogeny = evaluator_phylogeny;
            if (strip_evaluator_phylogenies) {
                unstripped_evaluator_phylogeny = evaluator_phylogeny.copy();
                SupportCount.strip(seq_names_to_keep, evaluator_phylogeny);
                PhylogenyMethods.orderAppearance(evaluator_phylogeny.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY);
                evaluator_phylogeny.externalNodesHaveChanged();
                evaluator_phylogeny.clearHashIdToNodeMap();
                evaluator_phylogeny.recalculateNumberOfExternalDescendants(true);
            }
            double s2 = SupportCount.compare(phylogeny, evaluator_phylogenies[i], phylogeny_external_names_per_node, true, similarity_threshold);
            if (similarity_threshold < 0.0 || s2 >= similarity_threshold) {
                PhylogenyMethods.orderAppearance(unstripped_evaluator_phylogeny.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY);
                evaluator_phylogenies_above_threshold.add(unstripped_evaluator_phylogeny);
            }
            if (!verbose) continue;
            if (similarity_threshold < 0.0) {
                System.out.println(i + ": " + s2);
                continue;
            }
            if (s2 >= similarity_threshold) {
                System.out.println(i + ": " + s2 + " <====");
                continue;
            }
            System.out.println(i + ": " + s2);
        }
        if (verbose) {
            System.out.println("----------------------------------------------------");
            System.out.println();
        }
        return evaluator_phylogenies_above_threshold;
    }

    private static Map<Long, ArrayList<String>> extractExternalNamesPerNode(Phylogeny phylogeny) throws NoSuchElementException {
        HashMap<Long, ArrayList<String>> phylogeny_external_names_per_node = new HashMap<Long, ArrayList<String>>();
        PhylogenyNodeIterator it = phylogeny.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            List<PhylogenyNode> l = n.getAllExternalDescendants();
            ArrayList<String> c = new ArrayList<String>();
            phylogeny_external_names_per_node.put(new Long(n.getId()), c);
            for (PhylogenyNode phylogenyNode : l) {
                c.add(phylogenyNode.getName());
            }
        }
        return phylogeny_external_names_per_node;
    }

    private static void strip(String[] to_keep, Phylogeny to_be_stripped) {
        PhylogenyMethods.deleteExternalNodesPositiveSelection(to_keep, to_be_stripped);
    }
}

