/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.wabi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;

public final class RestUtil {
    static final String LIST_SEPARATOR = "%0A";
    static final String LINE_SEPARATOR = "\n";
    private static final String BASE_URL = "http://xml.nig.ac.jp/rest/Invoke";
    private static final String SERVICE = "service";
    private static final String METHOD = "method";
    private static final String URL_ENC = "UTF-8";

    static String encode(String str) throws UnsupportedEncodingException {
        return URLEncoder.encode(str.trim(), URL_ENC);
    }

    public static String getResult(String query) throws IOException {
        URL url = new URL(BASE_URL);
        URLConnection urlc = url.openConnection();
        urlc.setDoOutput(true);
        urlc.setAllowUserInteraction(false);
        PrintStream ps = new PrintStream(urlc.getOutputStream());
        ps.print(query.trim());
        ps.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
        StringBuffer sb = new StringBuffer();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + LINE_SEPARATOR);
        }
        br.close();
        return sb.toString().trim();
    }

    public static String getResult(String service_name, String method_name, String parameters) throws IOException {
        String service = "service=" + RestUtil.encode(service_name);
        String method = "method=" + RestUtil.encode(method_name);
        return RestUtil.getResult(service + '&' + method + '&' + parameters.trim());
    }

    static String listAsString(List<String> l) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        for (String s2 : l) {
            if (sb.length() > 0) {
                sb.append(LIST_SEPARATOR);
            }
            sb.append(RestUtil.encode(s2));
        }
        return sb.toString();
    }
}

