/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.wabi;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.forester.ws.wabi.RestUtil;

public final class TxSearch {
    private static final String TAXONOMIC_RANK = "Taxonomic rank: ";
    private static final String FULL_LINEAGE = "Full lineage: ";
    private static final String SEARCH_LINEAGE_QUERY_PARAM_NAME = "query";
    private static final String SEARCH_LINEAGE_RANKS_PARAM_NAME = "ranks";
    private static final String SEARCH_LINEAGE_SUPERKINGDOM_PARAM_NAME = "superkingdom";
    private static final String GET_TX_ID_METHOD_NAME = "getTxId";
    private static final String GET_TX_NAME_METHOD_NAME = "getTxName";
    private static final String SEARCH_SIMPLE_METHOD_NAME = "searchSimple";
    private static final String TX_SEARCH_SERVICE_NAME = "TxSearch";
    private static final String TX_NAME_PARAM_NAME = "tx_Name";
    private static final String TX_ID_PARAM_NAME = "tx_Id";
    private static final String SEARCH_LINEAGE_NAME_METHOD_NAME = "searchLineage";
    private static final String SEARCH_PARAM_METHOD_NAME = "searchParam";

    public static String[] getLineage(String result) throws IOException {
        String[] lineage = null;
        for (String line : result.split("\n")) {
            if (!(line = line.trim()).startsWith(FULL_LINEAGE)) continue;
            if (lineage != null) {
                throw new IOException("search result is not unique");
            }
            lineage = line.substring(FULL_LINEAGE.length()).split(";");
        }
        return lineage;
    }

    public static String getTaxonomicRank(String result) throws IOException {
        String rank = null;
        for (String line : result.split("\n")) {
            if (!(line = line.trim()).startsWith(TAXONOMIC_RANK)) continue;
            if (rank != null) {
                throw new IOException("search result is not unique");
            }
            rank = line.substring(TAXONOMIC_RANK.length()).trim();
        }
        return rank;
    }

    public static String getTxId(String tx_name) throws IOException {
        return RestUtil.getResult(TX_SEARCH_SERVICE_NAME, GET_TX_ID_METHOD_NAME, "tx_Name=" + RestUtil.encode(tx_name)).trim();
    }

    public static String getTxName(String tx_id) throws IOException {
        return RestUtil.getResult(TX_SEARCH_SERVICE_NAME, GET_TX_NAME_METHOD_NAME, "tx_Id=" + RestUtil.encode(tx_id)).trim();
    }

    public static void main(String[] args) throws IOException {
        String[] lineage;
        String result = "";
        try {
            result = TxSearch.searchSimple("SAMSA");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        System.out.println("---------------");
        try {
            result = TxSearch.searchSimple("nematostella");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        for (String element : lineage = TxSearch.getLineage(result)) {
            System.out.println(element);
        }
        System.out.println(TxSearch.getTaxonomicRank(result));
        System.out.println("---------------");
        try {
            result = TxSearch.getTxId("nematostella");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        System.out.println("---------------");
        try {
            result = TxSearch.getTxName("45350");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        System.out.println("---------------");
        ArrayList<String> queries = new ArrayList<String>();
        queries.add("Campylobacter coli");
        queries.add("Escherichia coli");
        queries.add("Arabidopsis");
        queries.add("Trichoplax");
        queries.add("Samanea saman");
        queries.add("Kluyveromyces marxianus");
        queries.add("Bacillus subtilis subsp. subtilis str. N170");
        queries.add("Bornavirus parrot/PDD/2008");
        ArrayList<RANKS> ranks = new ArrayList<RANKS>();
        ranks.add(RANKS.ALL);
        try {
            result = TxSearch.searchLineage(queries, ranks);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        System.out.println("---------------");
        try {
            result = TxSearch.searchParam("Homo sapiens", TAX_NAME_CLASS.ALL, TAX_RANK.SPECIES, 10, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        System.out.println("---------------");
        try {
            result = TxSearch.searchParam("Samanea saman", TAX_NAME_CLASS.SCIENTIFIC_NAME, TAX_RANK.ALL, 10, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        System.out.println("---------------");
        try {
            result = TxSearch.searchParam("cow", TAX_NAME_CLASS.COMMON_NAME, TAX_RANK.ALL, 10, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        System.out.println("---------------");
        try {
            result = TxSearch.searchParam("Helicogloea lagerheimii", TAX_NAME_CLASS.SCIENTIFIC_NAME, TAX_RANK.ALL, 10, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        System.out.println("---------------");
        try {
            result = TxSearch.searchParam("Cronartium ribicola", TAX_NAME_CLASS.SCIENTIFIC_NAME, TAX_RANK.ALL, 10, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        System.out.println("---------------");
        try {
            result = TxSearch.searchParam("Peridermium harknessii", TAX_NAME_CLASS.SCIENTIFIC_NAME, TAX_RANK.ALL, 10, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        System.out.println("---------------");
        try {
            result = TxSearch.searchParam("Eukaryota", TAX_NAME_CLASS.SCIENTIFIC_NAME, TAX_RANK.ALL, 10, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
    }

    private static String ranksAsString(List<RANKS> l) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        for (RANKS r : l) {
            if (sb.length() > 0) {
                sb.append("%0A");
            }
            sb.append(RestUtil.encode(r.toString()));
        }
        return sb.toString();
    }

    public static String searchLineage(List<String> queries, List<RANKS> ranks) throws IOException {
        return TxSearch.searchLineage(queries, ranks, "");
    }

    public static String searchLineage(List<String> queries, List<RANKS> ranks, String superkingdom) throws IOException {
        return RestUtil.getResult(TX_SEARCH_SERVICE_NAME, SEARCH_LINEAGE_NAME_METHOD_NAME, "query=" + RestUtil.listAsString(queries) + "&" + SEARCH_LINEAGE_RANKS_PARAM_NAME + "=" + TxSearch.ranksAsString(ranks) + "&" + SEARCH_LINEAGE_SUPERKINGDOM_PARAM_NAME + "=" + RestUtil.encode(superkingdom)).trim();
    }

    public static String searchParam(String tx_name, TAX_NAME_CLASS tx_name_class, TAX_RANK tx_rank, int tx_rmax, boolean as_scientific_name) throws IOException {
        String as_scientific_name_str = "no";
        if (as_scientific_name) {
            as_scientific_name_str = "yes";
        }
        if (tx_rmax < 1) {
            tx_rmax = 1;
        }
        return RestUtil.getResult(TX_SEARCH_SERVICE_NAME, SEARCH_PARAM_METHOD_NAME, "tx_Name=" + RestUtil.encode(tx_name) + "&tx_Clas=" + RestUtil.encode(tx_name_class.toString()) + "&tx_Rank=" + RestUtil.encode(tx_rank.toString()) + "&tx_Rmax=" + tx_rmax + "&tx_Dcls=" + as_scientific_name_str).trim();
    }

    public static String searchSimple(String tx_name) throws IOException {
        return RestUtil.getResult(TX_SEARCH_SERVICE_NAME, SEARCH_SIMPLE_METHOD_NAME, "tx_Name=" + RestUtil.encode(tx_name)).trim();
    }

    public static enum TAX_RANK {
        ALL("All"),
        NO_RANK("no rank"),
        SUPERKINGDOM("superkingdom"),
        KINGDOM("kingdom"),
        SUBKINGDOM("subkingdom"),
        SUPERPHYLUM("superphylum"),
        PHYLUM("phylum"),
        SUBPHYLUM("subphylum"),
        SUPERCLASS("superclass"),
        CLASS("class"),
        SUBCLASS("subclass"),
        INFRACLASS("infraclass"),
        SUPERORDER("superorder"),
        ORDER("order"),
        SUBORDER("suborder"),
        INFRAORDER("infraorder"),
        PARVORDER("parvorder"),
        SUPERFAMILY("superfamily"),
        FAMILY("family"),
        SUBFAMILY("subfamily"),
        TRIBE("tribe"),
        SUBTRIBE("subtribe"),
        GENUS("genus"),
        SUBGENUS("subgenus"),
        SPECIES_GROUP("species group"),
        SPECIES_SUBGROUP("species subgroup"),
        SPECIES("species"),
        SUBSPECIES("subspecies"),
        VARIETAS("varietas"),
        FORMA("forma");

        private final String _str;

        private TAX_RANK(String name) {
            this._str = name;
        }

        public String toString() {
            return this._str;
        }
    }

    public static enum TAX_NAME_CLASS {
        ALL("all"),
        SCIENTIFIC_NAME("scientific name"),
        PREFFERED_COMMON_NAME("preferred common name"),
        COMMON_NAME("common name"),
        SYNONYM("synonym");

        private final String _str;

        private TAX_NAME_CLASS(String name) {
            this._str = name;
        }

        public String toString() {
            return this._str;
        }
    }

    public static enum RANKS {
        ALL("all"),
        SUPERKINGDOM("superkingdom"),
        KINGDOM("kingdom"),
        SUBKINGDOM("subkingdom"),
        SUPERPHYLUM("superphylum"),
        PHYLUM("phylum"),
        SUBPHYLUM("subphylum"),
        SUPERCLASS("superclass"),
        CLASS("class"),
        SUBCLASS("subclass"),
        INFRACLASS("infraclass"),
        SUPERORDER("superorder"),
        ORDER("order"),
        SUBORDER("suborder"),
        INFRAORDER("infraorder"),
        PARVORDER("parvorder"),
        SUPERFAMILY("superfamily"),
        FAMILY("family"),
        SUBFAMILY("subfamily"),
        TRIBE("tribe"),
        SUBTRIBE("subtribe"),
        GENUS("genus"),
        SPECIES("species");

        private final String _str;

        private RANKS(String name) {
            this._str = name;
        }

        public String toString() {
            return this._str;
        }
    }
}

